/*
 * Decompiled with CFR 0.152.
 */
package jogamp.newt.driver.ios;

import com.jogamp.common.util.ArrayHashSet;
import com.jogamp.math.FloatUtil;
import com.jogamp.nativewindow.DefaultGraphicsScreen;
import com.jogamp.nativewindow.util.Rectangle;
import com.jogamp.newt.Display;
import com.jogamp.newt.MonitorDevice;
import com.jogamp.newt.MonitorMode;
import jogamp.nativewindow.ios.IOSUtil;
import jogamp.newt.MonitorModeProps;
import jogamp.newt.ScreenImpl;
import jogamp.newt.driver.ios.DisplayDriver;

public class ScreenDriver
extends ScreenImpl {
    protected void createNativeImpl() {
        this.aScreen = new DefaultGraphicsScreen(this.getDisplay().getGraphicsDevice(), this.screen_idx);
    }

    protected void closeNativeImpl() {
    }

    private MonitorMode getMonitorModeImpl(MonitorModeProps.Cache cache, int n, int n2) {
        int[] nArray = this.getMonitorMode0(n, n2);
        MonitorMode monitorMode = null == nArray || 0 >= nArray.length ? null : MonitorModeProps.streamInMonitorMode(null, (MonitorModeProps.Cache)cache, (int[])nArray, (int)0);
        return monitorMode;
    }

    protected final void collectNativeMonitorModesAndDevicesImpl(MonitorModeProps.Cache cache) {
        CrtProps crtProps = new CrtProps();
        for (int i = 0; i < crtProps.count; ++i) {
            MonitorMode monitorMode;
            int n = crtProps.crtIDs[i];
            ArrayHashSet arrayHashSet = new ArrayHashSet(false, 16, 0.75f);
            int n2 = 0;
            while (null != (monitorMode = this.getMonitorModeImpl(cache, n, n2))) {
                if (monitorMode.getSurfaceSize().getBitsPerPixel() >= 24) {
                    arrayHashSet.getOrAdd((Object)monitorMode);
                }
                ++n2;
            }
            if (0 >= n2) {
                throw new InternalError("Could not gather single mode of device " + i + "/" + crtProps.count + " -> " + Display.toHexString((int)n));
            }
            monitorMode = this.getMonitorModeImpl(cache, n, -1);
            if (null == monitorMode) {
                throw new InternalError("Could not gather current mode of device " + i + "/" + crtProps.count + " -> " + Display.toHexString((int)n) + ", but gathered " + n2 + " modes");
            }
            float f = crtProps.pixelScaleArray[i];
            MonitorModeProps.streamInMonitorDevice((MonitorModeProps.Cache)cache, (ScreenImpl)this, (long)n, null, (MonitorMode)monitorMode, (float[])new float[]{f, f}, (boolean)false, (ArrayHashSet)arrayHashSet, (int[])crtProps.propsFixedArray[i], (int)0, null);
        }
    }

    protected boolean updateNativeMonitorDeviceViewportImpl(MonitorDevice monitorDevice, float[] fArray, Rectangle rectangle, Rectangle rectangle2) {
        float f;
        CrtProps crtProps = new CrtProps();
        int n = monitorDevice.getId();
        if (0 == n) {
            throw new IllegalArgumentException("Invalid monitor id " + Display.toHexString((int)n));
        }
        int n2 = crtProps.getIndex(n);
        if (0 > n2 || n2 >= crtProps.count) {
            throw new IndexOutOfBoundsException("monitor id " + n2 + " not within [0.." + (crtProps.count - 1) + "]");
        }
        int[] nArray = crtProps.propsFixedArray[n2];
        int n3 = 6;
        rectangle.set(nArray[n3++], nArray[n3++], nArray[n3++], nArray[n3++]);
        rectangle2.set(nArray[n3++], nArray[n3++], nArray[n3++], nArray[n3++]);
        fArray[0] = f = crtProps.pixelScaleArray[n2];
        fArray[1] = f;
        return true;
    }

    protected MonitorMode queryCurrentMonitorModeImpl(MonitorDevice monitorDevice) {
        return this.getMonitorModeImpl(null, monitorDevice.getId(), -1);
    }

    protected boolean setCurrentMonitorModeImpl(MonitorDevice monitorDevice, MonitorMode monitorMode) {
        return this.setMonitorMode0(monitorDevice.getId(), monitorMode.getId(), monitorMode.getRotation());
    }

    protected int validateScreenIndex(int n) {
        return 0;
    }

    private native int[] getMonitorDeviceIds0();

    private native int[] getMonitorProps0(int var1);

    private native int[] getMonitorMode0(int var1, int var2);

    private native boolean setMonitorMode0(int var1, int var2, int var3);

    static {
        DisplayDriver.initSingleton();
    }

    class CrtProps {
        final int count;
        final int[] crtIDs;
        final float[] pixelScaleArray;
        final int[][] propsOrigArray;
        final int[][] propsFixedArray;

        CrtProps() {
            int n;
            int n2;
            this.crtIDs = ScreenDriver.this.getMonitorDeviceIds0();
            this.count = this.crtIDs.length;
            this.pixelScaleArray = new float[this.count];
            this.propsOrigArray = new int[this.count][];
            this.propsFixedArray = new int[this.count][];
            for (n2 = 0; n2 < this.count; ++n2) {
                int n3 = this.crtIDs[n2];
                float f = IOSUtil.GetScreenPixelScaleByScreenIdx((int)n3);
                this.pixelScaleArray[n2] = FloatUtil.isZero((float)f) ? 1.0f : f;
                this.propsOrigArray[n2] = ScreenDriver.this.getMonitorProps0(n3);
                if (null == this.propsOrigArray[n2]) {
                    throw new InternalError("Could not gather device props " + n2 + "/" + this.count + " -> " + Display.toHexString((int)n3));
                }
                n = this.propsOrigArray[n2].length;
                this.propsFixedArray[n2] = new int[n];
                System.arraycopy(this.propsOrigArray[n2], 0, this.propsFixedArray[n2], 0, n);
            }
            block1: for (n2 = 0; n2 < this.count; ++n2) {
                int n4;
                int[] nArray = this.propsFixedArray[n2];
                int n5 = nArray[6];
                n = nArray[7];
                float f = this.pixelScaleArray[n2];
                nArray[8] = (int)((float)nArray[8] * f);
                nArray[9] = (int)((float)nArray[9] * f);
                if (0 != n5) {
                    for (n4 = 0; n4 < this.count; ++n4) {
                        if (n4 == n2 || n5 != this.propsOrigArray[n4][8]) continue;
                        nArray[6] = (int)((float)nArray[6] * this.pixelScaleArray[n4]);
                        break;
                    }
                }
                if (0 == n) continue;
                for (n4 = 0; n4 < this.count; ++n4) {
                    if (n4 == n2 || n != this.propsOrigArray[n4][9]) continue;
                    nArray[7] = (int)((float)nArray[7] * this.pixelScaleArray[n4]);
                    continue block1;
                }
            }
        }

        int getIndex(int n) {
            for (int i = 0; i < this.count; ++i) {
                if (n != this.crtIDs[i]) continue;
                return i;
            }
            return -1;
        }
    }
}

