/*
 * Decompiled with CFR 0.152.
 */
package jogamp.nativewindow.drm;

import com.jogamp.nativewindow.AbstractGraphicsDevice;
import com.jogamp.nativewindow.NativeWindowException;
import com.jogamp.nativewindow.ProxySurface;
import com.jogamp.nativewindow.UpstreamSurfaceHookMutableSize;
import jogamp.nativewindow.drm.DRMLib;
import jogamp.nativewindow.drm.DRMUtil;

public class GBMDummyUpstreamSurfaceHook
extends UpstreamSurfaceHookMutableSize {
    private long gbmDevice = 0L;

    public GBMDummyUpstreamSurfaceHook(int n, int n2) {
        super(n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void create(ProxySurface proxySurface) {
        AbstractGraphicsDevice abstractGraphicsDevice = proxySurface.getGraphicsConfiguration().getScreen().getDevice();
        int n = DRMUtil.GBM_FORMAT_XRGB8888;
        abstractGraphicsDevice.lock();
        try {
            if (0L == proxySurface.getSurfaceHandle()) {
                this.gbmDevice = DRMLib.gbm_create_device(DRMUtil.getDrmFd());
                if (0L == this.gbmDevice) {
                    throw new NativeWindowException("Creating dummy GBM device failed");
                }
                long l = DRMLib.gbm_surface_create(this.gbmDevice, 64, 64, n, 5);
                if (0L == l) {
                    throw new NativeWindowException("Creating dummy GBM surface failed");
                }
                proxySurface.setSurfaceHandle(l);
                proxySurface.addUpstreamOptionBits(64);
            }
            proxySurface.addUpstreamOptionBits(256);
        }
        finally {
            abstractGraphicsDevice.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void destroy(ProxySurface proxySurface) {
        if (proxySurface.containsUpstreamOptionBits(64)) {
            AbstractGraphicsDevice abstractGraphicsDevice = proxySurface.getGraphicsConfiguration().getScreen().getDevice();
            long l = proxySurface.getSurfaceHandle();
            if (0L == this.gbmDevice) {
                throw new InternalError("GBM device handle is null");
            }
            if (0L == l) {
                throw new InternalError("Owns upstream surface, but has no GBM surface: " + proxySurface);
            }
            abstractGraphicsDevice.lock();
            try {
                DRMLib.gbm_surface_destroy(l);
                proxySurface.setSurfaceHandle(0L);
                DRMLib.gbm_device_destroy(this.gbmDevice);
                this.gbmDevice = 0L;
                proxySurface.clearUpstreamOptionBits(64);
            }
            finally {
                abstractGraphicsDevice.unlock();
            }
        }
    }
}

