/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.openal;

import com.jogamp.common.GlueGenVersion;
import com.jogamp.common.os.Platform;
import com.jogamp.common.util.JogampVersion;
import com.jogamp.common.util.VersionUtil;
import com.jogamp.openal.AL;
import com.jogamp.openal.ALC;
import com.jogamp.openal.ALCcontext;
import com.jogamp.openal.ALCdevice;
import com.jogamp.openal.ALExt;
import com.jogamp.openal.ALFactory;
import com.jogamp.openal.ALVersion;
import java.util.jar.Manifest;

public class JoalVersion
extends JogampVersion {
    protected static volatile JoalVersion jogampCommonVersionInfo;

    protected JoalVersion(Manifest manifest) {
        super(manifest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JoalVersion getInstance() {
        if (null != jogampCommonVersionInfo) return jogampCommonVersionInfo;
        Class<JoalVersion> clazz = JoalVersion.class;
        synchronized (JoalVersion.class) {
            if (null != jogampCommonVersionInfo) return jogampCommonVersionInfo;
            Manifest manifest = VersionUtil.getManifest((ClassLoader)JoalVersion.class.getClassLoader(), (String)"com.jogamp.openal");
            jogampCommonVersionInfo = new JoalVersion(manifest);
            // ** MonitorExit[var0] (shouldn't be in output)
            return jogampCommonVersionInfo;
        }
    }

    public StringBuilder getBriefOSALBuildInfo(StringBuilder stringBuilder) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        stringBuilder.append("OS: ").append(Platform.getOSName()).append(", version ").append(Platform.getOSVersion()).append(", arch ").append(Platform.getArchName());
        stringBuilder.append(Platform.getNewline());
        stringBuilder.append("JOAL GIT sha1 ").append(this.getImplementationCommit());
        stringBuilder.append(Platform.getNewline());
        return stringBuilder;
    }

    public StringBuilder toString(ALC aLC, StringBuilder stringBuilder) {
        stringBuilder = super.toString(stringBuilder).append(Platform.getNewline());
        JoalVersion.getALStrings(aLC, stringBuilder);
        return stringBuilder;
    }

    public String toString(ALC aLC) {
        return this.toString(aLC, null).toString();
    }

    public static StringBuilder getALStrings(ALC aLC, StringBuilder stringBuilder) {
        ALCcontext aLCcontext;
        ALCdevice aLCdevice;
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        if (null == aLC) {
            stringBuilder.append("ALC null");
            return stringBuilder;
        }
        ALCcontext aLCcontext2 = aLC.alcGetCurrentContext();
        if (null == aLCcontext2) {
            aLCdevice = aLC.alcOpenDevice(null);
            aLCcontext = aLC.alcCreateContext(aLCdevice, null);
            aLC.alcMakeContextCurrent(aLCcontext);
        } else {
            aLCcontext = aLCcontext2;
            aLCdevice = aLC.alcGetContextsDevice(aLCcontext2);
        }
        AL aL = ALFactory.getAL();
        ALVersion aLVersion = new ALVersion(aL);
        ALExt aLExt = ALFactory.getALExt();
        aLVersion.toString(true, stringBuilder);
        stringBuilder.append("AL_EXTENSIONS  ").append(aL.alGetString(45060));
        stringBuilder.append(Platform.getNewline());
        boolean bl = aLC.alcEnumerationExtIsPresent();
        boolean bl2 = aLC.alcEnumerateAllExtIsPresent();
        String string = "(enumExt[def " + bl + ", all " + bl2 + "])";
        boolean bl3 = aLC.alcSoftSystemEventsIsPresent();
        int[] nArray = new int[]{0, 0};
        aLC.alcGetIntegerv(aLCdevice, 4096, 1, nArray, 0);
        aLC.alcGetIntegerv(aLCdevice, 4097, 1, nArray, 1);
        stringBuilder.append("ALC_VERSION     ").append(nArray[0]).append(".").append(nArray[1]);
        stringBuilder.append(Platform.getNewline());
        if (!bl && !bl2) {
            stringBuilder.append("ALC_DEF_OUTPUT Unknown ").append(string);
            stringBuilder.append(Platform.getNewline());
        } else {
            if (bl) {
                stringBuilder.append("ALC_DEF_OUTPUT (With ALC_ENUMERATION_EXT) ").append(aLC.alcGetString(aLCdevice, 4100));
                stringBuilder.append(Platform.getNewline());
            }
            if (bl2) {
                stringBuilder.append("ALC_DEF_OUTPUT (With ALC_ENUMERATE_ALL_EXT) ").append(aLC.alcGetString(aLCdevice, 4114));
                stringBuilder.append(Platform.getNewline());
            }
        }
        if (bl) {
            stringBuilder.append("ALC_DEF_CAPTURE ").append(aLC.alcGetString(aLCdevice, 785));
        } else {
            stringBuilder.append("ALC_DEF_CAPTURE Unknown ").append(string);
        }
        stringBuilder.append(Platform.getNewline());
        stringBuilder.append("ALC_SOFT_system_events").append(" ").append(bl3 ? "supported" : "unsupported");
        stringBuilder.append(Platform.getNewline());
        if (bl3) {
            class EventType {
                public final String key;
                public final int value;

                EventType(String string, int n) {
                    this.key = string;
                    this.value = n;
                }
            }
            EventType[] eventTypeArray;
            for (EventType eventType : eventTypeArray = new EventType[]{new EventType("ALC_EVENT_TYPE_DEVICE_ADDED_SOFT", 6615), new EventType("ALC_EVENT_TYPE_DEVICE_REMOVED_SOFT", 6616), new EventType("ALC_EVENT_TYPE_DEFAULT_DEVICE_CHANGED_SOFT", 6614)}) {
                int n = aLExt.alcEventIsSupportedSOFT(eventType.value, 6612);
                stringBuilder.append("    ").append(eventType.key).append(" event for playback devices is ").append(n == 6617 ? "supported" : "unsupported");
                stringBuilder.append(Platform.getNewline());
                int n2 = aLExt.alcEventIsSupportedSOFT(eventType.value, 6613);
                stringBuilder.append("    ").append(eventType.key).append(" event for capture devices is ").append(n2 == 6617 ? "supported" : "unsupported");
                stringBuilder.append(Platform.getNewline());
            }
        }
        if (null == aLCcontext2) {
            aLC.alcMakeContextCurrent(null);
            aLC.alcDestroyContext(aLCcontext);
            aLC.alcCloseDevice(aLCdevice);
        }
        JoalVersion.devicesToString(stringBuilder, aLC);
        return stringBuilder;
    }

    private static boolean checkALCError(ALC aLC, ALCdevice aLCdevice, String string) {
        int n = aLC.alcGetError(aLCdevice);
        if (n != 0) {
            System.err.printf("ALC Error 0x%x occurred: '%s' while '%s'%n", n, aLC.alcGetString(aLCdevice, n), string);
            return true;
        }
        return false;
    }

    public static void deviceToString(StringBuilder stringBuilder, ALC aLC, String string, boolean bl, String string2, String string3) {
        if (bl) {
            boolean bl2 = string.equals(string3);
            stringBuilder.append("    " + string + ", input, default " + bl2 + System.lineSeparator());
        } else {
            boolean bl3 = string.equals(string2);
            String string4 = bl3 ? "default " : "";
            int[] nArray = new int[]{0};
            ALCcontext aLCcontext = aLC.alcGetCurrentContext();
            ALCdevice aLCdevice = aLCcontext != null ? aLC.alcGetContextsDevice(aLCcontext) : null;
            ALCdevice aLCdevice2 = aLC.alcOpenDevice(string);
            if (null == aLCdevice2) {
                System.err.println("Error: Failed to open " + string4 + "output" + " device " + string);
                return;
            }
            ALCcontext aLCcontext2 = aLC.alcCreateContext(aLCdevice2, null);
            if (null == aLCcontext2) {
                System.err.println("Error: Failed to create context for " + string4 + "output" + " device " + string);
                aLC.alcCloseDevice(aLCdevice2);
                return;
            }
            if (!aLC.alcMakeContextCurrent(aLCcontext2)) {
                System.err.println("Error: Failed to make context current for " + string4 + "output" + " device " + string);
                JoalVersion.checkALCError(aLC, aLCdevice2, "alcMakeContextCurrent");
                aLC.alcDestroyContext(aLCcontext2);
                aLC.alcCloseDevice(aLCdevice2);
                return;
            }
            nArray[0] = 0;
            aLC.alcGetIntegerv(aLCdevice2, 4103, 1, nArray, 0);
            int n = JoalVersion.checkALCError(aLC, aLCdevice2, "read ALC_FREQUENCY") ? -1 : nArray[0];
            nArray[0] = 0;
            aLC.alcGetIntegerv(aLCdevice2, 4104, 1, nArray, 0);
            int n2 = JoalVersion.checkALCError(aLC, aLCdevice2, "read ALC_REFRESH") ? -1 : nArray[0];
            nArray[0] = 0;
            aLC.alcGetIntegerv(aLCdevice2, 4112, 1, nArray, 0);
            int n3 = JoalVersion.checkALCError(aLC, aLCdevice2, "read ALC_MONO_SOURCES") ? -1 : nArray[0];
            nArray[0] = 0;
            aLC.alcGetIntegerv(aLCdevice2, 4113, 1, nArray, 0);
            int n4 = JoalVersion.checkALCError(aLC, aLCdevice2, "read ALC_STEREO_SOURCES") ? -1 : nArray[0];
            stringBuilder.append("    " + string + ", " + "output" + ", default " + bl3 + ", mixer[freq " + n + ", refresh " + n2 + " (min latency " + 1000.0f / (float)n2 + " ms)], sources[mono " + n3 + ", stereo " + n4 + "]" + System.lineSeparator());
            if (null != aLCcontext) {
                aLC.alcMakeContextCurrent(aLCcontext);
                if (aLCcontext.getDirectBufferAddress() != aLCcontext2.getDirectBufferAddress()) {
                    aLC.alcDestroyContext(aLCcontext2);
                }
            } else {
                aLC.alcMakeContextCurrent(null);
                aLC.alcDestroyContext(aLCcontext2);
            }
            if (aLCdevice == null || aLCdevice.getDirectBufferAddress() != aLCdevice2.getDirectBufferAddress()) {
                aLC.alcCloseDevice(aLCdevice2);
            }
        }
    }

    public static void devicesToString(StringBuilder stringBuilder, ALC aLC) {
        String[] stringArray;
        String string;
        boolean bl = aLC.alcEnumerationExtIsPresent();
        boolean bl2 = aLC.alcEnumerateAllExtIsPresent();
        String string2 = "(enumExt[def " + bl + ", all " + bl2 + "])";
        if (!bl && !bl2) {
            stringBuilder.append("No output devices infos available ").append(string2);
        } else {
            if (bl2) {
                string = aLC.alcGetString(null, 4114);
                stringBuilder.append("Output devices (With ALC_ENUMERATE_ALL_EXT):" + System.lineSeparator());
                stringArray = aLC.alcGetAllDeviceSpecifiers();
                if (null != stringArray) {
                    for (String string3 : stringArray) {
                        JoalVersion.deviceToString(stringBuilder, aLC, string3, false, string, null);
                    }
                }
            }
            if (bl) {
                string = aLC.alcGetString(null, 4100);
                stringBuilder.append("Output devices (With ALC_ENUMERATION_EXT):" + System.lineSeparator());
                stringArray = aLC.alcGetDeviceSpecifiers();
                if (null != stringArray) {
                    for (String string3 : stringArray) {
                        JoalVersion.deviceToString(stringBuilder, aLC, string3, false, string, null);
                    }
                }
            }
        }
        if (!bl) {
            stringBuilder.append("No capture devices infos available ").append(string2);
        } else {
            string = aLC.alcGetString(null, 785);
            stringBuilder.append("Capture devices:" + System.lineSeparator());
            stringArray = aLC.alcGetCaptureDeviceSpecifiers();
            if (null != stringArray) {
                for (String string3 : stringArray) {
                    JoalVersion.deviceToString(stringBuilder, aLC, string3, true, null, string);
                }
            }
        }
    }

    public static void main(String[] stringArray) {
        System.err.println(VersionUtil.getPlatformInfo());
        System.err.println(GlueGenVersion.getInstance());
        System.err.println(JoalVersion.getInstance().toString(ALFactory.getALC()));
    }
}

