/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.newt.swt;

import com.jogamp.common.util.locks.RecursiveLock;
import com.jogamp.nativewindow.AbstractGraphicsConfiguration;
import com.jogamp.nativewindow.AbstractGraphicsDevice;
import com.jogamp.nativewindow.AbstractGraphicsScreen;
import com.jogamp.nativewindow.Capabilities;
import com.jogamp.nativewindow.CapabilitiesImmutable;
import com.jogamp.nativewindow.GraphicsConfigurationFactory;
import com.jogamp.nativewindow.NativeSurface;
import com.jogamp.nativewindow.NativeWindow;
import com.jogamp.nativewindow.NativeWindowException;
import com.jogamp.nativewindow.NativeWindowFactory;
import com.jogamp.nativewindow.NativeWindowHolder;
import com.jogamp.nativewindow.SurfaceUpdatedListener;
import com.jogamp.nativewindow.WindowClosingProtocol;
import com.jogamp.nativewindow.swt.SWTAccessor;
import com.jogamp.nativewindow.util.Insets;
import com.jogamp.nativewindow.util.InsetsImmutable;
import com.jogamp.nativewindow.util.Point;
import com.jogamp.nativewindow.util.Rectangle;
import com.jogamp.newt.Display;
import com.jogamp.newt.Window;
import com.jogamp.newt.util.EDTUtil;
import jogamp.nativewindow.macosx.OSXUtil;
import jogamp.newt.Debug;
import jogamp.newt.swt.SWTEDTUtil;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Scrollable;

public class NewtCanvasSWT
extends Canvas
implements NativeWindowHolder,
WindowClosingProtocol {
    private static final boolean DEBUG = Debug.debug((String)"Window");
    private final int iHashCode;
    private final AbstractGraphicsScreen screen;
    private WindowClosingProtocol.WindowClosingMode newtChildClosingMode = WindowClosingProtocol.WindowClosingMode.DISPOSE_ON_CLOSE;
    private final WindowClosingProtocol.WindowClosingMode closingMode = WindowClosingProtocol.WindowClosingMode.DISPOSE_ON_CLOSE;
    private volatile org.eclipse.swt.graphics.Rectangle clientAreaPixels;
    private volatile org.eclipse.swt.graphics.Rectangle clientAreaWindow;
    private volatile float[] pixelScale = new float[]{1.0f, 1.0f};
    private volatile SWTNativeWindow nativeWindow;
    private volatile Window newtChild = null;
    private volatile boolean newtChildReady = false;
    private volatile boolean postSetSize = false;
    private volatile boolean postSetPos = false;
    private final Listener swtListener = new Listener(){

        public void handleEvent(Event event) {
            switch (event.type) {
                case 9: {
                    if (DEBUG) {
                        System.err.println(NewtCanvasSWT.this.shortName() + ".Event.PAINT, " + event);
                    }
                    if (!NewtCanvasSWT.this.validateNative() || !NewtCanvasSWT.this.newtChildReady) break;
                    if (NewtCanvasSWT.this.postSetSize) {
                        NewtCanvasSWT.this.newtChild.setSize(((NewtCanvasSWT)NewtCanvasSWT.this).clientAreaWindow.width, ((NewtCanvasSWT)NewtCanvasSWT.this).clientAreaWindow.height);
                        NewtCanvasSWT.this.newtChild.setSurfaceScale(NewtCanvasSWT.this.pixelScale);
                        NewtCanvasSWT.this.postSetSize = false;
                    }
                    if (NewtCanvasSWT.this.postSetPos) {
                        NewtCanvasSWT.this.newtChild.setPosition(((NewtCanvasSWT)NewtCanvasSWT.this).clientAreaWindow.x, ((NewtCanvasSWT)NewtCanvasSWT.this).clientAreaWindow.y);
                        NewtCanvasSWT.this.postSetPos = false;
                    }
                    NewtCanvasSWT.this.newtChild.windowRepaint(0, 0, ((NewtCanvasSWT)NewtCanvasSWT.this).clientAreaPixels.width, ((NewtCanvasSWT)NewtCanvasSWT.this).clientAreaPixels.height);
                    break;
                }
                case 10: {
                    if (!DEBUG) break;
                    System.err.println(NewtCanvasSWT.this.shortName() + ".Event.MOVE, " + event);
                    break;
                }
                case 22: {
                    if (DEBUG) {
                        System.err.println(NewtCanvasSWT.this.shortName() + ".Event.SHOW, " + event);
                    }
                    if (!NewtCanvasSWT.this.newtChildReady) break;
                    NewtCanvasSWT.this.newtChild.setVisible(true, true);
                    break;
                }
                case 23: {
                    if (DEBUG) {
                        System.err.println(NewtCanvasSWT.this.shortName() + ".Event.HIDE, " + event);
                    }
                    if (!NewtCanvasSWT.this.newtChildReady) break;
                    NewtCanvasSWT.this.newtChild.setVisible(true, false);
                    break;
                }
                case 11: {
                    if (DEBUG) {
                        System.err.println(NewtCanvasSWT.this.shortName() + ".Event.RESIZE, " + event);
                    }
                    if (NewtCanvasSWT.this.isNativeValid()) {
                        NewtCanvasSWT.this.updatePosSizeCheck();
                        break;
                    }
                    NewtCanvasSWT.this.validateNative();
                    break;
                }
                case 12: {
                    if (DEBUG) {
                        System.err.println(NewtCanvasSWT.this.shortName() + ".Event.DISPOSE, " + event);
                    }
                    NewtCanvasSWT.this.dispose();
                    break;
                }
                case 26: {
                    if (!DEBUG) break;
                    System.err.println(NewtCanvasSWT.this.shortName() + ".Event.ACTIVATE, " + event);
                    break;
                }
                case 27: {
                    if (!DEBUG) break;
                    System.err.println(NewtCanvasSWT.this.shortName() + ".Event.DEACTIVATE, " + event);
                    break;
                }
                case 15: {
                    if (DEBUG) {
                        System.err.println(NewtCanvasSWT.this.shortName() + ".Event.FOCUS_IN, " + event);
                    }
                    if (!NewtCanvasSWT.this.newtChildReady) break;
                    NewtCanvasSWT.this.newtChild.requestFocus(false);
                    break;
                }
                case 16: {
                    if (!DEBUG) break;
                    System.err.println(NewtCanvasSWT.this.shortName() + ".Event.FOCUS_OUT, " + event);
                    break;
                }
                default: {
                    if (!DEBUG) break;
                    System.err.println(NewtCanvasSWT.this.shortName() + ".Event.misc: " + event.type + ", " + event);
                }
            }
        }
    };

    public static NewtCanvasSWT create(final Composite composite, final int n, final Window window) {
        final NewtCanvasSWT[] newtCanvasSWTArray = new NewtCanvasSWT[]{null};
        composite.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                newtCanvasSWTArray[0] = new NewtCanvasSWT(composite, n, window);
            }
        });
        return newtCanvasSWTArray[0];
    }

    private final String shortName() {
        return "NewtCanvasSWT(" + NewtCanvasSWT.toHexString(this.iHashCode) + ")";
    }

    public NewtCanvasSWT(Composite composite, int n, Window window) {
        super(composite, n | 0x40000);
        this.iHashCode = ((Object)((Object)this)).hashCode();
        SWTAccessor.setRealized((Control)this, (boolean)true);
        this.clientAreaPixels = SWTAccessor.getClientAreaInPixels((Scrollable)this);
        this.clientAreaWindow = this.getClientArea();
        if (0 < this.clientAreaWindow.width && 0 < this.clientAreaWindow.height) {
            this.pixelScale[0] = this.clientAreaPixels.width / this.clientAreaWindow.width;
            this.pixelScale[1] = this.clientAreaPixels.height / this.clientAreaWindow.height;
        } else {
            this.pixelScale[0] = 1.0f;
            this.pixelScale[1] = 1.0f;
        }
        AbstractGraphicsDevice abstractGraphicsDevice = SWTAccessor.getDevice((Control)this);
        this.screen = SWTAccessor.getScreen((AbstractGraphicsDevice)abstractGraphicsDevice, (int)-1);
        this.nativeWindow = null;
        this.setBackground(new Color((Device)composite.getDisplay(), 255, 255, 255));
        if (null != window) {
            this.setNEWTChild(window);
        }
        if (DEBUG) {
            long l = this.newtChildReady ? this.newtChild.getSurfaceHandle() : 0L;
            System.err.println("NewtCanvasSWT: , (" + Thread.currentThread().getName() + "): newtChildReady " + this.newtChildReady + ", pixel " + this.clientAreaPixels.x + "/" + this.clientAreaPixels.y + " " + this.clientAreaPixels.width + "x" + this.clientAreaPixels.height + ", window " + this.clientAreaWindow.x + "/" + this.clientAreaWindow.y + " " + this.clientAreaWindow.width + "x" + this.clientAreaWindow.height + ", scale " + this.pixelScale[0] + "/" + this.pixelScale[1] + " - surfaceHandle 0x" + Long.toHexString(l));
        }
        this.addListener(9, this.swtListener);
        this.addListener(10, this.swtListener);
        this.addListener(22, this.swtListener);
        this.addListener(23, this.swtListener);
        this.addListener(11, this.swtListener);
        this.addListener(12, this.swtListener);
        this.addListener(26, this.swtListener);
        this.addListener(27, this.swtListener);
        this.addListener(15, this.swtListener);
        this.addListener(16, this.swtListener);
    }

    private final int newtScaleUp(int n, int n2) {
        if (!SWTAccessor.isOSX) {
            return SWTAccessor.deviceZoomScaleUp((int)n);
        }
        return n2;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        if (DEBUG) {
            System.err.println(this.shortName() + ".setBounds: " + n + "/" + n2 + " " + n3 + "x" + n4);
        }
        this.updatePosSizeCheck();
    }

    protected final boolean isNativeValid() {
        return null != this.nativeWindow;
    }

    protected final boolean validateNative() {
        if (null != this.nativeWindow) {
            return true;
        }
        this.updatePosSizeCheck();
        org.eclipse.swt.graphics.Rectangle rectangle = this.clientAreaWindow;
        if (0 >= rectangle.width || 0 >= rectangle.height) {
            return false;
        }
        this.screen.getDevice().open();
        long l = SWTAccessor.getWindowHandle((Control)this);
        int n = SWTAccessor.getNativeVisualID((AbstractGraphicsDevice)this.screen.getDevice(), (long)l);
        boolean bl = NativeWindowFactory.isNativeVisualIDValidForProcessing((int)n);
        if (DEBUG) {
            System.err.println(this.shortName() + ".validateNative() windowHandle 0x" + Long.toHexString(l) + ", visualID 0x" + Integer.toHexString(n) + ", valid " + bl);
        }
        if (bl) {
            Capabilities capabilities = new Capabilities();
            GraphicsConfigurationFactory graphicsConfigurationFactory = GraphicsConfigurationFactory.getFactory((AbstractGraphicsDevice)this.screen.getDevice(), (CapabilitiesImmutable)capabilities);
            AbstractGraphicsConfiguration abstractGraphicsConfiguration = graphicsConfigurationFactory.chooseGraphicsConfiguration((CapabilitiesImmutable)capabilities, (CapabilitiesImmutable)capabilities, null, this.screen, n);
            if (DEBUG) {
                System.err.println(this.shortName() + ".validateNative() factory: " + graphicsConfigurationFactory + ", windowHandle 0x" + Long.toHexString(l) + ", visualID 0x" + Integer.toHexString(n) + ", chosen config: " + abstractGraphicsConfiguration);
            }
            if (null == abstractGraphicsConfiguration) {
                throw new NativeWindowException("Error choosing GraphicsConfiguration creating window: " + (Object)((Object)this));
            }
            this.nativeWindow = new SWTNativeWindow(abstractGraphicsConfiguration, l);
            this.reparentWindow(true);
        }
        return null != this.nativeWindow;
    }

    protected final void updatePosSizeCheck() {
        boolean bl;
        org.eclipse.swt.graphics.Rectangle rectangle = this.clientAreaWindow;
        org.eclipse.swt.graphics.Rectangle rectangle2 = SWTAccessor.getClientAreaInPixels((Scrollable)this);
        org.eclipse.swt.graphics.Rectangle rectangle3 = this.getClientArea();
        boolean bl2 = rectangle3.width != rectangle.width || rectangle3.height != rectangle.height;
        boolean bl3 = bl = rectangle3.x != rectangle.x || rectangle3.y != rectangle.y;
        if (bl2 || bl) {
            this.clientAreaPixels = rectangle2;
            this.clientAreaWindow = rectangle3;
            if (0 < rectangle3.width && 0 < rectangle3.height) {
                this.pixelScale[0] = rectangle2.width / rectangle3.width;
                this.pixelScale[1] = rectangle2.height / rectangle3.height;
            } else {
                this.pixelScale[0] = 1.0f;
                this.pixelScale[1] = 1.0f;
            }
        }
        if (DEBUG) {
            long l = this.newtChildReady ? this.newtChild.getSurfaceHandle() : 0L;
            System.err.println(this.shortName() + ".updatePosSizeCheck: sizeChanged " + bl2 + ", posChanged " + bl + ", (" + Thread.currentThread().getName() + "): newtChildReady " + this.newtChildReady + ", pixel " + rectangle2.x + "/" + rectangle2.y + " " + rectangle2.width + "x" + rectangle2.height + ", window " + rectangle3.x + "/" + rectangle3.y + " " + rectangle3.width + "x" + rectangle3.height + ", scale " + this.pixelScale[0] + "/" + this.pixelScale[1] + " - surfaceHandle 0x" + Long.toHexString(l));
        }
        if (bl2) {
            if (this.newtChildReady) {
                this.newtChild.setSize(rectangle3.width, rectangle3.height);
                this.newtChild.setSurfaceScale(this.pixelScale);
            } else {
                this.postSetSize = true;
            }
        }
        if (bl) {
            if (this.newtChildReady) {
                this.newtChild.setPosition(rectangle3.x, rectangle3.y);
            } else {
                this.postSetPos = true;
            }
        }
        if (DEBUG) {
            System.err.println(this.shortName() + ".updatePosSizeCheck.X END");
        }
    }

    public void update() {
    }

    public void dispose() throws SWTException {
        if (!SWTAccessor.isOnSWTThread((org.eclipse.swt.widgets.Display)this.getDisplay())) {
            throw new SWTException("Invalid thread access");
        }
        this.removeListener(9, this.swtListener);
        this.removeListener(10, this.swtListener);
        this.removeListener(22, this.swtListener);
        this.removeListener(23, this.swtListener);
        this.removeListener(11, this.swtListener);
        this.removeListener(12, this.swtListener);
        this.removeListener(26, this.swtListener);
        this.removeListener(27, this.swtListener);
        this.removeListener(15, this.swtListener);
        this.removeListener(16, this.swtListener);
        if (null != this.newtChild) {
            if (DEBUG) {
                System.err.println(this.shortName() + ".dispose.0: EDTUtil cur " + this.newtChild.getScreen().getDisplay().getEDTUtil() + ",\n\t" + this.newtChild);
            }
            this.configureNewtChild(false);
            this.newtChild.setVisible(false);
            this.newtChild.reparentWindow(null, -1, -1, 0);
            this.newtChild.destroy();
            this.newtChild = null;
        }
        this.screen.getDevice().close();
        this.nativeWindow = null;
        super.dispose();
    }

    public NativeWindow getNativeWindow() {
        return this.nativeWindow;
    }

    public NativeSurface getNativeSurface() {
        return this.nativeWindow;
    }

    public WindowClosingProtocol.WindowClosingMode getDefaultCloseOperation() {
        return this.closingMode;
    }

    public WindowClosingProtocol.WindowClosingMode setDefaultCloseOperation(WindowClosingProtocol.WindowClosingMode windowClosingMode) {
        return this.closingMode;
    }

    boolean isParent() {
        return null != this.newtChild;
    }

    boolean isFullscreen() {
        return null != this.newtChild && this.newtChild.isFullscreen();
    }

    public Window setNEWTChild(Window window) throws SWTException {
        if (!SWTAccessor.isOnSWTThread((org.eclipse.swt.widgets.Display)this.getDisplay())) {
            throw new SWTException("Invalid thread access");
        }
        Window window2 = this.newtChild;
        if (DEBUG) {
            System.err.println(this.shortName() + ".setNEWTChild.0: win " + NewtCanvasSWT.newtWinHandleToHexString(window2) + " -> " + NewtCanvasSWT.newtWinHandleToHexString(window));
        }
        if (null != this.newtChild) {
            this.reparentWindow(false);
            this.newtChild = null;
        }
        this.newtChild = window;
        if (null != this.nativeWindow && null != window) {
            this.reparentWindow(true);
        }
        return window2;
    }

    public Window getNEWTChild() {
        return this.newtChild;
    }

    public boolean setParent(Composite composite) {
        return super.setParent(composite);
    }

    void configureNewtChild(boolean bl) {
        this.newtChildReady = bl;
        if (null != this.newtChild) {
            this.newtChild.setKeyboardFocusHandler(null);
            if (bl) {
                this.newtChildClosingMode = this.newtChild.setDefaultCloseOperation(WindowClosingProtocol.WindowClosingMode.DO_NOTHING_ON_CLOSE);
            } else {
                this.newtChild.setFocusAction(null);
                this.newtChild.setDefaultCloseOperation(this.newtChildClosingMode);
            }
        }
    }

    void reparentWindow(boolean bl) {
        if (null == this.newtChild) {
            return;
        }
        if (DEBUG) {
            System.err.println(this.shortName() + ".reparentWindow.0: add=" + bl + ", win " + NewtCanvasSWT.newtWinHandleToHexString(this.newtChild) + ", EDTUtil: cur " + this.newtChild.getScreen().getDisplay().getEDTUtil());
        }
        this.newtChild.setFocusAction(null);
        if (bl) {
            this.updatePosSizeCheck();
            Display display = this.newtChild.getScreen().getDisplay();
            SWTEDTUtil sWTEDTUtil = new SWTEDTUtil(display, this.getDisplay());
            sWTEDTUtil.start();
            display.setEDTUtil((EDTUtil)sWTEDTUtil);
            this.newtChild.setSize(this.clientAreaWindow.width, this.clientAreaWindow.height);
            this.newtChild.reparentWindow((NativeWindow)this.nativeWindow, -1, -1, 2);
            this.newtChild.setPosition(this.clientAreaWindow.x, this.clientAreaWindow.y);
            this.newtChild.setVisible(true);
            this.configureNewtChild(true);
            this.newtChild.setSurfaceScale(this.pixelScale);
            this.newtChild.sendWindowEvent(100);
            this.setEnabled(true);
        } else {
            this.configureNewtChild(false);
            this.newtChild.setVisible(false);
            this.newtChild.reparentWindow(null, -1, -1, 0);
        }
        if (DEBUG) {
            System.err.println(this.shortName() + ".reparentWindow.X: add=" + bl + ", win " + NewtCanvasSWT.newtWinHandleToHexString(this.newtChild) + ", EDTUtil: cur " + this.newtChild.getScreen().getDisplay().getEDTUtil());
        }
    }

    private final void requestFocusNEWTChild() {
        if (this.newtChildReady) {
            this.newtChild.setFocusAction(null);
            this.newtChild.requestFocus();
        }
    }

    public boolean forceFocus() {
        boolean bl = NewtCanvasSWT.super.forceFocus();
        this.requestFocusNEWTChild();
        return bl;
    }

    static String newtWinHandleToHexString(Window window) {
        return null != window ? NewtCanvasSWT.toHexString(window.getWindowHandle()) : "nil";
    }

    static String toHexString(long l) {
        return "0x" + Long.toHexString(l);
    }

    private class SWTNativeWindow
    implements NativeWindow {
        private final AbstractGraphicsConfiguration config;
        private final long nativeWindowHandle;
        private final InsetsImmutable insets;

        public SWTNativeWindow(AbstractGraphicsConfiguration abstractGraphicsConfiguration, long l) {
            this.config = abstractGraphicsConfiguration;
            this.nativeWindowHandle = l;
            this.insets = SWTAccessor.isOSX ? OSXUtil.GetInsets((long)l) : new Insets(0, 0, 0, 0);
        }

        public RecursiveLock getLock() {
            return null;
        }

        public int lockSurface() throws NativeWindowException, RuntimeException {
            return 3;
        }

        public void unlockSurface() {
        }

        public boolean isSurfaceLockedByOtherThread() {
            return false;
        }

        public Thread getSurfaceLockOwner() {
            return null;
        }

        public boolean surfaceSwap() {
            return false;
        }

        public void addSurfaceUpdatedListener(SurfaceUpdatedListener surfaceUpdatedListener) {
        }

        public void addSurfaceUpdatedListener(int n, SurfaceUpdatedListener surfaceUpdatedListener) throws IndexOutOfBoundsException {
        }

        public void removeSurfaceUpdatedListener(SurfaceUpdatedListener surfaceUpdatedListener) {
        }

        public long getSurfaceHandle() {
            return 0L;
        }

        public int getX() {
            return 0;
        }

        public int getY() {
            return 0;
        }

        public int getWidth() {
            return NewtCanvasSWT.this.newtScaleUp(((NewtCanvasSWT)NewtCanvasSWT.this).clientAreaWindow.width, ((NewtCanvasSWT)NewtCanvasSWT.this).clientAreaWindow.width);
        }

        public int getHeight() {
            return NewtCanvasSWT.this.newtScaleUp(((NewtCanvasSWT)NewtCanvasSWT.this).clientAreaWindow.height, ((NewtCanvasSWT)NewtCanvasSWT.this).clientAreaWindow.height);
        }

        public final Rectangle getBounds() {
            return new Rectangle(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }

        public final Rectangle getSurfaceBounds() {
            return new Rectangle(this.getX(), this.getY(), this.getSurfaceWidth(), this.getSurfaceHeight());
        }

        public final int[] convertToWindowUnits(int[] nArray) {
            nArray[0] = (int)((float)nArray[0] / NewtCanvasSWT.this.pixelScale[0]);
            nArray[1] = (int)((float)nArray[1] / NewtCanvasSWT.this.pixelScale[1]);
            return nArray;
        }

        public final int[] convertToPixelUnits(int[] nArray) {
            nArray[0] = (int)((float)nArray[0] * NewtCanvasSWT.this.pixelScale[0]);
            nArray[1] = (int)((float)nArray[1] * NewtCanvasSWT.this.pixelScale[1]);
            return nArray;
        }

        public int getSurfaceWidth() {
            return NewtCanvasSWT.this.newtScaleUp(((NewtCanvasSWT)NewtCanvasSWT.this).clientAreaWindow.width, ((NewtCanvasSWT)NewtCanvasSWT.this).clientAreaPixels.width);
        }

        public int getSurfaceHeight() {
            return NewtCanvasSWT.this.newtScaleUp(((NewtCanvasSWT)NewtCanvasSWT.this).clientAreaWindow.height, ((NewtCanvasSWT)NewtCanvasSWT.this).clientAreaPixels.height);
        }

        public final NativeSurface getNativeSurface() {
            return this;
        }

        public AbstractGraphicsConfiguration getGraphicsConfiguration() {
            return this.config;
        }

        public long getDisplayHandle() {
            return this.config.getScreen().getDevice().getHandle();
        }

        public int getScreenIndex() {
            return this.config.getScreen().getIndex();
        }

        public void surfaceUpdated(Object object, NativeSurface nativeSurface, long l) {
        }

        public void destroy() {
        }

        public NativeWindow getParent() {
            return null;
        }

        public long getWindowHandle() {
            return this.nativeWindowHandle;
        }

        public InsetsImmutable getInsets() {
            return this.insets;
        }

        public Point getLocationOnScreen(Point point) {
            Point point2 = NativeWindowFactory.getLocationOnScreen((NativeWindow)this);
            if (null != point) {
                return point.translate(point2);
            }
            return point2;
        }

        public boolean hasFocus() {
            return NewtCanvasSWT.this.isFocusControl();
        }
    }
}

