/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.openal.test.manual;

import com.jogamp.openal.AL;
import com.jogamp.openal.ALC;
import com.jogamp.openal.ALCcontext;
import com.jogamp.openal.ALCdevice;
import com.jogamp.openal.ALFactory;
import com.jogamp.openal.ALVersion;
import com.jogamp.openal.JoalVersion;
import com.jogamp.openal.UnsupportedAudioFileException;
import com.jogamp.openal.test.resources.ResourceLocation;
import com.jogamp.openal.util.WAVData;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteOrder;

public class OpenALTest {
    private static final AL al;
    private static final ALC alc;
    private ALCdevice device = null;
    private ALCcontext context = null;
    private int[] sources = null;
    private boolean initialized = false;

    public void init() throws UnsupportedAudioFileException, IOException {
        if (this.initialized) {
            return;
        }
        System.err.println(JoalVersion.getInstance().toString(alc));
        this.device = alc.alcOpenDevice(null);
        this.context = alc.alcCreateContext(this.device, null);
        alc.alcMakeContextCurrent(this.context);
        System.out.println("ALVersion: " + new ALVersion(al).toString());
        int[] nArray = new int[1];
        al.alGenBuffers(1, nArray, 0);
        WAVData wAVData = WAVData.loadFromStream((InputStream)ResourceLocation.getTestStream2(), (int)ResourceLocation.getTestStream2Size(), (int)2, (int)16, (int)44100, (ByteOrder)ByteOrder.LITTLE_ENDIAN, (boolean)true);
        System.out.println("*** size " + wAVData.data.limit());
        al.alBufferData(nArray[0], wAVData.format, (Buffer)wAVData.data, wAVData.size, wAVData.freq);
        this.sources = new int[1];
        al.alGenSources(1, this.sources, 0);
        al.alSourcei(this.sources[0], 4105, nArray[0]);
        int[] nArray2 = new int[1];
        al.alGetSourcei(this.sources[0], 4103, nArray2, 0);
        System.err.println("Looping 1: " + (nArray2[0] == 1));
        this.initialized = true;
    }

    public void play() {
        if (!this.initialized) {
            return;
        }
        System.out.println("play direct");
        al.alSourceRewind(this.sources[0]);
        al.alSourcePlay(this.sources[0]);
    }

    public void play3f(float f, float f2, float f3) {
        if (!this.initialized) {
            return;
        }
        System.out.println("play3f " + f + ", " + f2 + ", " + f3);
        al.alSourceRewind(this.sources[0]);
        al.alSourcePlay(this.sources[0]);
        al.alSource3f(this.sources[0], 4100, f, f2, f3);
    }

    public void pause() {
        if (!this.initialized) {
            return;
        }
        al.alSourcePause(this.sources[0]);
    }

    public void dispose() {
        if (!this.initialized) {
            return;
        }
        if (null != this.sources) {
            al.alSourceStop(this.sources[0]);
            al.alDeleteSources(1, this.sources, 0);
            this.sources = null;
        }
        if (null != this.context) {
            alc.alcMakeContextCurrent(null);
            alc.alcDestroyContext(this.context);
            this.context = null;
        }
        if (null != this.device) {
            alc.alcCloseDevice(this.device);
            this.device = null;
        }
        this.initialized = false;
    }

    public static void main(String[] stringArray) throws InterruptedException, UnsupportedAudioFileException, IOException {
        OpenALTest openALTest = new OpenALTest();
        openALTest.init();
        openALTest.play();
        Thread.sleep(5000L);
        openALTest.play3f(2.0f, 2.0f, 2.0f);
        Thread.sleep(5000L);
        openALTest.play3f(3.0f, 3.0f, 3.0f);
        Thread.sleep(5000L);
        openALTest.play3f(0.0f, 0.0f, 0.0f);
        Thread.sleep(5000L);
        openALTest.dispose();
    }

    static {
        alc = ALFactory.getALC();
        al = ALFactory.getAL();
    }
}

