/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.openal.test.manual;

import com.jogamp.openal.AL;
import com.jogamp.openal.ALC;
import com.jogamp.openal.ALCcontext;
import com.jogamp.openal.ALCdevice;
import com.jogamp.openal.ALFactory;
import com.jogamp.openal.ALVersion;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.Buffer;
import java.nio.ShortBuffer;

public class Synth01AL {
    public static final float PI = (float)Math.PI;
    public static final float TWO_PI = (float)Math.PI * 2;
    private static final float EPSILON = 1.1920929E-7f;
    private static final float SHORT_MAX = 32767.0f;
    private ALC alc = null;
    private ALCdevice device = null;
    private ALCcontext context = null;
    private AL al = null;
    private final int[] buffers = new int[]{0};
    private final int[] sources = new int[]{0};
    private static final int SAMPLE_RATE = 44100;

    public static void waitForKey(String string) {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        System.err.println("> Press enter to " + string);
        try {
            System.err.println(bufferedReader.readLine());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void alCheckError(String string, boolean bl) {
        int n = this.al.alGetError();
        if (0 != n) {
            String string2 = String.format("ERROR - 0x%X %s (%s)", n, this.al.alGetString(n), string);
            System.err.println(string2);
            if (bl) {
                throw new RuntimeException(string2);
            }
        }
    }

    public void init() {
        this.alc = ALFactory.getALC();
        this.device = this.alc.alcOpenDevice(null);
        this.context = this.alc.alcCreateContext(this.device, null);
        this.alc.alcMakeContextCurrent(this.context);
        this.al = ALFactory.getAL();
        System.out.println("ALVersion: " + new ALVersion(this.al).toString());
        System.out.println("Output devices:");
        String[] stringArray = this.alc.alcGetDeviceSpecifiers();
        if (null != stringArray) {
            for (String string : stringArray) {
                System.out.println("    " + string);
            }
        }
        System.out.println("Output all devices:");
        stringArray = this.alc.alcGetAllDeviceSpecifiers();
        if (null != stringArray) {
            for (String string : stringArray) {
                System.out.println("    " + string);
            }
        }
        this.alCheckError("setup", true);
        this.al.alGenBuffers(1, this.buffers, 0);
        this.alCheckError("alGenBuffers", true);
        this.al.alGenSources(1, this.sources, 0);
        this.alCheckError("alGenSources", true);
    }

    public void exit() {
        this.al.alSourceStopv(1, this.sources, 0);
        for (int i = 0; i < 1; ++i) {
            this.al.alSourcei(this.sources[i], 4105, 0);
        }
        this.alCheckError("sources: stop and disconnected", true);
        this.al.alDeleteSources(1, this.sources, 0);
        this.al.alDeleteBuffers(1, this.buffers, 0);
        this.alCheckError("sources/buffers: deleted", true);
        if (null != this.context) {
            this.alc.alcMakeContextCurrent(null);
            this.alc.alcDestroyContext(this.context);
            this.context = null;
        }
        if (null != this.device) {
            this.alc.alcCloseDevice(this.device);
            this.device = null;
        }
    }

    public static int findBestWaveCount(float f, int n, int n2, int n3) {
        int n4;
        float f2 = 1.0f / f;
        float f3 = (float)Math.PI * 2 * f / (float)n;
        float f4 = Float.MAX_VALUE;
        float f5 = Float.MAX_VALUE;
        int n5 = -1;
        for (n4 = n2; n4 < n3 && f4 >= 1.1920929E-7f; ++n4) {
            float f6 = (float)n4 * f2;
            float f7 = f6 * (float)n;
            int n6 = (int)f7;
            float f8 = (float)Math.abs(Math.sin(f3 * (float)n6));
            if (!(f8 < f4)) continue;
            f4 = f8;
            f5 = f7 - (float)n6;
            n5 = n4;
        }
        System.err.printf("%nBest: %d/[%d..%d], waves %d, sample_count diff %.12f, sample diff %.12f%n", n4, n2, n3, n5, Float.valueOf(f5), Float.valueOf(f4));
        return n5;
    }

    public void loop(float f) {
        float f2 = 1.0f / f;
        float f3 = (float)Math.PI * 2 * f / 44100.0f;
        int n = Synth01AL.findBestWaveCount(f, 44100, 10, 1000);
        float f4 = (float)n * f2;
        int n2 = (int)(f4 * 44100.0f);
        System.err.printf("%nFreq %f Hz, period %f [ms], waves %d, duration %f [ms], sample[rate %d, step %f]%n", Float.valueOf(f), 1000.0 * (double)f2, n, 1000.0 * (double)f4, 44100, Float.valueOf(f3));
        ShortBuffer shortBuffer = ShortBuffer.allocate(n2);
        for (int i = 0; i < n2; ++i) {
            float f5 = (float)Math.sin(f3 * (float)i);
            shortBuffer.put((short)(32767.0f * f5));
        }
        shortBuffer.rewind();
        this.alCheckError("populating samples", true);
        this.al.alBufferData(this.buffers[0], 4353, (Buffer)shortBuffer, n2 * 2, 44100);
        this.alCheckError("alBufferData samples", true);
        shortBuffer.clear();
        this.al.alSourcei(this.sources[0], 4105, this.buffers[0]);
        this.alCheckError("alSourcei source <-> buffer", true);
        this.al.alSourcei(this.sources[0], 4103, 1);
        int[] nArray = new int[1];
        this.al.alGetSourcei(this.sources[0], 4103, nArray, 0);
        System.err.println("Looping 1: " + (nArray[0] == 1));
        this.al.alSourceRewind(this.sources[0]);
        this.al.alSourcePlay(this.sources[0]);
        this.alCheckError("alSourcePlay", true);
        int[] nArray2 = new int[]{0};
        this.al.alGetSourcei(this.sources[0], 4112, nArray2, 0);
        this.alCheckError("alGetSourcei AL_SOURCE_STATE", true);
        if (4114 == nArray2[0]) {
            Synth01AL.waitForKey("Stop");
        }
    }

    public static float atof(String string, float f) {
        try {
            return Float.parseFloat(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return f;
        }
    }

    public static void main(String[] stringArray) {
        float f = 100.0f;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-f")) continue;
            f = Synth01AL.atof(stringArray[++i], f);
        }
        Synth01AL synth01AL = new Synth01AL();
        synth01AL.init();
        synth01AL.loop(f);
        synth01AL.exit();
    }
}

