/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.demos.es2;

import com.jogamp.common.util.VersionUtil;
import com.jogamp.math.Recti;
import com.jogamp.math.util.SyncBuffer;
import com.jogamp.nativewindow.CapabilitiesChooser;
import com.jogamp.newt.event.WindowAdapter;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GL4;
import com.jogamp.opengl.GLArrayData;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLUniformData;
import com.jogamp.opengl.demos.es2.GearsES2;
import com.jogamp.opengl.demos.es2.LandscapeES2;
import com.jogamp.opengl.demos.es2.RedSquareES2;
import com.jogamp.opengl.demos.util.CommandlineOptions;
import com.jogamp.opengl.demos.util.MiscUtils;
import com.jogamp.opengl.util.Animator;
import com.jogamp.opengl.util.GLArrayDataServer;
import com.jogamp.opengl.util.PMVMatrix;
import com.jogamp.opengl.util.caps.NonFSAAGLCapsChooser;
import com.jogamp.opengl.util.glsl.ShaderCode;
import com.jogamp.opengl.util.glsl.ShaderProgram;
import com.jogamp.opengl.util.glsl.ShaderState;
import java.nio.FloatBuffer;

public class GearsFBO02
implements GLEventListener {
    private final GearsES2 demo;
    private final GLEventListener demo2;
    private final int swapInterval;
    private final ShaderState st;
    private final PMVMatrix pmvMatrix;
    private ShaderProgram sp0;
    private GLUniformData pmvMatrixUniform;
    private GLArrayDataServer interleavedVBO;
    private final GLUniformData texUnit0;
    private final GLUniformData texUnit1;
    private GLUniformData texType;
    Recti viewport = new Recti();
    private int fboID;
    private int fboWidth;
    private int fboHeight;
    private int colorTexID;
    private int depthStencilTexID;
    private int stencilViewID;
    private int depthStencilRenderID;
    private final boolean useDepthStencilTexture = true;
    private final int colorAttachmentPoint = 0;
    private static final float[] s_quadVertices = new float[]{-1.0f, -1.0f, 0.0f, 1.0f, -1.0f, 0.0f, -1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f};
    private static final float[] s_quadColors = new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
    private static final float[] s_quadTexCoords = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};

    public GearsFBO02(int n, int n2) {
        this.demo = new GearsES2(0);
        switch (n) {
            case 1: {
                this.demo2 = new RedSquareES2(0);
                break;
            }
            case 2: {
                this.demo2 = new LandscapeES2(0);
                break;
            }
            default: {
                this.demo2 = null;
            }
        }
        this.swapInterval = n2;
        this.texUnit0 = new GLUniformData("mgl_Texture0", 0);
        this.texUnit1 = new GLUniformData("mgl_Texture1", 1);
        this.st = new ShaderState();
        this.pmvMatrix = new PMVMatrix();
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        System.err.println("Init: Chosen Caps: " + gLAutoDrawable.getChosenGLCapabilities());
        GL4 gL4 = gLAutoDrawable.getGL().getGL4();
        this.demo.init(gLAutoDrawable);
        if (null != this.demo2) {
            this.demo2.init(gLAutoDrawable);
            this.demo.setScale(2.0f);
            this.demo.setRotX(0.0f);
            this.demo.setRotY(0.0f);
        }
        ShaderCode shaderCode = ShaderCode.create((GL2ES2)gL4, (int)35633, GearsFBO02.class, (String)"shader", (String)"shader/bin", (String)"texture01_xxx", (boolean)true);
        ShaderCode shaderCode2 = ShaderCode.create((GL2ES2)gL4, (int)35632, GearsFBO02.class, (String)"shader", (String)"shader/bin", (String)"texture01_customtex", (boolean)true);
        shaderCode.defaultShaderCustomization((GL2ES2)gL4, true, true);
        shaderCode2.defaultShaderCustomization((GL2ES2)gL4, true, true);
        this.sp0 = new ShaderProgram();
        this.sp0.add((GL2ES2)gL4, shaderCode, System.err);
        this.sp0.add((GL2ES2)gL4, shaderCode2, System.err);
        this.st.attachShaderProgram((GL2ES2)gL4, this.sp0, true);
        this.pmvMatrixUniform = new GLUniformData("mgl_PMVMatrix", 4, 4, (SyncBuffer)this.pmvMatrix.getSyncPMv());
        this.st.ownUniform(this.pmvMatrixUniform);
        this.st.uniform((GL2ES2)gL4, this.pmvMatrixUniform);
        this.interleavedVBO = GLArrayDataServer.createGLSLInterleaved((int)9, (int)5126, (boolean)false, (int)12, (int)35044);
        this.interleavedVBO.addGLSLSubArray("mgl_Vertex", 3, 34962);
        this.interleavedVBO.addGLSLSubArray("mgl_Color", 4, 34962);
        this.interleavedVBO.addGLSLSubArray("mgl_MultiTexCoord", 2, 34962);
        FloatBuffer floatBuffer = (FloatBuffer)this.interleavedVBO.getBuffer();
        for (int i = 0; i < 4; ++i) {
            floatBuffer.put(s_quadVertices, i * 3, 3);
            floatBuffer.put(s_quadColors, i * 4, 4);
            floatBuffer.put(s_quadTexCoords, i * 2, 2);
        }
        this.interleavedVBO.seal((GL)gL4, true);
        this.interleavedVBO.enableBuffer((GL)gL4, false);
        this.st.ownAttribute((GLArrayData)this.interleavedVBO, true);
        this.texType = new GLUniformData("mgl_TexType", 1);
        this.st.ownUniform(this.texType);
        this.st.uniform((GL2ES2)gL4, this.texType);
        this.st.ownUniform(this.texUnit0);
        this.st.uniform((GL2ES2)gL4, this.texUnit0);
        this.st.ownUniform(this.texUnit1);
        this.st.uniform((GL2ES2)gL4, this.texUnit1);
        this.st.useProgram((GL2ES2)gL4, false);
        this.viewport.set(0, 0, gLAutoDrawable.getSurfaceWidth(), gLAutoDrawable.getSurfaceHeight());
        this.initFBO(gL4, this.viewport.width() / 2, this.viewport.height() / 2);
        gL4.glEnable(2929);
    }

    private void initTexParam(GL2ES2 gL2ES2) {
        gL2ES2.glTexParameteri(3553, 10240, 9728);
        gL2ES2.glTexParameteri(3553, 10241, 9728);
        gL2ES2.glTexParameteri(3553, 10242, 33071);
        gL2ES2.glTexParameteri(3553, 10243, 33071);
    }

    private void initFBO(GL4 gL4, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int[] nArray = new int[]{0, 0};
        this.colorTexID = 0;
        this.depthStencilTexID = 0;
        this.stencilViewID = 0;
        this.depthStencilRenderID = 0;
        this.fboWidth = 0;
        this.fboHeight = 0;
        gL4.glGenTextures(1, nArray, 0);
        this.colorTexID = nArray[0];
        if (0 == this.colorTexID) {
            throw new GLException("XXX");
        }
        gL4.glGenTextures(2, nArray, 0);
        this.depthStencilTexID = nArray[0];
        this.stencilViewID = nArray[1];
        if (0 == this.depthStencilTexID || 0 == this.stencilViewID) {
            throw new GLException("XXX");
        }
        gL4.glGenFramebuffers(1, nArray, 0);
        this.fboID = nArray[0];
        if (0 == this.fboID) {
            throw new GLException("XXX");
        }
        gL4.glBindFramebuffer(36160, this.fboID);
        if (gL4.isGLES3()) {
            n5 = 32856;
            n4 = 6408;
            n3 = 5121;
        } else if (gL4.isGLES()) {
            n5 = 6408;
            n4 = 6408;
            n3 = 5121;
        } else {
            n5 = 32856;
            n4 = 32993;
            n3 = 33639;
        }
        gL4.glBindTexture(3553, this.colorTexID);
        gL4.glTexImage2D(3553, 0, n5, n, n2, 0, n4, n3, null);
        this.initTexParam((GL2ES2)gL4);
        gL4.glFramebufferTexture2D(36160, 36064, 3553, this.colorTexID, 0);
        gL4.glActiveTexture(33984 + this.texUnit0.intValue());
        gL4.glBindTexture(3553, this.depthStencilTexID);
        gL4.glTexImage2D(3553, 0, 35056, n, n2, 0, 34041, 34042, null);
        gL4.glTexStorage2D(3553, 1, 35056, n, n2);
        gL4.glTextureView(this.stencilViewID, 3553, this.depthStencilTexID, 35056, 0, 1, 0, 1);
        this.initTexParam((GL2ES2)gL4);
        gL4.glTexParameteri(3553, 37098, 6402);
        gL4.glActiveTexture(33984 + this.texUnit1.intValue());
        gL4.glBindTexture(3553, this.stencilViewID);
        this.initTexParam((GL2ES2)gL4);
        gL4.glTexParameteri(3553, 37098, 6401);
        gL4.glFramebufferTexture2D(36160, 33306, 3553, this.depthStencilTexID, 0);
        gL4.glBindFramebuffer(36160, 0);
        n5 = gL4.glCheckFramebufferStatus(36160);
        if (36053 != n5) {
            throw new GLException("FBO not complete, but 0x" + Integer.toHexString(n5));
        }
        this.fboWidth = n;
        this.fboHeight = n2;
    }

    private void disposeFBO(GL gL) {
        gL.glBindFramebuffer(36160, this.fboID);
        gL.glFramebufferTexture2D(36160, 36064, 3553, 0, 0);
        gL.glFramebufferTexture2D(36160, 36096, 3553, 0, 0);
        gL.glFramebufferRenderbuffer(36160, 36128, 36161, 0);
        gL.glBindTexture(3553, 0);
        int[] nArray = new int[]{this.colorTexID};
        gL.glDeleteTextures(1, nArray, 0);
        nArray = new int[]{this.depthStencilTexID, this.stencilViewID};
        gL.glDeleteTextures(2, nArray, 0);
        this.colorTexID = 0;
        this.depthStencilTexID = 0;
        this.stencilViewID = 0;
        this.depthStencilRenderID = 0;
        this.fboWidth = 0;
        this.fboHeight = 0;
        gL.glBindFramebuffer(36160, 0);
        nArray = new int[]{this.fboID};
        gL.glDeleteFramebuffers(1, nArray, 0);
        this.fboID = 0;
    }

    private void resetFBOs(GL4 gL4, int n, int n2) {
        if (this.fboWidth != n || this.fboHeight != n2) {
            this.disposeFBO((GL)gL4);
            this.initFBO(gL4, n, n2);
        }
    }

    private void resetStencil(GL2ES2 gL2ES2) {
        gL2ES2.glStencilFunc(519, 0, 255);
        gL2ES2.glStencilOp(7680, 7680, 7680);
        gL2ES2.glStencilMask(255);
    }

    public void dispose(GLAutoDrawable gLAutoDrawable) {
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        this.demo.dispose(gLAutoDrawable);
        this.disposeFBO((GL)gL2ES2);
        this.st.destroy(gL2ES2);
        this.sp0 = null;
        this.pmvMatrixUniform = null;
        this.interleavedVBO = null;
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        gL2ES2.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        gL2ES2.glClear(16640);
        gL2ES2.glViewport(this.viewport.x(), this.viewport.y(), this.fboWidth, this.fboHeight);
        gL2ES2.glBindFramebuffer(36160, this.fboID);
        gL2ES2.glEnable(2960);
        gL2ES2.glStencilFunc(519, 1, 255);
        gL2ES2.glStencilOp(7680, 7680, 7681);
        gL2ES2.glStencilMask(255);
        this.demo.setClearBuffers(true);
        this.demo.setClearStencilBuffer(true);
        this.demo.display(gLAutoDrawable);
        this.resetStencil(gL2ES2);
        gL2ES2.glBindFramebuffer(36160, 0);
        gL2ES2.glFinish();
        gL2ES2.glViewport(this.viewport.x(), this.viewport.y(), this.fboWidth, this.fboHeight);
        gL2ES2.glBindFramebuffer(36160, this.fboID);
        gL2ES2.glStencilFunc(517, 0, 255);
        gL2ES2.glStencilOp(7680, 7680, 7681);
        gL2ES2.glStencilMask(0);
        if (null != this.demo2) {
            this.demo2.display(gLAutoDrawable);
        } else {
            this.demo.setClearBuffers(false);
            this.demo.setClearStencilBuffer(false);
            this.demo.setGearsColor(-1, 1.0f, 0.8431f, 0.0f, 0.7f);
            this.demo.setScale(0.5f);
            this.demo.addPanning(-1.4f, -1.0f, 2.0f);
            this.demo.display(gLAutoDrawable);
            this.demo.setScale(1.0f);
            this.demo.addPanning(1.4f, 1.0f, -2.0f);
            this.demo.resetGearsColor();
        }
        this.resetStencil(gL2ES2);
        gL2ES2.glBindFramebuffer(36160, 0);
        gL2ES2.glFinish();
        this.st.useProgram(gL2ES2, true);
        gL2ES2.glViewport(this.viewport.x(), this.viewport.y(), this.fboWidth, this.fboHeight);
        this.texType.setData(0);
        this.st.uniform(gL2ES2, this.texType);
        gL2ES2.glActiveTexture(33984 + this.texUnit0.intValue());
        gL2ES2.glBindTexture(3553, this.colorTexID);
        if (!gL2ES2.isGLcore()) {
            gL2ES2.glEnable(3553);
        }
        this.interleavedVBO.enableBuffer((GL)gL2ES2, true);
        gL2ES2.glDrawArrays(5, 0, 4);
        this.interleavedVBO.enableBuffer((GL)gL2ES2, false);
        gL2ES2.glBindTexture(3553, 0);
        gL2ES2.glViewport(this.viewport.x(), this.viewport.y(), this.viewport.width(), this.viewport.height());
        gL2ES2.glViewport(this.viewport.x() + this.fboWidth, this.viewport.y(), this.fboWidth, this.fboHeight);
        this.texType.setData(1);
        this.st.uniform(gL2ES2, this.texType);
        gL2ES2.glActiveTexture(33984 + this.texUnit0.intValue());
        gL2ES2.glBindTexture(3553, this.depthStencilTexID);
        if (!gL2ES2.isGLcore()) {
            gL2ES2.glEnable(3553);
        }
        this.interleavedVBO.enableBuffer((GL)gL2ES2, true);
        gL2ES2.glDrawArrays(5, 0, 4);
        this.interleavedVBO.enableBuffer((GL)gL2ES2, false);
        gL2ES2.glBindTexture(3553, 0);
        gL2ES2.glViewport(this.viewport.x(), this.viewport.y(), this.viewport.width(), this.viewport.height());
        gL2ES2.glViewport(this.viewport.x() + this.fboWidth, this.viewport.y() + this.fboHeight, this.fboWidth, this.fboHeight);
        this.texType.setData(2);
        this.st.uniform(gL2ES2, this.texType);
        gL2ES2.glActiveTexture(33984 + this.texUnit1.intValue());
        gL2ES2.glBindTexture(3553, this.stencilViewID);
        if (!gL2ES2.isGLcore()) {
            gL2ES2.glEnable(3553);
        }
        this.interleavedVBO.enableBuffer((GL)gL2ES2, true);
        gL2ES2.glDrawArrays(5, 0, 4);
        this.interleavedVBO.enableBuffer((GL)gL2ES2, false);
        gL2ES2.glBindTexture(3553, 0);
        gL2ES2.glViewport(this.viewport.x(), this.viewport.y(), this.viewport.width(), this.viewport.height());
        this.st.useProgram(gL2ES2, false);
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        GL4 gL4 = gLAutoDrawable.getGL().getGL4();
        this.viewport.set(n, n2, n3, n4);
        System.err.println("**** Reshape.Reset: " + n3 + "x" + n4);
        this.resetFBOs(gL4, n3 / 2, n4 / 2);
        gL4.glViewport(this.viewport.x(), this.viewport.y(), this.fboWidth, this.fboHeight);
        gL4.glBindFramebuffer(36160, this.fboID);
        this.demo.reshape(gLAutoDrawable, n, n2, this.fboWidth, this.fboHeight);
        if (null != this.demo2) {
            this.demo2.reshape(gLAutoDrawable, n, n2, this.fboWidth, this.fboHeight);
        }
        gL4.glBindFramebuffer(36160, 0);
        gL4.glViewport(this.viewport.x(), this.viewport.y(), this.viewport.width(), this.viewport.height());
        gL4.setSwapInterval(this.swapInterval);
        this.pmvMatrix.glMatrixMode(5889);
        this.pmvMatrix.glLoadIdentity();
        this.pmvMatrix.glOrthof(-1.0f, 1.0f, -1.0f, 1.0f, 0.0f, 10.0f);
        this.pmvMatrix.glMatrixMode(5888);
        this.pmvMatrix.glLoadIdentity();
        this.st.useProgram((GL2ES2)gL4, true);
        this.st.uniform((GL2ES2)gL4, this.pmvMatrixUniform);
        this.st.useProgram((GL2ES2)gL4, false);
    }

    public static void main(String[] stringArray) {
        CommandlineOptions commandlineOptions = new CommandlineOptions(1280, 720, 0);
        commandlineOptions.setGLProfile("GL4");
        int n = 2;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-demo2") || i + 1 >= stringArray.length) continue;
            n = MiscUtils.atoi(stringArray[++i], n);
        }
        System.err.println(VersionUtil.getPlatformInfo());
        System.err.println(commandlineOptions);
        GLCapabilities gLCapabilities = commandlineOptions.getGLCaps();
        System.out.println("Requested: " + gLCapabilities);
        System.out.println("Demo2 Type: " + n);
        GLWindow gLWindow = GLWindow.create((GLCapabilitiesImmutable)gLCapabilities);
        if (0 == commandlineOptions.sceneMSAASamples) {
            gLWindow.setCapabilitiesChooser((CapabilitiesChooser)new NonFSAAGLCapsChooser(false));
        }
        gLWindow.setSize(commandlineOptions.surface_width, commandlineOptions.surface_height);
        gLWindow.setTitle(GearsFBO02.class.getSimpleName());
        gLWindow.addGLEventListener((GLEventListener)new GearsFBO02(n, 1));
        final Animator animator = new Animator(0);
        animator.setUpdateFPSFrames(300, null);
        animator.add((GLAutoDrawable)gLWindow);
        gLWindow.addWindowListener((WindowListener)new WindowAdapter(){

            public void windowDestroyed(WindowEvent windowEvent) {
                animator.stop();
            }
        });
        gLWindow.setVisible(true);
        animator.start();
    }
}

