/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.demos.graph.ui;

import com.jogamp.graph.curve.opengl.GLRegion;
import com.jogamp.graph.curve.opengl.RegionRenderer;
import com.jogamp.graph.curve.opengl.TextRegionUtil;
import com.jogamp.graph.font.Font;
import com.jogamp.graph.font.FontFactory;
import com.jogamp.graph.ui.GraphShape;
import com.jogamp.graph.ui.shapes.CrossHair;
import com.jogamp.math.FloatUtil;
import com.jogamp.math.Matrix4f;
import com.jogamp.math.Recti;
import com.jogamp.math.Vec2f;
import com.jogamp.math.Vec2i;
import com.jogamp.math.Vec3f;
import com.jogamp.math.Vec4f;
import com.jogamp.math.geom.AABBox;
import com.jogamp.math.geom.plane.AffineTransform;
import com.jogamp.math.util.PMVMatrix4f;
import com.jogamp.newt.event.WindowAdapter;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.JoglVersion;
import com.jogamp.opengl.demos.util.CommandlineOptions;
import com.jogamp.opengl.demos.util.MiscUtils;
import com.jogamp.opengl.util.Animator;
import java.io.IOException;

public class UIGraphDemoU01a {
    static final CommandlineOptions options = new CommandlineOptions(1280, 720, 2);
    static final Vec4f text_color = new Vec4f(0.0f, 1.0f, 0.0f, 1.0f);
    static Font font;
    static boolean projOrtho;
    static boolean projOrthoWin;
    static boolean textOnly;
    static int pass2TexUnit;
    static final Vec2i winOrigin;
    static final float normWidgetSize = 0.25f;

    public static void main(String[] stringArray) throws IOException {
        Object object;
        if (0 != stringArray.length) {
            object = new int[]{0};
            object[0] = 0;
            while (object[0] < stringArray.length) {
                if (!options.parse(stringArray, (int[])object)) {
                    if (stringArray[object[0]].equals("-projPersp")) {
                        projOrtho = false;
                        projOrthoWin = false;
                    } else if (stringArray[object[0]].equals("-projWin")) {
                        projOrtho = true;
                        projOrthoWin = true;
                    } else if (stringArray[object[0]].equals("-texUnit")) {
                        object[0] = object[0] + 1;
                        pass2TexUnit = MiscUtils.atoi(stringArray[object[0]], pass2TexUnit);
                    } else if (stringArray[object[0]].equals("-x")) {
                        object[0] = object[0] + 1;
                        winOrigin.setX(MiscUtils.atoi(stringArray[object[0]], winOrigin.x()));
                    } else if (stringArray[object[0]].equals("-y")) {
                        object[0] = object[0] + 1;
                        winOrigin.setY(MiscUtils.atoi(stringArray[object[0]], winOrigin.y()));
                    } else if (stringArray[object[0]].equals("-textOnly")) {
                        textOnly = true;
                    }
                }
                object[0] = object[0] + 1;
            }
        }
        System.err.println(JoglVersion.getInstance().toString());
        System.err.println(options);
        System.err.println("Ortho Projection " + projOrtho + ", Ortho-Win " + projOrthoWin);
        System.err.println("pass2TexUnit " + pass2TexUnit);
        object = options.getGLCaps();
        System.out.println("Requested: " + object);
        font = FontFactory.get((int)0).get(1, 2);
        System.err.println("Font: " + font.getFullFamilyName());
        final Animator animator = new Animator(0);
        MyRenderer myRenderer = new MyRenderer();
        final GLWindow gLWindow = GLWindow.create((GLCapabilitiesImmutable)object);
        gLWindow.setSize(UIGraphDemoU01a.options.surface_width, UIGraphDemoU01a.options.surface_height);
        gLWindow.setTitle(UIGraphDemoU01a.class.getSimpleName() + ": " + gLWindow.getSurfaceWidth() + " x " + gLWindow.getSurfaceHeight());
        gLWindow.setVisible(true);
        System.out.println("Chosen: " + gLWindow.getChosenGLCapabilities());
        gLWindow.addGLEventListener((GLEventListener)myRenderer);
        gLWindow.addWindowListener((WindowListener)new WindowAdapter(){

            public void windowResized(WindowEvent windowEvent) {
                gLWindow.setTitle(UIGraphDemoU01a.class.getSimpleName() + ": " + gLWindow.getSurfaceWidth() + " x " + gLWindow.getSurfaceHeight());
            }

            public void windowDestroyNotify(WindowEvent windowEvent) {
                animator.stop();
            }
        });
        animator.setUpdateFPSFrames(60, null);
        animator.add((GLAutoDrawable)gLWindow);
        animator.start();
    }

    static {
        projOrtho = true;
        projOrthoWin = false;
        textOnly = false;
        pass2TexUnit = 0;
        winOrigin = new Vec2i(UIGraphDemoU01a.options.surface_width / 2, UIGraphDemoU01a.options.surface_height / 2);
    }

    public static class MyRenderer
    implements GLEventListener {
        private final float angle;
        private final float zNear;
        private final float zFar;
        private final float sceneDist;
        private final Vec2f worldDim = new Vec2f(1.0f, 1.0f);
        private final Vec3f worldOrigin = new Vec3f();
        private final RegionRenderer renderer;
        private GLRegion textRegion;
        private GraphShape shape;
        private boolean onceAtDisplay = true;

        public MyRenderer() {
            if (projOrtho) {
                this.angle = 0.0f;
                this.zNear = -1.0f;
                this.zFar = 1.0f;
                this.sceneDist = this.zNear;
            } else {
                this.angle = 0.7853982f;
                this.zNear = 0.1f;
                this.zFar = 7000.0f;
                this.sceneDist = -this.zNear;
            }
            this.renderer = RegionRenderer.create((RegionRenderer.GLCallback)RegionRenderer.defaultBlendEnable, (RegionRenderer.GLCallback)RegionRenderer.defaultBlendDisable);
            this.renderer.setAAQuality(UIGraphDemoU01a.options.graphAAQuality);
            this.renderer.setSampleCount(UIGraphDemoU01a.options.graphAASamples);
        }

        public void init(GLAutoDrawable gLAutoDrawable) {
            GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
            System.err.println(JoglVersion.getGLInfo((GL)gL2ES2, null));
            if (!textOnly) {
                this.shape = new CrossHair(UIGraphDemoU01a.options.renderModes, 0.25f, 0.25f, 0.0025f);
                this.shape.setTextureUnit(pass2TexUnit);
                this.shape.setColor(0.0f, 0.0f, 1.0f, 1.0f);
                System.err.println("Init: Shape bounds " + this.shape.getBounds(gLAutoDrawable.getGLProfile()));
                System.err.println("Init: Shape " + this.shape);
            }
            this.renderer.init(gL2ES2);
            if (null == this.textRegion) {
                this.textRegion = GLRegion.create((GLProfile)gL2ES2.getGLProfile(), (int)UIGraphDemoU01a.options.renderModes, null, (int)pass2TexUnit, (int)0, (int)0);
            }
        }

        public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
            this.renderer.reshapeNotify(n, n2, n3, n4);
            this.setMatrix(this.renderer.getMatrix(), this.renderer.getViewport());
            if (!textOnly) {
                float f = Math.min(this.worldDim.x(), this.worldDim.y());
                this.shape.setScale(f, f, 1.0f);
            }
        }

        private void setMatrix(PMVMatrix4f pMVMatrix4f, Recti recti) {
            Vec3f vec3f;
            Vec3f vec3f2;
            pMVMatrix4f.loadPIdentity();
            float f = (float)recti.width() / (float)recti.height();
            if (projOrthoWin) {
                this.worldDim.setX((float)recti.width());
                this.worldDim.setY(this.worldDim.x() / f);
                pMVMatrix4f.orthoP(0.0f, this.worldDim.x(), 0.0f, this.worldDim.y(), this.zNear, this.zFar);
            } else if (projOrtho) {
                this.worldDim.setY(this.worldDim.x() / f);
                pMVMatrix4f.orthoP(-this.worldDim.x() / 2.0f, this.worldDim.x() / 2.0f, -this.worldDim.y() / 2.0f, this.worldDim.y() / 2.0f, this.zNear, this.zFar);
            } else {
                pMVMatrix4f.perspectiveP(this.angle, f, this.zNear, this.zFar);
                vec3f2 = new Vec3f();
                vec3f = new Vec3f();
                MyRenderer.winToPlaneCoord(pMVMatrix4f, recti, this.zNear, this.zFar, recti.x(), recti.y(), -this.sceneDist, vec3f2);
                MyRenderer.winToPlaneCoord(pMVMatrix4f, recti, this.zNear, this.zFar, recti.width(), recti.height(), -this.sceneDist, vec3f);
                AABBox aABBox = new AABBox();
                aABBox.setSize(vec3f2, vec3f);
                this.worldDim.set(aABBox.getWidth(), aABBox.getHeight());
            }
            pMVMatrix4f.translateP(0.0f, 0.0f, this.sceneDist);
            pMVMatrix4f.loadMvIdentity();
            MyRenderer.winToPlaneCoord(pMVMatrix4f, recti, this.zNear, this.zFar, winOrigin.x(), winOrigin.y(), -this.sceneDist, this.worldOrigin);
            vec3f2 = pMVMatrix4f.getP();
            vec3f = pMVMatrix4f.getMv();
            System.err.println("Reshape VP: " + recti);
            System.err.println("Reshape P :");
            System.err.println(vec3f2.toString());
            System.err.println("Reshape Mv:");
            System.err.println(vec3f.toString());
            System.err.println("World Dim : " + this.worldDim);
            System.err.println("Window Origin: " + winOrigin);
            System.err.println("World Origin : " + this.worldOrigin);
            pMVMatrix4f.translateMv(this.worldOrigin.x(), this.worldOrigin.y(), 0.0f);
        }

        public static void winToPlaneCoord(PMVMatrix4f pMVMatrix4f, Recti recti, float f, float f2, float f3, float f4, float f5, Vec3f vec3f) {
            float f6 = FloatUtil.getOrthoWinZ((float)f5, (float)f, (float)f2);
            pMVMatrix4f.mapWinToObj(f3, f4, f6, recti, vec3f);
        }

        public void display(GLAutoDrawable gLAutoDrawable) {
            Matrix4f matrix4f;
            Matrix4f matrix4f2;
            GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
            gL2ES2.glClearColor(1.0f, 1.0f, 1.0f, 1.0f);
            gL2ES2.glClear(16640);
            PMVMatrix4f pMVMatrix4f = this.renderer.getMatrix();
            if (this.onceAtDisplay) {
                matrix4f2 = pMVMatrix4f.getP();
                matrix4f = pMVMatrix4f.getMv();
                System.err.println("Display.0: P :");
                System.err.println(matrix4f2.toString());
                System.err.println("Display.0: Mv:");
                System.err.println(matrix4f.toString());
            }
            this.renderer.enable(gL2ES2, true);
            pMVMatrix4f.pushMv();
            this.drawText(gL2ES2, pMVMatrix4f, " Hello JogAmp Users!");
            pMVMatrix4f.popMv();
            if (!textOnly) {
                pMVMatrix4f.pushMv();
                this.shape.applyMatToMv(pMVMatrix4f);
                this.shape.draw(gL2ES2, this.renderer);
                if (this.onceAtDisplay) {
                    matrix4f2 = pMVMatrix4f.getP();
                    matrix4f = pMVMatrix4f.getMv();
                    System.err.println("Display.1: P :");
                    System.err.println(matrix4f2.toString());
                    System.err.println("Display.1: Mv:");
                    System.err.println(matrix4f.toString());
                    System.err.println("Display.1: Shape bounds " + this.shape.getBounds(gLAutoDrawable.getGLProfile()));
                    System.err.println("Display.1: Shape " + this.shape);
                    Recti recti = this.shape.getSurfacePort(pMVMatrix4f, this.renderer.getViewport(), new Recti());
                    System.err.println("Display.1: Shape SurfacePort " + recti);
                }
                pMVMatrix4f.popMv();
            }
            this.renderer.enable(gL2ES2, false);
            this.onceAtDisplay = false;
        }

        private void drawText(GL2ES2 gL2ES2, PMVMatrix4f pMVMatrix4f, String string) {
            float f;
            AffineTransform affineTransform = new AffineTransform();
            AffineTransform affineTransform2 = new AffineTransform();
            AABBox aABBox = font.getGlyphBounds((CharSequence)string, affineTransform, affineTransform2);
            float f2 = this.worldDim.x() / aABBox.getWidth();
            float f3 = f2 < (f = this.worldDim.y() / aABBox.getHeight()) ? f2 * 0.25f : f * 0.25f;
            pMVMatrix4f.scaleMv(f3, f3, 1.0f);
            pMVMatrix4f.translateMv(-aABBox.getWidth(), 0.0f, 0.0f);
            AABBox aABBox2 = TextRegionUtil.drawString3D((GL2ES2)gL2ES2, (GLRegion)this.textRegion.clear(gL2ES2), (RegionRenderer)this.renderer, (Font)font, (CharSequence)string, (Vec4f)text_color, (AffineTransform)affineTransform, (AffineTransform)affineTransform2);
            if (this.onceAtDisplay) {
                System.err.println("XXX: full_width: " + this.worldDim.x() + " / " + aABBox.getWidth() + " -> " + f2);
                System.err.println("XXX: full_height: " + this.worldDim.y() + " / " + aABBox.getHeight() + " -> " + f);
                System.err.println("XXX: txt_scale: " + f3);
                System.err.println("XXX: txt_box_em " + aABBox);
                System.err.println("XXX: txt_box_r  " + aABBox2);
                AABBox aABBox3 = aABBox2.mapToWindow(new AABBox(), pMVMatrix4f.getPMv(), this.renderer.getViewport(), true);
                System.err.println("Display.1: Shape TextPort " + aABBox3);
                Font.GlyphVisitor glyphVisitor = new Font.GlyphVisitor(){
                    int idx = 0;

                    public void visit(Font.Glyph glyph, AffineTransform affineTransform) {
                        System.err.println("idx[" + this.idx + "]: " + glyph);
                        ++this.idx;
                    }
                };
                AABBox aABBox4 = font.processString(glyphVisitor, null, (CharSequence)string, new AffineTransform(), new AffineTransform());
                System.err.println("XXX: txt_box_r2 " + aABBox4);
                Font.Glyph glyph = font.getGlyph(' ');
                System.err.println("XXX: space " + glyph);
                glyph = font.getGlyph('\t');
                System.err.println("XXX: tab " + glyph);
            }
        }

        public void dispose(GLAutoDrawable gLAutoDrawable) {
            GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
            this.textRegion.destroy(gL2ES2);
            if (!textOnly) {
                this.shape.destroy(gL2ES2, this.renderer);
            }
            this.renderer.destroy(gL2ES2);
            System.err.println("Destroyed");
        }
    }
}

