/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.demos.graph.ui;

import com.jogamp.common.av.AudioSink;
import com.jogamp.common.net.Uri;
import com.jogamp.common.util.IOUtil;
import com.jogamp.common.util.VersionUtil;
import com.jogamp.graph.curve.Region;
import com.jogamp.graph.curve.opengl.RegionRenderer;
import com.jogamp.graph.font.Font;
import com.jogamp.graph.font.FontFactory;
import com.jogamp.graph.font.FontScale;
import com.jogamp.graph.ui.Container;
import com.jogamp.graph.ui.GraphShape;
import com.jogamp.graph.ui.Group;
import com.jogamp.graph.ui.Scene;
import com.jogamp.graph.ui.Shape;
import com.jogamp.graph.ui.layout.Alignment;
import com.jogamp.graph.ui.layout.Gap;
import com.jogamp.graph.ui.layout.GridLayout;
import com.jogamp.graph.ui.shapes.BaseButton;
import com.jogamp.graph.ui.shapes.Button;
import com.jogamp.graph.ui.shapes.GLButton;
import com.jogamp.graph.ui.shapes.ImageButton;
import com.jogamp.graph.ui.shapes.Label;
import com.jogamp.graph.ui.shapes.MediaButton;
import com.jogamp.math.Vec2f;
import com.jogamp.math.geom.AABBox;
import com.jogamp.math.util.PMVMatrix4f;
import com.jogamp.nativewindow.CapabilitiesChooser;
import com.jogamp.newt.Display;
import com.jogamp.newt.MonitorDevice;
import com.jogamp.newt.NewtFactory;
import com.jogamp.newt.Screen;
import com.jogamp.newt.Window;
import com.jogamp.newt.event.MouseEvent;
import com.jogamp.newt.event.WindowAdapter;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.openal.sound3d.AudioSystem3D;
import com.jogamp.openal.sound3d.Context;
import com.jogamp.openal.sound3d.Device;
import com.jogamp.openal.sound3d.Listener;
import com.jogamp.openal.sound3d.Source;
import com.jogamp.openal.sound3d.Vec3f;
import com.jogamp.openal.util.ALAudioSink;
import com.jogamp.openal.util.SimpleSineSynth;
import com.jogamp.opengl.FPSCounter;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLAnimatorControl;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLPipelineFactory;
import com.jogamp.opengl.GLRunnable;
import com.jogamp.opengl.JoglVersion;
import com.jogamp.opengl.demos.es2.GearsES2;
import com.jogamp.opengl.demos.graph.FontSetDemos;
import com.jogamp.opengl.demos.graph.MSAATool;
import com.jogamp.opengl.demos.util.CommandlineOptions;
import com.jogamp.opengl.demos.util.MiscUtils;
import com.jogamp.opengl.util.Animator;
import com.jogamp.opengl.util.av.GLMediaPlayer;
import com.jogamp.opengl.util.av.GLMediaPlayerFactory;
import com.jogamp.opengl.util.caps.NonFSAAGLCapsChooser;
import com.jogamp.opengl.util.texture.ImageSequence;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import jogamp.graph.ui.TreeTool;

public class UISceneDemo20
implements GLEventListener {
    static final boolean DEBUG = false;
    static final boolean TRACE = false;
    static CommandlineOptions options = new CommandlineOptions(1280, 720, 2);
    private static final String defaultMediaURL = "https://archive.org/download/BigBuckBunny_328/BigBuckBunny_512kb.mp4";
    private boolean debug = false;
    private boolean trace = false;
    private final Scene scene;
    private final Font font;
    private final Font fontButtons;
    private final Font fontSymbols;
    private final Font fontFPS;
    private final Uri filmURL;
    private final float relTop = 0.9f;
    private final float relMiddle = 0.22f;
    private static final float buttonXSizeNorm = 0.09f;
    private static final float fontSizePt = 10.0f;
    private static final float fontSizeFixedNorm = 0.04f;
    private float dpiV = 96.0f;
    private int currentText = 0;
    private String actionText = null;
    private Label[] labels = null;
    private String[] strings = null;
    final Group buttonsLeft = new Group();
    final Group buttonsRight = new Group();
    private Label truePtSizeLabel = null;
    private Label jogampLabel = null;
    private Label fpsLabel = null;
    private GLAutoDrawable cDrawable;
    private final String jogamp = "JogAmp - Jogl Graph Module Demo";
    private final String truePtSize = "10.0 pt font size label - true scale!";
    private final String longText = "JOGL: Java\u2122 Binding for the OpenGL\u00ae API.\n\nLorem ipsum dolor sit amet, consectetur adipiscing elit. Donec \nUt purus odio, rhoncus sit amet commodo eget, ullamcorper vel\nquam iaculis urna cursus ornare. Nullam ut felis a ante ultrices\nIn hac habitasse platea dictumst. Vivamus et mi a quam lacinia\nMorbi quis bibendum nibh. Donec lectus orci, sagittis in consequat\nDonec ut dolor et nulla tristique varius. In nulla magna, fermentum\nin lorem. Maecenas in ipsum ac justo scelerisque sollicitudin.\n\nLyford\u2019s in Texas & L\u2019Anse-aux-Griffons in Qu\u00e9bec;\nKwikpak on the Yukon delta, Kv\u00e6ven in Norway, Kyulu in Kenya, not Rwanda.\u2026\nYtterbium in the periodic table. Are Toussaint L\u2019Ouverture, W\u00f6lfflin, Wolfe,\n\nThe quick brown fox jumps over the lazy dog\n";
    public static final int BUTTON_NEXTTEXT = 100;
    public static final int BUTTON_FPS = 101;
    public static final int BUTTON_VSYNC = 102;
    public static final int BUTTON_QUIT = 102;
    public static final int BUTTON_MOVIE = 200;
    public static final int BUTTON_GLEL = 200;
    private static final boolean enableOthers = true;
    private final Shape.MouseGestureAdapter dragZoomRotateListener = new Shape.MouseGestureAdapter(){

        public void mouseReleased(MouseEvent mouseEvent) {
            UISceneDemo20.this.actionText = null;
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            Shape.EventInfo eventInfo = (Shape.EventInfo)mouseEvent.getAttachment();
            if (mouseEvent.getPointerCount() == 1) {
                PMVMatrix4f pMVMatrix4f = new PMVMatrix4f();
                AABBox aABBox = UISceneDemo20.this.scene.getBounds(pMVMatrix4f, eventInfo.shape);
                UISceneDemo20.this.actionText = String.format((Locale)null, "Pos %s", aABBox.getCenter());
            }
        }

        public void mouseWheelMoved(MouseEvent mouseEvent) {
            Shape.EventInfo eventInfo = (Shape.EventInfo)mouseEvent.getAttachment();
            com.jogamp.math.Vec3f vec3f = new com.jogamp.math.Vec3f(mouseEvent.getRotation()).scale((float)Math.PI / 180);
            float f = vec3f.x();
            vec3f.setX(vec3f.y());
            vec3f.setY(f);
            eventInfo.shape.setRotation(eventInfo.shape.getRotation().rotateByEuler(vec3f.scale(2.0f)));
        }
    };

    public static void main(String[] stringArray) {
        Object object;
        float[] fArray = new float[]{0.0f, 0.0f};
        String string = null;
        String string2 = null;
        if (0 != stringArray.length) {
            object = new int[]{0};
            object[0] = (Display)false;
            while (object[0] < stringArray.length) {
                if (!options.parse(stringArray, (int[])object)) {
                    if (stringArray[object[0]].equals("-font")) {
                        Object object2 = object;
                        object2[0] = object2[0] + true;
                        string = stringArray[object[0]];
                    } else if (stringArray[object[0]].equals("-pixelScale")) {
                        float f;
                        Object object3 = object;
                        object3[0] = object3[0] + true;
                        fArray[0] = f = MiscUtils.atof(stringArray[object[0]], fArray[0]);
                        fArray[1] = f;
                    } else if (stringArray[object[0]].equals("-film") || stringArray[object[0]].equals("-file")) {
                        Object object4 = object;
                        object4[0] = object4[0] + true;
                        string2 = stringArray[object[0]];
                    }
                }
                Object object5 = object;
                object5[0] = object5[0] + true;
            }
        }
        System.err.println(options);
        object = NewtFactory.createDisplay(null);
        Screen screen = NewtFactory.createScreen((Display)object, (int)0);
        System.err.println(VersionUtil.getPlatformInfo());
        GLCapabilities gLCapabilities = options.getGLCaps();
        System.out.println("Requested: " + gLCapabilities);
        GLWindow gLWindow = GLWindow.create((Screen)screen, (GLCapabilitiesImmutable)gLCapabilities);
        gLWindow.invoke(false, gLAutoDrawable -> {
            gLAutoDrawable.getGL().setSwapInterval(UISceneDemo20.options.swapInterval);
            return true;
        });
        if (0 == UISceneDemo20.options.sceneMSAASamples) {
            gLWindow.setCapabilitiesChooser((CapabilitiesChooser)new NonFSAAGLCapsChooser(false));
        }
        gLWindow.setSize(UISceneDemo20.options.surface_width, UISceneDemo20.options.surface_height);
        gLWindow.setTitle("GraphUI Newt Demo: graph[" + Region.getRenderModeString((int)UISceneDemo20.options.renderModes) + "], msaa " + UISceneDemo20.options.sceneMSAASamples);
        gLWindow.setSurfaceScale(fArray);
        UISceneDemo20 uISceneDemo20 = new UISceneDemo20(string, string2, UISceneDemo20.options.renderModes, false, false);
        gLWindow.addGLEventListener((GLEventListener)uISceneDemo20);
        final Animator animator = new Animator(0);
        animator.setUpdateFPSFrames(300, null);
        animator.add((GLAutoDrawable)gLWindow);
        animator.setExclusiveContext(UISceneDemo20.options.exclusiveContext);
        gLWindow.addWindowListener((WindowListener)new WindowAdapter(){

            public void windowDestroyed(WindowEvent windowEvent) {
                animator.stop();
            }
        });
        gLWindow.setVisible(true);
        animator.start();
    }

    public UISceneDemo20(int n) {
        this(null, null, UISceneDemo20.options.noAADPIThreshold, n, false, false);
    }

    public UISceneDemo20(String string, String string2, int n, boolean bl, boolean bl2) {
        this(string, string2, UISceneDemo20.options.noAADPIThreshold, n, bl, bl2);
    }

    public UISceneDemo20(String string, String string2, float f, boolean bl, boolean bl2) {
        this(string, string2, f, 0, bl, bl2);
    }

    private UISceneDemo20(String string, String string2, float f, int n, boolean bl, boolean bl2) {
        UISceneDemo20.options.noAADPIThreshold = f;
        this.debug = bl;
        this.trace = bl2;
        UISceneDemo20.options.renderModes = n;
        try {
            this.font = null == string ? FontFactory.get((InputStream)IOUtil.getResource((String)"fonts/freefont/FreeSerif.ttf", (ClassLoader)FontSetDemos.class.getClassLoader(), FontSetDemos.class).getInputStream(), (boolean)true) : FontFactory.get((File)new File(string));
            System.err.println("Font " + this.font.getFullFamilyName());
            this.fontButtons = FontFactory.get((int)0).getDefault();
            this.fontSymbols = FontFactory.get((int)10).getDefault();
            this.fontFPS = FontFactory.get((InputStream)IOUtil.getResource((String)"fonts/freefont/FreeMono.ttf", (ClassLoader)FontSetDemos.class.getClassLoader(), FontSetDemos.class).getInputStream(), (boolean)true);
            System.err.println("Font FPS " + this.fontFPS.getFullFamilyName());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        try {
            this.filmURL = Uri.cast((String)(null != string2 ? string2 : defaultMediaURL));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RuntimeException(uRISyntaxException);
        }
        this.scene = new Scene(UISceneDemo20.options.graphAASamples);
        this.scene.setPMVMatrixSetup((Scene.PMVMatrixSetup)new Scene.DefaultPMVMatrixSetup(-1.0f));
        this.scene.getRenderer().setHintBits(2);
        this.scene.addShape((Shape)this.buttonsLeft);
        this.scene.addShape((Shape)this.buttonsRight);
    }

    private void rotateButtons(com.jogamp.math.Vec3f vec3f) {
        vec3f.scale((float)Math.PI / 180);
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.buttonsLeft.getShapes());
        arrayList.addAll(this.buttonsRight.getShapes());
        for (Shape shape : arrayList) {
            shape.setRotation(shape.getRotation().rotateByEuler(vec3f));
        }
    }

    private void setButtonsSpacing(float f, float f2) {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.buttonsLeft.getShapes());
        arrayList.addAll(this.buttonsRight.getShapes());
        for (Shape shape : arrayList) {
            if (!(shape instanceof Button)) continue;
            Button button = (Button)shape;
            float f3 = button.getSpacing().x() + f;
            float f4 = button.getSpacing().y() + f2;
            System.err.println("Spacing: X " + f3 + ", Y " + f4);
            button.setSpacing(f3, f4);
        }
    }

    private void setButtonsCorner(float f) {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.buttonsLeft.getShapes());
        arrayList.addAll(this.buttonsRight.getShapes());
        for (Shape shape : arrayList) {
            if (!(shape instanceof BaseButton)) continue;
            BaseButton baseButton = (BaseButton)shape;
            float f2 = baseButton.getCorner() + f;
            System.err.println("Corner: " + f2);
            baseButton.setCorner(f2);
        }
    }

    private void resetButtons() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.buttonsLeft.getShapes());
        arrayList.addAll(this.buttonsRight.getShapes());
        for (Shape shape : arrayList) {
            if (!(shape instanceof BaseButton)) continue;
            BaseButton baseButton = (BaseButton)shape;
            baseButton.setRotation(baseButton.getRotation().setIdentity());
            baseButton.setCorner(1.0f);
            if (!(baseButton instanceof Button)) continue;
            ((Button)baseButton).setSpacing(0.2f, 0.46f);
        }
    }

    public Shape getShapeByID(int n) {
        return this.scene.getShapeByID(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSound(Shape shape, Context context, Source source) {
        Listener listener = AudioSystem3D.getListener();
        context.makeCurrent(true);
        try {
            float[] fArray = listener.getOrientation();
            System.err.printf("Listener init orientation: at[%.3f %.3f %.3f], up[%.3f %.3f %.3f]%n", Float.valueOf(fArray[0]), Float.valueOf(fArray[1]), Float.valueOf(fArray[2]), Float.valueOf(fArray[3]), Float.valueOf(fArray[4]), Float.valueOf(fArray[5]));
            fArray = new float[]{0.0f, 0.0f, -1.0f, 0.0f, 1.0f, 0.0f};
            listener.setOrientation(fArray);
            fArray = listener.getOrientation();
            System.err.printf("Listener set orientation: at[%.3f %.3f %.3f], up[%.3f %.3f %.3f]%n", Float.valueOf(fArray[0]), Float.valueOf(fArray[1]), Float.valueOf(fArray[2]), Float.valueOf(fArray[3]), Float.valueOf(fArray[4]), Float.valueOf(fArray[5]));
            Vec3f vec3f = listener.getPosition();
            System.err.printf("Listener init pos: %.3f %.3f %.3f%n", Float.valueOf(vec3f.v1), Float.valueOf(vec3f.v2), Float.valueOf(vec3f.v3));
            listener.setPosition(0.0f, 0.0f, -0.25f);
            vec3f = listener.getPosition();
            System.err.printf("Listener set pos: %.3f %.3f %.3f%n", Float.valueOf(vec3f.v1), Float.valueOf(vec3f.v2), Float.valueOf(vec3f.v3));
            System.err.printf("Source init rel: %b%n", source.isSourceRelative());
            source.setSourceRelative(false);
            System.err.printf("Source set rel: %b%n", source.isSourceRelative());
            vec3f = source.getDirection();
            System.err.printf("Source init dir: %.3f %.3f %.3f%n", Float.valueOf(vec3f.v1), Float.valueOf(vec3f.v2), Float.valueOf(vec3f.v3));
            float f = source.getRolloffFactor();
            System.err.printf("Source init rollOff: %.3f%n", Float.valueOf(f));
            float f2 = source.getReferenceDistance();
            source.setReferenceDistance(0.75f);
            float f3 = source.getReferenceDistance();
            System.err.printf("Source ref-dist: %.3f -> %.3f%n", Float.valueOf(f2), Float.valueOf(f3));
            vec3f = source.getPosition();
            System.err.printf("Source init pos: %.3f %.3f %.3f%n", Float.valueOf(vec3f.v1), Float.valueOf(vec3f.v2), Float.valueOf(vec3f.v3));
            AudioSystem3D.checkError((Device)context.getDevice(), (String)"setup", (boolean)true, (boolean)false);
            this.setSoundPosition(shape, context, source);
        }
        finally {
            context.release(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSoundPosition(Shape shape, Context context, Source source) {
        PMVMatrix4f pMVMatrix4f = new PMVMatrix4f();
        AABBox aABBox = this.scene.getBounds(pMVMatrix4f, shape);
        context.makeCurrent(true);
        try {
            source.setPosition(aABBox.getCenter().x(), aABBox.getCenter().y(), aABBox.getCenter().z());
            System.err.println("Source pos: " + aABBox.getCenter());
        }
        finally {
            context.release(true);
        }
    }

    private static void setSineSoundLabel(Button button, float f, float f2) {
        String string;
        if (button.isToggleOn()) {
            string = String.format("scroll %.0f Hz\nctrl-scroll %.2f amp\nmove spatial", Float.valueOf(f), Float.valueOf(f2));
            button.setSpacing(0.05f, 0.2f);
        } else {
            string = String.format("click to enable\nf %.0f Hz, a %.2f", Float.valueOf(f), Float.valueOf(f2));
            button.setSpacing(0.2f, 0.46f);
        }
        button.setText((CharSequence)string);
    }

    private void initButtons(final GL2ES2 gL2ES22) {
        boolean bl = Region.isTwoPass((int)UISceneDemo20.options.renderModes);
        this.buttonsLeft.removeAllShapes(gL2ES22, this.scene.getRenderer());
        this.buttonsRight.removeAllShapes(gL2ES22, this.scene.getRenderer());
        this.buttonsLeft.setLayout((Group.Layout)new GridLayout(0.09f, 0.036000002f, Alignment.Fill, new Gap(0.018000001f, 0.009000001f), 7));
        this.buttonsRight.setLayout((Group.Layout)new GridLayout(1, 0.18f, 0.072000004f, Alignment.Fill, new Gap(0.018000001f, 0.009000001f)));
        System.err.println("Button Size: 0.09 x 0.036000002");
        Vec2f vec2f = new Vec2f(0.0f, 1.0f);
        Vec2f vec2f2 = new Vec2f(0.0f, 0.2f);
        Button button = new Button(UISceneDemo20.options.renderModes, this.fontSymbols, (CharSequence)this.fontSymbols.getUTF16String("fast_forward"), 0.09f, 0.036000002f);
        button.setSpacing(vec2f2, vec2f);
        button.setID(100);
        button.addMouseListener((Shape.MouseGestureListener)new Shape.MouseGestureAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (null != UISceneDemo20.this.labels[UISceneDemo20.this.currentText]) {
                    UISceneDemo20.this.labels[UISceneDemo20.this.currentText].setVisible(false);
                }
                UISceneDemo20.this.currentText = (UISceneDemo20.this.currentText + 1) % UISceneDemo20.this.labels.length;
                if (null != UISceneDemo20.this.labels[UISceneDemo20.this.currentText]) {
                    UISceneDemo20.this.labels[UISceneDemo20.this.currentText].setVisible(true);
                }
            }
        });
        button.addMouseListener((Shape.MouseGestureListener)this.dragZoomRotateListener);
        this.buttonsLeft.addShape((Shape)button);
        button = new Button(UISceneDemo20.options.renderModes, this.fontButtons, (CharSequence)"Show fps", (CharSequence)"Hide fps", 0.09f, 0.036000002f, 1.53E-4f);
        button.setID(101);
        button.setToggleable(true);
        button.setToggle(this.fpsLabel.isVisible());
        button.addMouseListener((Shape.MouseGestureListener)new Shape.MouseGestureAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                GLAnimatorControl gLAnimatorControl = UISceneDemo20.this.cDrawable.getAnimator();
                if (null != gLAnimatorControl) {
                    gLAnimatorControl.resetFPSCounter();
                }
                UISceneDemo20.this.fpsLabel.setVisible(!UISceneDemo20.this.fpsLabel.isVisible());
            }
        });
        button.addMouseListener((Shape.MouseGestureListener)this.dragZoomRotateListener);
        this.buttonsLeft.addShape((Shape)button);
        button = new Button(UISceneDemo20.options.renderModes, this.fontButtons, (CharSequence)" V-Sync ", 0.09f, 0.036000002f);
        button.setID(102);
        button.setToggleable(true);
        button.setToggle(gL2ES22.getSwapInterval() > 0);
        button.addMouseListener((Shape.MouseGestureListener)new Shape.MouseGestureAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                UISceneDemo20.this.cDrawable.invoke(false, new GLRunnable(){

                    public boolean run(GLAutoDrawable gLAutoDrawable) {
                        GL gL;
                        gL.setSwapInterval((gL = gLAutoDrawable.getGL()).getSwapInterval() <= 0 ? 1 : 0);
                        GLAnimatorControl gLAnimatorControl = gLAutoDrawable.getAnimator();
                        if (null != gLAnimatorControl) {
                            gLAnimatorControl.resetFPSCounter();
                        }
                        return true;
                    }
                });
            }
        });
        button.addMouseListener((Shape.MouseGestureListener)this.dragZoomRotateListener);
        this.buttonsLeft.addShape((Shape)button);
        button = new Button(UISceneDemo20.options.renderModes, this.fontButtons, (CharSequence)" < Tilt > ", 0.09f, 0.036000002f);
        button.addMouseListener((Shape.MouseGestureListener)new Shape.MouseGestureAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                Shape.EventInfo eventInfo = (Shape.EventInfo)mouseEvent.getAttachment();
                if (eventInfo.objPos.x() < eventInfo.shape.getBounds().getCenter().x()) {
                    UISceneDemo20.this.rotateButtons(new com.jogamp.math.Vec3f(0.0f, -5.0f, 0.0f));
                } else {
                    UISceneDemo20.this.rotateButtons(new com.jogamp.math.Vec3f(0.0f, 5.0f, 0.0f));
                }
            }

            public void mouseWheelMoved(MouseEvent mouseEvent) {
                UISceneDemo20.this.rotateButtons(new com.jogamp.math.Vec3f(0.0f, mouseEvent.getRotation()[1], 0.0f));
            }
        });
        this.buttonsLeft.addShape((Shape)button);
        if (bl) {
            button = new Button(UISceneDemo20.options.renderModes, this.fontButtons, (CharSequence)"< Samples >", 0.09f, 0.036000002f);
            button.addMouseListener((Shape.MouseGestureListener)new Shape.MouseGestureAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    Shape.EventInfo eventInfo = (Shape.EventInfo)mouseEvent.getAttachment();
                    int n = UISceneDemo20.this.scene.getSampleCount();
                    n = eventInfo.objPos.x() < eventInfo.shape.getBounds().getCenter().x() ? --n : ++n;
                    n = UISceneDemo20.this.scene.setSampleCount(n);
                }
            });
            button.addMouseListener((Shape.MouseGestureListener)this.dragZoomRotateListener);
            this.buttonsLeft.addShape((Shape)button);
            button = new Button(UISceneDemo20.options.renderModes, this.fontButtons, (CharSequence)"< Quality >", 0.09f, 0.036000002f);
            button.addMouseListener((Shape.MouseGestureListener)new Shape.MouseGestureAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    Shape.EventInfo eventInfo = (Shape.EventInfo)mouseEvent.getAttachment();
                    if (eventInfo.shape instanceof GraphShape) {
                        int n = UISceneDemo20.this.scene.getAAQuality();
                        n = eventInfo.objPos.x() < eventInfo.shape.getBounds().getCenter().x() ? --n : ++n;
                        UISceneDemo20.this.scene.setAAQuality(n);
                    }
                }
            });
            button.addMouseListener((Shape.MouseGestureListener)this.dragZoomRotateListener);
            this.buttonsLeft.addShape((Shape)button);
        }
        button = new Button(UISceneDemo20.options.renderModes, this.fontSymbols, (CharSequence)this.fontSymbols.getUTF16String("power_settings_new"), 0.09f, 0.036000002f);
        button.setSpacing(vec2f2, vec2f);
        button.setID(102);
        button.setColor(0.7f, 0.3f, 0.3f, 1.0f);
        button.setLabelColor(1.2f, 1.2f, 1.2f, 1.0f);
        button.setPressedColorMod(1.1f, 0.0f, 0.0f, 1.0f);
        button.addMouseListener((Shape.MouseGestureListener)new Shape.MouseGestureAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                MiscUtils.destroyWindow(UISceneDemo20.this.cDrawable);
            }
        });
        button.addMouseListener((Shape.MouseGestureListener)this.dragZoomRotateListener);
        this.buttonsLeft.addShape((Shape)button);
        button = new Button(UISceneDemo20.options.renderModes, this.fontSymbols, (CharSequence)this.fontSymbols.getUTF16String("flip"), 0.09f, 0.036000002f);
        button.setSpacing(vec2f2, vec2f);
        button.addMouseListener((Shape.MouseGestureListener)new Shape.MouseGestureAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                UISceneDemo20.this.rotateButtons(new com.jogamp.math.Vec3f(0.0f, 180.0f, 0.0f));
            }
        });
        button.addMouseListener((Shape.MouseGestureListener)this.dragZoomRotateListener);
        this.buttonsLeft.addShape((Shape)button);
        button = new Button(UISceneDemo20.options.renderModes, this.fontButtons, (CharSequence)" X Flip ", 0.09f, 0.036000002f);
        button.addMouseListener((Shape.MouseGestureListener)new Shape.MouseGestureAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                UISceneDemo20.this.rotateButtons(new com.jogamp.math.Vec3f(180.0f, 0.0f, 0.0f));
            }
        });
        button.addMouseListener((Shape.MouseGestureListener)this.dragZoomRotateListener);
        this.buttonsLeft.addShape((Shape)button);
        button = new Button(UISceneDemo20.options.renderModes, this.fontButtons, (CharSequence)"< Space >", 0.09f, 0.036000002f);
        button.addMouseListener((Shape.MouseGestureListener)new Shape.MouseGestureAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                float f;
                float f2;
                Shape.EventInfo eventInfo = (Shape.EventInfo)mouseEvent.getAttachment();
                if (eventInfo.objPos.x() < eventInfo.shape.getBounds().getCenter().x()) {
                    f2 = -0.01f;
                    f = -0.005f;
                } else {
                    f2 = 0.01f;
                    f = 0.005f;
                }
                UISceneDemo20.this.setButtonsSpacing(f2, f);
            }

            public void mouseWheelMoved(MouseEvent mouseEvent) {
                UISceneDemo20.this.setButtonsSpacing(mouseEvent.getRotation()[0] / 100.0f, mouseEvent.getRotation()[1] / 200.0f);
            }
        });
        this.buttonsLeft.addShape((Shape)button);
        button = new Button(UISceneDemo20.options.renderModes, this.fontButtons, (CharSequence)"< Corner >", 0.09f, 0.036000002f);
        button.addMouseListener((Shape.MouseGestureListener)new Shape.MouseGestureAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                Shape.EventInfo eventInfo = (Shape.EventInfo)mouseEvent.getAttachment();
                float f = eventInfo.objPos.x() < eventInfo.shape.getBounds().getCenter().x() ? -0.1f : 0.1f;
                UISceneDemo20.this.setButtonsCorner(f);
            }

            public void mouseWheelMoved(MouseEvent mouseEvent) {
                UISceneDemo20.this.setButtonsCorner(mouseEvent.getRotation()[1] / 20.0f);
            }
        });
        this.buttonsLeft.addShape((Shape)button);
        button = new Button(UISceneDemo20.options.renderModes, this.fontSymbols, (CharSequence)this.fontSymbols.getUTF16String("undo"), 0.09f, 0.036000002f);
        button.setSpacing(vec2f2, vec2f);
        button.addMouseListener((Shape.MouseGestureListener)new Shape.MouseGestureAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                UISceneDemo20.this.resetButtons();
            }
        });
        button.addMouseListener((Shape.MouseGestureListener)this.dragZoomRotateListener);
        this.buttonsLeft.addShape((Shape)button);
        button = new Button(UISceneDemo20.options.renderModes, this.fontSymbols, (CharSequence)this.fontSymbols.getUTF16String("camera"), 0.09f, 0.036000002f);
        button.setSpacing(vec2f2, vec2f);
        button.addMouseListener((Shape.MouseGestureListener)new Shape.MouseGestureAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                UISceneDemo20.this.scene.screenshot(false, UISceneDemo20.this.scene.nextScreenshotFile(null, UISceneDemo20.class.getSimpleName(), UISceneDemo20.options.renderModes, gL2ES22.getContext().getGLDrawable().getChosenGLCapabilities(), null));
            }
        });
        button.addMouseListener((Shape.MouseGestureListener)this.dragZoomRotateListener);
        this.buttonsLeft.addShape((Shape)button);
        int n = 1;
        int n2 = 2;
        int n3 = 3;
        Object object = GLMediaPlayerFactory.createDefault();
        object.setTextureUnit(n);
        object.setAudioChannelLimit(1);
        button = new MediaButton(UISceneDemo20.options.renderModes, 0.18f, 0.072000004f, (GLMediaPlayer)object);
        button.setID(200);
        ((MediaButton)button).setVerbose(false).addDefaultEventListener().setFixedARatioResize(true);
        button.setToggleable(true);
        button.setToggle(true);
        button.setToggleOffColorMod(0.0f, 1.0f, 0.0f, 1.0f);
        button.addMouseListener((Shape.MouseGestureListener)this.dragZoomRotateListener);
        button.onToggle(arg_0 -> UISceneDemo20.lambda$initButtons$1((GLMediaPlayer)object, arg_0));
        Object object2 = new Button[]{null};
        object.addEventListener(new GLMediaPlayer.GLMediaEventListener(){
            final /* synthetic */ ALAudioSink[] val$alAudioSink;
            {
                this.val$alAudioSink = aLAudioSinkArray;
            }

            public void attributesChanged(GLMediaPlayer gLMediaPlayer, GLMediaPlayer.EventMask eventMask, long l) {
                System.err.println("MediaButton AttributesChanges: " + eventMask + ", when " + l);
                System.err.println("MediaButton State: " + gLMediaPlayer);
                if (eventMask.isSet(GLMediaPlayer.EventMask.Bit.Init)) {
                    AudioSink audioSink = gLMediaPlayer.getAudioSink();
                    this.val$alAudioSink[0] = audioSink instanceof ALAudioSink ? (ALAudioSink)audioSink : null;
                }
                if (eventMask.isSet(GLMediaPlayer.EventMask.Bit.EOS)) {
                    this.val$alAudioSink[0] = null;
                }
            }
        });
        button.onMove((arg_0, arg_1, arg_2, arg_3) -> this.lambda$initButtons$2((ALAudioSink[])object2, arg_0, arg_1, arg_2, arg_3));
        button.onDraw((arg_0, arg_1, arg_2) -> this.lambda$initButtons$3((ALAudioSink[])object2, arg_0, arg_1, arg_2));
        this.buttonsRight.addShape((Shape)button);
        object.playStream(this.filmURL, -1, -1, -2, 3);
        object = new SimpleSineSynth();
        this.scene.addDisposeAction(arg_0 -> UISceneDemo20.lambda$initButtons$4((SimpleSineSynth)object, arg_0));
        object.setFreq(200.0f);
        object.setAmplitude(0.1f);
        button = object2 = new Button(UISceneDemo20.options.renderModes, this.fontButtons, (CharSequence)"lala", 0.18f, 0.072000004f);
        button.setToggleable(true);
        button.setToggle(false);
        UISceneDemo20.setSineSoundLabel(object2, object.getFreq(), object.getAmplitude());
        ALAudioSink aLAudioSink = object.getSink();
        Source source = aLAudioSink.getSource();
        button.addMouseListener((Shape.MouseGestureListener)new Shape.MouseGestureAdapter((SimpleSineSynth)object, (Button)object2){
            final /* synthetic */ SimpleSineSynth val$sineSound;
            final /* synthetic */ Button val$sineButton;
            {
                this.val$sineSound = simpleSineSynth;
                this.val$sineButton = button;
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                UISceneDemo20.this.actionText = null;
            }

            public void mouseDragged(MouseEvent mouseEvent) {
                Shape.EventInfo eventInfo = (Shape.EventInfo)mouseEvent.getAttachment();
                if (mouseEvent.getPointerCount() == 1) {
                    PMVMatrix4f pMVMatrix4f = new PMVMatrix4f();
                    AABBox aABBox = UISceneDemo20.this.scene.getBounds(pMVMatrix4f, eventInfo.shape);
                    UISceneDemo20.this.actionText = String.format((Locale)null, "Pos %s", aABBox.getCenter());
                }
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                Shape.EventInfo eventInfo = (Shape.EventInfo)mouseEvent.getAttachment();
                if (eventInfo.shape.isToggleOn()) {
                    this.val$sineSound.play();
                } else {
                    this.val$sineSound.pause();
                }
                UISceneDemo20.setSineSoundLabel(this.val$sineButton, this.val$sineSound.getFreq(), this.val$sineSound.getAmplitude());
            }

            public void mouseWheelMoved(MouseEvent mouseEvent) {
                if (mouseEvent.isControlDown()) {
                    float f = this.val$sineSound.getAmplitude() + mouseEvent.getRotation()[1] / 20.0f;
                    this.val$sineSound.setAmplitude(f);
                } else {
                    float f = this.val$sineSound.getFreq() + mouseEvent.getRotation()[1] * 10.0f;
                    this.val$sineSound.setFreq(f);
                }
                UISceneDemo20.setSineSoundLabel(this.val$sineButton, this.val$sineSound.getFreq(), this.val$sineSound.getAmplitude());
                System.err.println("Sine " + this.val$sineSound);
            }
        });
        button.onDraw((shape, gL2ES2, regionRenderer) -> {
            if (null != aLAudioSink && aLAudioSink.getContext().isValid()) {
                this.initSound(shape, aLAudioSink.getContext(), source);
                System.err.println("Sine Audio: " + aLAudioSink);
                return true;
            }
            return false;
        });
        button.onMove((shape, vec3f, vec3f2, mouseEvent) -> this.setSoundPosition(shape, aLAudioSink.getContext(), source));
        this.buttonsRight.addShape((Shape)button);
        object = new ImageSequence(n2, true);
        button = new ImageButton(UISceneDemo20.options.renderModes, 0.18f, 0.072000004f, (ImageSequence)object);
        try {
            object.addFrame((GL)gL2ES22, UISceneDemo20.class, "button-released-145x53.png", "png");
            object.addFrame((GL)gL2ES22, UISceneDemo20.class, "button-pressed-145x53.png", "png");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        object.setManualStepping(true);
        button.addMouseListener((Shape.MouseGestureListener)this.dragZoomRotateListener);
        button.addMouseListener((Shape.MouseGestureListener)new Shape.MouseGestureAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                Shape.EventInfo eventInfo = (Shape.EventInfo)mouseEvent.getAttachment();
                ImageButton imageButton = (ImageButton)eventInfo.shape;
                imageButton.setCurrentIdx(1);
                System.err.println("XXX: " + imageButton);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                Shape.EventInfo eventInfo = (Shape.EventInfo)mouseEvent.getAttachment();
                ImageButton imageButton = (ImageButton)eventInfo.shape;
                imageButton.setCurrentIdx(0);
            }
        });
        this.buttonsRight.addShape((Shape)button);
        object = new GearsES2(0);
        ((GearsES2)object).setVerbose(false);
        ((GearsES2)object).setClearColor(new float[]{0.9f, 0.9f, 0.9f, 1.0f});
        object2 = new boolean[]{true};
        new Thread(new Runnable(){
            final /* synthetic */ GearsES2 val$gears;
            final /* synthetic */ boolean[] val$animate;
            {
                this.val$gears = gearsES2;
                this.val$animate = blArray;
            }

            @Override
            public void run() {
                System.err.println("Gears Anim: Waiting");
                try {
                    this.val$gears.waitForInit(true);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                System.err.println("Gears Anim: Started");
                while (this.val$gears.isInit()) {
                    if (this.val$animate[0]) {
                        float f = (this.val$gears.getRotY() + 1.0f) % 360.0f;
                        this.val$gears.setRotY(f);
                    }
                    try {
                        Thread.sleep(15L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                System.err.println("Gears Anim: End");
            }
        }).start();
        button = new GLButton(UISceneDemo20.options.renderModes, 0.18f, 0.072000004f, n3, (GLEventListener)object, false);
        button.setID(200);
        button.setToggleable(true);
        button.setToggle(false);
        ((GLButton)button).setAnimate(false);
        button.addMouseListener((Shape.MouseGestureListener)this.dragZoomRotateListener);
        button.addMouseListener((Shape.MouseGestureListener)new Shape.MouseGestureAdapter((boolean[])object2){
            final /* synthetic */ boolean[] val$animate;
            {
                this.val$animate = blArray;
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                Shape.EventInfo eventInfo = (Shape.EventInfo)mouseEvent.getAttachment();
                GLButton gLButton = (GLButton)eventInfo.shape;
                gLButton.setAnimate(gLButton.isToggleOn());
                this.val$animate[0] = gLButton.getAnimate();
            }
        });
        this.buttonsRight.addShape((Shape)button);
    }

    private void initTexts() {
        this.strings = new String[4];
        int n = 0;
        this.strings[n++] = "- Mouse Scroll Over Object\n   - General\n     - X-Rotation\n     - Shift: Y-Rotation\n   - Tilt, Space and Corner\n     - Their respective action via wheel\n       (shift = other value)\n\n- Mouse Drag On Object\n   - Click on Object and drag mouse\n   - Current postion in status line at bottom\n   - Resize when click on 1/4 bottom-left or bottom-right corner.\n\n- Tilt Button Rotate Whole Button Group";
        this.strings[n++] = "abcdefghijklmn\nopqrstuvwxyz\nABCDEFGHIJKL\nMNOPQRSTUVWXYZ\n0123456789.:,;(*!?/\\\")$%^&-+@~#<>{}[]";
        this.strings[n++] = "The quick brown fox jumps over the lazy dog";
        this.strings[n++] = "JOGL: Java\u2122 Binding for the OpenGL\u00ae API.\n\nLorem ipsum dolor sit amet, consectetur adipiscing elit. Donec \nUt purus odio, rhoncus sit amet commodo eget, ullamcorper vel\nquam iaculis urna cursus ornare. Nullam ut felis a ante ultrices\nIn hac habitasse platea dictumst. Vivamus et mi a quam lacinia\nMorbi quis bibendum nibh. Donec lectus orci, sagittis in consequat\nDonec ut dolor et nulla tristique varius. In nulla magna, fermentum\nin lorem. Maecenas in ipsum ac justo scelerisque sollicitudin.\n\nLyford\u2019s in Texas & L\u2019Anse-aux-Griffons in Qu\u00e9bec;\nKwikpak on the Yukon delta, Kv\u00e6ven in Norway, Kyulu in Kenya, not Rwanda.\u2026\nYtterbium in the periodic table. Are Toussaint L\u2019Ouverture, W\u00f6lfflin, Wolfe,\n\nThe quick brown fox jumps over the lazy dog\n";
        this.labels = new Label[n];
        this.currentText = this.strings.length - 1;
    }

    private void initLabels(GL2ES2 gL2ES2) {
        this.jogampLabel = new Label(UISceneDemo20.options.renderModes, this.font, 0.04f, (CharSequence)"JogAmp - Jogl Graph Module Demo");
        this.jogampLabel.addMouseListener((Shape.MouseGestureListener)this.dragZoomRotateListener);
        this.jogampLabel.setVisible(true);
        this.scene.addShape((Shape)this.jogampLabel);
        this.truePtSizeLabel = new Label(UISceneDemo20.options.renderModes, this.font, (CharSequence)"10.0 pt font size label - true scale!");
        this.truePtSizeLabel.setVisible(true);
        this.truePtSizeLabel.setColor(0.1f, 0.1f, 0.1f, 1.0f);
        this.scene.addShape((Shape)this.truePtSizeLabel);
        this.fpsLabel = new Label(UISceneDemo20.options.renderModes, this.fontFPS, (CharSequence)"Nothing there yet");
        this.fpsLabel.addMouseListener((Shape.MouseGestureListener)this.dragZoomRotateListener);
        this.fpsLabel.setVisible(true);
        this.fpsLabel.setColor(0.1f, 0.1f, 0.1f, 1.0f);
        this.scene.addShape((Shape)this.fpsLabel);
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        MonitorDevice monitorDevice;
        Object object = gLAutoDrawable.getUpstreamWidget();
        if (object instanceof Window) {
            Window window = (Window)object;
            monitorDevice = window.getMainMonitor();
            float[] fArray = MonitorDevice.mmToInch((float[])monitorDevice.getPixelsPerMM(new float[2]));
            float[] fArray2 = MonitorDevice.mmToInch((float[])window.getPixelsPerMM(new float[2]));
            this.dpiV = fArray2[1];
            System.err.println("Monitor detected: " + monitorDevice);
            System.err.println("Monitor dpi: " + fArray[0] + " x " + fArray[1]);
            System.err.println("Surface scale: native " + Arrays.toString(window.getMaximumSurfaceScale(new float[2])) + ", current " + Arrays.toString(window.getCurrentSurfaceScale(new float[2])));
            System.err.println("Surface dpi " + fArray2[0] + " x " + fArray2[1]);
        } else {
            System.err.println("Using default DPI of " + this.dpiV);
        }
        int n = options.fixDefaultAARenderModeWithDPIThreshold(this.dpiV);
        System.err.println("AUTO RenderMode: dpi " + this.dpiV + ", threshold " + UISceneDemo20.options.noAADPIThreshold + ", mode " + Region.getRenderModeString((int)n) + " -> " + Region.getRenderModeString((int)UISceneDemo20.options.renderModes));
        if (gLAutoDrawable instanceof GLWindow) {
            System.err.println("UISceneDemo20: init (1)");
            GLWindow gLWindow = (GLWindow)gLAutoDrawable;
            this.scene.attachInputListenerTo(gLWindow);
        } else {
            System.err.println("UISceneDemo20: init (0)");
        }
        this.cDrawable = gLAutoDrawable;
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        if (this.debug) {
            gL2ES2 = gL2ES2.getContext().setGL(GLPipelineFactory.create((String)"com.jogamp.opengl.Debug", null, (GL)gL2ES2, null)).getGL2ES2();
        }
        if (this.trace) {
            gL2ES2 = gL2ES2.getContext().setGL(GLPipelineFactory.create((String)"com.jogamp.opengl.Trace", null, (GL)gL2ES2, (Object[])new Object[]{System.err})).getGL2ES2();
        }
        System.err.println(JoglVersion.getGLInfo((GL)gL2ES2, null, (boolean)false).toString());
        System.err.println("VSync Swap Interval: " + gL2ES2.getSwapInterval());
        System.err.println("Chosen: " + gLAutoDrawable.getChosenGLCapabilities());
        MSAATool.dump(gLAutoDrawable);
        gL2ES2.setSwapInterval(1);
        gL2ES2.glEnable(2929);
        gL2ES2.glEnable(3042);
        this.initTexts();
        this.initLabels(gL2ES2);
        this.initButtons(gL2ES2);
        this.scene.setAAQuality(UISceneDemo20.options.graphAAQuality);
        this.scene.init(gLAutoDrawable);
        monitorDevice = gLAutoDrawable.getAnimator();
        if (null != monitorDevice) {
            monitorDevice.resetFPSCounter();
        }
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        System.err.println("UISceneDemo20: reshape: " + n + "/" + n2 + " " + n3 + "x" + n4);
        System.err.println("UISceneDemo20: drawable: " + gLAutoDrawable);
        System.err.println("Reshape: Scene Plane.0 " + this.scene.getBounds());
        float f = this.scene.getBounds().getWidth();
        float f2 = this.scene.getBounds().getHeight();
        System.err.println("Reshape: Scene Plane.0 " + f + " x " + f2);
        this.scene.reshape(gLAutoDrawable, n, n2, n3, n4);
        AABBox aABBox = this.scene.getBounds();
        float f3 = this.scene.getZEpsilon(16);
        System.err.println("Reshape: Scene Plane.1 " + aABBox);
        System.err.println("Reshape: Scene zEpsilon " + f3);
        float f4 = aABBox.getWidth();
        float f5 = aABBox.getHeight();
        float f6 = f4 > f5 ? f4 : f5;
        TreeTool.forAll((Container)this.buttonsLeft, shape -> {
            if (shape instanceof Button) {
                ((Button)shape).setLabelZOffset(f3);
            }
            return false;
        });
        TreeTool.forAll((Container)this.buttonsRight, shape -> {
            if (shape instanceof Button) {
                ((Button)shape).setLabelZOffset(f3);
            }
            return false;
        });
        this.buttonsLeft.validate(gLAutoDrawable.getGL().getGL2ES2());
        this.buttonsRight.validate(gLAutoDrawable.getGL().getGL2ES2());
        this.buttonsLeft.setScale(f6, f6, 1.0f);
        this.buttonsRight.setScale(f6, f6, 1.0f);
        float f7 = aABBox.getMinX();
        float f8 = aABBox.getMinY();
        float f9 = f8 + f5 * 0.9f;
        System.err.println("XXX: dw " + f4 + ", dh " + f5 + ", dyTop " + f9);
        System.err.println("BL " + this.buttonsLeft);
        System.err.println("BL " + this.buttonsLeft.getLayout());
        System.err.println("BR " + this.buttonsRight);
        System.err.println("BR " + this.buttonsRight.getLayout());
        this.buttonsLeft.moveTo(f7, f9 - this.buttonsLeft.getScaledHeight(), 0.0f);
        this.buttonsRight.moveTo(f7 + f4 - this.buttonsRight.getScaledWidth(), f9 - this.buttonsRight.getScaledHeight(), 0.0f);
        this.jogampLabel.setScale(f5, f5, 1.0f);
        float f10 = f7 + f4 * 0.22f;
        float f11 = f8 + f5 - this.jogampLabel.getScaledLineHeight();
        this.jogampLabel.moveTo(f10, f11 - this.jogampLabel.getScaledLineHeight(), 0.0f);
        float f12 = FontScale.toPixels((float)10.0f, (float)this.dpiV);
        float f13 = f12 / (float)n4 * f5;
        System.err.println("10Pt PixelSize: Display " + this.dpiV + " dpi, fontSize " + 10.0f + " pt, " + FontScale.ptToMM((float)10.0f) + " mm -> " + f12 + " pixels, " + f13 + " scene-size");
        this.truePtSizeLabel.setScale(f13, f13, 1.0f);
        this.truePtSizeLabel.moveTo(f10, f11 - this.jogampLabel.getScaledLineHeight() - this.truePtSizeLabel.getScaledLineHeight(), 0.0f);
        AABBox aABBox2 = this.fontFPS.getGlyphBounds((CharSequence)this.scene.getStatusText(gLAutoDrawable, UISceneDemo20.options.renderModes, this.dpiV));
        f13 = f4 / (1.4f * aABBox2.getWidth());
        this.fpsLabel.setScale(f13, f13, 1.0f);
        this.fpsLabel.moveTo(aABBox.getMinX(), aABBox.getMinY() + f13 * (this.fontFPS.getMetrics().getLineGap() - this.fontFPS.getMetrics().getDescent()), 0.0f);
        this.fpsLabel.validate(gLAutoDrawable.getGL().getGL2ES2());
        System.err.println("StatusLabel Scale: " + f13 + " = " + f4 + " / " + aABBox2.getWidth() + ", " + aABBox2);
        System.err.println("StatusLabel: " + this.fpsLabel);
        if (null != this.labels[this.currentText]) {
            this.labels[this.currentText].setScale(f5, f5, 1.0f);
            this.labels[this.currentText].moveTo(f10, f11 - this.jogampLabel.getScaledLineHeight() - 1.5f * this.truePtSizeLabel.getScaledLineHeight() - this.labels[this.currentText].getScaledHeight(), 0.0f);
            System.err.println("Label[" + this.currentText + "] MOVE: " + this.labels[this.currentText]);
            System.err.println("Label[" + this.currentText + "] MOVE: " + this.labels[this.currentText].getPosition());
        }
    }

    public void dispose(GLAutoDrawable gLAutoDrawable) {
        System.err.println("UISceneDemo20: dispose");
        this.scene.dispose(gLAutoDrawable);
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        Object object;
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        gL2ES2.glClearColor(1.0f, 1.0f, 1.0f, 1.0f);
        gL2ES2.glClear(16640);
        if (null == this.labels[this.currentText]) {
            object = this.scene.getBounds();
            float f = object.getHeight();
            float f2 = object.getMinY() + object.getHeight() - this.jogampLabel.getScaledLineHeight();
            float f3 = object.getMinX() + object.getWidth() * 0.22f;
            this.labels[this.currentText] = new Label(UISceneDemo20.options.renderModes, this.font, 0.04f, (CharSequence)this.strings[this.currentText]);
            this.labels[this.currentText].setScale(f, f, 1.0f);
            this.labels[this.currentText].setColor(0.1f, 0.1f, 0.1f, 1.0f);
            this.labels[this.currentText].setVisible(true);
            this.labels[this.currentText].setFixedARatioResize(true);
            this.labels[this.currentText].validate(gL2ES2);
            this.labels[this.currentText].move(f3, f2 - this.jogampLabel.getScaledLineHeight() - 1.5f * this.truePtSizeLabel.getScaledLineHeight() - this.labels[this.currentText].getScaledHeight(), 0.0f);
            this.labels[this.currentText].addMouseListener((Shape.MouseGestureListener)this.dragZoomRotateListener);
            this.scene.addShape((Shape)this.labels[this.currentText]);
            System.err.println("Label[" + this.currentText + "] CTOR: " + this.labels[this.currentText]);
            System.err.println("Label[" + this.currentText + "] CTOR: " + this.labels[this.currentText].getPosition());
        }
        if (!this.fpsLabel.isVisible() || this.fpsLabel.setText((CharSequence)(object = null == this.actionText ? this.scene.getStatusText(gLAutoDrawable, UISceneDemo20.options.renderModes, this.dpiV) : (null != gLAutoDrawable.getAnimator() ? Scene.getStatusText((FPSCounter)gLAutoDrawable.getAnimator()) + ", " + this.actionText : this.actionText)))) {
            // empty if block
        }
        this.scene.display(gLAutoDrawable);
    }

    private static /* synthetic */ boolean lambda$initButtons$4(SimpleSineSynth simpleSineSynth, GLAutoDrawable gLAutoDrawable) {
        simpleSineSynth.stop();
        return true;
    }

    private /* synthetic */ boolean lambda$initButtons$3(ALAudioSink[] aLAudioSinkArray, Shape shape, GL2ES2 gL2ES2, RegionRenderer regionRenderer) {
        ALAudioSink aLAudioSink = aLAudioSinkArray[0];
        if (null != aLAudioSink && aLAudioSink.getContext().isValid()) {
            this.initSound(shape, aLAudioSink.getContext(), aLAudioSink.getSource());
            System.err.println("Media Audio: " + aLAudioSink);
            return true;
        }
        return false;
    }

    private /* synthetic */ void lambda$initButtons$2(ALAudioSink[] aLAudioSinkArray, Shape shape, com.jogamp.math.Vec3f vec3f, com.jogamp.math.Vec3f vec3f2, MouseEvent mouseEvent) {
        ALAudioSink aLAudioSink = aLAudioSinkArray[0];
        if (null != aLAudioSink && aLAudioSink.getContext().isValid()) {
            this.setSoundPosition(shape, aLAudioSink.getContext(), aLAudioSink.getSource());
        }
    }

    private static /* synthetic */ void lambda$initButtons$1(GLMediaPlayer gLMediaPlayer, Shape shape) {
        gLMediaPlayer.setAudioVolume(shape.isToggleOn() ? 1.0f : 0.0f);
    }
}

