/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opencl.CLBuffer;
import com.jogamp.opencl.CLCommandQueue;
import com.jogamp.opencl.CLContext;
import com.jogamp.opencl.CLDevice;
import com.jogamp.opencl.CLEvent;
import com.jogamp.opencl.CLEventList;
import com.jogamp.opencl.CLEventListener;
import com.jogamp.opencl.CLKernel;
import com.jogamp.opencl.CLMemory;
import com.jogamp.opencl.CLPlatform;
import com.jogamp.opencl.CLProgram;
import com.jogamp.opencl.CLUserEvent;
import com.jogamp.opencl.CLVersion;
import com.jogamp.opencl.test.util.MiscUtils;
import com.jogamp.opencl.test.util.UITestCase;
import com.jogamp.opencl.util.CLDeviceFilters;
import com.jogamp.opencl.util.CLPlatformFilters;
import com.jogamp.opencl.util.Filter;
import com.jogamp.opencl.util.MultiQueueBarrier;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.EnumSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class CLCommandQueueTest
extends UITestCase {
    @Rule
    public Timeout methodTimeout = new Timeout(20000);

    @Test
    public void enumsTest() {
        EnumSet enumSet = CLCommandQueue.Mode.valuesOf((long)3L);
        Assert.assertTrue((boolean)enumSet.contains(CLCommandQueue.Mode.OUT_OF_ORDER_MODE));
        Assert.assertTrue((boolean)enumSet.contains(CLCommandQueue.Mode.PROFILING_MODE));
        Assert.assertNotNull((Object)CLCommandQueue.Mode.valuesOf((long)0L));
        Assert.assertEquals((long)0L, (long)CLCommandQueue.Mode.valuesOf((long)0L).size());
        for (CLCommandQueue.Mode mode : CLCommandQueue.Mode.values()) {
            Assert.assertEquals((Object)mode, (Object)CLCommandQueue.Mode.valueOf((int)mode.QUEUE_MODE));
        }
        for (CLCommandQueue.Mode mode : CLEvent.ProfilingCommand.values()) {
            Assert.assertEquals((Object)mode, (Object)CLEvent.ProfilingCommand.valueOf((int)mode.COMMAND));
        }
        for (CLCommandQueue.Mode mode : CLEvent.CommandType.values()) {
            Assert.assertEquals((Object)mode, (Object)CLEvent.CommandType.valueOf((int)mode.TYPE));
        }
        for (CLCommandQueue.Mode mode : CLEvent.ExecutionStatus.values()) {
            Assert.assertEquals((Object)mode, (Object)CLEvent.ExecutionStatus.valueOf((int)mode.STATUS));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void eventsTest() throws IOException {
        System.out.println(" - - - event synchronization test - - - ");
        CLContext cLContext = CLContext.create();
        try {
            CLDevice cLDevice = cLContext.getDevices()[0];
            int n = cLDevice.getMaxWorkItemSizes()[0];
            int n2 = MiscUtils.roundUp(n, 0x140000);
            CLBuffer cLBuffer = cLContext.createByteBuffer(n2 * 4, new CLMemory.Mem[]{CLMemory.Mem.READ_ONLY});
            CLBuffer cLBuffer2 = cLContext.createByteBuffer(n2 * 4, new CLMemory.Mem[]{CLMemory.Mem.READ_ONLY});
            CLBuffer cLBuffer3 = cLContext.createByteBuffer(n2 * 4, new CLMemory.Mem[]{CLMemory.Mem.READ_ONLY});
            CLBuffer cLBuffer4 = cLContext.createByteBuffer(n2 * 4, new CLMemory.Mem[]{CLMemory.Mem.READ_ONLY});
            MiscUtils.fillBuffer((ByteBuffer)cLBuffer.buffer, 12345);
            MiscUtils.fillBuffer((ByteBuffer)cLBuffer2.buffer, 67890);
            CLProgram cLProgram = cLContext.createProgram(this.getClass().getResourceAsStream("testkernels.cl")).build();
            CLKernel cLKernel = cLProgram.createCLKernel("VectorAddGM").setArg(3, n2);
            CLCommandQueue cLCommandQueue = cLDevice.createCommandQueue();
            System.out.println(cLCommandQueue);
            CLEventList cLEventList = new CLEventList(2);
            System.out.println(cLEventList);
            Assert.assertEquals((long)0L, (long)cLEventList.size());
            cLCommandQueue.putWriteBuffer(cLBuffer, false, cLEventList).putWriteBuffer(cLBuffer2, false, cLEventList);
            System.out.println(cLEventList);
            Assert.assertEquals((long)2L, (long)cLEventList.size());
            cLCommandQueue.putWaitForEvents(cLEventList, true);
            cLEventList.release();
            Assert.assertEquals((long)0L, (long)cLEventList.size());
            cLKernel.setArgs(new CLMemory[]{cLBuffer, cLBuffer2, cLBuffer3});
            cLCommandQueue.put1DRangeKernel(cLKernel, 0L, (long)n2, (long)n, cLEventList);
            cLKernel.setArgs(new CLMemory[]{cLBuffer, cLBuffer2, cLBuffer4});
            cLCommandQueue.put1DRangeKernel(cLKernel, 0L, (long)n2, (long)n, cLEventList);
            Assert.assertEquals((long)2L, (long)cLEventList.size());
            cLCommandQueue.putWaitForEvent(cLEventList, 0, true).putWaitForEvent(cLEventList, 1, true);
            cLEventList.release();
            cLCommandQueue.putReadBuffer(cLBuffer3, false, cLEventList).putReadBuffer(cLBuffer4, false, cLEventList);
            cLCommandQueue.putWaitForEvents(cLEventList, true);
            cLEventList.release();
            MiscUtils.checkIfEqual((ByteBuffer)cLBuffer3.buffer, (ByteBuffer)cLBuffer4.buffer, n2);
            System.out.println("results are valid");
        }
        finally {
            cLContext.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void eventConditionsTest() throws IOException {
        System.out.println(" - - - event conditions test - - - ");
        CLPlatform cLPlatform = CLPlatform.getDefault((Filter[])new Filter[]{CLPlatformFilters.queueMode((CLCommandQueue.Mode[])new CLCommandQueue.Mode[]{CLCommandQueue.Mode.OUT_OF_ORDER_MODE})});
        CLDevice cLDevice = null;
        cLDevice = cLPlatform == null ? CLPlatform.getDefault().getMaxFlopsDevice() : cLPlatform.getMaxFlopsDevice(new Filter[]{CLDeviceFilters.queueMode((CLCommandQueue.Mode[])new CLCommandQueue.Mode[]{CLCommandQueue.Mode.OUT_OF_ORDER_MODE})});
        CLContext cLContext = CLContext.create((CLDevice[])new CLDevice[]{cLDevice});
        try {
            CLProgram cLProgram = cLContext.createProgram(this.getClass().getResourceAsStream("testkernels.cl")).build();
            CLBuffer cLBuffer = cLContext.createBuffer((Buffer)Buffers.newDirectIntBuffer((int[])new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1}), new CLMemory.Mem[0]);
            int n = cLBuffer.getNIOCapacity();
            CLCommandQueue cLCommandQueue = cLDevice.getQueueProperties().contains(CLCommandQueue.Mode.OUT_OF_ORDER_MODE) ? cLDevice.createCommandQueue(CLCommandQueue.Mode.OUT_OF_ORDER_MODE) : cLDevice.createCommandQueue();
            CLEventList cLEventList = new CLEventList(3);
            CLKernel cLKernel = cLProgram.createCLKernel("add").putArg((CLMemory)cLBuffer).putArg(1).putArg(n);
            CLKernel cLKernel2 = cLProgram.createCLKernel("mul").putArg((CLMemory)cLBuffer).putArg(2).putArg(n);
            cLCommandQueue.putWriteBuffer(cLBuffer, false, cLEventList);
            cLCommandQueue.put1DRangeKernel(cLKernel, 0L, (long)n, 1L, cLEventList, cLEventList);
            cLCommandQueue.put1DRangeKernel(cLKernel2, 0L, (long)n, 1L, cLEventList, cLEventList);
            cLCommandQueue.putReadBuffer(cLBuffer, false, cLEventList, null);
            cLCommandQueue.finish();
            cLEventList.release();
            for (int i = 0; i < n; ++i) {
                Assert.assertEquals((long)4L, (long)((IntBuffer)cLBuffer.getBuffer()).get(i));
            }
        }
        finally {
            cLContext.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void profilingEventsTest() throws IOException {
        System.out.println(" - - - event synchronization test - - - ");
        CLContext cLContext = CLContext.create();
        try {
            CLDevice cLDevice = cLContext.getDevices()[0];
            int n = cLDevice.getMaxWorkItemSizes()[0];
            int n2 = MiscUtils.roundUp(n, 0x140000);
            CLBuffer cLBuffer = cLContext.createByteBuffer(n2 * 4, new CLMemory.Mem[]{CLMemory.Mem.READ_ONLY});
            CLBuffer cLBuffer2 = cLContext.createByteBuffer(n2 * 4, new CLMemory.Mem[]{CLMemory.Mem.READ_ONLY});
            CLBuffer cLBuffer3 = cLContext.createByteBuffer(n2 * 4, new CLMemory.Mem[]{CLMemory.Mem.READ_ONLY});
            MiscUtils.fillBuffer((ByteBuffer)cLBuffer.buffer, 12345);
            MiscUtils.fillBuffer((ByteBuffer)cLBuffer2.buffer, 67890);
            CLProgram cLProgram = cLContext.createProgram(this.getClass().getResourceAsStream("testkernels.cl")).build();
            CLKernel cLKernel = cLProgram.createCLKernel("VectorAddGM").setArg(3, n2);
            CLCommandQueue cLCommandQueue = cLDevice.createCommandQueue(CLCommandQueue.Mode.PROFILING_MODE);
            System.out.println(cLCommandQueue);
            cLCommandQueue.putWriteBuffer(cLBuffer, true).putWriteBuffer(cLBuffer2, true);
            CLEventList cLEventList = new CLEventList(1);
            Assert.assertEquals((long)0L, (long)cLEventList.size());
            cLKernel.setArgs(new CLMemory[]{cLBuffer, cLBuffer2, cLBuffer3});
            cLCommandQueue.put1DRangeKernel(cLKernel, 0L, (long)n2, (long)n, cLEventList);
            Assert.assertEquals((long)1L, (long)cLEventList.size());
            CLEvent cLEvent = cLEventList.getEvent(0);
            System.out.println(cLEvent);
            cLCommandQueue.putWaitForEvents(cLEventList, true);
            Assert.assertEquals((Object)CLEvent.ExecutionStatus.COMPLETE, (Object)cLEvent.getStatus());
            System.out.println(cLEvent);
            long l = cLEvent.getProfilingInfo(CLEvent.ProfilingCommand.END) - cLEvent.getProfilingInfo(CLEvent.ProfilingCommand.START);
            System.out.println("time: " + l);
            Assert.assertTrue((l > 0L ? 1 : 0) != 0);
            cLEventList.release();
        }
        finally {
            cLContext.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void customEventsTest() throws IOException, InterruptedException {
        System.out.println(" - - - user events test - - - ");
        CLContext cLContext = CLPlatform.listCLPlatforms();
        CLPlatform cLPlatform = cLContext[0];
        for (CLPlatform cLPlatform2 : cLContext) {
            if (!cLPlatform2.isAtLeast(CLVersion.CL_1_1)) continue;
            cLPlatform = cLPlatform2;
            break;
        }
        if (!cLPlatform.isAtLeast(CLVersion.CL_1_1)) {
            System.out.println("test disabled, required CLVersion: " + CLVersion.CL_1_1 + " available: " + cLPlatform.getVersion());
            return;
        }
        CLContext cLContext2 = CLContext.create((CLPlatform)cLPlatform);
        try {
            CLDevice cLDevice = cLContext2.getDevices()[0];
            int n = cLDevice.getMaxWorkItemSizes()[0];
            int n2 = MiscUtils.roundUp(n, 0x140000);
            CLBuffer cLBuffer = cLContext2.createByteBuffer(n2 * 4, new CLMemory.Mem[]{CLMemory.Mem.READ_ONLY});
            CLBuffer cLBuffer2 = cLContext2.createByteBuffer(n2 * 4, new CLMemory.Mem[]{CLMemory.Mem.READ_ONLY});
            CLBuffer cLBuffer3 = cLContext2.createByteBuffer(n2 * 4, new CLMemory.Mem[]{CLMemory.Mem.READ_ONLY});
            MiscUtils.fillBuffer((ByteBuffer)cLBuffer.buffer, 12345);
            MiscUtils.fillBuffer((ByteBuffer)cLBuffer2.buffer, 67890);
            CLProgram cLProgram = cLContext2.createProgram(this.getClass().getResourceAsStream("testkernels.cl")).build();
            CLKernel cLKernel = cLProgram.createCLKernel("VectorAddGM").setArg(3, n2);
            CLCommandQueue cLCommandQueue = cLDevice.createCommandQueue();
            cLCommandQueue.putWriteBuffer(cLBuffer, true).putWriteBuffer(cLBuffer2, true);
            cLKernel.setArgs(new CLMemory[]{cLBuffer, cLBuffer2, cLBuffer3});
            CLUserEvent cLUserEvent = CLUserEvent.create((CLContext)cLContext2);
            Assert.assertEquals((Object)CLEvent.CommandType.USER, (Object)cLUserEvent.getType());
            Assert.assertEquals((Object)CLEvent.ExecutionStatus.SUBMITTED, (Object)cLUserEvent.getStatus());
            System.out.println(cLUserEvent);
            CLEventList cLEventList = new CLEventList(new CLEvent[]{cLUserEvent});
            CLEventList cLEventList2 = new CLEventList(1);
            Assert.assertEquals((long)1L, (long)cLEventList.size());
            Assert.assertEquals((long)1L, (long)cLEventList.capacity());
            Assert.assertEquals((long)0L, (long)cLEventList2.size());
            Assert.assertEquals((long)1L, (long)cLEventList2.capacity());
            cLCommandQueue.put1DRangeKernel(cLKernel, 0L, (long)n2, (long)n, cLEventList, cLEventList2);
            Assert.assertEquals((long)1L, (long)cLEventList2.size());
            Thread.sleep(1000L);
            CLEvent cLEvent = cLEventList2.getEvent(0);
            if (cLContext2.getPlatform().isVendorIntel()) {
                Assert.assertEquals((Object)CLEvent.ExecutionStatus.SUBMITTED, (Object)cLEvent.getStatus());
            } else {
                Assert.assertEquals((Object)CLEvent.ExecutionStatus.QUEUED, (Object)cLEvent.getStatus());
            }
            cLUserEvent.setComplete();
            Assert.assertTrue((boolean)cLUserEvent.isComplete());
            cLCommandQueue.finish();
            Assert.assertTrue((boolean)cLEvent.isComplete());
        }
        finally {
            cLContext2.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void eventCallbackTest() throws InterruptedException {
        System.out.println(" - - - event callback test - - - ");
        CLPlatform cLPlatform = CLPlatform.getDefault();
        if (!cLPlatform.isAtLeast(CLVersion.CL_1_1)) {
            System.out.println("test disabled, required CLVersion: " + CLVersion.CL_1_1 + " available: " + cLPlatform.getVersion());
            return;
        }
        CLContext cLContext = CLContext.create();
        try {
            final CLUserEvent cLUserEvent = CLUserEvent.create((CLContext)cLContext);
            final CountDownLatch countDownLatch = new CountDownLatch(1);
            cLUserEvent.registerCallback(new CLEventListener(){

                public void eventStateChanged(CLEvent cLEvent, int n) {
                    System.out.println("event received: " + cLEvent);
                    Assert.assertEquals((Object)cLEvent, (Object)cLUserEvent);
                    countDownLatch.countDown();
                }
            });
            cLUserEvent.setStatus(CLEvent.ExecutionStatus.COMPLETE);
            countDownLatch.await(2L, TimeUnit.SECONDS);
            Assert.assertEquals((long)countDownLatch.getCount(), (long)0L);
            cLUserEvent.release();
        }
        finally {
            cLContext.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void concurrencyTest() throws IOException, InterruptedException {
        System.out.println(" - - - QueueBarrier test - - - ");
        CLContext cLContext = CLContext.create();
        try {
            CLDevice[] cLDeviceArray = cLContext.getDevices();
            if (cLDeviceArray.length < 2) {
                System.out.println("aborting test... need at least 2 devices");
                return;
            }
            final CLBuffer cLBuffer = cLContext.createByteBuffer(0xA00000, new CLMemory.Mem[]{CLMemory.Mem.READ_ONLY});
            final CLBuffer cLBuffer2 = cLContext.createByteBuffer(0xA00000, new CLMemory.Mem[]{CLMemory.Mem.READ_ONLY});
            final CLBuffer cLBuffer3 = cLContext.createByteBuffer(0xA00000, new CLMemory.Mem[]{CLMemory.Mem.READ_ONLY});
            final CLBuffer cLBuffer4 = cLContext.createByteBuffer(0xA00000, new CLMemory.Mem[]{CLMemory.Mem.READ_ONLY});
            final CLBuffer cLBuffer5 = cLContext.createByteBuffer(0xA00000, new CLMemory.Mem[]{CLMemory.Mem.READ_ONLY});
            final CLBuffer cLBuffer6 = cLContext.createByteBuffer(0xA00000, new CLMemory.Mem[]{CLMemory.Mem.READ_ONLY});
            CLProgram cLProgram = cLContext.createProgram(this.getClass().getResourceAsStream("testkernels.cl")).build();
            final CLKernel cLKernel = cLProgram.createCLKernel("VectorAddGM").setArg(3, 0x280000);
            final CLKernel cLKernel2 = cLProgram.createCLKernel("VectorAddGM").setArg(3, 0x280000);
            final CLCommandQueue cLCommandQueue = cLDeviceArray[0].createCommandQueue();
            final CLCommandQueue cLCommandQueue2 = cLDeviceArray[1].createCommandQueue();
            System.out.println(cLCommandQueue);
            System.out.println(cLCommandQueue2);
            MiscUtils.fillBuffer((ByteBuffer)cLBuffer.buffer, 12345);
            final MultiQueueBarrier multiQueueBarrier = new MultiQueueBarrier(2);
            Thread thread = new Thread("C"){

                @Override
                public void run() {
                    int n = cLCommandQueue.getDevice().getMaxWorkItemSizes()[0];
                    MiscUtils.fillBuffer((ByteBuffer)cLBuffer3.buffer, 12345);
                    MiscUtils.fillBuffer((ByteBuffer)cLBuffer4.buffer, 67890);
                    cLCommandQueue.putWriteBuffer(cLBuffer3, false).putWriteBuffer(cLBuffer4, false);
                    cLKernel.setArgs(new CLMemory[]{cLBuffer3, cLBuffer4, cLBuffer});
                    CLEventList cLEventList = new CLEventList(2);
                    cLCommandQueue.put1DRangeKernel(cLKernel, 0L, 0x280000L, (long)n, cLEventList).putReadBuffer(cLBuffer, false, cLEventList);
                    multiQueueBarrier.waitFor(cLCommandQueue, cLEventList);
                }
            };
            Thread thread2 = new Thread("D"){

                @Override
                public void run() {
                    int n = cLCommandQueue2.getDevice().getMaxWorkItemSizes()[0];
                    int n2 = (int)cLKernel2.getWorkGroupSize(cLCommandQueue2.getDevice());
                    int n3 = Math.min(n, n2);
                    MiscUtils.fillBuffer((ByteBuffer)cLBuffer5.buffer, 12345);
                    MiscUtils.fillBuffer((ByteBuffer)cLBuffer6.buffer, 67890);
                    cLCommandQueue2.putWriteBuffer(cLBuffer5, false).putWriteBuffer(cLBuffer6, false);
                    cLKernel2.setArgs(new CLMemory[]{cLBuffer5, cLBuffer6, cLBuffer2});
                    CLEventList cLEventList = new CLEventList(2);
                    cLCommandQueue2.put1DRangeKernel(cLKernel2, 0L, 0x280000L, (long)n3, cLEventList);
                    cLCommandQueue2.putReadBuffer(cLBuffer2, false, cLEventList);
                    multiQueueBarrier.waitFor(cLCommandQueue2, cLEventList);
                }
            };
            System.out.println("starting threads");
            thread.start();
            thread2.start();
            Assert.assertTrue((boolean)multiQueueBarrier.await(5L, TimeUnit.SECONDS));
            System.out.println("done");
            MiscUtils.checkIfEqual((ByteBuffer)cLBuffer.buffer, (ByteBuffer)cLBuffer2.buffer, 0x280000);
            System.out.println("results are valid");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        finally {
            cLContext.release();
        }
    }

    public static void main(String[] stringArray) throws IOException {
        String string = CLCommandQueueTest.class.getName();
        JUnitCore.main((String[])new String[]{string});
    }
}

