/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.math;

import com.jogamp.graph.geom.Vertex;
import com.jogamp.math.FloatUtil;
import com.jogamp.math.Ray;
import com.jogamp.math.Vec2f;
import com.jogamp.math.Vec3f;
import com.jogamp.math.Vec4f;
import com.jogamp.math.Vert2fImmutable;
import com.jogamp.math.geom.plane.Winding;
import java.util.List;

public final class VectorUtil {
    public static boolean isVec2Zero(Vec3f vec3f) {
        return 0.0f == vec3f.x() && 0.0f == vec3f.y();
    }

    public static boolean isZero(float f, float f2, float f3, float f4) {
        return FloatUtil.isZero(f, f4) && FloatUtil.isZero(f2, f4) && FloatUtil.isZero(f3, f4);
    }

    public static boolean isZero(float f, float f2, float f3) {
        return FloatUtil.isZero(f) && FloatUtil.isZero(f2) && FloatUtil.isZero(f3);
    }

    public static float distSquareVec3(float[] fArray, float[] fArray2) {
        float f = fArray[0] - fArray2[0];
        float f2 = fArray[1] - fArray2[1];
        float f3 = fArray[2] - fArray2[2];
        return f * f + f2 * f2 + f3 * f3;
    }

    public static float distVec3(float[] fArray, float[] fArray2) {
        return FloatUtil.sqrt(VectorUtil.distSquareVec3(fArray, fArray2));
    }

    public static float normSquareVec2(float[] fArray) {
        return fArray[0] * fArray[0] + fArray[1] * fArray[1];
    }

    public static float normSquareVec3(float[] fArray) {
        return fArray[0] * fArray[0] + fArray[1] * fArray[1] + fArray[2] * fArray[2];
    }

    public static float normSquareVec3(float[] fArray, int n) {
        float f = fArray[0 + n];
        float f2 = f * f;
        f = fArray[1 + n];
        f2 += f * f;
        f = fArray[2 + n];
        return f2 + f * f;
    }

    public static float normVec2(float[] fArray) {
        return FloatUtil.sqrt(VectorUtil.normSquareVec2(fArray));
    }

    public static float[] normalizeVec3(float[] fArray) {
        float f = VectorUtil.normSquareVec3(fArray);
        if (FloatUtil.isZero(f)) {
            fArray[0] = 0.0f;
            fArray[1] = 0.0f;
            fArray[2] = 0.0f;
        } else {
            float f2 = 1.0f / FloatUtil.sqrt(f);
            fArray[0] = fArray[0] * f2;
            fArray[1] = fArray[1] * f2;
            fArray[2] = fArray[2] * f2;
        }
        return fArray;
    }

    public static float[] normalizeVec3(float[] fArray, int n) {
        float f = VectorUtil.normSquareVec3(fArray, n);
        if (FloatUtil.isZero(f)) {
            fArray[0 + n] = 0.0f;
            fArray[1 + n] = 0.0f;
            fArray[2 + n] = 0.0f;
        } else {
            float f2 = 1.0f / FloatUtil.sqrt(f);
            int n2 = 0 + n;
            fArray[n2] = fArray[n2] * f2;
            int n3 = 1 + n;
            fArray[n3] = fArray[n3] * f2;
            int n4 = 2 + n;
            fArray[n4] = fArray[n4] * f2;
        }
        return fArray;
    }

    public static float[] scaleVec2(float[] fArray, float[] fArray2, float f) {
        fArray[0] = fArray2[0] * f;
        fArray[1] = fArray2[1] * f;
        return fArray;
    }

    public static float[] scaleVec2(float[] fArray, float[] fArray2, float[] fArray3) {
        fArray[0] = fArray2[0] * fArray3[0];
        fArray[1] = fArray2[1] * fArray3[1];
        return fArray;
    }

    public static float[] divVec2(float[] fArray, float[] fArray2, float f) {
        fArray[0] = fArray2[0] / f;
        fArray[1] = fArray2[1] / f;
        return fArray;
    }

    public static float[] divVec2(float[] fArray, float[] fArray2, float[] fArray3) {
        fArray[0] = fArray2[0] / fArray3[0];
        fArray[1] = fArray2[1] / fArray3[1];
        return fArray;
    }

    public static float[] addVec2(float[] fArray, float[] fArray2, float[] fArray3) {
        fArray[0] = fArray2[0] + fArray3[0];
        fArray[1] = fArray2[1] + fArray3[1];
        return fArray;
    }

    public static float[] subVec2(float[] fArray, float[] fArray2, float[] fArray3) {
        fArray[0] = fArray2[0] - fArray3[0];
        fArray[1] = fArray2[1] - fArray3[1];
        return fArray;
    }

    public static float[] crossVec3(float[] fArray, int n, float[] fArray2, int n2, float[] fArray3, int n3) {
        fArray[0 + n] = fArray2[1 + n2] * fArray3[2 + n3] - fArray2[2 + n2] * fArray3[1 + n3];
        fArray[1 + n] = fArray2[2 + n2] * fArray3[0 + n3] - fArray2[0 + n2] * fArray3[2 + n3];
        fArray[2 + n] = fArray2[0 + n2] * fArray3[1 + n3] - fArray2[1 + n2] * fArray3[0 + n3];
        return fArray;
    }

    public static Vec3f midpoint(Vec3f vec3f, Vec3f vec3f2, Vec3f vec3f3) {
        vec3f.set((vec3f2.x() + vec3f3.x()) * 0.5f, (vec3f2.y() + vec3f3.y()) * 0.5f, (vec3f2.z() + vec3f3.z()) * 0.5f);
        return vec3f;
    }

    public static float determinant(Vec3f vec3f, Vec3f vec3f2, Vec3f vec3f3) {
        return vec3f.x() * vec3f2.y() * vec3f3.z() + vec3f.y() * vec3f2.z() * vec3f3.x() + vec3f.z() * vec3f2.x() * vec3f3.y() - vec3f.x() * vec3f2.z() * vec3f3.y() - vec3f.y() * vec3f2.x() * vec3f3.z() - vec3f.z() * vec3f2.y() * vec3f3.x();
    }

    public static boolean isCollinear(Vec3f vec3f, Vec3f vec3f2, Vec3f vec3f3) {
        return FloatUtil.isZero(VectorUtil.determinant(vec3f, vec3f2, vec3f3));
    }

    public static boolean isInCircle(Vert2fImmutable vert2fImmutable, Vert2fImmutable vert2fImmutable2, Vert2fImmutable vert2fImmutable3, Vert2fImmutable vert2fImmutable4) {
        return VectorUtil.inCircleVal(vert2fImmutable, vert2fImmutable2, vert2fImmutable3, vert2fImmutable4) > 2.220446049250313E-16;
    }

    public static double inCircleVal(Vert2fImmutable vert2fImmutable, Vert2fImmutable vert2fImmutable2, Vert2fImmutable vert2fImmutable3, Vert2fImmutable vert2fImmutable4) {
        return VectorUtil.sqlend(vert2fImmutable.x(), vert2fImmutable.y()) * VectorUtil.triArea(vert2fImmutable2, vert2fImmutable3, vert2fImmutable4) - VectorUtil.sqlend(vert2fImmutable2.x(), vert2fImmutable2.y()) * VectorUtil.triArea(vert2fImmutable, vert2fImmutable3, vert2fImmutable4) + VectorUtil.sqlend(vert2fImmutable3.x(), vert2fImmutable3.y()) * VectorUtil.triArea(vert2fImmutable, vert2fImmutable2, vert2fImmutable4) - VectorUtil.sqlend(vert2fImmutable4.x(), vert2fImmutable4.y()) * VectorUtil.triArea(vert2fImmutable, vert2fImmutable2, vert2fImmutable3);
    }

    private static double sqlend(double d, double d2) {
        return d * d + d2 * d2;
    }

    public static double triArea(Vert2fImmutable vert2fImmutable, Vert2fImmutable vert2fImmutable2, Vert2fImmutable vert2fImmutable3) {
        return VectorUtil.triArea(vert2fImmutable.x(), vert2fImmutable.y(), vert2fImmutable2.x(), vert2fImmutable2.y(), vert2fImmutable3.x(), vert2fImmutable3.y());
    }

    private static double triArea(double d, double d2, double d3, double d4, double d5, double d6) {
        return (d3 - d) * (d6 - d2) - (d4 - d2) * (d5 - d);
    }

    public static boolean isInTriangle(Vec3f vec3f, Vec3f vec3f2, Vec3f vec3f3, Vec3f vec3f4, Vec3f vec3f5, Vec3f vec3f6, Vec3f vec3f7) {
        vec3f5.minus(vec3f3, vec3f);
        vec3f6.minus(vec3f2, vec3f);
        vec3f7.minus(vec3f4, vec3f);
        float f = vec3f5.dot(vec3f5);
        float f2 = vec3f5.dot(vec3f6);
        float f3 = vec3f6.dot(vec3f6);
        float f4 = vec3f5.dot(vec3f7);
        float f5 = vec3f6.dot(vec3f7);
        float f6 = 1.0f / (f * f3 - f2 * f2);
        float f7 = (f3 * f4 - f2 * f5) * f6;
        float f8 = (f * f5 - f2 * f4) * f6;
        return f7 >= 0.0f && f8 >= 0.0f && f7 + f8 < 1.0f;
    }

    public static boolean isInTriangle3(Vec3f vec3f, Vec3f vec3f2, Vec3f vec3f3, Vec3f vec3f4, Vec3f vec3f5, Vec3f vec3f6, Vec3f vec3f7, Vec3f vec3f8, Vec3f vec3f9) {
        vec3f7.minus(vec3f3, vec3f);
        vec3f8.minus(vec3f2, vec3f);
        float f = vec3f7.dot(vec3f7);
        float f2 = vec3f7.dot(vec3f8);
        float f3 = vec3f8.dot(vec3f8);
        float f4 = 1.0f / (f * f3 - f2 * f2);
        vec3f9.minus(vec3f4, vec3f);
        float f5 = vec3f7.dot(vec3f9);
        float f6 = vec3f8.dot(vec3f9);
        float f7 = (f3 * f5 - f2 * f6) * f4;
        float f8 = (f * f6 - f2 * f5) * f4;
        if (f7 >= 0.0f && f8 >= 0.0f && f7 + f8 < 1.0f) {
            return true;
        }
        vec3f9.minus(vec3f5, vec3f);
        f5 = vec3f7.dot(vec3f9);
        f6 = vec3f8.dot(vec3f9);
        f7 = (f3 * f5 - f2 * f6) * f4;
        f8 = (f * f6 - f2 * f5) * f4;
        if (f7 >= 0.0f && f8 >= 0.0f && f7 + f8 < 1.0f) {
            return true;
        }
        vec3f9.minus(vec3f6, vec3f);
        f5 = vec3f7.dot(vec3f9);
        f6 = vec3f8.dot(vec3f9);
        f7 = (f3 * f5 - f2 * f6) * f4;
        f8 = (f * f6 - f2 * f5) * f4;
        return f7 >= 0.0f && f8 >= 0.0f && f7 + f8 < 1.0f;
    }

    public static boolean isInTriangle3(Vec3f vec3f, Vec3f vec3f2, Vec3f vec3f3, Vec3f vec3f4, Vec3f vec3f5, Vec3f vec3f6, Vec3f vec3f7, Vec3f vec3f8, Vec3f vec3f9, float f) {
        vec3f7.minus(vec3f3, vec3f);
        vec3f8.minus(vec3f2, vec3f);
        float f2 = vec3f7.dot(vec3f7);
        float f3 = vec3f7.dot(vec3f8);
        float f4 = vec3f8.dot(vec3f8);
        float f5 = 1.0f / (f2 * f4 - f3 * f3);
        vec3f9.minus(vec3f4, vec3f);
        float f6 = vec3f7.dot(vec3f9);
        float f7 = vec3f8.dot(vec3f9);
        float f8 = (f4 * f6 - f3 * f7) * f5;
        float f9 = (f2 * f7 - f3 * f6) * f5;
        if (FloatUtil.compare(f8, 0.0f, f) >= 0 && FloatUtil.compare(f9, 0.0f, f) >= 0 && FloatUtil.compare(f8 + f9, 1.0f, f) < 0) {
            return true;
        }
        vec3f9.minus(vec3f5, vec3f);
        f6 = vec3f7.dot(vec3f9);
        f7 = vec3f8.dot(vec3f9);
        f8 = (f4 * f6 - f3 * f7) * f5;
        f9 = (f2 * f7 - f3 * f6) * f5;
        if (FloatUtil.compare(f8, 0.0f, f) >= 0 && FloatUtil.compare(f9, 0.0f, f) >= 0 && FloatUtil.compare(f8 + f9, 1.0f, f) < 0) {
            return true;
        }
        vec3f9.minus(vec3f6, vec3f);
        f6 = vec3f7.dot(vec3f9);
        f7 = vec3f8.dot(vec3f9);
        f8 = (f4 * f6 - f3 * f7) * f5;
        f9 = (f2 * f7 - f3 * f6) * f5;
        return FloatUtil.compare(f8, 0.0f, f) >= 0 && FloatUtil.compare(f9, 0.0f, f) >= 0 && FloatUtil.compare(f8 + f9, 1.0f, f) < 0;
    }

    public static boolean isCCW(Vert2fImmutable vert2fImmutable, Vert2fImmutable vert2fImmutable2, Vert2fImmutable vert2fImmutable3) {
        return VectorUtil.triArea(vert2fImmutable, vert2fImmutable2, vert2fImmutable3) > 2.220446049250313E-16;
    }

    public static Winding getWinding(Vert2fImmutable vert2fImmutable, Vert2fImmutable vert2fImmutable2, Vert2fImmutable vert2fImmutable3) {
        return VectorUtil.triArea(vert2fImmutable, vert2fImmutable2, vert2fImmutable3) > 2.220446049250313E-16 ? Winding.CCW : Winding.CW;
    }

    public static double area(List<? extends Vert2fImmutable> list) {
        int n = list.size();
        double d = 0.0;
        int n2 = n - 1;
        int n3 = 0;
        while (n3 < n) {
            Vert2fImmutable vert2fImmutable = list.get(n2);
            Vert2fImmutable vert2fImmutable2 = list.get(n3);
            d += (double)vert2fImmutable.x() * (double)vert2fImmutable2.y() - (double)vert2fImmutable2.x() * (double)vert2fImmutable.y();
            n2 = n3++;
        }
        return d;
    }

    public static Winding getWinding(List<? extends Vert2fImmutable> list) {
        return VectorUtil.area(list) >= 0.0 ? Winding.CCW : Winding.CW;
    }

    public static Vec4f getPlaneVec3(Vec4f vec4f, Vec3f vec3f, Vec3f vec3f2) {
        vec4f.set(vec3f, -vec3f.dot(vec3f2));
        return vec4f;
    }

    public static Vec4f getPlaneVec3(Vec4f vec4f, Vec3f vec3f, Vec3f vec3f2, Vec3f vec3f3, Vec3f vec3f4, Vec3f vec3f5, Vec3f vec3f6) {
        vec3f6.cross(vec3f4.minus(vec3f2, vec3f), vec3f5.minus(vec3f3, vec3f)).normalize();
        vec4f.set(vec3f6, -vec3f6.dot(vec3f));
        return vec4f;
    }

    public static Vec3f line2PlaneIntersection(Vec3f vec3f, Ray ray, Vec4f vec4f, float f) {
        Vec3f vec3f2 = new Vec3f(vec4f);
        float f2 = ray.dir.dot(vec3f2);
        if (FloatUtil.isZero(f2, f)) {
            return null;
        }
        vec3f.set(ray.dir);
        return vec3f.scale(-(ray.orig.dot(vec3f2) + vec4f.w()) / f2).add(ray.orig);
    }

    @Deprecated
    public static Vec3f line2lineIntersection0(Vec3f vec3f, Vert2fImmutable vert2fImmutable, Vert2fImmutable vert2fImmutable2, Vert2fImmutable vert2fImmutable3, Vert2fImmutable vert2fImmutable4) {
        float f = (vert2fImmutable.x() - vert2fImmutable2.x()) * (vert2fImmutable3.y() - vert2fImmutable4.y()) - (vert2fImmutable.y() - vert2fImmutable2.y()) * (vert2fImmutable3.x() - vert2fImmutable4.x());
        if (f == 0.0f) {
            return null;
        }
        float f2 = vert2fImmutable.x() * vert2fImmutable2.y() - vert2fImmutable.y() * vert2fImmutable2.x();
        float f3 = vert2fImmutable3.x() * vert2fImmutable4.y() - vert2fImmutable3.y() * vert2fImmutable4.y();
        float f4 = ((vert2fImmutable3.x() - vert2fImmutable4.x()) * f2 - (vert2fImmutable.x() - vert2fImmutable2.x()) * f3) / f;
        float f5 = ((vert2fImmutable3.y() - vert2fImmutable4.y()) * f2 - (vert2fImmutable.y() - vert2fImmutable2.y()) * f3) / f;
        return vec3f.set(f4, f5, 0.0f);
    }

    @Deprecated
    public static Vec3f seg2SegIntersection0(Vec3f vec3f, Vert2fImmutable vert2fImmutable, Vert2fImmutable vert2fImmutable2, Vert2fImmutable vert2fImmutable3, Vert2fImmutable vert2fImmutable4) {
        float f = (vert2fImmutable.x() - vert2fImmutable2.x()) * (vert2fImmutable3.y() - vert2fImmutable4.y()) - (vert2fImmutable.y() - vert2fImmutable2.y()) * (vert2fImmutable3.x() - vert2fImmutable4.x());
        if (f == 0.0f) {
            return null;
        }
        float f2 = vert2fImmutable.x() * vert2fImmutable2.y() - vert2fImmutable.y() * vert2fImmutable2.x();
        float f3 = vert2fImmutable3.x() * vert2fImmutable4.y() - vert2fImmutable3.y() * vert2fImmutable4.y();
        float f4 = ((vert2fImmutable3.x() - vert2fImmutable4.x()) * f2 - (vert2fImmutable.x() - vert2fImmutable2.x()) * f3) / f;
        float f5 = ((vert2fImmutable3.y() - vert2fImmutable4.y()) * f2 - (vert2fImmutable.y() - vert2fImmutable2.y()) * f3) / f;
        float f6 = (f4 - vert2fImmutable.x()) / (vert2fImmutable2.x() - vert2fImmutable.x());
        float f7 = (f4 - vert2fImmutable3.x()) / (vert2fImmutable4.x() - vert2fImmutable3.x());
        if (f6 <= 0.0f || f6 >= 1.0f) {
            return null;
        }
        if (f7 <= 0.0f || f7 >= 1.0f) {
            return null;
        }
        return vec3f.set(f4, f5, 0.0f);
    }

    @Deprecated
    public static boolean testSeg2SegIntersection0(Vert2fImmutable vert2fImmutable, Vert2fImmutable vert2fImmutable2, Vert2fImmutable vert2fImmutable3, Vert2fImmutable vert2fImmutable4) {
        float f = (vert2fImmutable.x() - vert2fImmutable2.x()) * (vert2fImmutable3.y() - vert2fImmutable4.y()) - (vert2fImmutable.y() - vert2fImmutable2.y()) * (vert2fImmutable3.x() - vert2fImmutable4.x());
        if (f == 0.0f) {
            return false;
        }
        float f2 = vert2fImmutable.x() * vert2fImmutable2.y() - vert2fImmutable.y() * vert2fImmutable2.x();
        float f3 = vert2fImmutable3.x() * vert2fImmutable4.y() - vert2fImmutable3.y() * vert2fImmutable4.y();
        float f4 = ((vert2fImmutable3.x() - vert2fImmutable4.x()) * f2 - (vert2fImmutable.x() - vert2fImmutable2.x()) * f3) / f;
        float f5 = (f4 - vert2fImmutable.x()) / (vert2fImmutable2.x() - vert2fImmutable.x());
        float f6 = (f4 - vert2fImmutable3.x()) / (vert2fImmutable4.x() - vert2fImmutable3.x());
        return !(f5 <= 0.0f || f5 >= 1.0f || f6 <= 0.0f) && !(f6 >= 1.0f);
    }

    @Deprecated
    public static boolean testTri2SegIntersection0(Vert2fImmutable vert2fImmutable, Vert2fImmutable vert2fImmutable2, Vert2fImmutable vert2fImmutable3, Vert2fImmutable vert2fImmutable4, Vert2fImmutable vert2fImmutable5) {
        return VectorUtil.testSeg2SegIntersection0(vert2fImmutable, vert2fImmutable2, vert2fImmutable4, vert2fImmutable5) || VectorUtil.testSeg2SegIntersection0(vert2fImmutable2, vert2fImmutable3, vert2fImmutable4, vert2fImmutable5) || VectorUtil.testSeg2SegIntersection0(vert2fImmutable, vert2fImmutable3, vert2fImmutable4, vert2fImmutable5);
    }

    public static boolean seg2SegIntersection(Vec3f vec3f, Vec2f vec2f, Vec2f vec2f2, Vec2f vec2f3, Vec2f vec2f4, float f, boolean bl) {
        Vec2f vec2f5;
        Vec2f vec2f6 = vec2f2.minus(vec2f);
        float f2 = vec2f6.cross(vec2f5 = vec2f4.minus(vec2f3));
        if (FloatUtil.isZero(f2, f)) {
            if (bl) {
                Vec2f vec2f7 = vec2f3.minus(vec2f);
                float f3 = vec2f7.cross(vec2f6);
                if (FloatUtil.isZero(f3, f)) {
                    Vec2f vec2f8 = vec2f.minus(vec2f3);
                    float f4 = vec2f7.dot(vec2f6);
                    float f5 = vec2f8.dot(vec2f5);
                    if (f <= f4 && f4 - vec2f6.dot(vec2f6) <= f || f <= f5 && f5 - vec2f5.dot(vec2f5) <= f) {
                        vec3f.set(vec2f4, 0.0f);
                        return true;
                    }
                    return false;
                }
                return false;
            }
            return false;
        }
        Vec2f vec2f9 = vec2f3.minus(vec2f);
        float f6 = vec2f9.cross(vec2f6);
        float f7 = vec2f9.cross(vec2f5) / f2;
        float f8 = f6 / f2;
        if (f <= f7 && f7 - 1.0f <= f && f <= f8 && f8 - 1.0f <= f) {
            vec3f.set(vec2f.plus(vec2f6.mul(f7)), 0.0f);
            return true;
        }
        return false;
    }

    public static boolean testSeg2SegIntersection(Vec2f vec2f, Vec2f vec2f2, Vec2f vec2f3, Vec2f vec2f4, float f, boolean bl) {
        Vec2f vec2f5;
        Vec2f vec2f6 = vec2f2.minus(vec2f);
        float f2 = vec2f6.cross(vec2f5 = vec2f4.minus(vec2f3));
        if (FloatUtil.isZero(f2, f)) {
            if (bl) {
                Vec2f vec2f7 = vec2f3.minus(vec2f);
                float f3 = vec2f7.cross(vec2f6);
                if (FloatUtil.isZero(f3, f)) {
                    Vec2f vec2f8 = vec2f.minus(vec2f3);
                    float f4 = vec2f7.dot(vec2f6);
                    float f5 = vec2f8.dot(vec2f5);
                    return f <= f4 && f4 - vec2f6.dot(vec2f6) <= f || f <= f5 && f5 - vec2f5.dot(vec2f5) <= f;
                }
                return false;
            }
            return false;
        }
        Vec2f vec2f9 = vec2f3.minus(vec2f);
        float f6 = vec2f9.cross(vec2f6);
        float f7 = vec2f9.cross(vec2f5) / f2;
        float f8 = f6 / f2;
        return f <= f7 && f7 - 1.0f <= f && f <= f8 && f8 - 1.0f <= f;
    }

    public static boolean testSeg2SegIntersection(Vert2fImmutable vert2fImmutable, Vert2fImmutable vert2fImmutable2, Vert2fImmutable vert2fImmutable3, Vert2fImmutable vert2fImmutable4, float f, boolean bl) {
        float f2 = vert2fImmutable2.x() - vert2fImmutable.x();
        float f3 = vert2fImmutable2.y() - vert2fImmutable.y();
        float f4 = vert2fImmutable4.x() - vert2fImmutable3.x();
        float f5 = vert2fImmutable4.y() - vert2fImmutable3.y();
        float f6 = f2 * f5 - f3 * f4;
        if (FloatUtil.isZero(f6, f)) {
            if (bl) {
                float f7;
                float f8 = vert2fImmutable3.x() - vert2fImmutable.x();
                float f9 = f8 * f3 - (f7 = vert2fImmutable3.y() - vert2fImmutable.y()) * f2;
                if (FloatUtil.isZero(f9, f)) {
                    float f10 = vert2fImmutable.x() - vert2fImmutable3.x();
                    float f11 = vert2fImmutable.y() - vert2fImmutable3.y();
                    float f12 = f8 * f2 + f7 * f3;
                    float f13 = f10 * f4 + f11 * f5;
                    float f14 = f2 * f2 + f3 * f3;
                    float f15 = f4 * f4 + f5 * f5;
                    return f <= f12 && f12 - f14 <= f || f <= f13 && f13 - f15 <= f;
                }
                return false;
            }
            return false;
        }
        float f16 = vert2fImmutable3.x() - vert2fImmutable.x();
        float f17 = vert2fImmutable3.y() - vert2fImmutable.y();
        float f18 = f16 * f3 - f17 * f2;
        float f19 = (f16 * f5 - f17 * f4) / f6;
        float f20 = f18 / f6;
        return f <= f19 && f19 - 1.0f <= f && f <= f20 && f20 - 1.0f <= f;
    }

    public static boolean testTri2SegIntersection(Vert2fImmutable vert2fImmutable, Vert2fImmutable vert2fImmutable2, Vert2fImmutable vert2fImmutable3, Vert2fImmutable vert2fImmutable4, Vert2fImmutable vert2fImmutable5, float f, boolean bl) {
        return VectorUtil.testSeg2SegIntersection(vert2fImmutable, vert2fImmutable2, vert2fImmutable4, vert2fImmutable5, f, bl) || VectorUtil.testSeg2SegIntersection(vert2fImmutable2, vert2fImmutable3, vert2fImmutable4, vert2fImmutable5, f, bl) || VectorUtil.testSeg2SegIntersection(vert2fImmutable, vert2fImmutable3, vert2fImmutable4, vert2fImmutable5, f, bl);
    }

    public static boolean testSeg2SegIntersection(Vert2fImmutable vert2fImmutable, Vert2fImmutable vert2fImmutable2, Vert2fImmutable vert2fImmutable3, Vert2fImmutable vert2fImmutable4) {
        float f = vert2fImmutable2.x() - vert2fImmutable.x();
        float f2 = vert2fImmutable2.y() - vert2fImmutable.y();
        float f3 = vert2fImmutable4.x() - vert2fImmutable3.x();
        float f4 = vert2fImmutable4.y() - vert2fImmutable3.y();
        float f5 = f * f4 - f2 * f3;
        if (FloatUtil.isZero(f5)) {
            return false;
        }
        float f6 = vert2fImmutable3.x() - vert2fImmutable.x();
        float f7 = vert2fImmutable3.y() - vert2fImmutable.y();
        float f8 = f6 * f2 - f7 * f;
        float f9 = (f6 * f4 - f7 * f3) / f5;
        float f10 = f8 / f5;
        return 1.1920929E-7f <= f9 && f9 - 1.0f <= 1.1920929E-7f && 1.1920929E-7f <= f10 && f10 - 1.0f <= 1.1920929E-7f;
    }

    public static boolean testTri2SegIntersection(Vert2fImmutable vert2fImmutable, Vert2fImmutable vert2fImmutable2, Vert2fImmutable vert2fImmutable3, Vert2fImmutable vert2fImmutable4, Vert2fImmutable vert2fImmutable5) {
        return VectorUtil.testSeg2SegIntersection(vert2fImmutable, vert2fImmutable2, vert2fImmutable4, vert2fImmutable5) || VectorUtil.testSeg2SegIntersection(vert2fImmutable2, vert2fImmutable3, vert2fImmutable4, vert2fImmutable5) || VectorUtil.testSeg2SegIntersection(vert2fImmutable, vert2fImmutable3, vert2fImmutable4, vert2fImmutable5);
    }

    public static boolean isConvex0(List<? extends Vert2fImmutable> list, boolean bl) {
        int n = list.size();
        if (n < 3) {
            return bl;
        }
        float f = 0.0f;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        Vert2fImmutable vert2fImmutable = list.get(n - 2);
        Vert2fImmutable vert2fImmutable2 = list.get(n - 1);
        for (int i = 0; i < n; ++i) {
            Vert2fImmutable vert2fImmutable3 = vert2fImmutable;
            vert2fImmutable = vert2fImmutable2;
            vert2fImmutable2 = list.get(i);
            float f2 = vert2fImmutable.x() - vert2fImmutable3.x();
            float f3 = vert2fImmutable.y() - vert2fImmutable3.y();
            float f4 = vert2fImmutable2.x() - vert2fImmutable.x();
            float f5 = vert2fImmutable2.y() - vert2fImmutable.y();
            if (f4 > 1.1920929E-7f) {
                if (n2 == 0) {
                    n3 = 1;
                } else if (n2 < 0) {
                    ++n4;
                }
                n2 = 1;
            } else if (f4 < -1.1920929E-7f) {
                if (n2 == 0) {
                    n3 = -1;
                } else if (n2 > 0) {
                    ++n4;
                }
                n2 = -1;
            }
            if (n4 > 2) {
                return false;
            }
            if (f5 > 1.1920929E-7f) {
                if (n5 == 0) {
                    n6 = 1;
                } else if (n5 < 0) {
                    ++n7;
                }
                n5 = 1;
            } else if (f5 < -1.1920929E-7f) {
                if (n5 == 0) {
                    n6 = -1;
                } else if (n5 > 0) {
                    ++n7;
                }
                n5 = -1;
            }
            if (n7 > 2) {
                return false;
            }
            float f6 = f2 * f5 - f4 * f3;
            if (FloatUtil.isZero(f) && !FloatUtil.isZero(f6)) {
                f = f6;
                continue;
            }
            if (f > 1.1920929E-7f && f6 < -1.1920929E-7f) {
                return false;
            }
            if (!(f < -1.1920929E-7f) || !(f6 > 1.1920929E-7f)) continue;
            return false;
        }
        if (n2 != 0 && n3 != 0 && n2 != n3) {
            ++n4;
        }
        if (n5 != 0 && n6 != 0 && n5 != n6) {
            ++n7;
        }
        return n4 == 2 && n7 == 2;
    }

    private static int cmod(int n, int n2) {
        if (n >= 0) {
            return n % n2;
        }
        return n + n2;
    }

    public static boolean isConvex1(List<Vertex> list, boolean bl) {
        Vertex vertex;
        Vertex vertex2;
        int n = list.size();
        if (n < 3) {
            return bl;
        }
        float f = 0.0f;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = -3;
        while (!(vertex2 = list.get(VectorUtil.cmod(++n8, n))).isOnCurve() && n8 < n) {
        }
        if (n8 >= n) {
            return bl;
        }
        while (!(vertex = list.get(VectorUtil.cmod(++n8, n))).isOnCurve() && n8 < n) {
        }
        if (n8 >= n) {
            return bl;
        }
        while (n8 < n) {
            Vertex vertex3 = vertex2;
            vertex2 = vertex;
            while (!(vertex = list.get(VectorUtil.cmod(++n8, n))).isOnCurve() && n8 < n) {
            }
            if (n8 >= n) break;
            float f2 = vertex2.x() - vertex3.x();
            float f3 = vertex2.y() - vertex3.y();
            float f4 = vertex.x() - vertex2.x();
            float f5 = vertex.y() - vertex2.y();
            if (f4 > 1.1920929E-7f) {
                if (n2 == 0) {
                    n3 = 1;
                } else if (n2 < 0) {
                    ++n4;
                }
                n2 = 1;
            } else if (f4 < -1.1920929E-7f) {
                if (n2 == 0) {
                    n3 = -1;
                } else if (n2 > 0) {
                    ++n4;
                }
                n2 = -1;
            }
            if (n4 > 2) {
                return false;
            }
            if (f5 > 1.1920929E-7f) {
                if (n5 == 0) {
                    n6 = 1;
                } else if (n5 < 0) {
                    ++n7;
                }
                n5 = 1;
            } else if (f5 < -1.1920929E-7f) {
                if (n5 == 0) {
                    n6 = -1;
                } else if (n5 > 0) {
                    ++n7;
                }
                n5 = -1;
            }
            if (n7 > 2) {
                return false;
            }
            float f6 = f2 * f5 - f4 * f3;
            if (FloatUtil.isZero(f) && !FloatUtil.isZero(f6)) {
                f = f6;
                continue;
            }
            if (f > 1.1920929E-7f && f6 < -1.1920929E-7f) {
                return false;
            }
            if (!(f < -1.1920929E-7f) || !(f6 > 1.1920929E-7f)) continue;
            return false;
        }
        if (n2 != 0 && n3 != 0 && n2 != n3) {
            ++n4;
        }
        if (n5 != 0 && n6 != 0 && n5 != n6) {
            ++n7;
        }
        return n4 == 2 && n7 == 2;
    }

    public static boolean isSelfIntersecting1(List<Vertex> list) {
        int n = list.size();
        if (n < 4) {
            return false;
        }
        for (int i = 0; i < n - 1; ++i) {
            Vertex vertex = list.get(i);
            Vertex vertex2 = list.get(i + 1);
            for (int j = i + 2; j < n; ++j) {
                Vertex vertex3;
                Vertex vertex4;
                if (i == 0 && j == n - 1 || !VectorUtil.testSeg2SegIntersection((Vert2fImmutable)vertex, (Vert2fImmutable)vertex2, (Vert2fImmutable)(vertex4 = list.get(j)), (Vert2fImmutable)(vertex3 = list.get((j + 1) % n)), 0.0f, false)) continue;
                return true;
            }
        }
        return false;
    }
}

