/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen.opengl;

import com.jogamp.gluegen.CodeGenUtils;
import com.jogamp.gluegen.JavaType;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.nio.Buffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class BuildComposablePipeline {
    public static final int GEN_DEBUG = 1;
    public static final int GEN_TRACE = 2;
    public static final int GEN_CUSTOM = 4;
    public static final int GEN_PROLOG_XOR_DOWNSTREAM = 8;
    public static final int GEN_GL_IDENTITY_BY_ASSIGNABLE_CLASS = 16;
    private static final HashMap<String, String> addedGLHooks = new HashMap();
    private static final String[] addedGLHookMethodNames = new String[]{"mapBuffer", "mapBufferRange", "mapNamedBuffer", "mapNamedBufferRange"};
    int mode;
    private final String outputDir;
    private final String outputPackage;
    private final String outputName;
    private final Class<?> classToComposeAround;
    private final Class<?> classPrologOpt;
    private final Class<?> classDownstream;
    private boolean hasImmediateMode;
    private boolean hasGL2ES1StackOverflow;

    public static Class<?> getClass(String string) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
        }
        catch (Exception exception) {
            throw new RuntimeException("Could not find class \"" + string + "\"", exception);
        }
        return clazz;
    }

    public static Method getMethod(Class<?> clazz, Method method) {
        Method method2 = null;
        try {
            method2 = clazz.getMethod(method.getName(), method.getParameterTypes());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return method2;
    }

    public static void main(String[] stringArray) {
        int n;
        Class<?> clazz;
        Class<?> clazz2;
        String string;
        String string2;
        Object object;
        String string3 = stringArray[0];
        Class<?> clazz3 = BuildComposablePipeline.getClass(string3);
        String string4 = stringArray[1];
        if (stringArray.length > 2) {
            object = stringArray[2];
            string2 = BuildComposablePipeline.getPackageName((String)object);
            string = BuildComposablePipeline.getBaseClassName((String)object);
            clazz2 = BuildComposablePipeline.getClass(stringArray[3]);
            clazz = BuildComposablePipeline.getClass(stringArray[4]);
            n = 4;
            if (stringArray.length > 5) {
                for (int i = 5; i < stringArray.length; ++i) {
                    if (stringArray[i].equals("prolog_xor_downstream")) {
                        n |= 8;
                        continue;
                    }
                    if (!stringArray[i].equals("gl_identity_by_assignable_class")) continue;
                    n |= 0x10;
                }
            }
        } else {
            string2 = BuildComposablePipeline.getPackageName(string3);
            string = null;
            clazz2 = null;
            clazz = clazz3;
            n = 3;
        }
        object = new BuildComposablePipeline(n, string4, string2, string, clazz3, clazz2, clazz);
        try {
            ((BuildComposablePipeline)object).emit();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Error generating composable pipeline source files", iOException);
        }
    }

    protected BuildComposablePipeline(int n, String string, String string2, String string3, Class<?> clazz, Class<?> clazz2, Class<?> clazz3) {
        this.mode = n;
        this.outputDir = string;
        this.outputPackage = string2;
        this.outputName = string3;
        this.classToComposeAround = clazz;
        this.classPrologOpt = clazz2;
        this.classDownstream = clazz3;
        if (!clazz.isInterface()) {
            throw new IllegalArgumentException(clazz.getName() + " is not an interface class");
        }
        try {
            this.hasImmediateMode = null != clazz.getMethod("glBegin", Integer.TYPE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.hasGL2ES1StackOverflow = this.hasImmediateMode && clazz.getField("GL_STACK_OVERFLOW") != null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void emit() throws IOException {
        List<Method> list = Arrays.asList(this.classToComposeAround.getMethods());
        HashSet<PlainMethod> hashSet = new HashSet<PlainMethod>();
        for (Method method : list) {
            String string = method.getName();
            if (string.equals("getDownstreamGL") || string.equals("toString")) continue;
            boolean bl = string.startsWith("isGL");
            boolean bl2 = string.startsWith("getGL");
            boolean bl3 = string.startsWith("gl") || bl || bl2 || addedGLHooks.containsKey(string);
            hashSet.add(new PlainMethod(method, bl3, bl, bl2));
        }
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(hashSet);
        Collections.sort(arrayList, new Comparator<PlainMethod>(){

            @Override
            public int compare(PlainMethod plainMethod, PlainMethod plainMethod2) {
                return plainMethod.getWrappedMethod().getName().compareTo(plainMethod2.getWrappedMethod().getName());
            }
        });
        if (0 != (this.mode & 1)) {
            new DebugPipeline(this.outputDir, this.outputPackage, this.classToComposeAround, this.classDownstream).emit(arrayList.iterator());
        }
        if (0 != (this.mode & 2)) {
            new TracePipeline(this.outputDir, this.outputPackage, this.classToComposeAround, this.classDownstream).emit(arrayList.iterator());
        }
        if (0 != (this.mode & 4)) {
            new CustomPipeline(this.mode, this.outputDir, this.outputPackage, this.outputName, this.classToComposeAround, this.classPrologOpt, this.classDownstream).emit(arrayList.iterator());
        }
    }

    public static String getPackageName(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return null;
        }
        return string.substring(0, n);
    }

    public static String getBaseClassName(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1);
    }

    public static final void printFunctionCallString(PrintWriter printWriter, Method method) {
        Class<?>[] classArray = method.getParameterTypes();
        printWriter.print("    \"" + method.getName() + "(\"");
        for (int i = 0; i < classArray.length; ++i) {
            printWriter.print("+\"<" + classArray[i].getName() + ">");
            if (classArray[i].isArray()) {
                printWriter.print("\"");
            } else if (classArray[i].equals(Integer.TYPE)) {
                printWriter.print(" 0x\"+Integer.toHexString(arg" + i + ").toUpperCase()");
            } else {
                printWriter.print(" \"+arg" + i);
            }
            if (i >= classArray.length - 1) continue;
            printWriter.print("+\", \"");
        }
        printWriter.print("+\")\"");
    }

    static {
        for (int i = 0; i < addedGLHookMethodNames.length; ++i) {
            addedGLHooks.put(addedGLHookMethodNames[i], addedGLHookMethodNames[i]);
        }
    }

    protected static class PlainMethod {
        final Method m;
        final boolean runHooks;
        final boolean isSynthethicIsGL;
        final boolean isSynthethicGetGL;

        PlainMethod(Method method, boolean bl, boolean bl2, boolean bl3) {
            this.m = method;
            this.runHooks = bl;
            this.isSynthethicIsGL = bl2;
            this.isSynthethicGetGL = bl3;
        }

        public Method getWrappedMethod() {
            return this.m;
        }

        public boolean runHooks() {
            return this.runHooks;
        }

        public boolean isSynthetic() {
            return this.isSynthethicIsGL || this.isSynthethicGetGL;
        }

        public boolean isSyntheticIsGL() {
            return this.isSynthethicIsGL;
        }

        public boolean isSyntheticGetGL() {
            return this.isSynthethicGetGL;
        }

        public boolean equals(Object object) {
            if (object instanceof PlainMethod) {
                PlainMethod plainMethod = (PlainMethod)object;
                boolean bl = this.m.getName().equals(plainMethod.m.getName()) && this.m.getModifiers() == plainMethod.m.getModifiers() && this.m.getReturnType().equals(plainMethod.m.getReturnType()) && Arrays.equals(this.m.getParameterTypes(), plainMethod.m.getParameterTypes());
                return bl;
            }
            return false;
        }

        public int hashCode() {
            int n = this.m.getName().hashCode() ^ this.m.getModifiers() ^ this.m.getReturnType().hashCode();
            Class<?>[] classArray = this.m.getParameterTypes();
            for (int i = 0; i < classArray.length; ++i) {
                n ^= classArray[i].hashCode();
            }
            return n;
        }

        public String toString() {
            Class<?>[] classArray = this.m.getParameterTypes();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("(");
            for (int i = 0; i < classArray.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(classArray[i].getName());
            }
            stringBuilder.append(")");
            return this.m.toString() + "\n\tname: " + this.m.getName() + "\n\tsynt: isGL " + this.isSynthethicIsGL + ", getGL " + this.isSynthethicGetGL + "\n\tmods: " + this.m.getModifiers() + "\n\tretu: " + this.m.getReturnType() + "\n\targs[" + classArray.length + "]: " + stringBuilder.toString();
        }
    }

    protected class DebugPipeline
    extends PipelineEmitter {
        String className;

        DebugPipeline(String string, String string2, Class<?> clazz, Class<?> clazz2) {
            super(string, string2, clazz, null, clazz2);
            this.className = "Debug" + this.getBaseInterfaceName();
        }

        @Override
        protected String getOutputName() {
            return this.className;
        }

        @Override
        protected int getMode() {
            return 0;
        }

        @Override
        protected boolean emptyMethodAllowed() {
            return false;
        }

        @Override
        protected boolean emptyDownstreamAllowed() {
            return false;
        }

        @Override
        protected void preMethodEmissionHook(PrintWriter printWriter) {
            super.preMethodEmissionHook(printWriter);
        }

        @Override
        protected void constructorHook(PrintWriter printWriter) {
            printWriter.print("  public " + this.getOutputName() + "(");
            printWriter.println(this.downstreamName + " " + this.getDownstreamObjectName() + ")");
            printWriter.println("  {");
            printWriter.println("    if (" + this.getDownstreamObjectName() + " == null) {");
            printWriter.println("      throw new IllegalArgumentException(\"null " + this.getDownstreamObjectName() + "\");");
            printWriter.println("    }");
            printWriter.print("    this." + this.getDownstreamObjectName());
            printWriter.println(" = " + this.getDownstreamObjectName() + ";");
            if (null != this.prologNameOpt) {
                printWriter.print("    this." + this.getPrologObjectNameOpt());
                printWriter.println(" = " + this.getPrologObjectNameOpt() + ";");
            }
            printWriter.println("    // Fetch GLContext object for better error checking (if possible)");
            printWriter.println("    _context = " + this.getDownstreamObjectName() + ".getContext();");
            printWriter.println("  }");
            printWriter.println();
        }

        @Override
        protected void postMethodEmissionHook(PrintWriter printWriter) {
            super.postMethodEmissionHook(printWriter);
            printWriter.println("  private int checkGLError() {");
            if (BuildComposablePipeline.this.hasImmediateMode) {
                printWriter.println("    if (insideBeginEndPair) return GL_NO_ERROR;");
                printWriter.println();
            }
            printWriter.format("    return %s.glGetError();%n", this.getDownstreamObjectName());
            printWriter.println("  }");
            printWriter.println("  private void writeGLError(int err, String fmt, Object... args)");
            printWriter.println("  {");
            printWriter.println("    StringBuilder buf = new StringBuilder();");
            printWriter.println("    buf.append(Thread.currentThread().toString());");
            printWriter.println("    buf.append(\" glGetError() returned the following error codes after a call to \");");
            printWriter.println("    buf.append(String.format(fmt, args));");
            printWriter.println("    buf.append(\": \");");
            printWriter.println();
            printWriter.println("    // Loop repeatedly to allow for distributed GL implementations,");
            printWriter.println("    // as detailed in the glGetError() specification");
            printWriter.println("    int recursionDepth = 10;");
            printWriter.println("    do {");
            printWriter.println("      switch (err) {");
            printWriter.println("        case GL_INVALID_ENUM: buf.append(\"GL_INVALID_ENUM \"); break;");
            printWriter.println("        case GL_INVALID_VALUE: buf.append(\"GL_INVALID_VALUE \"); break;");
            printWriter.println("        case GL_INVALID_OPERATION: buf.append(\"GL_INVALID_OPERATION \"); break;");
            if (BuildComposablePipeline.this.hasGL2ES1StackOverflow) {
                printWriter.println("        case GL2ES1.GL_STACK_OVERFLOW: buf.append(\"GL_STACK_OVERFLOW \"); break;");
                printWriter.println("        case GL2ES1.GL_STACK_UNDERFLOW: buf.append(\"GL_STACK_UNDERFLOW \"); break;");
            }
            printWriter.println("        case GL_OUT_OF_MEMORY: buf.append(\"GL_OUT_OF_MEMORY \"); break;");
            printWriter.println("        case GL_NO_ERROR: throw new InternalError(\"Should not be treating GL_NO_ERROR as error\");");
            printWriter.println("        default: buf.append(\"Unknown glGetError() return value: \");");
            printWriter.println("      }");
            printWriter.println("      buf.append(\"( \" + err + \" 0x\"+Integer.toHexString(err).toUpperCase() + \"), \");");
            printWriter.println("    } while ((--recursionDepth >= 0) && (err = " + this.getDownstreamObjectName() + ".glGetError()) != GL_NO_ERROR);");
            printWriter.println("    throw new GLException(buf.toString());");
            printWriter.println("  }");
            if (BuildComposablePipeline.this.hasImmediateMode) {
                printWriter.println("  /** True if the pipeline is inside a glBegin/glEnd pair.*/");
                printWriter.println("  private boolean insideBeginEndPair = false;");
                printWriter.println();
            }
            printWriter.println("  private void checkContext() {");
            printWriter.println("    GLContext currentContext = GLContext.getCurrent();");
            printWriter.println("    if (currentContext == null) {");
            printWriter.println("      throw new GLException(\"No OpenGL context is current on this thread\");");
            printWriter.println("    }");
            printWriter.println("    if ((_context != null) && (_context != currentContext)) {");
            printWriter.println("      throw new GLException(\"This GL object is being incorrectly used with a different GLContext than that which created it\");");
            printWriter.println("    }");
            printWriter.println("  }");
            printWriter.println("  private GLContext _context;");
        }

        @Override
        protected void emitClassDocComment(PrintWriter printWriter) {
            printWriter.println("/**");
            printWriter.println(" * <p>");
            printWriter.println(" * Composable pipeline which wraps an underlying {@link GL} implementation,");
            printWriter.println(" * providing error checking after each OpenGL method call. If an error occurs,");
            printWriter.println(" * causes a {@link GLException} to be thrown at exactly the point of failure.");
            printWriter.println(" * </p>");
            printWriter.println(" * <p>");
            printWriter.println(" * Sample code which installs this pipeline:");
            printWriter.println(" * <pre>");
            printWriter.println(" *   gl = drawable.setGL(new DebugGL(drawable.getGL()));");
            printWriter.println(" * </pre>");
            printWriter.println(" * For automatic instantiation see {@link GLPipelineFactory#create(String, Class, GL, Object[])}");
            printWriter.println(" * </p>");
            printWriter.println(" */");
        }

        @Override
        protected boolean hasPreDownstreamCallHook(PlainMethod plainMethod) {
            return !plainMethod.isSynthetic();
        }

        @Override
        protected void preDownstreamCallHook(PrintWriter printWriter, PlainMethod plainMethod) {
            printWriter.println("    checkContext();");
        }

        @Override
        protected boolean hasPostDownstreamCallHook(PlainMethod plainMethod) {
            return !plainMethod.isSynthetic();
        }

        @Override
        protected void postDownstreamCallHook(PrintWriter printWriter, PlainMethod plainMethod) {
            Method method = plainMethod.getWrappedMethod();
            if (method.getName().equals("glBegin")) {
                printWriter.println("    insideBeginEndPair = true;");
                printWriter.println("    // NOTE: can't check glGetError(); it's not allowed inside glBegin/glEnd pair");
            } else {
                if (method.getName().equals("glEnd")) {
                    printWriter.println("    insideBeginEndPair = false;");
                }
                printWriter.println("    final int err = checkGLError();");
                printWriter.println("    if (err != GL_NO_ERROR) {");
                StringBuilder stringBuilder = new StringBuilder();
                StringBuilder stringBuilder2 = new StringBuilder();
                stringBuilder.append("\"%s(");
                stringBuilder2.append("\"").append(method.getName()).append("\"");
                Class<?>[] classArray = method.getParameterTypes();
                for (int i = 0; i < classArray.length; ++i) {
                    if (i > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append("<").append(classArray[i].getName()).append(">");
                    if (classArray[i].isArray()) continue;
                    if (classArray[i].equals(Integer.TYPE)) {
                        stringBuilder.append(" 0x%X");
                        stringBuilder2.append(", arg").append(i);
                        continue;
                    }
                    stringBuilder.append(" %s");
                    stringBuilder2.append(", arg").append(i);
                }
                stringBuilder.append(")\",");
                stringBuilder2.append(");");
                printWriter.print("      writeGLError(err, ");
                printWriter.println(stringBuilder.toString());
                printWriter.print("                   ");
                printWriter.println(stringBuilder2.toString());
                printWriter.println("    }");
            }
        }
    }

    protected class TracePipeline
    extends PipelineEmitter {
        String className;

        TracePipeline(String string, String string2, Class<?> clazz, Class<?> clazz2) {
            super(string, string2, clazz, null, clazz2);
            this.className = "Trace" + this.getBaseInterfaceName();
        }

        @Override
        protected String getOutputName() {
            return this.className;
        }

        @Override
        protected int getMode() {
            return 0;
        }

        @Override
        protected boolean emptyMethodAllowed() {
            return false;
        }

        @Override
        protected boolean emptyDownstreamAllowed() {
            return false;
        }

        @Override
        protected void preMethodEmissionHook(PrintWriter printWriter) {
            super.preMethodEmissionHook(printWriter);
        }

        @Override
        protected void constructorHook(PrintWriter printWriter) {
            printWriter.print("  public " + this.getOutputName() + "(");
            printWriter.println(this.downstreamName + " " + this.getDownstreamObjectName() + ", PrintStream " + this.getOutputStreamName() + ")");
            printWriter.println("  {");
            printWriter.println("    if (" + this.getDownstreamObjectName() + " == null) {");
            printWriter.println("      throw new IllegalArgumentException(\"null " + this.getDownstreamObjectName() + "\");");
            printWriter.println("    }");
            printWriter.print("    this." + this.getDownstreamObjectName());
            printWriter.println(" = " + this.getDownstreamObjectName() + ";");
            printWriter.print("    this." + this.getOutputStreamName());
            printWriter.println(" = " + this.getOutputStreamName() + ";");
            printWriter.println("  }");
            printWriter.println();
        }

        @Override
        protected void postMethodEmissionHook(PrintWriter printWriter) {
            super.postMethodEmissionHook(printWriter);
            printWriter.println("private PrintStream " + this.getOutputStreamName() + ";");
            printWriter.println("private int indent = 0;");
            printWriter.println("protected String dumpArray(Object obj)");
            printWriter.println("{");
            printWriter.println("  if (obj == null) return \"[null]\";");
            printWriter.println("  StringBuilder sb = new StringBuilder(\"[\");");
            printWriter.println("  int len  = java.lang.reflect.Array.getLength(obj);");
            printWriter.println("  int count = Math.min(len,16);");
            printWriter.println("  for ( int i =0; i < count; i++ ) {");
            printWriter.println("    sb.append(java.lang.reflect.Array.get(obj,i));");
            printWriter.println("    if (i < count-1)");
            printWriter.println("      sb.append(',');");
            printWriter.println("  }");
            printWriter.println("  if ( len > 16 )");
            printWriter.println("    sb.append(\"...\").append(len);");
            printWriter.println("  sb.append(']');");
            printWriter.println("  return sb.toString();");
            printWriter.println("}");
            printWriter.println("protected void print(String str)");
            printWriter.println("{");
            printWriter.println("  " + this.getOutputStreamName() + ".print(str);");
            printWriter.println("}");
            printWriter.println("protected void println(String str)");
            printWriter.println("{");
            printWriter.println("  " + this.getOutputStreamName() + ".println(str);");
            printWriter.println("}");
            printWriter.println("protected void printIndent()");
            printWriter.println("{");
            printWriter.println("  for( int i =0; i < indent; i++) {" + this.getOutputStreamName() + ".print(' ');}");
            printWriter.println("}");
        }

        @Override
        protected void emitClassDocComment(PrintWriter printWriter) {
            printWriter.println("/**");
            printWriter.println(" * <p>");
            printWriter.println(" * Composable pipeline which wraps an underlying {@link GL} implementation,");
            printWriter.println(" * providing tracing information to a user-specified {@link java.io.PrintStream}");
            printWriter.println(" * before and after each OpenGL method call.");
            printWriter.println(" * </p>");
            printWriter.println(" * <p>");
            printWriter.println(" * Sample code which installs this pipeline:");
            printWriter.println(" * <pre>");
            printWriter.println(" *   gl = drawable.setGL(new TraceGL(drawable.getGL(), System.err));");
            printWriter.println(" * </pre>");
            printWriter.println(" * For automatic instantiation see {@link GLPipelineFactory#create(String, Class, GL, Object[])}");
            printWriter.println(" * </p>");
            printWriter.println(" */");
        }

        @Override
        protected boolean hasPreDownstreamCallHook(PlainMethod plainMethod) {
            return !plainMethod.isSynthetic();
        }

        @Override
        protected void preDownstreamCallHook(PrintWriter printWriter, PlainMethod plainMethod) {
            Method method = plainMethod.getWrappedMethod();
            if (method.getName().equals("glEnd") || method.getName().equals("glEndList")) {
                printWriter.println("    indent-=2;");
                printWriter.println("    printIndent();");
            } else {
                printWriter.println("    printIndent();");
            }
            printWriter.print("    print(");
            BuildComposablePipeline.printFunctionCallString(printWriter, method);
            printWriter.println(");");
        }

        @Override
        protected boolean hasPostDownstreamCallHook(PlainMethod plainMethod) {
            return !plainMethod.isSynthetic();
        }

        @Override
        protected void postDownstreamCallHook(PrintWriter printWriter, PlainMethod plainMethod) {
            Method method = plainMethod.getWrappedMethod();
            Class<?> clazz = method.getReturnType();
            if (clazz != Void.TYPE) {
                printWriter.println("    println(\" = \"+_res);");
            } else {
                printWriter.println("    println(\"\");");
            }
            if (method.getName().equals("glBegin")) {
                printWriter.println("    indent+=2;");
            }
        }

        private String getOutputStreamName() {
            return "stream";
        }
    }

    protected class CustomPipeline
    extends PipelineEmitter {
        String className;
        int mode;

        CustomPipeline(int n, String string, String string2, String string3, Class<?> clazz, Class<?> clazz2, Class<?> clazz3) {
            super(string, string2, clazz, clazz2, clazz3);
            this.className = string3;
            this.mode = n;
        }

        @Override
        protected String getOutputName() {
            return this.className;
        }

        @Override
        protected int getMode() {
            return this.mode;
        }

        @Override
        protected boolean emptyMethodAllowed() {
            return true;
        }

        @Override
        protected boolean emptyDownstreamAllowed() {
            return true;
        }

        @Override
        protected void preMethodEmissionHook(PrintWriter printWriter) {
            super.preMethodEmissionHook(printWriter);
        }

        @Override
        protected void constructorHook(PrintWriter printWriter) {
            printWriter.print("  public " + this.getOutputName() + "(");
            printWriter.print(this.downstreamName + " " + this.getDownstreamObjectName());
            if (null != this.prologNameOpt) {
                printWriter.println(", " + this.prologNameOpt + " " + this.getPrologObjectNameOpt() + ")");
            } else {
                printWriter.println(")");
            }
            printWriter.println("  {");
            printWriter.println("    if (" + this.getDownstreamObjectName() + " == null) {");
            printWriter.println("      throw new IllegalArgumentException(\"null " + this.getDownstreamObjectName() + "\");");
            printWriter.println("    }");
            printWriter.print("    this." + this.getDownstreamObjectName());
            printWriter.println(" = " + this.getDownstreamObjectName() + ";");
            if (null != this.prologNameOpt) {
                printWriter.print("    this." + this.getPrologObjectNameOpt());
                printWriter.println(" = " + this.getPrologObjectNameOpt() + ";");
            }
            printWriter.println("  }");
            printWriter.println();
        }

        @Override
        protected void postMethodEmissionHook(PrintWriter printWriter) {
            super.postMethodEmissionHook(printWriter);
            if (null != this.prologNameOpt) {
                printWriter.print("  private " + this.prologNameOpt + " " + this.getPrologObjectNameOpt() + ";");
            }
        }

        @Override
        protected void emitClassDocComment(PrintWriter printWriter) {
            printWriter.println("/**");
            printWriter.println(" * Composable pipeline {@link " + this.outputPackage + "." + BuildComposablePipeline.this.outputName + "}, implementing the interface");
            printWriter.println(" * {@link " + this.baseInterfaceClass.getName() + "}");
            printWriter.println(" * <p>");
            printWriter.println(" * Each method follows the call graph <ul>");
            if (null != this.prologClassOpt) {
                printWriter.println(" *   <li> call <em>prolog</em> {@link " + this.prologClassOpt.getName() + "} if available");
            }
            printWriter.println(" *   <li> call <em>downstream</em> {@link " + this.downstreamClass.getName() + "} if available");
            if (null != this.prologClassOpt && 0 != (8 & this.getMode())) {
                printWriter.println(" *        <strong>and</strong> if no call to {@link " + this.prologClassOpt.getName() + "} is made");
            }
            printWriter.println(" * </ul><p>");
            printWriter.println(" * ");
            printWriter.println(" * <ul>");
            printWriter.println(" *   <li> <em>Interface</em> {@link " + this.baseInterfaceClass.getName() + "}");
            if (null != this.prologClassOpt) {
                printWriter.println(" *   <li> <em>Prolog</em> {@link " + this.prologClassOpt.getName() + "}");
            }
            printWriter.println(" *   <li> <em>Downstream</em> {@link " + this.downstreamClass.getName() + "}");
            printWriter.println(" * </ul><p>");
            printWriter.println(" *  Sample code which installs this pipeline: </P>");
            printWriter.println(" * ");
            printWriter.println("<PRE>");
            if (null != this.prologNameOpt) {
                printWriter.println("     GL gl = drawable.setGL( new " + this.className + "( drawable.getGL().getGL2ES2(), new " + this.prologNameOpt + "( drawable.getGL().getGL2ES2() ) ) );");
            } else {
                printWriter.println("     GL gl = drawable.setGL( new " + this.className + "( drawable.getGL().getGL2ES2() ) );");
            }
            printWriter.println("</PRE>");
            printWriter.println("*/");
        }

        @Override
        protected boolean hasPreDownstreamCallHook(PlainMethod plainMethod) {
            return null != BuildComposablePipeline.getMethod(this.prologClassOpt, plainMethod.getWrappedMethod());
        }

        @Override
        protected void preDownstreamCallHook(PrintWriter printWriter, PlainMethod plainMethod) {
            Method method = plainMethod.getWrappedMethod();
            if (null != this.prologNameOpt) {
                printWriter.print(this.getPrologObjectNameOpt());
                printWriter.print('.');
                printWriter.print(method.getName());
                printWriter.print('(');
                printWriter.print(this.getArgListAsString(method, false, true));
                printWriter.println(");");
            }
        }

        @Override
        protected boolean hasPostDownstreamCallHook(PlainMethod plainMethod) {
            return false;
        }

        @Override
        protected void postDownstreamCallHook(PrintWriter printWriter, PlainMethod plainMethod) {
        }
    }

    protected abstract class PipelineEmitter {
        private File file;
        protected String basePackage;
        protected String baseName;
        protected String downstreamPackage;
        protected String downstreamName;
        protected String prologPackageOpt = null;
        protected String prologNameOpt = null;
        protected String outputDir;
        protected String outputPackage;
        protected Class<?> baseInterfaceClass;
        protected Class<?> prologClassOpt = null;
        protected Class<?> downstreamClass;

        PipelineEmitter(String string, String string2, Class<?> clazz, Class<?> clazz2, Class<?> clazz3) {
            this.outputDir = string;
            this.outputPackage = string2;
            this.baseInterfaceClass = clazz;
            this.prologClassOpt = clazz2;
            this.downstreamClass = clazz3;
            this.basePackage = BuildComposablePipeline.getPackageName(clazz.getName());
            this.baseName = BuildComposablePipeline.getBaseClassName(clazz.getName());
            this.downstreamPackage = BuildComposablePipeline.getPackageName(clazz3.getName());
            this.downstreamName = BuildComposablePipeline.getBaseClassName(clazz3.getName());
            if (null != clazz2) {
                this.prologPackageOpt = BuildComposablePipeline.getPackageName(clazz2.getName());
                this.prologNameOpt = BuildComposablePipeline.getBaseClassName(clazz2.getName());
            }
        }

        public void emit(Iterator<PlainMethod> iterator) throws IOException {
            Object object;
            String string = this.getOutputName();
            this.file = new File(this.outputDir + File.separatorChar + string + ".java");
            String string2 = this.file.getParent();
            if (string2 != null) {
                object = new File(string2);
                ((File)object).mkdirs();
            }
            object = new PrintWriter(new BufferedWriter(new FileWriter(this.file)));
            HashSet hashSet = new HashSet();
            hashSet.add(this.baseInterfaceClass);
            String[] stringArray = new String[]{this.baseInterfaceClass.getName()};
            List<Class<?>> list = Arrays.asList(this.baseInterfaceClass.getInterfaces());
            hashSet.addAll(list);
            hashSet.add(this.downstreamClass);
            if (null != this.prologClassOpt) {
                hashSet.add(this.prologClassOpt);
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("java.io.*");
            arrayList.add("com.jogamp.opengl.*");
            arrayList.add("com.jogamp.gluegen.runtime.*");
            arrayList.add(Buffer.class.getPackage().getName() + ".*");
            for (Class genericDeclaration : hashSet) {
                arrayList.add(genericDeclaration.getName());
            }
            CodeGenUtils.emitJavaHeaders((PrintWriter)object, (String)this.outputPackage, (String)string, (boolean)true, arrayList, (String[])new String[]{"public"}, (String[])stringArray, null, (CodeGenUtils.EmissionCallback)new CodeGenUtils.EmissionCallback(){

                public void emit(PrintWriter printWriter) {
                    PipelineEmitter.this.emitClassDocComment(printWriter);
                }
            });
            this.preMethodEmissionHook((PrintWriter)object);
            this.constructorHook((PrintWriter)object);
            this.emitSyntheticGLMethods((PrintWriter)object);
            while (iterator.hasNext()) {
                PlainMethod plainMethod = iterator.next();
                Method method = plainMethod.getWrappedMethod();
                this.emitMethodDocComment((PrintWriter)object, method);
                this.emitSignature((PrintWriter)object, method);
                this.emitBody((PrintWriter)object, plainMethod);
            }
            this.postMethodEmissionHook((PrintWriter)object);
            ((PrintWriter)object).println();
            ((PrintWriter)object).print("  private " + this.downstreamName + " " + this.getDownstreamObjectName() + ";");
            ((PrintWriter)object).println();
            ((PrintWriter)object).print("} // end class ");
            ((PrintWriter)object).println(string);
            ((PrintWriter)object).flush();
            ((PrintWriter)object).close();
            System.out.println("wrote to file: " + this.file);
        }

        protected String getDownstreamObjectName() {
            return "downstream" + this.downstreamName;
        }

        protected String getPrologObjectNameOpt() {
            if (null != this.prologNameOpt) {
                return "prolog" + this.prologNameOpt;
            }
            return null;
        }

        protected void emitMethodDocComment(PrintWriter printWriter, Method method) {
        }

        protected void emitSignature(PrintWriter printWriter, Method method) {
            printWriter.format("  @Override%n  public %s %s(%s)%n", JavaType.createForClass(method.getReturnType()).getName(), method.getName(), this.getArgListAsString(method, true, true));
        }

        protected void emitBody(PrintWriter printWriter, PlainMethod plainMethod) {
            boolean bl;
            boolean bl2 = plainMethod.runHooks();
            Method method = plainMethod.getWrappedMethod();
            printWriter.println("  {");
            Class<?> clazz = method.getReturnType();
            boolean bl3 = bl2 && this.hasPreDownstreamCallHook(plainMethod);
            boolean bl4 = bl2 && this.hasPostDownstreamCallHook(plainMethod);
            boolean bl5 = null != BuildComposablePipeline.getMethod(this.downstreamClass, method) && (0 == (8 & this.getMode()) || !bl3);
            boolean bl6 = bl = clazz != Void.TYPE;
            if (!bl5 && !this.emptyDownstreamAllowed()) {
                throw new RuntimeException("Method " + method + " has no downstream (" + this.downstreamName + ")");
            }
            if (!(bl3 || bl4 || bl5)) {
                if (!this.emptyMethodAllowed()) {
                    throw new RuntimeException("Method " + method + " is empty, no downstream (" + this.downstreamName + ") nor prolog (" + this.prologNameOpt + ").");
                }
                printWriter.print("    if(DEBUG) { System.out.println(\"WARNING: No prolog, no downstream, empty: \"+");
                BuildComposablePipeline.printFunctionCallString(printWriter, method);
                printWriter.println("); } ");
            }
            if (bl3) {
                if (bl && !bl5) {
                    if (bl4) {
                        printWriter.print("    " + JavaType.createForClass(clazz).getName());
                        printWriter.print(" _res = ");
                    } else {
                        printWriter.print("    return ");
                    }
                }
                this.preDownstreamCallHook(printWriter, plainMethod);
            }
            if (bl5) {
                if (plainMethod.isSyntheticIsGL()) {
                    this.emitGLIsMethodBody(printWriter, plainMethod);
                } else if (plainMethod.isSyntheticGetGL()) {
                    this.emitGLGetMethodBody(printWriter, plainMethod);
                } else {
                    if (bl) {
                        if (bl4) {
                            printWriter.print("    " + JavaType.createForClass(clazz).getName());
                            printWriter.print(" _res = ");
                        } else {
                            printWriter.print("    return ");
                        }
                    } else {
                        printWriter.print("    ");
                    }
                    printWriter.print(this.getDownstreamObjectName());
                    printWriter.print('.');
                    printWriter.print(method.getName());
                    printWriter.print('(');
                    printWriter.print(this.getArgListAsString(method, false, true));
                    printWriter.println(");");
                }
            }
            if (bl4) {
                this.postDownstreamCallHook(printWriter, plainMethod);
            }
            if (bl && bl5 && bl4) {
                printWriter.println("    return _res;");
            }
            printWriter.println("  }");
        }

        protected String getArgListAsString(Method method, boolean bl, boolean bl2) {
            StringBuilder stringBuilder = new StringBuilder(256);
            if (!bl2 && !bl) {
                throw new IllegalArgumentException("Cannot generate arglist without both arg types and arg names");
            }
            Class<?>[] classArray = method.getParameterTypes();
            for (int i = 0; i < classArray.length; ++i) {
                if (bl) {
                    stringBuilder.append(JavaType.createForClass(classArray[i]).getName());
                    stringBuilder.append(' ');
                }
                if (bl2) {
                    stringBuilder.append("arg");
                    stringBuilder.append(i);
                }
                if (i >= classArray.length - 1) continue;
                stringBuilder.append(',');
            }
            return stringBuilder.toString();
        }

        protected String getBaseInterfaceName() {
            return this.baseName;
        }

        protected abstract String getOutputName();

        protected void preMethodEmissionHook(PrintWriter printWriter) {
            printWriter.println("  public static final boolean DEBUG = jogamp.opengl.Debug.debug(\"" + this.getOutputName() + "\");");
        }

        protected abstract void constructorHook(PrintWriter var1);

        protected void postMethodEmissionHook(PrintWriter printWriter) {
            printWriter.println("  @Override");
            printWriter.println("  public String toString() {");
            printWriter.println("    StringBuilder sb = new StringBuilder();");
            printWriter.println("    sb.append(\"" + this.getOutputName() + " [this 0x\"+Integer.toHexString(hashCode())+\" implementing " + this.baseInterfaceClass.getName() + ",\\n\\t\");");
            if (null != this.prologClassOpt) {
                printWriter.println("    sb.append(\" prolog: \"+" + this.getPrologObjectNameOpt() + ".toString()+\",\\n\\t\");");
            }
            printWriter.println("    sb.append(\" downstream: \"+" + this.getDownstreamObjectName() + ".toString()+\"\\n\\t]\");");
            printWriter.println("    return sb.toString();");
            printWriter.println("  }");
        }

        protected abstract void preDownstreamCallHook(PrintWriter var1, PlainMethod var2);

        protected abstract boolean hasPreDownstreamCallHook(PlainMethod var1);

        protected abstract void postDownstreamCallHook(PrintWriter var1, PlainMethod var2);

        protected abstract boolean hasPostDownstreamCallHook(PlainMethod var1);

        protected abstract int getMode();

        protected abstract boolean emptyMethodAllowed();

        protected abstract boolean emptyDownstreamAllowed();

        protected abstract void emitClassDocComment(PrintWriter var1);

        protected void emitGLIsMethodBody(PrintWriter printWriter, PlainMethod plainMethod) {
            String string = plainMethod.getWrappedMethod().getName();
            String string2 = string.substring(2);
            if (string2.equals("GL")) {
                printWriter.println("    return true;");
            } else if (!(0 == (0x10 & this.getMode()) || string2.equals("GLES") || string2.endsWith("core") || string2.endsWith("Compatible"))) {
                Class<?> clazz = BuildComposablePipeline.getClass("com.jogamp.opengl." + string2);
                if (clazz.isAssignableFrom(this.baseInterfaceClass)) {
                    printWriter.println("    return true;");
                } else {
                    printWriter.println("    return false;");
                }
            } else {
                printWriter.println("    return " + this.getDownstreamObjectName() + ".is" + string2 + "();");
            }
        }

        protected void emitGLGetMethodBody(PrintWriter printWriter, PlainMethod plainMethod) {
            String string = plainMethod.getWrappedMethod().getName();
            String string2 = string.substring(3);
            if (string2.equals("GL")) {
                printWriter.println("    return this;");
            } else if (string2.equals("GLProfile")) {
                printWriter.println("    return " + this.getDownstreamObjectName() + ".getGLProfile();");
            } else {
                Class<?> clazz = BuildComposablePipeline.getClass("com.jogamp.opengl." + string2);
                if (clazz.isAssignableFrom(this.baseInterfaceClass)) {
                    printWriter.println("    if( is" + string2 + "() ) { return this; }");
                    printWriter.println("    throw new GLException(\"Not a " + string2 + " implementation\");");
                } else {
                    printWriter.println("    throw new GLException(\"Not a " + string2 + " implementation\");");
                }
            }
        }

        protected void emitSyntheticGLMethods(PrintWriter printWriter) {
            printWriter.println("  @Override");
            printWriter.println("  public final GL getDownstreamGL() throws GLException {");
            printWriter.println("    return " + this.getDownstreamObjectName() + ";");
            printWriter.println("  }");
        }
    }
}

