/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen.opengl;

import com.jogamp.gluegen.ConstantDefinition;
import com.jogamp.gluegen.FunctionEmitter;
import com.jogamp.gluegen.GlueEmitterControls;
import com.jogamp.gluegen.GlueGen;
import com.jogamp.gluegen.JavaCodeUnit;
import com.jogamp.gluegen.JavaConfiguration;
import com.jogamp.gluegen.JavaEmitter;
import com.jogamp.gluegen.JavaMethodBindingEmitter;
import com.jogamp.gluegen.JavaType;
import com.jogamp.gluegen.MethodBinding;
import com.jogamp.gluegen.SymbolFilter;
import com.jogamp.gluegen.cgram.types.AliasedSymbol;
import com.jogamp.gluegen.cgram.types.FunctionSymbol;
import com.jogamp.gluegen.cgram.types.Type;
import com.jogamp.gluegen.opengl.BuildStaticGLInfo;
import com.jogamp.gluegen.opengl.GLConfiguration;
import com.jogamp.gluegen.opengl.GLJavaMethodBindingEmitter;
import com.jogamp.gluegen.procaddress.ProcAddressEmitter;
import com.jogamp.gluegen.procaddress.ProcAddressJavaMethodBindingEmitter;
import com.jogamp.gluegen.runtime.opengl.GLNameResolver;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class GLEmitter
extends ProcAddressEmitter {
    private final Map<MethodBinding, MethodBinding> bufferObjectMethodBindings = new IdentityHashMap<MethodBinding, MethodBinding>();

    public void beginEmission(GlueEmitterControls glueEmitterControls) throws IOException {
        this.getGLConfig().parseGLSemHeaders(glueEmitterControls);
        if (null == this.getGLConfig().getGLSemInfo()) {
            throw new RuntimeException("No 'GLSemHeader' defined.");
        }
        this.getGLConfig().parseGLDocHeaders(glueEmitterControls);
        if (null == this.getGLConfig().getGLDocInfo()) {
            throw new InternalError("XXX");
        }
        this.renameExtensionsIntoCore();
        if (this.getGLConfig().getAutoUnifyExtensions()) {
            this.unifyExtensions(glueEmitterControls);
        }
        super.beginEmission(glueEmitterControls);
    }

    protected void renameExtensionsIntoCore() {
        GLConfiguration gLConfiguration = this.getGLConfig();
        this.renameExtensionsIntoCore(gLConfiguration, gLConfiguration.getGLSemInfo(), true);
        this.renameExtensionsIntoCore(gLConfiguration, gLConfiguration.getGLDocInfo(), false);
    }

    protected void renameExtensionsIntoCore(GLConfiguration gLConfiguration, BuildStaticGLInfo buildStaticGLInfo, boolean bl) {
        String string = bl ? "GLSemHeader" : "GLDocHeader";
        Set<String> set = bl ? gLConfiguration.getExtensionsRenamedIntoCore() : buildStaticGLInfo.getExtensions();
        for (String string2 : set) {
            if (bl && gLConfiguration.isIgnoredExtension(string2)) {
                this.LOG.log(Level.INFO, "<RenameExtensionIntoCore: {0} IGNORED {1}>", new Object[]{string2, string});
                continue;
            }
            this.LOG.log(Level.INFO, "<RenameExtensionIntoCore: {0} BEGIN {1}", new Object[]{string2, string});
            Set<String> set2 = buildStaticGLInfo.getDeclarations(string2);
            if (set2 != null) {
                for (String string3 : set2) {
                    String string4;
                    boolean bl2 = GLNameResolver.isGLFunction(string3);
                    boolean bl3 = false;
                    if (!bl2) {
                        bl3 = GLNameResolver.isGLEnumeration(string3);
                    }
                    if (!bl2 && !bl3 || (string4 = GLNameResolver.normalize(string3, bl2)).equals(string3)) continue;
                    if (bl) {
                        gLConfiguration.addJavaSymbolRename(string3, string4);
                        continue;
                    }
                    gLConfiguration.addJavaDocSymbolRename(string3, string4);
                }
            }
            this.LOG.log(Level.INFO, "RenameExtensionIntoCore: {0} END>", new Object[]{string2, string});
        }
    }

    private void unifyExtensions(GlueEmitterControls glueEmitterControls) {
        glueEmitterControls.runSymbolFilter((SymbolFilter)new ExtensionUnifier());
    }

    protected JavaConfiguration createConfig() {
        return new GLConfiguration(this);
    }

    protected void mangleBinding(MethodBinding methodBinding) {
        methodBinding.setNativeName(methodBinding.getInterfaceName());
        super.mangleBinding(methodBinding);
    }

    protected List<MethodBinding> expandMethodBinding(MethodBinding methodBinding) {
        GLConfiguration gLConfiguration = this.getGLConfig();
        List list = super.expandMethodBinding(methodBinding);
        if (!gLConfiguration.isBufferObjectFunction((AliasedSymbol)methodBinding.getCSymbol())) {
            return list;
        }
        boolean bl = gLConfiguration.isBufferObjectOnly(methodBinding.getName());
        ArrayList<MethodBinding> arrayList = new ArrayList<MethodBinding>();
        if (GlueGen.debug()) {
            System.err.println("expandMethodBinding: j " + methodBinding.toString());
            System.err.println("expandMethodBinding: c " + methodBinding.getCSymbol());
        }
        int n = 0;
        while (n < list.size()) {
            MethodBinding methodBinding2 = (MethodBinding)list.get(n);
            if (methodBinding2.signatureUsesJavaPrimitiveArrays()) {
                ++n;
                continue;
            }
            MethodBinding methodBinding3 = methodBinding2;
            int n2 = 0;
            for (int i = 0; i < methodBinding2.getNumArguments(); ++i) {
                JavaType javaType = methodBinding2.getJavaArgumentType(i);
                if (javaType.isOpaqued()) {
                    ++n2;
                } else if (javaType.isNIOBuffer()) {
                    methodBinding3 = methodBinding3.replaceJavaArgumentType(i, JavaType.createForClass(Long.TYPE));
                    ++n2;
                }
                if (!GlueGen.debug()) continue;
                Type type = methodBinding2.getCArgumentType(i);
                System.err.println("  [" + i + "]: #" + n2 + ", " + type.getDebugString() + ", " + javaType.getDebugString());
            }
            if (0 == n2) {
                throw new RuntimeException("Error: didn't find any void* arguments for BufferObject function " + methodBinding.toString());
            }
            this.bufferObjectMethodBindings.put(methodBinding3, methodBinding3);
            if (methodBinding3 != methodBinding2) {
                arrayList.add(methodBinding3);
                if (bl) {
                    list.remove(n);
                    continue;
                }
                ++n;
                continue;
            }
            ++n;
        }
        list.addAll(arrayList);
        return list;
    }

    protected boolean needsModifiedEmitters(FunctionSymbol functionSymbol) {
        return (this.callThroughProcAddress(functionSymbol) || this.needsBufferObjectVariant(functionSymbol)) && !this.getConfig().isUnimplemented((AliasedSymbol)functionSymbol);
    }

    public boolean isBufferObjectMethodBinding(MethodBinding methodBinding) {
        return this.bufferObjectMethodBindings.containsKey(methodBinding);
    }

    public void emitDefine(ConstantDefinition constantDefinition, String string) throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = constantDefinition.getName();
        if (0 == this.addExtensionsOfSymbols2Doc(stringBuilder, ", ", ", ", string2)) {
            if (constantDefinition.isEnum()) {
                String string3 = constantDefinition.getEnumName();
                if (null == string3) {
                    stringBuilder.append("Part of CORE ");
                    stringBuilder.append("ENUM");
                }
            } else if (this.getGLConfig().getAllowNonGLExtensions()) {
                stringBuilder.append("Part of CORE ");
                stringBuilder.append("DEF");
            } else {
                StringBuilder stringBuilder2 = new StringBuilder();
                JavaEmitter.addStrings2Buffer((StringBuilder)stringBuilder2, (String)", ", (String)string2, (Collection)constantDefinition.getAliasedNames());
                this.LOG.log(Level.INFO, constantDefinition.getASTLocusTag(), "Dropping marker: {0}", (Object)stringBuilder2.toString());
                return;
            }
        }
        if (null != string) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("<br>");
            }
            stringBuilder.append(string);
        }
        super.emitDefine(constantDefinition, stringBuilder.toString());
    }

    private int addExtensionListOfSymbol2Doc(BuildStaticGLInfo buildStaticGLInfo, StringBuilder stringBuilder, String string, String string2) {
        int n = 0;
        Set<String> set = buildStaticGLInfo.getExtension(string2);
        if (null != set) {
            Iterator<String> iterator = set.iterator();
            while (iterator.hasNext()) {
                String string3 = iterator.next();
                if (null == string3) continue;
                stringBuilder.append("<code>");
                stringBuilder.append(string3);
                stringBuilder.append("</code>");
                if (iterator.hasNext()) {
                    stringBuilder.append(string);
                }
                ++n;
            }
        }
        return n;
    }

    private int addExtensionListOfAliasedSymbols2Doc(BuildStaticGLInfo buildStaticGLInfo, StringBuilder stringBuilder, String string, String string2, String string3) {
        int n = 0;
        if (null != string3) {
            boolean bl = (n += this.addExtensionListOfSymbol2Doc(buildStaticGLInfo, stringBuilder, string, string3)) > 0;
            Set<String> set = ((GLConfiguration)this.cfg).getRenamedJavaDocSymbols(string3);
            if (null != set) {
                for (String string4 : set) {
                    int n2;
                    if (bl) {
                        stringBuilder.append(string2);
                    }
                    bl = (n2 = this.addExtensionListOfSymbol2Doc(buildStaticGLInfo, stringBuilder, string, string4)) > 0;
                    n += n2;
                }
            }
        }
        return n;
    }

    public int addExtensionsOfSymbols2Doc(StringBuilder stringBuilder, String string, String string2, String string3) {
        BuildStaticGLInfo buildStaticGLInfo = this.getGLConfig().getGLDocInfo();
        if (null == buildStaticGLInfo) {
            throw new RuntimeException("No GLDocInfo for: " + string3);
        }
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        return this.addExtensionListOfAliasedSymbols2Doc(buildStaticGLInfo, stringBuilder, string, string2, string3);
    }

    protected void generateModifiedEmitters(JavaMethodBindingEmitter javaMethodBindingEmitter, List<FunctionEmitter> list) {
        ArrayList arrayList = new ArrayList();
        super.generateModifiedEmitters(javaMethodBindingEmitter, arrayList);
        boolean bl = this.bufferObjectMethodBindings.containsKey(javaMethodBindingEmitter.getBinding());
        for (Object object : arrayList) {
            if (object instanceof ProcAddressJavaMethodBindingEmitter) {
                object = new GLJavaMethodBindingEmitter((ProcAddressJavaMethodBindingEmitter)object, this, bl);
            }
            list.add((FunctionEmitter)object);
        }
    }

    protected boolean needsBufferObjectVariant(FunctionSymbol functionSymbol) {
        return this.getGLConfig().isBufferObjectFunction((AliasedSymbol)functionSymbol);
    }

    protected GLConfiguration getGLConfig() {
        return (GLConfiguration)this.getConfig();
    }

    protected void endProcAddressTable() throws Exception {
        JavaCodeUnit javaCodeUnit = this.tableJavaUnit;
        javaCodeUnit.emitln("  @Override");
        javaCodeUnit.emitln("  protected boolean isFunctionAvailableImpl(String functionNameUsr) throws IllegalArgumentException  {");
        javaCodeUnit.emitln("    final String functionNameBase = " + GLNameResolver.class.getName() + ".normalizeVEN(com.jogamp.gluegen.runtime.opengl.GLNameResolver.normalizeARB(functionNameUsr, true), true);");
        javaCodeUnit.emitln("    final String addressFieldNameBase = \"_addressof_\" + functionNameBase;");
        javaCodeUnit.emitln("    final int funcNamePermNum = " + GLNameResolver.class.getName() + ".getFuncNamePermutationNumber(functionNameBase);");
        javaCodeUnit.emitln("    final java.lang.reflect.Field addressField = com.jogamp.common.util.SecurityUtil.doPrivileged(new java.security.PrivilegedAction<java.lang.reflect.Field>() {");
        javaCodeUnit.emitln("        public final java.lang.reflect.Field run() {");
        javaCodeUnit.emitln("            java.lang.reflect.Field addressField = null;");
        javaCodeUnit.emitln("            for(int i = 0; i < funcNamePermNum; i++) {");
        javaCodeUnit.emitln("                final String addressFieldName = " + GLNameResolver.class.getName() + ".getFuncNamePermutation(addressFieldNameBase, i);");
        javaCodeUnit.emitln("                try {");
        javaCodeUnit.emitln("                    addressField = " + this.tableClassName + ".class.getDeclaredField( addressFieldName );");
        javaCodeUnit.emitln("                    addressField.setAccessible(true); // we need to read the protected value!");
        javaCodeUnit.emitln("                    return addressField;");
        javaCodeUnit.emitln("                } catch (NoSuchFieldException ex) { }");
        javaCodeUnit.emitln("            }");
        javaCodeUnit.emitln("            return null;");
        javaCodeUnit.emitln("        } } );");
        javaCodeUnit.emitln();
        javaCodeUnit.emitln("    if(null==addressField) {");
        javaCodeUnit.emitln("      // The user is calling a bogus function or one which is not");
        javaCodeUnit.emitln("      // runtime linked");
        javaCodeUnit.emitln("      throw new RuntimeException(");
        javaCodeUnit.emitln("          \"WARNING: Address field query failed for \\\"\" + functionNameBase + \"\\\"/\\\"\" + functionNameUsr +");
        javaCodeUnit.emitln("          \"\\\"; it's either statically linked or address field is not a known \" +");
        javaCodeUnit.emitln("          \"function\");");
        javaCodeUnit.emitln("    } ");
        javaCodeUnit.emitln("    try {");
        javaCodeUnit.emitln("      return 0 != addressField.getLong(this);");
        javaCodeUnit.emitln("    } catch (Exception e) {");
        javaCodeUnit.emitln("      throw new RuntimeException(");
        javaCodeUnit.emitln("          \"WARNING: Address query failed for \\\"\" + functionNameBase + \"\\\"/\\\"\" + functionNameUsr +");
        javaCodeUnit.emitln("          \"\\\"; it's either statically linked or is not a known \" +");
        javaCodeUnit.emitln("          \"function\", e);");
        javaCodeUnit.emitln("    }");
        javaCodeUnit.emitln("  }");
        javaCodeUnit.emitln("  @Override");
        javaCodeUnit.emitln("  public long getAddressFor(String functionNameUsr) throws SecurityException, IllegalArgumentException {");
        javaCodeUnit.emitln("    SecurityUtil.checkAllLinkPermission();");
        javaCodeUnit.emitln("    final String functionNameBase = " + GLNameResolver.class.getName() + ".normalizeVEN(com.jogamp.gluegen.runtime.opengl.GLNameResolver.normalizeARB(functionNameUsr, true), true);");
        javaCodeUnit.emitln("    final String addressFieldNameBase = \"_addressof_\" + functionNameBase;");
        javaCodeUnit.emitln("    final int  funcNamePermNum = " + GLNameResolver.class.getName() + ".getFuncNamePermutationNumber(functionNameBase);");
        javaCodeUnit.emitln("    final java.lang.reflect.Field addressField = com.jogamp.common.util.SecurityUtil.doPrivileged(new java.security.PrivilegedAction<java.lang.reflect.Field>() {");
        javaCodeUnit.emitln("        public final java.lang.reflect.Field run() {");
        javaCodeUnit.emitln("            java.lang.reflect.Field addressField = null;");
        javaCodeUnit.emitln("            for(int i = 0; i < funcNamePermNum; i++) {");
        javaCodeUnit.emitln("                final String addressFieldName = " + GLNameResolver.class.getName() + ".getFuncNamePermutation(addressFieldNameBase, i);");
        javaCodeUnit.emitln("                try {");
        javaCodeUnit.emitln("                    addressField = " + this.tableClassName + ".class.getDeclaredField( addressFieldName );");
        javaCodeUnit.emitln("                    addressField.setAccessible(true); // we need to read the protected value!");
        javaCodeUnit.emitln("                    return addressField;");
        javaCodeUnit.emitln("                } catch (NoSuchFieldException ex) { }");
        javaCodeUnit.emitln("            }");
        javaCodeUnit.emitln("            return null;");
        javaCodeUnit.emitln("        } } );");
        javaCodeUnit.emitln();
        javaCodeUnit.emitln("    if(null==addressField) {");
        javaCodeUnit.emitln("      // The user is calling a bogus function or one which is not");
        javaCodeUnit.emitln("      // runtime linked");
        javaCodeUnit.emitln("      throw new RuntimeException(");
        javaCodeUnit.emitln("          \"WARNING: Address field query failed for \\\"\" + functionNameBase + \"\\\"/\\\"\" + functionNameUsr +");
        javaCodeUnit.emitln("          \"\\\"; it's either statically linked or address field is not a known \" +");
        javaCodeUnit.emitln("          \"function\");");
        javaCodeUnit.emitln("    } ");
        javaCodeUnit.emitln("    try {");
        javaCodeUnit.emitln("      return addressField.getLong(this);");
        javaCodeUnit.emitln("    } catch (Exception e) {");
        javaCodeUnit.emitln("      throw new RuntimeException(");
        javaCodeUnit.emitln("          \"WARNING: Address query failed for \\\"\" + functionNameBase + \"\\\"/\\\"\" + functionNameUsr +");
        javaCodeUnit.emitln("          \"\\\"; it's either statically linked or is not a known \" +");
        javaCodeUnit.emitln("          \"function\", e);");
        javaCodeUnit.emitln("    }");
        javaCodeUnit.emitln("  }");
        javaCodeUnit.emitln("} // end of class " + this.tableClassName);
        javaCodeUnit.close();
    }

    class ExtensionUnifier
    implements SymbolFilter {
        private List<ConstantDefinition> constants;
        private List<FunctionSymbol> functions;

        ExtensionUnifier() {
        }

        public List<ConstantDefinition> getConstants() {
            return this.constants;
        }

        public List<FunctionSymbol> getFunctions() {
            return this.functions;
        }

        public void filterSymbols(List<ConstantDefinition> list, List<FunctionSymbol> list2) {
            BuildStaticGLInfo buildStaticGLInfo = GLEmitter.this.getGLConfig().getGLSemInfo();
            if (buildStaticGLInfo == null) {
                return;
            }
            LinkedHashMap<String, ConstantDefinition> linkedHashMap = new LinkedHashMap<String, ConstantDefinition>();
            for (ConstantDefinition object22 : list) {
                linkedHashMap.put(object22.getName(), object22);
            }
            LinkedHashMap linkedHashMap2 = new LinkedHashMap();
            for (FunctionSymbol functionSymbol : list2) {
                linkedHashMap2.put(functionSymbol.getName(), functionSymbol);
            }
            Set<String> set = buildStaticGLInfo.getExtensions();
            for (String string : set) {
                boolean bl;
                Set<String> set2 = buildStaticGLInfo.getDeclarations(string);
                boolean bl2 = true;
                boolean bl3 = true;
                String string2 = null;
                for (String string3 : set2) {
                    boolean bl4 = bl = !string3.startsWith("GL_");
                    if (!GLNameResolver.isExtension(string3, bl)) {
                        bl2 = false;
                        break;
                    }
                    if (bl) {
                        if (!linkedHashMap2.containsKey(string3)) {
                            bl2 = false;
                            break;
                        }
                    } else if (!linkedHashMap.containsKey(string3)) {
                        bl2 = false;
                        break;
                    }
                    string2 = string3;
                    String string4 = GLNameResolver.normalize(string3, bl);
                    bl3 = buildStaticGLInfo.getExtension(string4) != null;
                    if (bl3) continue;
                    break;
                }
                if (!bl2) continue;
                if (bl3) {
                    for (String string3 : set2) {
                        boolean bl5 = bl = !string3.startsWith("GL_");
                        if (bl) {
                            linkedHashMap2.remove(string3);
                            continue;
                        }
                        linkedHashMap.remove(string3);
                    }
                    System.err.println("INFO: unified extension " + string + " into core API");
                    continue;
                }
                System.err.println("INFO: didn't unify extension " + string + " into core API because of " + string2);
            }
            this.constants = new ArrayList(linkedHashMap.values());
            this.functions = new ArrayList(linkedHashMap2.values());
        }
    }

    static enum BufferObjectKind {
        UNPACK_PIXEL,
        PACK_PIXEL,
        ARRAY,
        ELEMENT,
        INDIRECT;

    }
}

