/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen.opengl.nativesig;

import com.jogamp.gluegen.GlueGenException;
import com.jogamp.gluegen.JavaMethodBindingEmitter;
import com.jogamp.gluegen.JavaType;
import com.jogamp.gluegen.MethodBinding;
import com.jogamp.gluegen.cgram.types.Type;
import com.jogamp.gluegen.opengl.GLEmitter;
import com.jogamp.gluegen.opengl.GLJavaMethodBindingEmitter;
import com.jogamp.gluegen.opengl.nativesig.NativeSignatureEmitter;
import com.jogamp.gluegen.procaddress.ProcAddressJavaMethodBindingEmitter;

public class NativeSignatureJavaMethodBindingEmitter
extends GLJavaMethodBindingEmitter {
    public NativeSignatureJavaMethodBindingEmitter(GLJavaMethodBindingEmitter gLJavaMethodBindingEmitter) {
        super(gLJavaMethodBindingEmitter);
    }

    public NativeSignatureJavaMethodBindingEmitter(ProcAddressJavaMethodBindingEmitter procAddressJavaMethodBindingEmitter, GLEmitter gLEmitter, boolean bl) {
        super(procAddressJavaMethodBindingEmitter, gLEmitter, bl);
    }

    public NativeSignatureJavaMethodBindingEmitter(JavaMethodBindingEmitter javaMethodBindingEmitter, NativeSignatureEmitter nativeSignatureEmitter) {
        super(javaMethodBindingEmitter, false, null, false, false, nativeSignatureEmitter);
    }

    protected StringBuilder appendSignature(StringBuilder stringBuilder) {
        stringBuilder.append(this.getBaseIndentString());
        this.appendNativeSignatureAnnotation(stringBuilder);
        return super.appendSignature(stringBuilder);
    }

    protected void appendNativeSignatureAnnotation(StringBuilder stringBuilder) {
        if (this.hasModifier(JavaMethodBindingEmitter.NATIVE)) {
            stringBuilder.append("@NativeSignature(\"l");
            MethodBinding methodBinding = this.getBinding();
            if (this.callThroughProcAddress) {
                stringBuilder.append("p");
            }
            stringBuilder.append("(");
            if (this.callThroughProcAddress) {
                stringBuilder.append("P");
            }
            for (int i = 0; i < methodBinding.getNumArguments(); ++i) {
                this.appendNativeSignatureElement(stringBuilder, methodBinding.getJavaArgumentType(i), methodBinding.getCArgumentType(i), i);
            }
            stringBuilder.append(")");
            this.appendNativeSignatureElement(stringBuilder, methodBinding.getJavaReturnType(), methodBinding.getCReturnType(), -1);
            stringBuilder.append("\")");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void appendNativeSignatureElement(StringBuilder stringBuilder, JavaType javaType, Type type, int n) {
        if (javaType.isVoid()) {
            if (n <= 0) return;
            throw new InternalError("Error parsing arguments -- void should not be seen aside from argument 0");
        }
        if (javaType.isNIOBuffer()) {
            stringBuilder.append("A");
            return;
        } else if (javaType.isPrimitiveArray()) {
            stringBuilder.append("MO");
            return;
        } else if (javaType.isPrimitive()) {
            Class clazz = javaType.getJavaClass();
            if (clazz == Byte.TYPE) {
                stringBuilder.append("B");
                return;
            } else if (clazz == Character.TYPE) {
                stringBuilder.append("C");
                return;
            } else if (clazz == Double.TYPE) {
                stringBuilder.append("D");
                return;
            } else if (clazz == Float.TYPE) {
                stringBuilder.append("F");
                return;
            } else if (clazz == Integer.TYPE) {
                stringBuilder.append("I");
                return;
            } else if (clazz == Long.TYPE) {
                if (type.isPointer()) {
                    stringBuilder.append("A");
                    return;
                } else {
                    stringBuilder.append("J");
                }
                return;
            } else if (clazz == Short.TYPE) {
                stringBuilder.append("S");
                return;
            } else {
                if (clazz != Boolean.TYPE) throw new InternalError("Unhandled primitive type " + clazz);
                stringBuilder.append("Z");
            }
            return;
        } else {
            if (!javaType.isString()) throw new RuntimeException("Type not yet handled: " + javaType);
            stringBuilder.append("A");
        }
    }

    protected String getReturnTypeString(boolean bl) {
        JavaType javaType;
        if (this.isPrivateNativeMethod() && ((javaType = this.getBinding().getJavaReturnType()).isString() || javaType.isNIOByteBuffer())) {
            return "long";
        }
        return super.getReturnTypeString(bl);
    }

    protected void emitPreCallSetup(MethodBinding methodBinding) {
        super.emitPreCallSetup(methodBinding);
        for (int i = 0; i < methodBinding.getNumArguments(); ++i) {
            JavaType javaType = methodBinding.getJavaArgumentType(i);
            if (javaType.isNIOBuffer() && !this.useNIODirectOnly) {
                this.unit.emitln("  Object " + this.getNIOBufferArrayName(i) + " = (_direct ? null : Buffers.getArray(" + this.getArgumentName(i) + "));");
                continue;
            }
            if (!javaType.isString()) continue;
            this.unit.emitln("    long " + methodBinding.getArgumentName(i) + "_c_str = BuffersInternal.newCString(" + methodBinding.getArgumentName(i) + ");");
        }
    }

    protected String getNIOBufferArrayName(int n) {
        return "__buffer_array_" + n;
    }

    protected int appendArguments(StringBuilder stringBuilder) {
        boolean bl = false;
        int n = 0;
        if (this.callThroughProcAddress && this.changeNameAndArguments) {
            stringBuilder.append("long procAddress");
            ++n;
            bl = true;
        }
        if (this.isPrivateNativeMethod() && this.binding.hasContainingType()) {
            if (bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("long ");
            stringBuilder.append(NativeSignatureJavaMethodBindingEmitter.javaThisArgumentName());
            ++n;
            bl = true;
        }
        for (int i = 0; i < this.binding.getNumArguments(); ++i) {
            JavaType javaType = this.binding.getJavaArgumentType(i);
            if (javaType.isVoid()) {
                if (this.binding.getNumArguments() == 1) continue;
                throw new InternalError("\"void\" argument type found in multi-argument function \"" + this.binding + "\"");
            }
            if (javaType.isJNIEnv() || this.binding.isArgumentThisPointer(i)) continue;
            if (bl) {
                stringBuilder.append(", ");
            }
            if (this.isPrivateNativeMethod() && (this.isForDirectBufferImplementation() && javaType.isNIOBuffer() || javaType.isString())) {
                stringBuilder.append("long");
            } else {
                stringBuilder.append(this.erasedTypeString(javaType, false));
            }
            stringBuilder.append(" ");
            stringBuilder.append(this.getArgumentName(i));
            ++n;
            bl = true;
            if (this.isForIndirectBufferAndArrayImplementation()) {
                if (javaType.isNIOBuffer()) {
                    stringBuilder.append(", int " + this.byteOffsetArgName(i));
                } else if (javaType.isNIOBufferArray()) {
                    stringBuilder.append(", int[] " + this.byteOffsetArrayArgName(i));
                }
            }
            if (!javaType.isPrimitiveArray()) continue;
            stringBuilder.append(", int " + this.offsetArgName(i));
        }
        return n;
    }

    protected void emitReturnVariableSetupAndCall(MethodBinding methodBinding) {
        this.unit.emit("    ");
        JavaType javaType = methodBinding.getJavaReturnType();
        boolean bl = false;
        if (!javaType.isVoid()) {
            if (javaType.isCompoundTypeWrapper() || javaType.isNIOByteBuffer()) {
                this.unit.emitln("final java.nio.ByteBuffer _res;");
                bl = true;
            } else if (javaType.isArrayOfCompoundTypeWrappers()) {
                this.unit.emitln("final java.nio.ByteBuffer[] _res;");
                bl = true;
            } else if (javaType.isString() || javaType.isNIOByteBuffer()) {
                this.unit.emit("final ");
                this.unit.emit(javaType.toString());
                this.unit.emitln(" _res;");
                bl = true;
            } else {
                this.unit.emit("final ");
                this.emitReturnType();
                this.unit.emitln(" _res;");
                bl = true;
            }
        }
        if (methodBinding.signatureCanUseIndirectNIO() && !this.useNIODirectOnly) {
            this.unit.emitln("if (_direct) {");
            this.unit.emit("    ");
        }
        if (bl) {
            this.unit.emit("  _res = ");
            if (javaType.isString()) {
                this.unit.emit("BuffersInternal.newJavaString(");
            } else if (javaType.isNIOByteBuffer()) {
                this.unit.emit("BuffersInternal.newDirectByteBuffer(");
            }
        } else {
            this.unit.emit("  ");
            if (!javaType.isVoid()) {
                this.unit.emit("return ");
            }
        }
        if (methodBinding.signatureUsesJavaPrimitiveArrays() && !methodBinding.signatureCanUseIndirectNIO()) {
            this.emitCall(methodBinding);
            if (javaType.isString() || javaType.isNIOByteBuffer()) {
                this.unit.emit(")");
            }
            this.unit.emit(";");
            this.unit.emitln();
        } else {
            this.emitCall(methodBinding);
            if (javaType.isString() || javaType.isNIOByteBuffer()) {
                this.unit.emit(")");
            }
            this.unit.emit(";");
        }
        if (methodBinding.signatureCanUseIndirectNIO() && !this.useNIODirectOnly) {
            this.unit.emitln();
            this.unit.emitln("    } else {");
            this.unit.emit("    ");
            if (bl) {
                this.unit.emit("    _res = ");
            } else {
                this.unit.emit("  ");
                if (!javaType.isVoid()) {
                    this.unit.emit("return ");
                }
            }
            this.emitCall(methodBinding);
            this.unit.emit(";");
            this.unit.emitln();
            this.unit.emitln("    }");
        } else {
            this.unit.emitln();
        }
        this.emitPrologueOrEpilogue(this.epilogue);
        if (bl) {
            this.emitCallResultReturn(methodBinding);
        }
    }

    protected int emitCallArguments(MethodBinding methodBinding, boolean bl) {
        boolean bl2 = false;
        int n = 0;
        if (this.callThroughProcAddress) {
            this.unit.emit("__addr_");
            bl2 = true;
            ++n;
        }
        if (methodBinding.hasContainingType()) {
            assert (methodBinding.getContainingType().isCompoundTypeWrapper());
            this.unit.emit("BuffersInternal.getDirectBufferAddress(");
            this.unit.emit("getBuffer()");
            this.unit.emit(")");
            bl2 = true;
            ++n;
        }
        for (int i = 0; i < methodBinding.getNumArguments(); ++i) {
            JavaType javaType = methodBinding.getJavaArgumentType(i);
            if (javaType.isJNIEnv() || methodBinding.isArgumentThisPointer(i)) continue;
            if (javaType.isVoid()) {
                assert (methodBinding.getNumArguments() == 1);
                continue;
            }
            if (bl2) {
                this.unit.emit(", ");
            }
            if (javaType.isCompoundTypeWrapper()) {
                this.unit.emit("BuffersInternal.getDirectBufferAddress(");
                this.unit.emit("((");
            }
            if (javaType.isNIOBuffer()) {
                if (!bl) {
                    this.unit.emit(this.getNIOBufferArrayName(i));
                } else {
                    this.unit.emit("BuffersInternal.getDirectBufferAddress(");
                    this.unit.emit(this.getArgumentName(i));
                    this.unit.emit(")");
                }
            } else {
                this.unit.emit(this.getArgumentName(i));
            }
            if (javaType.isCompoundTypeWrapper()) {
                this.unit.emit(" == null) ? null : ");
                this.unit.emit(this.getArgumentName(i));
                this.unit.emit(".getBuffer())");
                this.unit.emit(")");
            }
            if (javaType.isNIOBuffer()) {
                if (bl) {
                    this.unit.emit("+ Buffers.getDirectBufferByteOffset(" + this.getArgumentName(i) + ")");
                } else {
                    this.unit.emit(", BuffersInternal.arrayBaseOffset(" + this.getNIOBufferArrayName(i) + ") + Buffers.getIndirectBufferByteOffset(" + this.getArgumentName(i) + ")");
                }
            } else if (javaType.isNIOBufferArray()) {
                this.unit.emit(", " + this.byteOffsetArrayArgName(i));
            }
            if (javaType.isPrimitiveArray()) {
                this.unit.emit(", ");
                this.unit.emit("BuffersInternal.arrayBaseOffset(" + this.getArgumentName(i) + ") + ");
                if (javaType.isFloatArray()) {
                    this.unit.emit("Buffers.SIZEOF_FLOAT * ");
                } else if (javaType.isDoubleArray()) {
                    this.unit.emit("Buffers.SIZEOF_DOUBLE * ");
                } else if (javaType.isByteArray()) {
                    this.unit.emit("1 * ");
                } else if (javaType.isLongArray()) {
                    this.unit.emit("Buffers.SIZEOF_LONG * ");
                } else if (javaType.isShortArray()) {
                    this.unit.emit("Buffers.SIZEOF_SHORT * ");
                } else if (javaType.isIntArray()) {
                    this.unit.emit("Buffers.SIZEOF_INT * ");
                } else {
                    throw new GlueGenException("Unsupported type for calculating array offset argument for " + this.getArgumentName(i) + "-- error occurred while processing Java glue code for " + methodBinding.getCSymbol().getAliasedString(), methodBinding.getCSymbol().getASTLocusTag());
                }
                this.unit.emit(this.offsetArgName(i));
            }
            if (javaType.isString()) {
                this.unit.emit("_c_str");
            }
            if (javaType.isCompoundTypeWrapper()) {
                this.unit.emit(")");
            }
            bl2 = true;
            ++n;
        }
        return n;
    }

    protected void emitCallResultReturn(MethodBinding methodBinding) {
        for (int i = 0; i < methodBinding.getNumArguments(); ++i) {
            JavaType javaType = methodBinding.getJavaArgumentType(i);
            if (!javaType.isString()) continue;
            this.unit.emitln(";");
            this.unit.emitln("    BuffersInternal.freeCString(" + methodBinding.getArgumentName(i) + "_c_str);");
        }
        super.emitCallResultReturn(methodBinding);
    }

    public String getNativeName() {
        String string = super.getNativeName();
        if (this.isPrivateNativeMethod() && this.bufferObjectVariant) {
            return string + "BufObj";
        }
        return string;
    }

    protected String getImplMethodName(boolean bl) {
        String string = null;
        string = bl ? this.binding.getName() + "$0" : this.binding.getName() + "$1";
        if (this.bufferObjectVariant) {
            return string + "BufObj";
        }
        return string;
    }
}

