/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.x11.glx;

import com.jogamp.common.ExceptionUtils;
import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.PointerBuffer;
import com.jogamp.nativewindow.AbstractGraphicsConfiguration;
import com.jogamp.nativewindow.AbstractGraphicsDevice;
import com.jogamp.nativewindow.AbstractGraphicsScreen;
import com.jogamp.nativewindow.CapabilitiesChooser;
import com.jogamp.nativewindow.CapabilitiesFilter;
import com.jogamp.nativewindow.CapabilitiesImmutable;
import com.jogamp.nativewindow.GraphicsConfigurationFactory;
import com.jogamp.nativewindow.VisualIDHolder;
import com.jogamp.nativewindow.x11.X11GraphicsDevice;
import com.jogamp.nativewindow.x11.X11GraphicsScreen;
import com.jogamp.opengl.DefaultGLCapabilitiesChooser;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesChooser;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLDrawableFactory;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.GLRendererQuirks;
import java.io.PrintStream;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jogamp.nativewindow.x11.X11Lib;
import jogamp.nativewindow.x11.XVisualInfo;
import jogamp.opengl.GLGraphicsConfigurationFactory;
import jogamp.opengl.GLGraphicsConfigurationUtil;
import jogamp.opengl.x11.glx.GLX;
import jogamp.opengl.x11.glx.GLXUtil;
import jogamp.opengl.x11.glx.X11GLCapabilities;
import jogamp.opengl.x11.glx.X11GLXDrawableFactory;
import jogamp.opengl.x11.glx.X11GLXGraphicsConfiguration;

public class X11GLXGraphicsConfigurationFactory
extends GLGraphicsConfigurationFactory {
    static VisualIDHolder.VIDComparator XVisualIDComparator = new VisualIDHolder.VIDComparator(VisualIDHolder.VIDType.X11_XVISUAL);
    static GraphicsConfigurationFactory fallbackX11GraphicsConfigurationFactory = null;

    static void registerFactory() {
        X11GLXGraphicsConfigurationFactory x11GLXGraphicsConfigurationFactory = new X11GLXGraphicsConfigurationFactory();
        GraphicsConfigurationFactory graphicsConfigurationFactory = GraphicsConfigurationFactory.registerFactory(X11GraphicsDevice.class, GLCapabilitiesImmutable.class, (GraphicsConfigurationFactory)x11GLXGraphicsConfigurationFactory);
        if (graphicsConfigurationFactory == x11GLXGraphicsConfigurationFactory) {
            throw new InternalError("GraphicsConfigurationFactory lifecycle impl. error");
        }
        if (null != graphicsConfigurationFactory) {
            fallbackX11GraphicsConfigurationFactory = graphicsConfigurationFactory;
        } else {
            fallbackX11GraphicsConfigurationFactory = GraphicsConfigurationFactory.getFactory(X11GraphicsDevice.class, CapabilitiesImmutable.class);
            if (null == fallbackX11GraphicsConfigurationFactory) {
                throw new InternalError("Missing fallback GraphicsConfigurationFactory");
            }
        }
    }

    private X11GLXGraphicsConfigurationFactory() {
    }

    protected AbstractGraphicsConfiguration chooseGraphicsConfigurationImpl(CapabilitiesImmutable capabilitiesImmutable, CapabilitiesImmutable capabilitiesImmutable2, CapabilitiesChooser capabilitiesChooser, AbstractGraphicsScreen abstractGraphicsScreen, int n) {
        if (!(abstractGraphicsScreen instanceof X11GraphicsScreen)) {
            throw new IllegalArgumentException("Only X11GraphicsScreen are allowed here");
        }
        if (!(capabilitiesImmutable instanceof GLCapabilitiesImmutable)) {
            throw new IllegalArgumentException("This NativeWindowFactory accepts only GLCapabilities objects - chosen");
        }
        if (!(capabilitiesImmutable2 instanceof GLCapabilitiesImmutable)) {
            throw new IllegalArgumentException("This NativeWindowFactory accepts only GLCapabilities objects - requested");
        }
        if (capabilitiesChooser != null && !(capabilitiesChooser instanceof GLCapabilitiesChooser)) {
            throw new IllegalArgumentException("This NativeWindowFactory accepts only GLCapabilitiesChooser objects");
        }
        if (!GLXUtil.isGLXAvailableOnServer((X11GraphicsDevice)abstractGraphicsScreen.getDevice())) {
            if (null != fallbackX11GraphicsConfigurationFactory) {
                if (DEBUG) {
                    System.err.println("No GLX available, fallback to " + fallbackX11GraphicsConfigurationFactory.getClass().getSimpleName() + " for: " + abstractGraphicsScreen);
                }
                return fallbackX11GraphicsConfigurationFactory.chooseGraphicsConfiguration(capabilitiesImmutable, capabilitiesImmutable2, capabilitiesChooser, abstractGraphicsScreen, 0);
            }
            throw new InternalError("No GLX and no fallback GraphicsConfigurationFactory available for: " + abstractGraphicsScreen);
        }
        return X11GLXGraphicsConfigurationFactory.chooseGraphicsConfigurationStatic((GLCapabilitiesImmutable)capabilitiesImmutable, (GLCapabilitiesImmutable)capabilitiesImmutable2, (GLCapabilitiesChooser)capabilitiesChooser, (X11GraphicsScreen)abstractGraphicsScreen, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static List<GLCapabilitiesImmutable> getAvailableCapabilities(X11GLXDrawableFactory x11GLXDrawableFactory, AbstractGraphicsDevice abstractGraphicsDevice) {
        X11GLXDrawableFactory.SharedResource sharedResource = x11GLXDrawableFactory.getOrCreateSharedResourceImpl(abstractGraphicsDevice);
        if (null == sharedResource) {
            throw new GLException("Shared resource for device n/a: " + abstractGraphicsDevice);
        }
        X11GraphicsScreen x11GraphicsScreen = (X11GraphicsScreen)sharedResource.getScreen();
        X11GraphicsDevice x11GraphicsDevice = (X11GraphicsDevice)x11GraphicsScreen.getDevice();
        boolean bl = sharedResource.isGLXMultisampleAvailable();
        GLProfile gLProfile = GLProfile.getDefault((AbstractGraphicsDevice)abstractGraphicsDevice);
        List<GLCapabilitiesImmutable> list = null;
        x11GraphicsDevice.lock();
        try {
            if (sharedResource.isGLXVersionGreaterEqualOneThree()) {
                list = X11GLXGraphicsConfigurationFactory.getAvailableGLCapabilitiesFBConfig(x11GraphicsScreen, gLProfile, bl);
            }
            if (null == list || list.isEmpty()) {
                list = X11GLXGraphicsConfigurationFactory.getAvailableGLCapabilitiesXVisual(x11GraphicsScreen, gLProfile, bl);
            }
        }
        finally {
            x11GraphicsDevice.unlock();
        }
        if (null != list && list.size() > 1) {
            Collections.sort(list, XVisualIDComparator);
        }
        return list;
    }

    static List<GLCapabilitiesImmutable> getAvailableGLCapabilitiesFBConfig(X11GraphicsScreen x11GraphicsScreen, GLProfile gLProfile, boolean bl) {
        PointerBuffer pointerBuffer = null;
        X11GraphicsDevice x11GraphicsDevice = (X11GraphicsDevice)x11GraphicsScreen.getDevice();
        long l = x11GraphicsDevice.getHandle();
        int n = x11GraphicsScreen.getIndex();
        IntBuffer intBuffer = Buffers.newDirectIntBuffer((int)1);
        intBuffer.put(0, -1);
        ArrayList<GLCapabilitiesImmutable> arrayList = new ArrayList<GLCapabilitiesImmutable>();
        pointerBuffer = GLX.glXChooseFBConfig(l, n, null, intBuffer);
        if (pointerBuffer == null || pointerBuffer.limit() <= 0) {
            if (DEBUG) {
                System.err.println("X11GLXGraphicsConfiguration.getAvailableGLCapabilitiesFBConfig: Failed glXChooseFBConfig (" + x11GraphicsScreen + "): " + pointerBuffer + ", " + intBuffer.get(0));
            }
            return null;
        }
        for (int i = 0; i < pointerBuffer.limit(); ++i) {
            X11GLCapabilities x11GLCapabilities = X11GLXGraphicsConfiguration.GLXFBConfig2GLCapabilities(x11GraphicsDevice, gLProfile, pointerBuffer.get(i), 15, bl);
            if (null != x11GLCapabilities) {
                arrayList.add((GLCapabilitiesImmutable)x11GLCapabilities);
                continue;
            }
            if (!DEBUG) continue;
            System.err.println("X11GLXGraphicsConfiguration.getAvailableGLCapabilitiesFBConfig: FBConfig invalid (2): (" + x11GraphicsScreen + "): fbcfg: " + X11GLXGraphicsConfigurationFactory.toHexString((long)pointerBuffer.get(i)));
        }
        return arrayList;
    }

    static List<GLCapabilitiesImmutable> getAvailableGLCapabilitiesXVisual(X11GraphicsScreen x11GraphicsScreen, GLProfile gLProfile, boolean bl) {
        X11GraphicsDevice x11GraphicsDevice = (X11GraphicsDevice)x11GraphicsScreen.getDevice();
        long l = x11GraphicsDevice.getHandle();
        int n = x11GraphicsScreen.getIndex();
        int[] nArray = new int[1];
        XVisualInfo xVisualInfo = XVisualInfo.create();
        xVisualInfo.setScreen(n);
        XVisualInfo[] xVisualInfoArray = X11Lib.XGetVisualInfo((long)l, (long)2L, (XVisualInfo)xVisualInfo, (int[])nArray, (int)0);
        if (xVisualInfoArray == null || xVisualInfoArray.length < 1) {
            throw new GLException("Error while enumerating available XVisualInfos");
        }
        ArrayList<GLCapabilitiesImmutable> arrayList = new ArrayList<GLCapabilitiesImmutable>();
        for (int i = 0; i < xVisualInfoArray.length; ++i) {
            X11GLCapabilities x11GLCapabilities = X11GLXGraphicsConfiguration.XVisualInfo2GLCapabilities(x11GraphicsDevice, gLProfile, xVisualInfoArray[i], 15, bl);
            if (null != x11GLCapabilities) {
                arrayList.add((GLCapabilitiesImmutable)x11GLCapabilities);
            }
            if (!DEBUG) continue;
            System.err.println("X11GLXGraphicsConfiguration.getAvailableGLCapabilitiesXVisual: XVisual invalid: (" + x11GraphicsScreen + "): fbcfg: " + X11GLXGraphicsConfigurationFactory.toHexString((long)xVisualInfoArray[i].getVisualid()));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static X11GLXGraphicsConfiguration chooseGraphicsConfigurationStatic(GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesImmutable gLCapabilitiesImmutable2, GLCapabilitiesChooser gLCapabilitiesChooser, X11GraphicsScreen x11GraphicsScreen, int n) {
        if (x11GraphicsScreen == null) {
            throw new IllegalArgumentException("AbstractGraphicsScreen is null");
        }
        if (gLCapabilitiesImmutable == null) {
            gLCapabilitiesImmutable = new GLCapabilities(null);
        }
        X11GraphicsDevice x11GraphicsDevice = (X11GraphicsDevice)x11GraphicsScreen.getDevice();
        X11GLXDrawableFactory x11GLXDrawableFactory = (X11GLXDrawableFactory)GLDrawableFactory.getDesktopFactory();
        boolean bl = !(gLCapabilitiesImmutable = GLGraphicsConfigurationUtil.fixGLCapabilities((GLCapabilitiesImmutable)gLCapabilitiesImmutable, (GLDrawableFactory)x11GLXDrawableFactory, (AbstractGraphicsDevice)x11GraphicsDevice)).isOnscreen() && gLCapabilitiesImmutable.isPBuffer();
        X11GLXGraphicsConfiguration x11GLXGraphicsConfiguration = null;
        x11GraphicsDevice.lock();
        try {
            if (x11GLXDrawableFactory.isGLXVersionGreaterEqualOneThree((AbstractGraphicsDevice)x11GraphicsDevice)) {
                x11GLXGraphicsConfiguration = X11GLXGraphicsConfigurationFactory.chooseGraphicsConfigurationFBConfig(gLCapabilitiesImmutable, gLCapabilitiesImmutable2, gLCapabilitiesChooser, x11GraphicsScreen, n);
            }
            if (null == x11GLXGraphicsConfiguration) {
                if (bl) {
                    throw new GLException("Error: Couldn't create X11GLXGraphicsConfiguration based on FBConfig for visualID " + X11GLXGraphicsConfigurationFactory.toHexString((int)n) + ", " + gLCapabilitiesImmutable);
                }
                x11GLXGraphicsConfiguration = X11GLXGraphicsConfigurationFactory.chooseGraphicsConfigurationXVisual(gLCapabilitiesImmutable, gLCapabilitiesImmutable2, gLCapabilitiesChooser, x11GraphicsScreen, n);
            }
        }
        finally {
            x11GraphicsDevice.unlock();
        }
        if (null == x11GLXGraphicsConfiguration) {
            throw new GLException("Error: Couldn't create X11GLXGraphicsConfiguration based on FBConfig and XVisual for visualID " + X11GLXGraphicsConfigurationFactory.toHexString((int)n) + ", " + x11GraphicsScreen + ", " + gLCapabilitiesImmutable);
        }
        if (DEBUG) {
            System.err.println("X11GLXGraphicsConfiguration.chooseGraphicsConfigurationStatic(visualID " + X11GLXGraphicsConfigurationFactory.toHexString((int)n) + ", " + x11GraphicsScreen + "," + gLCapabilitiesImmutable + "): " + x11GLXGraphicsConfiguration);
        }
        return x11GLXGraphicsConfiguration;
    }

    static X11GLXGraphicsConfiguration fetchGraphicsConfigurationFBConfig(X11GraphicsScreen x11GraphicsScreen, int n, GLProfile gLProfile) {
        int n2;
        X11GraphicsDevice x11GraphicsDevice = (X11GraphicsDevice)x11GraphicsScreen.getDevice();
        long l = x11GraphicsDevice.getHandle();
        long l2 = X11GLXGraphicsConfiguration.glXFBConfigID2FBConfig(l, n2 = x11GraphicsScreen.getIndex(), n);
        if (0L == l2 || !X11GLXGraphicsConfiguration.GLXFBConfigValid(l, l2)) {
            if (DEBUG) {
                System.err.println("X11GLXGraphicsConfiguration.chooseGraphicsConfigurationFBConfig: Failed.0 - GLX FBConfig invalid: (" + x11GraphicsScreen + "," + X11GLXGraphicsConfigurationFactory.toHexString((int)n) + "): fbcfg: " + X11GLXGraphicsConfigurationFactory.toHexString((long)l2));
            }
            return null;
        }
        X11GLXDrawableFactory x11GLXDrawableFactory = (X11GLXDrawableFactory)GLDrawableFactory.getDesktopFactory();
        X11GLCapabilities x11GLCapabilities = X11GLXGraphicsConfiguration.GLXFBConfig2GLCapabilities(x11GraphicsDevice, gLProfile, l2, 15, x11GLXDrawableFactory.isGLXMultisampleAvailable((AbstractGraphicsDevice)x11GraphicsDevice));
        if (null == x11GLCapabilities) {
            if (DEBUG) {
                System.err.println("X11GLXGraphicsConfiguration.chooseGraphicsConfigurationFBConfig: Failed.1 - GLX FBConfig invalid: (" + x11GraphicsScreen + "," + X11GLXGraphicsConfigurationFactory.toHexString((int)n) + "): fbcfg: " + X11GLXGraphicsConfigurationFactory.toHexString((long)l2));
            }
            return null;
        }
        return new X11GLXGraphicsConfiguration(x11GraphicsScreen, x11GLCapabilities, (GLCapabilitiesImmutable)x11GLCapabilities, (GLCapabilitiesChooser)new DefaultGLCapabilitiesChooser());
    }

    private static X11GLXGraphicsConfiguration chooseGraphicsConfigurationFBConfig(GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesImmutable gLCapabilitiesImmutable2, GLCapabilitiesChooser gLCapabilitiesChooser, X11GraphicsScreen x11GraphicsScreen, int n) {
        ArrayList arrayList;
        boolean bl;
        ArrayList<Object> arrayList2;
        boolean bl2;
        int n2 = -1;
        PointerBuffer pointerBuffer = null;
        GLProfile gLProfile = gLCapabilitiesImmutable.getGLProfile();
        X11GraphicsDevice x11GraphicsDevice = (X11GraphicsDevice)x11GraphicsScreen.getDevice();
        long l = x11GraphicsDevice.getHandle();
        int n3 = x11GraphicsScreen.getIndex();
        X11GLXDrawableFactory x11GLXDrawableFactory = (X11GLXDrawableFactory)GLDrawableFactory.getDesktopFactory();
        boolean bl3 = x11GLXDrawableFactory.isGLXMultisampleAvailable((AbstractGraphicsDevice)x11GraphicsDevice);
        IntBuffer intBuffer = X11GLXGraphicsConfiguration.GLCapabilities2AttribList(gLCapabilitiesImmutable, true, bl3, l, n3);
        IntBuffer intBuffer2 = Buffers.newDirectIntBuffer((int)1);
        intBuffer2.put(0, -1);
        int n4 = GLGraphicsConfigurationUtil.getExclusiveWinAttributeBits((GLCapabilitiesImmutable)gLCapabilitiesImmutable);
        GLRendererQuirks gLRendererQuirks = x11GLXDrawableFactory.getRendererQuirks((AbstractGraphicsDevice)x11GraphicsDevice, gLProfile);
        boolean bl4 = 0 == n ? (pointerBuffer = GLX.glXChooseFBConfig(l, n3, intBuffer, intBuffer2)) != null && pointerBuffer.limit() > 0 : false;
        boolean bl5 = gLCapabilitiesImmutable.isBitmap() || gLCapabilitiesImmutable.isPBuffer();
        boolean bl6 = GLRendererQuirks.exist((GLRendererQuirks)gLRendererQuirks, (int)24) || bl5 && GLRendererQuirks.exist((GLRendererQuirks)gLRendererQuirks, (int)25);
        boolean bl7 = !bl6 && bl4 && gLCapabilitiesImmutable.isBackgroundOpaque();
        boolean bl8 = bl2 = null == gLCapabilitiesChooser && bl7;
        if (bl4) {
            arrayList2 = X11GLXGraphicsConfiguration.GLXFBConfig2GLCapabilities(x11GraphicsDevice, gLProfile, pointerBuffer, n4, bl3, bl2);
            if (arrayList2.size() > 0) {
                int n5 = n2 = bl7 ? 0 : -1;
                if (DEBUG) {
                    System.err.println("glXChooseFBConfig recommended fbcfg " + X11GLXGraphicsConfigurationFactory.toHexString((long)pointerBuffer.get(0)) + ", idx " + n2);
                    System.err.println("useRecommendedIndex " + bl7 + ", shallSkipCapsChooser " + bl2);
                    System.err.println("user  caps " + gLCapabilitiesImmutable);
                    System.err.println("fbcfg caps " + pointerBuffer.limit() + ", availCaps " + arrayList2.get(0));
                }
            } else if (DEBUG) {
                System.err.println("glXChooseFBConfig no caps for recommended fbcfg " + X11GLXGraphicsConfigurationFactory.toHexString((long)pointerBuffer.get(0)));
                System.err.println("useRecommendedIndex " + bl7 + ", shallSkipCapsChooser " + bl2);
                System.err.println("user  caps " + gLCapabilitiesImmutable);
            }
        } else {
            arrayList2 = new ArrayList();
        }
        if (0 == arrayList2.size()) {
            n2 = -1;
            pointerBuffer = GLX.glXChooseFBConfig(l, n3, null, intBuffer2);
            if (pointerBuffer == null || pointerBuffer.limit() <= 0) {
                if (DEBUG) {
                    System.err.println("X11GLXGraphicsConfiguration.chooseGraphicsConfigurationFBConfig: Failed glXChooseFBConfig (" + x11GraphicsScreen + "," + gLCapabilitiesImmutable + "): " + pointerBuffer + ", " + intBuffer2.get(0));
                }
                return null;
            }
            arrayList2 = X11GLXGraphicsConfiguration.GLXFBConfig2GLCapabilities(x11GraphicsDevice, gLProfile, pointerBuffer, n4, bl3, false);
        }
        boolean bl9 = bl = bl2 && 0 <= n2;
        if (DEBUG) {
            System.err.println("X11GLXGraphicsConfiguration.chooseGraphicsConfigurationFBConfig: got configs: " + arrayList2.size());
            for (int i = 0; i < arrayList2.size(); ++i) {
                System.err.println(i + ": " + arrayList2.get(i));
            }
            System.err.println("recommendedIndex " + n2 + ", skipCapsChooser " + bl);
        }
        if ((arrayList = !bl && bl5 && GLRendererQuirks.exist((GLRendererQuirks)gLRendererQuirks, (int)25) ? CapabilitiesFilter.removeMoreColorCompsAndUnmatchingNativeVisualID(arrayList2, (int)8, (int)n) : CapabilitiesFilter.removeUnmatchingNativeVisualID(arrayList2, (int)n)).size() > 0 && DEBUG) {
            System.err.println("X11GLXGraphicsConfiguration.chooseGraphicsConfigurationFBConfig: filtered configs: " + arrayList2.size());
            for (int i = 0; i < arrayList2.size(); ++i) {
                System.err.println(i + ": " + arrayList2.get(i));
            }
        }
        if (0 == arrayList2.size()) {
            if (DEBUG) {
                System.err.println("X11GLXGraphicsConfiguration.chooseGraphicsConfigurationFBConfig: post filter visualID " + X11GLXGraphicsConfigurationFactory.toHexString((int)n) + " no config found, failed - return null");
            }
            return null;
        }
        int n6 = bl ? n2 : X11GLXGraphicsConfigurationFactory.chooseCapabilities((CapabilitiesChooser)gLCapabilitiesChooser, (CapabilitiesImmutable)gLCapabilitiesImmutable, arrayList2, (int)n2);
        if (0 > n6) {
            if (DEBUG) {
                System.err.println("X11GLXGraphicsConfiguration.chooseGraphicsConfigurationFBConfig: failed, return null");
                ExceptionUtils.dumpStack((PrintStream)System.err);
            }
            return null;
        }
        X11GLCapabilities x11GLCapabilities = (X11GLCapabilities)((Object)arrayList2.get(n6));
        return new X11GLXGraphicsConfiguration(x11GraphicsScreen, x11GLCapabilities, gLCapabilitiesImmutable2, gLCapabilitiesChooser);
    }

    private static X11GLXGraphicsConfiguration chooseGraphicsConfigurationXVisual(GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesImmutable gLCapabilitiesImmutable2, GLCapabilitiesChooser gLCapabilitiesChooser, X11GraphicsScreen x11GraphicsScreen, int n) {
        X11GLCapabilities x11GLCapabilities;
        int n2;
        if (gLCapabilitiesChooser == null) {
            gLCapabilitiesChooser = new DefaultGLCapabilitiesChooser();
        }
        GLProfile gLProfile = gLCapabilitiesImmutable.getGLProfile();
        int n3 = GLGraphicsConfigurationUtil.getExclusiveWinAttributeBits((boolean)gLCapabilitiesImmutable.isOnscreen(), (boolean)gLCapabilitiesImmutable.isFBO(), (boolean)false, (boolean)gLCapabilitiesImmutable.isBitmap());
        ArrayList<X11GLCapabilities> arrayList = new ArrayList<X11GLCapabilities>();
        int n4 = -1;
        X11GraphicsDevice x11GraphicsDevice = (X11GraphicsDevice)x11GraphicsScreen.getDevice();
        long l = x11GraphicsDevice.getHandle();
        int n5 = x11GraphicsScreen.getIndex();
        X11GLXDrawableFactory x11GLXDrawableFactory = (X11GLXDrawableFactory)GLDrawableFactory.getDesktopFactory();
        boolean bl = x11GLXDrawableFactory.isGLXMultisampleAvailable((AbstractGraphicsDevice)x11GraphicsDevice);
        IntBuffer intBuffer = X11GLXGraphicsConfiguration.GLCapabilities2AttribList(gLCapabilitiesImmutable, false, bl, l, n5);
        XVisualInfo xVisualInfo = null;
        if (0 == n) {
            xVisualInfo = GLX.glXChooseVisual(l, n5, intBuffer);
            if (DEBUG) {
                System.err.print("glXChooseVisual recommended ");
                if (xVisualInfo == null) {
                    System.err.println("null visual");
                } else {
                    System.err.println("visual id " + X11GLXGraphicsConfigurationFactory.toHexString((long)xVisualInfo.getVisualid()));
                }
            }
        }
        int[] nArray = new int[1];
        XVisualInfo xVisualInfo2 = XVisualInfo.create();
        xVisualInfo2.setScreen(n5);
        XVisualInfo[] xVisualInfoArray = X11Lib.XGetVisualInfo((long)l, (long)2L, (XVisualInfo)xVisualInfo2, (int[])nArray, (int)0);
        if (xVisualInfoArray == null || xVisualInfoArray.length < 1) {
            throw new GLException("Error while enumerating available XVisualInfos");
        }
        for (n2 = 0; n2 < xVisualInfoArray.length; ++n2) {
            x11GLCapabilities = X11GLXGraphicsConfiguration.XVisualInfo2GLCapabilities(x11GraphicsDevice, gLProfile, xVisualInfoArray[n2], n3, bl);
            if (null != x11GLCapabilities) {
                arrayList.add(x11GLCapabilities);
                if (!gLCapabilitiesImmutable.isBackgroundOpaque() || xVisualInfo == null || xVisualInfo.getVisualid() != xVisualInfoArray[n2].getVisualid()) continue;
                n4 = arrayList.size() - 1;
                continue;
            }
            if (!DEBUG) continue;
            System.err.println("X11GLXGraphicsConfiguration.chooseGraphicsConfigurationXVisual: XVisual invalid: (" + x11GraphicsScreen + "): fbcfg: " + X11GLXGraphicsConfigurationFactory.toHexString((long)xVisualInfoArray[n2].getVisualid()));
        }
        if (DEBUG) {
            System.err.println("X11GLXGraphicsConfiguration.chooseGraphicsConfigurationXVisual: got configs: " + arrayList.size());
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                System.err.println(n2 + ": " + arrayList.get(n2));
            }
        }
        if (0 != n) {
            n2 = 0;
            while (n2 < arrayList.size()) {
                x11GLCapabilities = (VisualIDHolder)arrayList.get(n2);
                if (x11GLCapabilities.getVisualID(VisualIDHolder.VIDType.X11_XVISUAL) != n) {
                    arrayList.remove(n2);
                    continue;
                }
                ++n2;
            }
            if (0 == arrayList.size()) {
                if (DEBUG) {
                    System.err.println("X11GLXGraphicsConfiguration.chooseGraphicsConfigurationXVisual: post filter visualID " + X11GLXGraphicsConfigurationFactory.toHexString((int)n) + " no config found, failed - return null");
                }
                return null;
            }
            if (DEBUG) {
                System.err.println("X11GLXGraphicsConfiguration.chooseGraphicsConfigurationXVisual: post filter visualID " + X11GLXGraphicsConfigurationFactory.toHexString((int)n) + " got configs: " + arrayList.size());
            }
        }
        if (0 > (n2 = X11GLXGraphicsConfigurationFactory.chooseCapabilities((CapabilitiesChooser)gLCapabilitiesChooser, (CapabilitiesImmutable)gLCapabilitiesImmutable, arrayList, (int)n4))) {
            if (DEBUG) {
                System.err.println("X11GLXGraphicsConfiguration.chooseGraphicsConfigurationXVisual: failed, return null");
                ExceptionUtils.dumpStack((PrintStream)System.err);
            }
            return null;
        }
        x11GLCapabilities = (X11GLCapabilities)((Object)arrayList.get(n2));
        return new X11GLXGraphicsConfiguration(x11GraphicsScreen, x11GLCapabilities, gLCapabilitiesImmutable2, gLCapabilitiesChooser);
    }
}

