/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.openal.util;

import com.jogamp.common.av.AudioFormat;
import com.jogamp.common.av.PTS;
import com.jogamp.common.nio.Buffers;
import com.jogamp.common.os.Platform;
import com.jogamp.common.util.WorkerThread;
import com.jogamp.openal.sound3d.Context;
import com.jogamp.openal.sound3d.Device;
import com.jogamp.openal.sound3d.Source;
import com.jogamp.openal.util.ALAudioSink;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;

public final class SimpleSineSynth {
    private static final boolean DEBUG = false;
    private static final float PI = (float)Math.PI;
    private static final float TWO_PI = (float)Math.PI * 2;
    private static final float EPSILON = 1.1920929E-7f;
    private static final float SHORT_MAX = 32767.0f;
    public static final float MIDDLE_C = 261.625f;
    private final ALAudioSink audioSink;
    private final Object stateLock = new Object();
    private volatile float audioAmplitude = 1.0f;
    private volatile float audioFreq = 261.625f;
    private volatile int nextAudioPTS = 0;
    private SynthWorker streamWorker;

    public SimpleSineSynth() {
        this(null);
    }

    public SimpleSineSynth(Device device) {
        this.audioSink = new ALAudioSink(device);
        this.streamWorker = new SynthWorker();
    }

    public ALAudioSink getSink() {
        return this.audioSink;
    }

    public final Device getDevice() {
        return this.audioSink.getDevice();
    }

    public final Context getContext() {
        return this.audioSink.getContext();
    }

    public final Source getSource() {
        return this.audioSink.getSource();
    }

    public void setFreq(float f) {
        this.audioFreq = f;
    }

    public float getFreq() {
        return this.audioFreq;
    }

    public void setAmplitude(float f) {
        this.audioAmplitude = Math.min(1.0f, Math.max(0.0f, f));
    }

    public float getAmplitude() {
        return this.audioAmplitude;
    }

    public int getLatency() {
        return null != this.streamWorker ? this.streamWorker.frameDuration : 64;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void play() {
        Object object = this.stateLock;
        synchronized (object) {
            if (null == this.streamWorker) {
                this.streamWorker = new SynthWorker();
            }
            this.streamWorker.doResume();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        Object object = this.stateLock;
        synchronized (object) {
            if (null != this.streamWorker) {
                this.streamWorker.doPause(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.stateLock;
        synchronized (object) {
            if (null != this.streamWorker) {
                this.streamWorker.doStop();
                this.streamWorker = null;
            } else {
                this.audioSink.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPlaying() {
        Object object = this.stateLock;
        synchronized (object) {
            if (null != this.streamWorker) {
                return this.streamWorker.isPlaying();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        Object object = this.stateLock;
        synchronized (object) {
            if (null != this.streamWorker) {
                return this.streamWorker.isRunning();
            }
        }
        return false;
    }

    public int getNextPTS() {
        return this.nextAudioPTS;
    }

    public PTS getPTS() {
        return this.audioSink.getPTS();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String toString() {
        Object object = this.stateLock;
        synchronized (object) {
            int n = this.getPTS().getLast();
            int n2 = this.getNextPTS() - n;
            return this.getClass().getSimpleName() + "[f " + this.audioFreq + ", a " + this.audioAmplitude + ", latency " + this.getLatency() + ", state[running " + this.isRunning() + ", playing " + this.isPlaying() + "], pts[next " + this.getNextPTS() + ", play " + n + ", lag " + n2 + "], " + this.audioSink.toString() + "]";
        }
    }

    private static ByteBuffer allocate(int n) {
        return Buffers.newDirectByteBuffer((int)n);
    }

    class SynthWorker {
        private final boolean useFloat32SampleType;
        private final int bytesPerSample;
        private final AudioFormat audioFormat;
        private ByteBuffer sampleBuffer;
        private int frameDuration;
        private int audioQueueLimit;
        private float lastFreq;
        private float nextSin;
        private boolean upSin;
        private int nextStep;
        private final WorkerThread.StateCallback stateCB = (workerThread, state) -> {
            switch (state) {
                case INIT: {
                    SimpleSineSynth.this.nextAudioPTS = (int)Platform.currentMillis();
                    break;
                }
                case PAUSED: {
                    SimpleSineSynth.this.audioSink.pause();
                    break;
                }
                case RESUMED: {
                    SimpleSineSynth.this.nextAudioPTS = (int)Platform.currentMillis();
                    SimpleSineSynth.this.audioSink.play();
                    break;
                }
                case END: {
                    break;
                }
            }
        };
        private final WorkerThread.Callback action = workerThread -> this.enqueueWave();
        final WorkerThread wt = new WorkerThread(null, null, true, this.action, this.stateCB);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        SynthWorker() {
            SynthWorker synthWorker = this;
            synchronized (synthWorker) {
                SimpleSineSynth.this.nextAudioPTS = 0;
                AudioFormat audioFormat = new AudioFormat(((SimpleSineSynth)SimpleSineSynth.this).audioSink.getPreferredFormat().sampleRate, 32, 1, true, false, false, true);
                if (SimpleSineSynth.this.audioSink.isSupported(audioFormat)) {
                    this.useFloat32SampleType = true;
                    this.bytesPerSample = 4;
                    this.audioFormat = audioFormat;
                } else {
                    this.useFloat32SampleType = false;
                    this.bytesPerSample = 2;
                    this.audioFormat = new AudioFormat(((SimpleSineSynth)SimpleSineSynth.this).audioSink.getPreferredFormat().sampleRate, this.bytesPerSample << 3, 1, true, true, false, true);
                }
                System.err.println("OpenAL float32 supported: " + this.useFloat32SampleType);
                this.sampleBuffer = SimpleSineSynth.allocate(this.audioFormat.getDurationsByteSize(0.03f));
                this.frameDuration = 10;
                this.audioQueueLimit = Math.max(16, Math.min(96, 3 * Math.round(1000.0f * SimpleSineSynth.this.audioSink.getDefaultLatency())));
                SimpleSineSynth.this.audioSink.init(this.audioFormat, this.frameDuration, this.audioQueueLimit);
                this.frameDuration = Math.round(1000.0f * SimpleSineSynth.this.audioSink.getLatency());
                this.lastFreq = 0.0f;
                this.nextSin = 0.0f;
                this.upSin = true;
                this.nextStep = 0;
                this.wt.start(true);
            }
        }

        private final int findNextStep(boolean bl, float f, float f2, int n, int n2) {
            float f3 = (float)Math.PI * 2 * f2 / (float)n;
            float f4 = Float.MAX_VALUE;
            float f5 = 0.0f;
            int n3 = -1;
            float f6 = 0.0f;
            for (int i = 0; i < n2 && f4 >= 1.1920929E-7f; ++i) {
                float f7 = (float)Math.sin(f3 * (float)i);
                float f8 = Math.abs(f - f7);
                if (f8 < f4 && (bl && f7 >= f6 || !bl && f7 < f6)) {
                    f5 = f7;
                    f4 = f8;
                    n3 = i;
                }
                f6 = f7;
            }
            return n3;
        }

        private final void enqueueWave() {
            int n;
            boolean bl;
            boolean bl2;
            float f = SimpleSineSynth.this.audioFreq;
            float f2 = SimpleSineSynth.this.audioAmplitude;
            float f3 = 1.0f / f;
            float f4 = (float)Math.PI * 2 * f / (float)this.audioFormat.sampleRate;
            float f5 = (float)this.frameDuration / 1000.0f;
            int n2 = (int)(f5 * (float)this.audioFormat.sampleRate);
            if (Math.abs(f - this.lastFreq) >= 1.1920929E-7f) {
                bl2 = true;
                bl = false;
                this.lastFreq = f;
                this.nextStep = this.findNextStep(this.upSin, this.nextSin, f, this.audioFormat.sampleRate, n2);
            } else {
                bl2 = false;
                if (this.nextStep + n2 >= 2147483) {
                    this.nextStep = this.findNextStep(this.upSin, this.nextSin, f, this.audioFormat.sampleRate, n2);
                    bl = true;
                } else {
                    bl = false;
                }
            }
            if (this.sampleBuffer.capacity() < this.bytesPerSample * n2) {
                this.sampleBuffer = SimpleSineSynth.allocate(this.bytesPerSample * n2);
            }
            float f6 = 0.0f;
            if (this.useFloat32SampleType) {
                int n3;
                FloatBuffer floatBuffer = this.sampleBuffer.asFloatBuffer();
                for (n = n3 = this.nextStep; n < n3 + n2; ++n) {
                    f6 = (float)Math.sin(f4 * (float)n);
                    floatBuffer.put(f6 * f2);
                }
            } else {
                int n4;
                for (n = n4 = this.nextStep; n < n4 + n2; ++n) {
                    f6 = (float)Math.sin(f4 * (float)n);
                    short s = (short)(32767.0f * f6 * f2);
                    this.sampleBuffer.put((byte)(s & 0xFF));
                    this.sampleBuffer.put((byte)(s >>> 8 & 0xFF));
                }
            }
            this.nextStep = n;
            this.nextSin = (float)Math.sin(f4 * (float)this.nextStep);
            this.upSin = this.nextSin >= f6;
            this.sampleBuffer.rewind();
            SimpleSineSynth.this.audioSink.enqueueData(SimpleSineSynth.this.nextAudioPTS, this.sampleBuffer, n2 * this.bytesPerSample);
            this.sampleBuffer.clear();
            SimpleSineSynth.this.nextAudioPTS += this.frameDuration;
        }

        public final synchronized void doPause(boolean bl) {
            this.wt.pause(bl);
        }

        public final synchronized void doResume() {
            this.wt.resume();
        }

        public final synchronized void doStop() {
            this.wt.stop(true);
            SimpleSineSynth.this.audioSink.destroy();
        }

        public final boolean isRunning() {
            return this.wt.isRunning();
        }

        public final boolean isPlaying() {
            return this.wt.isActive();
        }
    }
}

