/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.graph.ui;

import com.jogamp.graph.curve.OutlineShape;
import com.jogamp.graph.curve.Region;
import com.jogamp.graph.curve.opengl.GLRegion;
import com.jogamp.graph.curve.opengl.RegionRenderer;
import com.jogamp.graph.ui.Shape;
import com.jogamp.graph.ui.layout.Padding;
import com.jogamp.math.Vec3f;
import com.jogamp.math.Vec4f;
import com.jogamp.math.geom.AABBox;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.util.texture.TextureSequence;
import java.util.ArrayList;
import java.util.List;

public abstract class GraphShape
extends Shape {
    protected final int renderModesReq;
    protected int renderModes;
    protected int pass2TexUnit = 0;
    protected GLRegion region = null;
    protected float oshapeSharpness = 0.5f;
    private final List<GLRegion> dirtyRegions = new ArrayList<GLRegion>();

    protected GraphShape(int n) {
        this.renderModesReq = n;
        this.renderModes = n;
    }

    public final int getRenderModesReq() {
        return this.renderModesReq;
    }

    public final int getRenderModes() {
        return this.renderModes;
    }

    public void setTextureUnit(int n) {
        this.pass2TexUnit = n;
        if (null != this.region) {
            this.region.setTextureUnit(n);
        }
    }

    public final GraphShape setSharpness(float f) {
        this.oshapeSharpness = f;
        this.markShapeDirty();
        return this;
    }

    public final float getSharpness() {
        return this.oshapeSharpness;
    }

    @Override
    public boolean hasColorChannel() {
        return Region.hasColorChannel((int)this.renderModes) || Region.hasColorTexture((int)this.renderModes);
    }

    private final void clearDirtyRegions(GL2ES2 gL2ES2) {
        for (GLRegion gLRegion : this.dirtyRegions) {
            gLRegion.destroy(gL2ES2);
        }
        this.dirtyRegions.clear();
    }

    @Override
    protected final void clearImpl0(GL2ES2 gL2ES2, RegionRenderer regionRenderer) {
        this.clearImpl(gL2ES2, regionRenderer);
        this.clearDirtyRegions(gL2ES2);
        if (null != this.region) {
            this.region.clear(gL2ES2);
        }
    }

    @Override
    protected final void destroyImpl0(GL2ES2 gL2ES2, RegionRenderer regionRenderer) {
        this.destroyImpl(gL2ES2, regionRenderer);
        this.clearDirtyRegions(gL2ES2);
        if (null != this.region) {
            this.region.destroy(gL2ES2);
            this.region = null;
        }
    }

    @Override
    protected void drawImpl0(GL2ES2 gL2ES2, RegionRenderer regionRenderer, Vec4f vec4f) {
        regionRenderer.setColorStatic(vec4f);
        this.region.draw(gL2ES2, regionRenderer);
    }

    public GLRegion getRegion() {
        return this.region;
    }

    @Override
    protected final void drawToSelectImpl0(GL2ES2 gL2ES2, RegionRenderer regionRenderer) {
        this.region.drawToSelect(gL2ES2, regionRenderer);
    }

    protected final void resetGLRegion(GLProfile gLProfile, GL2ES2 gL2ES2, TextureSequence textureSequence, int n, int n2) {
        if (this.hasBorder()) {
            n += 8;
            n2 += 24;
        }
        if (null == this.region) {
            this.region = GLRegion.create((GLProfile)gLProfile, (int)this.renderModes, (TextureSequence)textureSequence, (int)this.pass2TexUnit, (int)n, (int)n2);
        } else if (null == gL2ES2) {
            this.dirtyRegions.add(this.region);
            this.region = GLRegion.create((GLProfile)gLProfile, (int)this.renderModes, (TextureSequence)textureSequence, (int)this.pass2TexUnit, (int)n, (int)n2);
        } else {
            this.region.clear(gL2ES2);
            this.region.setBufferCapacity(n, n2);
        }
    }

    protected final void resetGLRegion(GLProfile gLProfile, GL2ES2 gL2ES2, TextureSequence textureSequence, OutlineShape outlineShape) {
        int[] nArray = Region.countOutlineShape((OutlineShape)outlineShape, (int[])new int[2]);
        this.resetGLRegion(gLProfile, gL2ES2, textureSequence, nArray[0], nArray[1]);
    }

    @Override
    protected final void validateImpl(GL2ES2 gL2ES2, GLProfile gLProfile) {
        if (null != gL2ES2) {
            this.clearDirtyRegions(gL2ES2);
        }
        if (this.isShapeDirty()) {
            if (this.hasBorder() && !this.rgbaColor.isEqual(this.getBorderColor()) && !Region.hasColorChannel((int)this.renderModes)) {
                this.renderModes |= 0x200;
            }
            this.addShapeToRegion(gLProfile, gL2ES2);
            if (this.hasBorder()) {
                GraphShape.addRectangle((Region)this.region, this.oshapeSharpness, this.box, this.getPadding(), this.getBorderThickness(), this.getBorderColor());
                this.setRotationPivot(this.box.getCenter());
            } else if (this.hasPadding()) {
                Padding padding = this.getPadding();
                Vec3f vec3f = this.box.getLow();
                Vec3f vec3f2 = this.box.getHigh();
                this.box.resize(vec3f.x() - padding.left, vec3f.y() - padding.bottom, vec3f.z());
                this.box.resize(vec3f2.x() + padding.right, vec3f2.y() + padding.top, vec3f.z());
                this.setRotationPivot(this.box.getCenter());
            }
        } else if (this.isStateDirty()) {
            this.region.markStateDirty();
        }
    }

    protected static void addRectangle(Region region, float f, AABBox aABBox, Padding padding, float f2, Vec4f vec4f) {
        OutlineShape outlineShape = new OutlineShape();
        Padding padding2 = null != padding ? padding : Padding.None;
        float f3 = aABBox.getMinX() - padding2.left;
        float f4 = aABBox.getMaxX() + padding2.right;
        float f5 = aABBox.getMinY() - padding2.bottom;
        float f6 = aABBox.getMaxY() + padding2.top;
        float f7 = aABBox.getMaxZ();
        outlineShape.moveTo(f3, f5, f7);
        outlineShape.lineTo(f4, f5, f7);
        outlineShape.lineTo(f4, f6, f7);
        outlineShape.lineTo(f3, f6, f7);
        outlineShape.lineTo(f3, f5, f7);
        outlineShape.closeLastOutline(true);
        outlineShape.addEmptyOutline();
        float f8 = f2;
        outlineShape.moveTo(f3 + f8, f5 + f8, f7);
        outlineShape.lineTo(f3 + f8, f6 - f8, f7);
        outlineShape.lineTo(f4 - f8, f6 - f8, f7);
        outlineShape.lineTo(f4 - f8, f5 + f8, f7);
        outlineShape.lineTo(f3 + f8, f5 + f8, f7);
        outlineShape.closeLastOutline(true);
        outlineShape.setIsQuadraticNurbs();
        outlineShape.setSharpness(f);
        region.addOutlineShape(outlineShape, null, vec4f);
        aABBox.resize(outlineShape.getBounds());
    }

    protected void clearImpl(GL2ES2 gL2ES2, RegionRenderer regionRenderer) {
    }

    protected void destroyImpl(GL2ES2 gL2ES2, RegionRenderer regionRenderer) {
    }

    protected abstract void addShapeToRegion(GLProfile var1, GL2ES2 var2);

    @Override
    public String getSubString() {
        if (this.renderModesReq != this.renderModes) {
            return super.getSubString() + ", renderMode[req " + Region.getRenderModeString((int)this.renderModesReq) + ", has " + Region.getRenderModeString((int)this.renderModes) + "]";
        }
        return super.getSubString() + ", renderMode " + Region.getRenderModeString((int)this.renderModesReq);
    }
}

