/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.graph.ui;

import com.jogamp.graph.curve.Region;
import com.jogamp.graph.curve.opengl.RegionRenderer;
import com.jogamp.graph.ui.Container;
import com.jogamp.graph.ui.GraphShape;
import com.jogamp.graph.ui.Scene;
import com.jogamp.graph.ui.Shape;
import com.jogamp.graph.ui.shapes.Rectangle;
import com.jogamp.math.FloatUtil;
import com.jogamp.math.Matrix4f;
import com.jogamp.math.Vec2f;
import com.jogamp.math.Vec3f;
import com.jogamp.math.Vec4f;
import com.jogamp.math.geom.AABBox;
import com.jogamp.math.geom.Cube;
import com.jogamp.math.geom.Frustum;
import com.jogamp.math.util.PMVMatrix4f;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLProfile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import jogamp.graph.ui.TreeTool;

public class Group
extends Shape
implements Container {
    private final List<Shape> shapes = new CopyOnWriteArrayList<Shape>();
    private Shape[] drawShapeArray = new Shape[0];
    private final List<Shape> renderedShapesB0 = new ArrayList<Shape>();
    private final List<Shape> renderedShapesB1 = new ArrayList<Shape>();
    private final List<Shape> renderedShapesB2 = new ArrayList<Shape>();
    private volatile List<Shape> renderedShapes = this.renderedShapesB1;
    private int renderedShapesIdx = 1;
    private final Vec3f fixedSize = new Vec3f();
    private Layout layouter;
    private Rectangle border = null;
    private boolean relayoutOnDirtyShapes = true;
    private Scene topLevelHolder = null;
    private boolean clipOnBounds = false;
    private Frustum clipFrustum = null;
    private boolean doFrustumCulling = false;
    private final Frustum tempF00 = new Frustum();
    private final Cube tempC00 = new Cube();
    private final Cube tempC01 = new Cube();

    public Group() {
        this(null, null, null, null);
    }

    public Group(Layout layout) {
        this(null, layout, null, null);
    }

    public Group(String string, Layout layout, Vec2f vec2f, Shape shape) {
        if (null != string) {
            this.setName(string);
        }
        this.layouter = layout;
        this.setInteractive(false);
        if (null != vec2f) {
            this.setFixedSize(vec2f);
        }
        if (null != shape) {
            this.addShape(shape);
        }
    }

    @Override
    public final boolean isGroup() {
        return true;
    }

    public Layout getLayout() {
        return this.layouter;
    }

    public Group setLayout(Layout layout) {
        this.layouter = layout;
        return this;
    }

    public Group setFixedSize(Vec3f vec3f) {
        this.fixedSize.set(vec3f);
        return this;
    }

    public Group setFixedSize(Vec2f vec2f) {
        this.fixedSize.set(vec2f.x(), vec2f.y(), Float.NaN);
        return this;
    }

    public Vec3f getFixedSize() {
        return this.fixedSize;
    }

    public Vec2f getFixedSize(Vec2f vec2f) {
        vec2f.set(this.fixedSize.x(), this.fixedSize.y());
        return vec2f;
    }

    public Group setClipOnBounds(boolean bl) {
        this.clipOnBounds = bl;
        return this;
    }

    public boolean getClipOnBounds() {
        return this.clipOnBounds;
    }

    public Group setClipMvFrustum(Frustum frustum) {
        this.clipFrustum = frustum;
        return this;
    }

    public Frustum getClipMvFrustum() {
        return this.clipFrustum;
    }

    @Override
    public int getShapeCount() {
        return this.shapes.size();
    }

    @Override
    public List<Shape> getShapes() {
        return this.shapes;
    }

    @Override
    public List<Shape> getRenderedShapes() {
        return this.renderedShapes;
    }

    @Override
    public void addShape(Shape shape) {
        this.shapes.add(shape);
        shape.setParent(this);
        this.markShapeDirty();
    }

    public boolean replaceShape(Shape shape, Shape shape2) {
        int n = this.shapes.indexOf(shape);
        if (0 > n) {
            return false;
        }
        if (null == this.shapes.remove(n)) {
            return false;
        }
        shape.setParent(null);
        this.shapes.add(n, shape2);
        shape2.setParent(this);
        this.markShapeDirty();
        return true;
    }

    @Override
    public Shape removeShape(Shape shape) {
        if (this.shapes.remove(shape)) {
            shape.setParent(null);
            this.markShapeDirty();
            return shape;
        }
        return null;
    }

    @Override
    public void removeShapes(Collection<? extends Shape> collection) {
        for (Shape shape : collection) {
            this.removeShape(shape);
        }
    }

    @Override
    public boolean removeShape(GL2ES2 gL2ES2, RegionRenderer regionRenderer, Shape shape) {
        if (this.shapes.remove(shape)) {
            shape.setParent(null);
            this.markShapeDirty();
            shape.destroy(gL2ES2, regionRenderer);
            return true;
        }
        return false;
    }

    @Override
    public void addShapes(Collection<? extends Shape> collection) {
        for (Shape shape : collection) {
            this.addShape(shape);
        }
    }

    @Override
    public void removeShapes(GL2ES2 gL2ES2, RegionRenderer regionRenderer, Collection<? extends Shape> collection) {
        for (Shape shape : collection) {
            this.removeShape(gL2ES2, regionRenderer, shape);
        }
    }

    @Override
    public void removeAllShapes(GL2ES2 gL2ES2, RegionRenderer regionRenderer) {
        int n = this.shapes.size();
        for (int i = n - 1; i >= 0; --i) {
            this.removeShape(gL2ES2, regionRenderer, this.shapes.get(i));
        }
    }

    @Override
    public boolean hasColorChannel() {
        return false;
    }

    @Override
    protected void clearImpl0(GL2ES2 gL2ES2, RegionRenderer regionRenderer) {
        this.disableTopLevelWidget();
        for (Shape shape : this.shapes) {
            shape.clear(gL2ES2, regionRenderer);
        }
        this.shapes.clear();
        this.drawShapeArray = new Shape[0];
        this.renderedShapesB0.clear();
        this.renderedShapesB1.clear();
        this.renderedShapesB2.clear();
        this.renderedShapes = this.renderedShapesB1;
        this.renderedShapesIdx = 1;
    }

    @Override
    protected void destroyImpl0(GL2ES2 gL2ES2, RegionRenderer regionRenderer) {
        this.disableTopLevelWidget();
        for (Shape shape : this.shapes) {
            shape.destroy(gL2ES2, regionRenderer);
        }
        this.shapes.clear();
        this.drawShapeArray = new Shape[0];
        this.renderedShapesB0.clear();
        this.renderedShapesB1.clear();
        this.renderedShapesB2.clear();
        this.renderedShapes = this.renderedShapesB1;
        this.renderedShapesIdx = 1;
        if (null != this.border) {
            this.border.destroy(gL2ES2, regionRenderer);
            this.border = null;
        }
    }

    @Override
    public final void setPMvCullingEnabled(boolean bl) {
        this.doFrustumCulling = bl;
    }

    @Override
    public final boolean isPMvCullingEnabled() {
        return this.doFrustumCulling;
    }

    @Override
    public final boolean isCullingEnabled() {
        return this.doFrustumCulling || this.clipOnBounds || null != this.clipFrustum;
    }

    @Override
    public final boolean isOutside(PMVMatrix4f pMVMatrix4f, Shape shape) {
        boolean bl;
        AABBox aABBox = shape.getBounds();
        boolean bl2 = bl = null != this.clipFrustum;
        if (bl || this.clipOnBounds) {
            boolean bl3;
            Frustum frustum = bl ? this.clipFrustum : this.tempC00.set(this.box).transform(pMVMatrix4f.getMv()).updateFrustumPlanes(this.tempF00);
            pMVMatrix4f.pushMv();
            shape.applyMatToMv(pMVMatrix4f);
            if (this.doFrustumCulling && pMVMatrix4f.getFrustum().isOutside(aABBox)) {
                bl3 = true;
            } else {
                Cube cube = this.tempC01.set(aABBox).transform(pMVMatrix4f.getMv());
                bl3 = frustum.isOutside(cube);
            }
            pMVMatrix4f.popMv();
            return bl3;
        }
        if (this.doFrustumCulling) {
            pMVMatrix4f.pushMv();
            shape.applyMatToMv(pMVMatrix4f);
            boolean bl4 = pMVMatrix4f.getFrustum().isOutside(aABBox);
            pMVMatrix4f.popMv();
            return bl4;
        }
        return false;
    }

    @Override
    public boolean isOutside2(Matrix4f matrix4f, Shape shape, PMVMatrix4f pMVMatrix4f) {
        boolean bl;
        AABBox aABBox = shape.getBounds();
        boolean bl2 = bl = null != this.clipFrustum;
        if (bl || this.clipOnBounds) {
            boolean bl3;
            Frustum frustum;
            Frustum frustum2 = frustum = bl ? this.clipFrustum : this.tempC00.set(this.box).transform(matrix4f).updateFrustumPlanes(this.tempF00);
            if (this.doFrustumCulling && pMVMatrix4f.getFrustum().isOutside(aABBox)) {
                bl3 = true;
            } else {
                Cube cube = this.tempC01.set(aABBox).transform(pMVMatrix4f.getMv());
                bl3 = frustum.isOutside(cube);
            }
            return bl3;
        }
        if (this.doFrustumCulling) {
            return pMVMatrix4f.getFrustum().isOutside(aABBox);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void drawImpl0(GL2ES2 gL2ES2, RegionRenderer regionRenderer, Vec4f vec4f) {
        boolean bl;
        List<Shape> list;
        int n;
        PMVMatrix4f pMVMatrix4f = regionRenderer.getMatrix();
        int n2 = this.shapes.size();
        Arrays.fill(this.drawShapeArray, null);
        Shape[] shapeArray = this.shapes.toArray(this.drawShapeArray);
        this.drawShapeArray = shapeArray;
        Arrays.sort(shapeArray, 0, n2, Shape.ZAscendingComparator);
        switch (this.renderedShapesIdx) {
            case 0: {
                n = 1;
                list = this.renderedShapesB1;
                break;
            }
            case 1: {
                n = 2;
                list = this.renderedShapesB2;
                break;
            }
            default: {
                n = 0;
                list = this.renderedShapesB0;
            }
        }
        boolean bl2 = bl = null != this.clipFrustum;
        if (bl || this.clipOnBounds) {
            Frustum frustum = regionRenderer.getClipFrustum();
            Frustum frustum2 = bl ? this.clipFrustum : this.tempC00.set(this.box).transform(pMVMatrix4f.getMv()).updateFrustumPlanes(this.tempF00);
            regionRenderer.setClipFrustum(frustum2);
            List<Shape> list2 = list;
            synchronized (list2) {
                list.clear();
                for (int i = 0; i < n2; ++i) {
                    Shape shape = shapeArray[i];
                    if (!shape.isVisible()) continue;
                    pMVMatrix4f.pushMv();
                    shape.applyMatToMv(pMVMatrix4f);
                    AABBox aABBox = shape.getBounds();
                    Cube cube = this.tempC01.set(aABBox).transform(pMVMatrix4f.getMv());
                    if (!(frustum2.isOutside(cube) || this.doFrustumCulling && pMVMatrix4f.getFrustum().isOutside(aABBox))) {
                        shape.draw(gL2ES2, regionRenderer);
                        list.add(shape);
                        shape.setDiscarded(false);
                    } else {
                        shape.setDiscarded(true);
                    }
                    pMVMatrix4f.popMv();
                }
            }
            regionRenderer.setClipFrustum(frustum);
        } else {
            List<Shape> list3 = list;
            synchronized (list3) {
                list.clear();
                for (int i = 0; i < n2; ++i) {
                    Shape shape = shapeArray[i];
                    if (!shape.isVisible()) continue;
                    pMVMatrix4f.pushMv();
                    shape.applyMatToMv(pMVMatrix4f);
                    if (!this.doFrustumCulling || !pMVMatrix4f.getFrustum().isOutside(shape.getBounds())) {
                        shape.draw(gL2ES2, regionRenderer);
                        list.add(shape);
                        shape.setDiscarded(false);
                    } else {
                        shape.setDiscarded(true);
                    }
                    pMVMatrix4f.popMv();
                }
            }
        }
        this.renderedShapes = list;
        this.renderedShapesIdx = n;
        if (null != this.border && this.border.isVisible()) {
            this.border.draw(gL2ES2, regionRenderer);
        }
    }

    @Override
    protected final void drawToSelectImpl0(GL2ES2 gL2ES2, RegionRenderer regionRenderer) {
        PMVMatrix4f pMVMatrix4f = regionRenderer.getMatrix();
        Object[] objectArray = this.shapes.toArray();
        Arrays.sort(objectArray, Shape.ZAscendingComparator);
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            Shape shape = (Shape)objectArray[i];
            if (!shape.isVisible()) continue;
            pMVMatrix4f.pushMv();
            shape.applyMatToMv(pMVMatrix4f);
            if (!this.doFrustumCulling || !pMVMatrix4f.getFrustum().isOutside(shape.getBounds())) {
                shape.drawToSelect(gL2ES2, regionRenderer);
            }
            pMVMatrix4f.popMv();
        }
        if (null != this.border && this.border.isVisible()) {
            this.border.drawToSelect(gL2ES2, regionRenderer);
        }
    }

    public void setRelayoutOnDirtyShapes(boolean bl) {
        this.relayoutOnDirtyShapes = bl;
    }

    public boolean getRelayoutOnDirtyShapes() {
        return this.relayoutOnDirtyShapes;
    }

    public final Group enableTopLevelWidget(Scene scene) {
        this.topLevelHolder = scene;
        scene.addTopLevel(this);
        return this;
    }

    public final Group disableTopLevelWidget() {
        Scene scene = this.topLevelHolder;
        this.topLevelHolder = null;
        if (null != scene) {
            scene.removeTopLevel(this);
        }
        return this;
    }

    public final boolean isTopLevelWidget() {
        return null != this.topLevelHolder;
    }

    @Override
    protected boolean isShapeDirty() {
        if (this.relayoutOnDirtyShapes) {
            for (Shape shape : this.shapes) {
                if (!shape.isShapeDirty()) continue;
                this.markShapeDirty();
            }
        }
        return super.isShapeDirty();
    }

    @Override
    protected void validateImpl(GL2ES2 gL2ES2, GLProfile gLProfile) {
        if (this.isShapeDirty()) {
            boolean bl;
            Object object;
            boolean bl2 = this.hasBorder() && null == this.border;
            GraphShape graphShape = null;
            PMVMatrix4f pMVMatrix4f = new PMVMatrix4f();
            if (null != this.layouter) {
                if (0 == this.shapes.size()) {
                    this.box.resize(0.0f, 0.0f, 0.0f);
                } else {
                    for (Shape object2 : this.shapes) {
                        if (bl2 && null == graphShape && object2 instanceof GraphShape) {
                            graphShape = (GraphShape)object2;
                        }
                        this.layouter.preValidate(object2);
                        object2.validate(gL2ES2, gLProfile);
                    }
                    this.layouter.layout(this, this.box, pMVMatrix4f);
                }
            } else if (0 == this.shapes.size()) {
                this.box.resize(0.0f, 0.0f, 0.0f);
            } else {
                object = new AABBox();
                for (Shape shape : this.shapes) {
                    if (bl2 && null == graphShape && shape instanceof GraphShape) {
                        graphShape = (GraphShape)shape;
                    }
                    shape.validate(gL2ES2, gLProfile);
                    pMVMatrix4f.pushMv();
                    shape.applyMatToMv(pMVMatrix4f);
                    shape.getBounds().transform(pMVMatrix4f.getMv(), object);
                    pMVMatrix4f.popMv();
                    this.box.resize(object);
                }
            }
            if (this.hasPadding()) {
                Shape shape;
                object = this.getPadding();
                Vec3f vec3f = this.box.getLow();
                shape = this.box.getHigh();
                this.box.resize(vec3f.x() - object.left, vec3f.y() - object.bottom, vec3f.z());
                this.box.resize(shape.x() + object.right, shape.y() + object.top, vec3f.z());
                this.setRotationPivot(this.box.getCenter());
            }
            boolean bl3 = !FloatUtil.isZero((float)this.fixedSize.x()) && !FloatUtil.isZero((float)this.fixedSize.y());
            boolean bl4 = bl = null != this.clipFrustum || this.clipOnBounds;
            if (bl3 || bl) {
                boolean bl5 = bl || bl3 && Float.isNaN(this.fixedSize.z());
                Vec3f vec3f = this.box.getLow();
                if (bl5) {
                    Vec3f vec3f2;
                    float f = this.box.getDepth();
                    float f2 = 100.0f * Scene.DEFAULT_Z16_EPSILON;
                    vec3f.add(0.0f, 0.0f, -(1.0f * f2));
                    if (bl3) {
                        vec3f2 = new Vec3f(vec3f);
                        vec3f2.add(this.fixedSize.x(), this.fixedSize.y(), f + 2.0f * f2);
                    } else {
                        vec3f2 = this.box.getHigh();
                        vec3f2.add(0.0f, 0.0f, f + 1.0f * f2);
                    }
                    this.box.setSize(vec3f, vec3f2);
                } else if (bl3) {
                    Vec3f vec3f3 = bl3 ? new Vec3f(vec3f) : this.box.getHigh();
                    vec3f3.add(this.fixedSize.x(), this.fixedSize.y(), this.fixedSize.z());
                    this.box.setSize(vec3f, vec3f3);
                }
            }
            if (this.hasBorder()) {
                if (null == this.border) {
                    int n = null != graphShape ? graphShape.getRenderModes() : 0;
                    int n2 = Region.isVBAA((int)n) ? 2 : 0;
                    this.border = new Rectangle(n2, this.box, this.getBorderThickness());
                } else {
                    this.border.setVisible(true);
                    this.border.setBounds(this.box, this.getBorderThickness());
                }
                this.border.setColor(this.getBorderColor());
            } else if (null != this.border) {
                this.border.setVisible(false);
            }
        }
    }

    @Override
    public boolean contains(Shape shape) {
        return TreeTool.contains(this, shape);
    }

    @Override
    public Shape getShapeByIdx(int n) {
        if (0 > n) {
            return null;
        }
        return this.shapes.get(n);
    }

    @Override
    public Shape getShapeByID(int n) {
        return TreeTool.getShapeByID(this, n);
    }

    @Override
    public Shape getShapeByName(String string) {
        return TreeTool.getShapeByName(this, string);
    }

    @Override
    public AABBox getBounds(PMVMatrix4f pMVMatrix4f, Shape shape) {
        pMVMatrix4f.reset();
        this.applyMatToMv(pMVMatrix4f);
        AABBox aABBox = new AABBox();
        if (null == shape) {
            return aABBox;
        }
        TreeTool.forOne(this, pMVMatrix4f, shape, () -> shape.getBounds().transform(pMVMatrix4f.getMv(), aABBox));
        return aABBox;
    }

    @Override
    public String getSubString() {
        return super.getSubString() + ", shapes " + this.shapes.size();
    }

    public static interface Layout {
        public void preValidate(Shape var1);

        public void layout(Group var1, AABBox var2, PMVMatrix4f var3);
    }
}

