/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.graph.ui.layout;

import com.jogamp.graph.ui.Group;
import com.jogamp.graph.ui.Shape;
import com.jogamp.graph.ui.layout.Alignment;
import com.jogamp.graph.ui.layout.Gap;
import com.jogamp.graph.ui.layout.Padding;
import com.jogamp.math.FloatUtil;
import com.jogamp.math.Vec2f;
import com.jogamp.math.Vec3f;
import com.jogamp.math.geom.AABBox;
import com.jogamp.math.util.PMVMatrix4f;
import java.util.List;

public class GridLayout
implements Group.Layout {
    private final Order order;
    private final int col_limit;
    private final int row_limit;
    private final Vec2f cellSize;
    private final Alignment alignment;
    private final Gap gap;
    private final Padding padding;
    private int row_count;
    private int col_count;
    private static final boolean TRACE_LAYOUT = false;

    public GridLayout(int n, float f, float f2, Alignment alignment) {
        this(alignment, Math.max(1, n), -1, f, f2, Gap.None, null);
    }

    public GridLayout(int n, float f, float f2, Alignment alignment, Gap gap) {
        this(alignment, Math.max(1, n), -1, f, f2, gap, null);
    }

    public GridLayout(int n, float f, float f2, Alignment alignment, Gap gap, Padding padding) {
        this(alignment, Math.max(1, n), -1, f, f2, gap, padding);
    }

    public GridLayout(float f, float f2, Alignment alignment, int n) {
        this(alignment, -1, Math.max(1, n), f, f2, Gap.None, null);
    }

    public GridLayout(float f, float f2, Alignment alignment, Gap gap, int n) {
        this(alignment, -1, Math.max(1, n), f, f2, gap, null);
    }

    public GridLayout(float f, float f2, Alignment alignment, Gap gap, Padding padding, int n) {
        this(alignment, -1, Math.max(1, n), f, f2, gap, padding);
    }

    private GridLayout(Alignment alignment, int n, int n2, float f, float f2, Gap gap, Padding padding) {
        this.order = 0 < n ? Order.COLUMN : Order.ROW;
        this.col_limit = n;
        this.row_limit = n2;
        this.cellSize = new Vec2f(Math.max(0.0f, f), Math.max(0.0f, f2));
        this.alignment = alignment;
        this.gap = gap;
        this.padding = padding;
        this.row_count = 0;
        this.col_count = 0;
    }

    public Order getOrder() {
        return this.order;
    }

    public int getColumnCount() {
        return this.col_count;
    }

    public int getRowCount() {
        return this.row_count;
    }

    public Vec2f getCellSize() {
        return this.cellSize;
    }

    public Alignment getAlignment() {
        return this.alignment;
    }

    public Gap getGap() {
        return this.gap;
    }

    public Padding getPadding() {
        return this.padding;
    }

    @Override
    public void preValidate(Shape shape) {
        if (null != this.padding) {
            shape.setPaddding(this.padding);
        }
    }

    @Override
    public void layout(Group group, AABBox aABBox, PMVMatrix4f pMVMatrix4f) {
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        float f6;
        float f7;
        float f8;
        float f9;
        AABBox aABBox2;
        Shape shape;
        int n;
        boolean bl = !FloatUtil.isZero((float)this.cellSize.x());
        boolean bl2 = !FloatUtil.isZero((float)this.cellSize.y());
        boolean bl3 = bl && this.alignment.isSet(Alignment.Bit.CenterHoriz);
        boolean bl4 = bl2 && this.alignment.isSet(Alignment.Bit.CenterVert);
        boolean bl5 = this.alignment.isSet(Alignment.Bit.Fill) && (bl || bl2);
        List<Shape> list = group.getShapes();
        if (Order.COLUMN == this.order) {
            this.row_count = (int)Math.ceil((double)list.size() / (double)this.col_limit);
            this.col_count = this.col_limit;
        } else {
            this.row_count = this.row_limit;
            this.col_count = (int)Math.ceil((double)list.size() / (double)this.row_limit);
        }
        int n2 = 0;
        int n3 = 0;
        float f10 = 0.0f;
        float f11 = 0.0f;
        float f12 = -3.4028235E38f;
        float f13 = -3.4028235E38f;
        AABBox[] aABBoxArray = new AABBox[list.size()];
        float[] fArray = new float[this.col_count * this.row_count];
        for (n = 0; n < list.size(); ++n) {
            shape = list.get(n);
            pMVMatrix4f.pushMv();
            shape.applyMatToMv(pMVMatrix4f);
            aABBox2 = shape.getBounds().transform(pMVMatrix4f.getMv(), new AABBox());
            pMVMatrix4f.popMv();
            f9 = aABBox2.getWidth();
            f8 = aABBox2.getHeight();
            if (FloatUtil.isZero((float)f8) || FloatUtil.isZero((float)f8)) continue;
            aABBoxArray[n] = aABBox2;
            if (bl5) {
                f7 = bl ? this.cellSize.x() : f9;
                f6 = bl2 ? this.cellSize.y() : f8;
                f5 = f7 / f9;
                f4 = f6 / f8;
                f3 = f5 < f4 ? f5 : f4;
            } else {
                f3 = 1.0f;
            }
            f7 = f3 * f9;
            f6 = f3 * f8;
            f5 = bl ? this.cellSize.x() : f7;
            f4 = bl2 ? this.cellSize.y() : f6;
            f2 = f11 + f4;
            f = f10 + f5;
            f13 = Math.max(f13, f2);
            f12 = Math.max(f12, f);
            fArray[this.col_count * n3 + n2] = f2;
            if (n + 1 >= list.size()) continue;
            if (Order.COLUMN == this.order) {
                if (n2 + 1 == this.col_count) {
                    n2 = 0;
                    ++n3;
                    f10 = 0.0f;
                    f11 += f4 + this.gap.height();
                    continue;
                }
                ++n2;
                f10 += f5 + this.gap.width();
                continue;
            }
            if (n3 + 1 == this.row_count) {
                n3 = 0;
                ++n2;
                f11 = 0.0f;
                f10 += f5 + this.gap.width();
                continue;
            }
            ++n3;
            f11 += f4 + this.gap.height();
        }
        n3 = 0;
        n2 = 0;
        f10 = 0.0f;
        f11 = 0.0f;
        for (n = 0; n < list.size(); ++n) {
            shape = list.get(n);
            aABBox2 = aABBoxArray[n];
            if (null == aABBox2) continue;
            f9 = aABBox2.getWidth();
            f8 = aABBox2.getHeight();
            f7 = 0.0f;
            f6 = 0.0f;
            if (bl5) {
                f5 = bl ? this.cellSize.x() : f9;
                f4 = bl2 ? this.cellSize.y() : f8;
                f2 = f5 / f9;
                f = f4 / f8;
                f3 = f2 < f ? f2 : f;
            } else {
                f3 = 1.0f;
            }
            f5 = f3 * f9;
            f4 = f3 * f8;
            f2 = bl ? this.cellSize.x() : f5;
            f = bl2 ? this.cellSize.y() : f4;
            f11 = f13 - fArray[this.col_count * n3 + n2];
            if (bl3) {
                f7 += 0.5f * (f2 - f5);
            }
            if (bl4) {
                f6 += 0.5f * (f - f4);
            }
            float f14 = f10 + f7;
            float f15 = f11 + f6;
            shape.moveTo(f14, f15, shape.getPosition().z());
            Vec3f vec3f = new Vec3f(shape.getBounds().getLow());
            vec3f.setZ(0.0f);
            if (bl3 || bl4) {
                if (!bl4 && vec3f.y() > 0.0f) {
                    vec3f.setY(0.0f);
                } else if (!bl3 && vec3f.x() > 0.0f) {
                    vec3f.setX(0.0f);
                }
                vec3f.mul(shape.getScale()).scale(-1.0f);
            } else {
                vec3f.min(new Vec3f()).mul(shape.getScale()).scale(-1.0f);
            }
            shape.move(vec3f.scale(f3));
            aABBox.resize(f10, f11, aABBox2.getMinZ());
            aABBox.resize(f10 + f2, f11 + f, aABBox2.getMaxZ());
            shape.scale(f3, f3, 1.0f);
            if (n + 1 >= list.size()) continue;
            if (Order.COLUMN == this.order) {
                if (n2 + 1 == this.col_count) {
                    n2 = 0;
                    ++n3;
                    f10 = 0.0f;
                    continue;
                }
                ++n2;
                f10 += f2 + this.gap.width();
                continue;
            }
            if (n3 + 1 == this.row_count) {
                n3 = 0;
                ++n2;
                f11 = 0.0f;
                f10 += f2 + this.gap.width();
                continue;
            }
            ++n3;
        }
        if (Float.isInfinite(aABBox.getWidth()) || Float.isInfinite(aABBox.getHeight())) {
            aABBox.resize(0.0f, 0.0f, 0.0f);
        }
    }

    public String toString() {
        String string = null == this.padding || this.padding.zeroSize() ? "" : ", " + this.padding.toString();
        String string2 = this.gap.zeroSumSize() ? "" : ", " + this.gap.toString();
        return "Grid[" + this.col_count + "x" + this.row_count + ", " + (Object)((Object)this.order) + ", cell " + this.cellSize + ", a " + this.alignment + string2 + string + "]";
    }

    public static enum Order {
        COLUMN,
        ROW;

    }
}

