/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.graph.ui.shapes;

import com.jogamp.graph.curve.OutlineShape;
import com.jogamp.graph.curve.Region;
import com.jogamp.graph.font.Font;
import com.jogamp.graph.ui.GraphShape;
import com.jogamp.math.Vec3f;
import com.jogamp.math.geom.AABBox;
import com.jogamp.math.geom.plane.AffineTransform;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLProfile;
import java.util.List;

public class GlyphShape
extends GraphShape {
    private final Font.Glyph glyph;
    private final int regionVertCount;
    private final int regionIdxCount;
    private final Vec3f origPos;

    public GlyphShape(int n, Font.Glyph glyph, float f, float f2) {
        super(n);
        this.glyph = glyph;
        this.origPos = new Vec3f(f, f2, 0.0f);
        if (glyph.isNonContour()) {
            this.setVisible(false);
        }
        int[] nArray = Region.countOutlineShape((OutlineShape)glyph.getShape(), (int[])new int[2]);
        this.regionVertCount = nArray[0];
        this.regionIdxCount = nArray[1];
    }

    public GlyphShape(int n, Font.Glyph glyph, Vec3f vec3f) {
        this(n, glyph, vec3f.x(), vec3f.y());
    }

    public GlyphShape(int n, Font font, char c, float f, float f2) {
        this(n, font.getGlyph(c), f, f2);
    }

    public GlyphShape(GlyphShape glyphShape) {
        this(glyphShape.renderModes, glyphShape.glyph, glyphShape.origPos);
    }

    public Font.Glyph getGlyph() {
        return this.glyph;
    }

    public Font getFont() {
        return this.glyph.getFont();
    }

    public Vec3f getOrigPos() {
        return this.origPos;
    }

    public float getLineHeight() {
        return this.glyph.getFont().getLineHeight();
    }

    public static final AABBox processString(final List<GlyphShape> list, final int n, Font font, CharSequence charSequence) {
        Font.GlyphVisitor glyphVisitor = new Font.GlyphVisitor(){

            public void visit(Font.Glyph glyph, AffineTransform affineTransform) {
                if (!glyph.isNonContour()) {
                    list.add(new GlyphShape(n, glyph, affineTransform.getTranslateX(), affineTransform.getTranslateY()));
                }
            }
        };
        return font.processString(glyphVisitor, null, charSequence, new AffineTransform(), new AffineTransform());
    }

    @Override
    protected void addShapeToRegion(GLProfile gLProfile, GL2ES2 gL2ES2) {
        OutlineShape outlineShape = this.glyph.getShape();
        this.box.reset();
        if (null != outlineShape) {
            AABBox aABBox = outlineShape.getBounds();
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.setToTranslation(-aABBox.getMinX(), -aABBox.getMinY() + this.glyph.getBounds().getMinY());
            outlineShape.setSharpness(this.oshapeSharpness);
            this.resetGLRegion(gLProfile, gL2ES2, null, this.regionVertCount, this.regionIdxCount);
            this.region.addOutlineShape(outlineShape, affineTransform, this.rgbaColor);
            this.box.resize(affineTransform.transform(aABBox, new AABBox()));
            this.setRotationPivot(this.box.getCenter());
        } else {
            this.resetGLRegion(gLProfile, gL2ES2, null, this.regionVertCount, this.regionIdxCount);
        }
    }

    @Override
    public String getSubString() {
        return super.getSubString() + ", origPos " + this.origPos.x() + " / " + this.origPos.y() + ", cp 0x" + Integer.toHexString(this.glyph.getCodepoint());
    }
}

