/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.graph.ui.shapes;

import com.jogamp.graph.curve.OutlineShape;
import com.jogamp.graph.ui.GraphShape;
import com.jogamp.math.FloatUtil;
import com.jogamp.math.geom.AABBox;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLProfile;

public class Rectangle
extends GraphShape {
    private float minX;
    private float minY;
    private float zPos;
    private float width;
    private float height;
    private float lineWidth;

    public Rectangle(int n, float f, float f2, float f3, float f4, float f5, float f6) {
        super(n);
        this.minX = f;
        this.minY = f2;
        this.zPos = f6;
        this.width = f3;
        this.height = f4;
        this.lineWidth = f5;
    }

    public Rectangle(int n, AABBox aABBox, float f) {
        this(n, aABBox.getMinX(), aABBox.getMinY(), aABBox.getWidth(), aABBox.getHeight(), f, aABBox.getCenter().z());
    }

    public Rectangle(int n, float f, float f2, float f3, float f4, float f5) {
        this(n, f, f2, f3, f4, f5, 0.0f);
    }

    public Rectangle(int n, float f, float f2, float f3) {
        this(n, 0.0f, 0.0f, f, f2, f3, 0.0f);
    }

    public final float getX() {
        return this.minX;
    }

    public final float getY() {
        return this.minY;
    }

    public final float getZ() {
        return this.zPos;
    }

    public final float getWidth() {
        return this.width;
    }

    public final float getHeight() {
        return this.height;
    }

    public final float getLineWidth() {
        return this.lineWidth;
    }

    public void setPosition(float f, float f2, float f3) {
        this.minX = f;
        this.minY = f2;
        this.zPos = f3;
        this.markShapeDirty();
    }

    public void setDimension(float f, float f2, float f3) {
        if (this.width != f || this.height != f2 || this.lineWidth != f3) {
            this.width = f;
            this.height = f2;
            this.lineWidth = f3;
            this.markShapeDirty();
        }
    }

    public void setBounds(AABBox aABBox, float f) {
        this.setPosition(aABBox.getMinX(), aABBox.getMinY(), aABBox.getCenter().z());
        this.setDimension(aABBox.getWidth(), aABBox.getHeight(), f);
    }

    @Override
    protected void addShapeToRegion(GLProfile gLProfile, GL2ES2 gL2ES2) {
        OutlineShape outlineShape = new OutlineShape();
        float f = this.minX;
        float f2 = this.minY;
        float f3 = this.minX + this.getWidth();
        float f4 = this.minY + this.getHeight();
        float f5 = this.zPos;
        outlineShape.moveTo(f, f2, f5);
        outlineShape.lineTo(f3, f2, f5);
        outlineShape.lineTo(f3, f4, f5);
        outlineShape.lineTo(f, f4, f5);
        outlineShape.lineTo(f, f2, f5);
        outlineShape.closeLastOutline(true);
        if (!FloatUtil.isZero((float)this.lineWidth)) {
            outlineShape.addEmptyOutline();
            float f6 = this.lineWidth;
            outlineShape.moveTo(f + f6, f2 + f6, f5);
            outlineShape.lineTo(f + f6, f4 - f6, f5);
            outlineShape.lineTo(f3 - f6, f4 - f6, f5);
            outlineShape.lineTo(f3 - f6, f2 + f6, f5);
            outlineShape.lineTo(f + f6, f2 + f6, f5);
            outlineShape.closeLastOutline(true);
        }
        outlineShape.setIsQuadraticNurbs();
        outlineShape.setSharpness(this.oshapeSharpness);
        this.resetGLRegion(gLProfile, gL2ES2, null, outlineShape);
        this.region.addOutlineShape(outlineShape, null, this.rgbaColor);
        this.box.resize(outlineShape.getBounds());
        this.setRotationPivot(this.box.getCenter());
    }

    @Override
    public String getSubString() {
        return super.getSubString() + ", dim " + this.getWidth() + " x " + this.getHeight();
    }
}

