/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.openal.test.junit;

import com.jogamp.common.util.VersionNumber;
import com.jogamp.openal.ALC;
import com.jogamp.openal.ALCcontext;
import com.jogamp.openal.ALCdevice;
import com.jogamp.openal.ALFactory;
import com.jogamp.openal.ALVersion;
import com.jogamp.openal.JoalVersion;
import com.jogamp.openal.test.util.UITestCase;
import java.io.IOException;
import org.junit.After;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class ALVersionTest
extends UITestCase {
    private static final String OpenALVendor = "OpenAL Community";
    private static final String OpenALRenderer = "OpenAL Soft";
    private static final VersionNumber ALVersion11 = new VersionNumber(1, 1, 0);
    private static final VersionNumber OpenALVersion1230 = new VersionNumber(1, 23, 0);

    @Test
    public void test01ALVersion() {
        ALVersion aLVersion = new ALVersion(ALFactory.getALC());
        int n = aLVersion.getVersion().compareTo(ALVersion11);
        int n2 = aLVersion.getVendorVersion().compareTo(OpenALVersion1230);
        System.out.println("ALVersion: " + aLVersion.toString() + ", version >= 1.1: " + n + ", vendorVersion >= 1.23.0: " + n2);
        Assert.assertEquals((Object)OpenALVendor, (Object)aLVersion.getVendor());
        Assert.assertEquals((Object)OpenALRenderer, (Object)aLVersion.getRenderer());
        Assert.assertTrue((n >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((n2 >= 0 ? 1 : 0) != 0);
    }

    @Test
    public void test02JoalVersion() {
        JoalVersion joalVersion = JoalVersion.getInstance();
        System.err.println(joalVersion.toString(ALFactory.getALC()));
    }

    @Test
    public void test03JoalVersionMustNoChangeContextAndDeviceUsed() {
        ALC aLC = ALFactory.getALC();
        ALCdevice aLCdevice = aLC.alcOpenDevice(null);
        ALCcontext aLCcontext = aLC.alcCreateContext(aLCdevice, null);
        aLC.alcMakeContextCurrent(aLCcontext);
        JoalVersion joalVersion = JoalVersion.getInstance();
        System.err.println(joalVersion.toString(aLC));
        ALCcontext aLCcontext2 = aLC.alcGetCurrentContext();
        Assert.assertNotNull((Object)aLCcontext2);
        Assert.assertEquals((long)aLCcontext.getDirectBufferAddress(), (long)aLCcontext2.getDirectBufferAddress());
        ALCdevice aLCdevice2 = aLC.alcGetContextsDevice(aLCcontext2);
        Assert.assertNotNull((Object)aLCdevice2);
        Assert.assertEquals((long)aLCdevice.getDirectBufferAddress(), (long)aLCdevice2.getDirectBufferAddress());
    }

    @Test
    public void test04JoalVersionMustNotSetAdditionalContext() {
        ALC aLC = ALFactory.getALC();
        JoalVersion joalVersion = JoalVersion.getInstance();
        System.err.println(joalVersion.toString(aLC));
        ALCcontext aLCcontext = aLC.alcGetCurrentContext();
        Assert.assertNull((Object)aLCcontext);
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
        ALC aLC = ALFactory.getALC();
        ALCcontext aLCcontext = aLC.alcGetCurrentContext();
        if (null != aLCcontext) {
            aLC.alcDestroyContext(aLCcontext);
            ALCdevice aLCdevice = aLC.alcGetContextsDevice(aLCcontext);
            if (null != aLCdevice) {
                aLC.alcCloseDevice(aLCdevice);
            }
        }
    }

    public static void main(String[] stringArray) throws IOException {
        JUnitCore.main((String[])new String[]{ALVersionTest.class.getName()});
    }
}

