/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util.stereo;

import com.jogamp.common.util.ReflectionUtil;
import com.jogamp.nativewindow.NativeWindowFactory;
import com.jogamp.opengl.util.stereo.StereoDevice;
import com.jogamp.opengl.util.stereo.StereoDeviceConfig;
import com.jogamp.opengl.util.stereo.generic.GenericStereoDeviceFactory;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

public abstract class StereoDeviceFactory {
    private static final String OVRStereoDeviceClazzName = "jogamp.opengl.oculusvr.OVRStereoDeviceFactory";
    private static final String GenericStereoDeviceClazzName = GenericStereoDeviceFactory.class.getName();
    private static final String isAvailableMethodName = "isAvailable";
    private static final ArrayList<WeakReference<StereoDeviceFactory>> factoryList;
    private static final ArrayList<WeakReference<StereoDevice>> deviceList;

    public static StereoDeviceFactory createDefaultFactory() {
        ClassLoader classLoader = StereoDeviceFactory.class.getClassLoader();
        StereoDeviceFactory stereoDeviceFactory = StereoDeviceFactory.createFactory(classLoader, OVRStereoDeviceClazzName);
        if (null == stereoDeviceFactory) {
            stereoDeviceFactory = StereoDeviceFactory.createFactory(classLoader, GenericStereoDeviceClazzName);
        }
        return stereoDeviceFactory;
    }

    public static StereoDeviceFactory createFactory(DeviceType deviceType) {
        String string;
        switch (deviceType.ordinal()) {
            case 0: {
                return StereoDeviceFactory.createDefaultFactory();
            }
            case 1: {
                string = GenericStereoDeviceClazzName;
                break;
            }
            case 2: {
                string = OVRStereoDeviceClazzName;
                break;
            }
            default: {
                throw new InternalError("Unsupported type " + (Object)((Object)deviceType));
            }
        }
        ClassLoader classLoader = StereoDeviceFactory.class.getClassLoader();
        return StereoDeviceFactory.createFactory(classLoader, string);
    }

    public static StereoDeviceFactory createFactory(ClassLoader classLoader, String string) {
        StereoDeviceFactory stereoDeviceFactory;
        block4: {
            stereoDeviceFactory = null;
            try {
                if (((Boolean)ReflectionUtil.callStaticMethod(string, isAvailableMethodName, null, null, classLoader)).booleanValue()) {
                    stereoDeviceFactory = (StereoDeviceFactory)ReflectionUtil.createInstance(string, classLoader);
                }
            }
            catch (Throwable throwable) {
                if (!StereoDevice.DEBUG) break block4;
                System.err.println("Caught " + throwable.getClass().getName() + ": " + throwable.getMessage());
                throwable.printStackTrace();
            }
        }
        if (null != stereoDeviceFactory) {
            StereoDeviceFactory.addFactory2List(stereoDeviceFactory);
        }
        return stereoDeviceFactory;
    }

    public final StereoDevice createDevice(int n, StereoDeviceConfig stereoDeviceConfig, boolean bl) {
        StereoDevice stereoDevice = this.createDeviceImpl(n, stereoDeviceConfig, bl);
        if (null != stereoDevice) {
            StereoDeviceFactory.addDevice2List(stereoDevice);
        }
        return stereoDevice;
    }

    protected abstract StereoDevice createDeviceImpl(int var1, StereoDeviceConfig var2, boolean var3);

    public abstract boolean isValid();

    public abstract void shutdown();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addFactory2List(StereoDeviceFactory stereoDeviceFactory) {
        ArrayList<WeakReference<StereoDeviceFactory>> arrayList = factoryList;
        synchronized (arrayList) {
            int n = 0;
            while (n < factoryList.size()) {
                if (null == factoryList.get(n).get()) {
                    factoryList.remove(n);
                    continue;
                }
                ++n;
            }
            factoryList.add(new WeakReference<StereoDeviceFactory>(stereoDeviceFactory));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addDevice2List(StereoDevice stereoDevice) {
        ArrayList<WeakReference<StereoDevice>> arrayList = deviceList;
        synchronized (arrayList) {
            int n = 0;
            while (n < deviceList.size()) {
                if (null == deviceList.get(n).get()) {
                    deviceList.remove(n);
                    continue;
                }
                ++n;
            }
            deviceList.add(new WeakReference<StereoDevice>(stereoDevice));
        }
    }

    private static final void shutdownAll() {
        StereoDeviceFactory.shutdownDevices();
        StereoDeviceFactory.shutdownFactories();
    }

    private static final void shutdownFactories() {
        while (0 < factoryList.size()) {
            StereoDeviceFactory stereoDeviceFactory = (StereoDeviceFactory)factoryList.remove(0).get();
            if (null == stereoDeviceFactory || !stereoDeviceFactory.isValid()) continue;
            stereoDeviceFactory.shutdown();
        }
    }

    private static final void shutdownDevices() {
        while (0 < deviceList.size()) {
            StereoDevice stereoDevice = (StereoDevice)deviceList.remove(0).get();
            if (null == stereoDevice || !stereoDevice.isValid()) continue;
            stereoDevice.dispose();
        }
    }

    static {
        NativeWindowFactory.addCustomShutdownHook(false, new Runnable(){

            @Override
            public void run() {
                StereoDeviceFactory.shutdownAll();
            }
        });
        factoryList = new ArrayList();
        deviceList = new ArrayList();
    }

    public static enum DeviceType {
        Default,
        Generic,
        OculusVR,
        OculusVR_DK2;

    }
}

