/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font;

import com.jogamp.common.net.Uri;
import com.jogamp.common.util.IntObjectHashMap;
import com.jogamp.graph.font.Font;
import com.jogamp.graph.font.FontSet;
import java.io.IOException;
import jogamp.graph.font.FontLoaderImpl;

public class UbuntuFontLoader
extends FontLoaderImpl
implements FontSet {
    private static final IntObjectHashMap fontMap = new IntObjectHashMap();
    private static final Uri.Encoded jarName = Uri.Encoded.cast("jogl-fonts-p0.jar");
    private static final String absFontPath = "jogamp/graph/font/fonts/ubuntu/";
    private static final FontSet fontLoader = new UbuntuFontLoader();
    static final String[] availableFontFileNames = new String[]{"Ubuntu-R.ttf", "Ubuntu-RI.ttf", "Ubuntu-B.ttf", "Ubuntu-BI.ttf", "Ubuntu-L.ttf", "Ubuntu-LI.ttf", "Ubuntu-M.ttf", "Ubuntu-MI.ttf"};

    public static final FontSet get() {
        return fontLoader;
    }

    private UbuntuFontLoader() {
    }

    @Override
    public Font getDefault() throws IOException {
        return this.get(0, 0);
    }

    @Override
    public synchronized Font get(int n, int n2) throws IOException {
        Font font = (Font)fontMap.get(n << 8 | n2);
        if (font != null) {
            return font;
        }
        switch (n) {
            case 0: 
            case 3: 
            case 4: {
                if (UbuntuFontLoader.isOneSet(n2, 4)) {
                    if (UbuntuFontLoader.isOneSet(n2, 8)) {
                        font = this.readFont(availableFontFileNames[3], jarName, absFontPath);
                        break;
                    }
                    font = this.readFont(availableFontFileNames[2], jarName, absFontPath);
                    break;
                }
                if (UbuntuFontLoader.isOneSet(n2, 8)) {
                    font = this.readFont(availableFontFileNames[1], jarName, absFontPath);
                    break;
                }
                font = this.readFont(availableFontFileNames[0], jarName, absFontPath);
                break;
            }
            case 1: {
                if (UbuntuFontLoader.isOneSet(n2, 8)) {
                    font = this.readFont(availableFontFileNames[5], jarName, absFontPath);
                    break;
                }
                font = this.readFont(availableFontFileNames[4], jarName, absFontPath);
                break;
            }
            case 2: {
                font = UbuntuFontLoader.isOneSet(n2, 8) ? this.readFont(availableFontFileNames[6], jarName, absFontPath) : this.readFont(availableFontFileNames[7], jarName, absFontPath);
            }
        }
        if (null != font) {
            fontMap.put(n << 8 | n2, font);
        }
        return font;
    }
}

