/*
 * Decompiled with CFR 0.152.
 */
package jogamp.newt.driver.x11;

import com.jogamp.common.util.ArrayHashSet;
import com.jogamp.common.util.PropertyAccess;
import com.jogamp.common.util.VersionNumber;
import com.jogamp.nativewindow.AbstractGraphicsDevice;
import com.jogamp.nativewindow.util.Rectangle;
import com.jogamp.nativewindow.util.RectangleImmutable;
import com.jogamp.nativewindow.x11.X11GraphicsDevice;
import com.jogamp.nativewindow.x11.X11GraphicsScreen;
import com.jogamp.newt.MonitorDevice;
import com.jogamp.newt.MonitorMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import jogamp.nativewindow.SurfaceScaleUtils;
import jogamp.nativewindow.x11.X11Util;
import jogamp.newt.Debug;
import jogamp.newt.DisplayImpl;
import jogamp.newt.MonitorModeProps;
import jogamp.newt.ScreenImpl;
import jogamp.newt.driver.x11.DisplayDriver;
import jogamp.newt.driver.x11.RandR;
import jogamp.newt.driver.x11.RandR11;
import jogamp.newt.driver.x11.RandR13;

public class ScreenDriver
extends ScreenImpl {
    protected static final boolean DEBUG_TEST_RANDR13_DISABLED;
    protected static final float[] global_pixel_scale;
    protected static final Map<String, float[]> monitor_pixel_scale_map;
    protected static final boolean global_pixel_scale_set;
    protected static final boolean monitor_pixel_scale_map_set;
    private VersionNumber randrVersion;
    private RandR rAndR;
    private final DisplayImpl.DisplayRunnable<Boolean> xineramaEnabledQueryWithTemp = new DisplayImpl.DisplayRunnable<Boolean>(){

        public Boolean run(long l) {
            return X11Util.XineramaIsEnabled((long)l);
        }
    };

    static void initSingleton() {
    }

    protected void createNativeImpl() {
        Long l = this.runWithLockedDisplayDevice(new DisplayImpl.DisplayRunnable<Long>(){

            public Long run(long l) {
                return ScreenDriver.GetScreen0(l, ScreenDriver.this.screen_idx);
            }
        });
        if (l == 0L) {
            throw new RuntimeException("Error creating screen: " + this.screen_idx);
        }
        X11GraphicsDevice x11GraphicsDevice = (X11GraphicsDevice)this.getDisplay().getGraphicsDevice();
        long l2 = x11GraphicsDevice.getHandle();
        this.aScreen = new X11GraphicsScreen(x11GraphicsDevice, this.screen_idx);
        int[] nArray = ScreenDriver.getRandRVersion0(l2);
        this.randrVersion = new VersionNumber(nArray[0], nArray[1], 0);
        this.rAndR = !DEBUG_TEST_RANDR13_DISABLED && this.randrVersion.compareTo(RandR.version130) >= 0 ? new RandR13(this.randrVersion) : (this.randrVersion.compareTo(RandR.version110) >= 0 ? new RandR11(this.randrVersion) : null);
        ((DisplayDriver)this.display).registerRandR(this.rAndR);
        if (DEBUG) {
            System.err.println("Using " + this.rAndR);
            this.rAndR.dumpInfo(l2, this.screen_idx);
        }
    }

    protected void closeNativeImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void collectNativeMonitorModesAndDevicesImpl(MonitorModeProps.Cache cache) {
        block15: {
            if (null == this.rAndR) {
                return;
            }
            AbstractGraphicsDevice abstractGraphicsDevice = this.getDisplay().getGraphicsDevice();
            abstractGraphicsDevice.lock();
            try {
                if (!this.rAndR.beginInitialQuery(abstractGraphicsDevice.getHandle(), this)) break block15;
                try {
                    int[] nArray;
                    int n;
                    int[] nArray2 = this.rAndR.getMonitorDeviceIds(abstractGraphicsDevice.getHandle(), this);
                    int n2 = null != nArray2 ? nArray2.length : 0;
                    ArrayHashSet arrayHashSet = new ArrayHashSet(false, 16, 0.75f);
                    for (n = 0; n < n2; ++n) {
                        nArray = this.rAndR.getAvailableRotations(abstractGraphicsDevice.getHandle(), this, nArray2[n]);
                        if (null == nArray) continue;
                        ArrayList<Integer> arrayList = new ArrayList<Integer>(nArray.length);
                        for (int i = 0; i < nArray.length; ++i) {
                            arrayList.add(nArray[i]);
                        }
                        arrayHashSet.addAll(arrayList);
                    }
                    n = 0;
                    do {
                        if (null == (nArray = this.rAndR.getMonitorModeProps(abstractGraphicsDevice.getHandle(), this, n++))) continue;
                        for (int i = 0; i < arrayHashSet.size(); ++i) {
                            nArray[7] = (Integer)arrayHashSet.get(i);
                            MonitorModeProps.streamInMonitorMode(null, (MonitorModeProps.Cache)cache, (int[])nArray, (int)0);
                        }
                    } while (null != nArray);
                    if (cache.monitorModes.size() > 0) {
                        for (n = 0; n < n2; ++n) {
                            int n3 = nArray2[n];
                            int[] nArray3 = this.rAndR.getMonitorDeviceProps(abstractGraphicsDevice.getHandle(), this, cache, n3);
                            String string = this.rAndR.getMonitorName(abstractGraphicsDevice.getHandle(), this, n3);
                            if (null == nArray3 || 17 > nArray3[0] || 17 > nArray3.length) continue;
                            float[] fArray = null;
                            if (monitor_pixel_scale_map_set && null != string && !string.isEmpty()) {
                                fArray = monitor_pixel_scale_map.get(string);
                            }
                            if (null == fArray && global_pixel_scale_set) {
                                fArray = global_pixel_scale;
                            }
                            MonitorModeProps.streamInMonitorDevice((MonitorModeProps.Cache)cache, (ScreenImpl)this, (long)n3, (String)string, (float[])fArray, (boolean)true, (int[])nArray3, (int)0, null);
                        }
                    }
                }
                finally {
                    this.rAndR.endInitialQuery(abstractGraphicsDevice.getHandle(), this);
                }
            }
            finally {
                abstractGraphicsDevice.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean updateNativeMonitorDeviceViewportImpl(MonitorDevice monitorDevice, float[] fArray, Rectangle rectangle, Rectangle rectangle2) {
        AbstractGraphicsDevice abstractGraphicsDevice = this.getDisplay().getGraphicsDevice();
        abstractGraphicsDevice.lock();
        try {
            int[] nArray = this.rAndR.getMonitorDeviceViewport(abstractGraphicsDevice.getHandle(), this, monitorDevice.getId());
            if (null != nArray) {
                rectangle.set(nArray[0], nArray[1], nArray[2], nArray[3]);
                rectangle2.set(nArray[0], nArray[1], nArray[2], nArray[3]);
                rectangle2.scaleInv(fArray[0], fArray[1]);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            abstractGraphicsDevice.unlock();
        }
    }

    protected MonitorMode queryCurrentMonitorModeImpl(final MonitorDevice monitorDevice) {
        if (null == this.rAndR) {
            return null;
        }
        return this.runWithLockedDisplayDevice(new DisplayImpl.DisplayRunnable<MonitorMode>(){

            public MonitorMode run(long l) {
                int[] nArray = ScreenDriver.this.rAndR.getCurrentMonitorModeProps(l, ScreenDriver.this, monitorDevice.getId());
                if (null != nArray) {
                    return MonitorModeProps.streamInMonitorMode(null, null, (int[])nArray, (int)0);
                }
                return null;
            }
        });
    }

    protected boolean setCurrentMonitorModeImpl(final MonitorDevice monitorDevice, final MonitorMode monitorMode) {
        if (null == this.rAndR) {
            return false;
        }
        long l = System.currentTimeMillis();
        boolean bl = this.runWithLockedDisplayDevice(new DisplayImpl.DisplayRunnable<Boolean>(){

            public Boolean run(long l) {
                return ScreenDriver.this.rAndR.setCurrentMonitorModeStart(l, ScreenDriver.this, monitorDevice, monitorMode);
            }
        });
        boolean bl2 = bl ? this.rAndR.setCurrentMonitorModeWait(this) : false;
        if (DEBUG || !bl2) {
            System.err.println("X11Screen.setCurrentMonitorModeImpl: " + (bl2 ? " OK" : "NOK") + " (started " + bl + "): t/TO " + (System.currentTimeMillis() - l) + "/" + 10000 + "ms; " + monitorDevice.getCurrentMode() + " -> " + monitorMode);
        }
        return bl2;
    }

    protected int validateScreenIndex(int n) {
        DisplayDriver displayDriver = (DisplayDriver)this.getDisplay();
        Boolean bl = displayDriver.isXineramaEnabled();
        if (null != bl) {
            return bl != false ? 0 : n;
        }
        return this.runWithTempDisplayHandle(this.xineramaEnabledQueryWithTemp) != false ? 0 : n;
    }

    protected void calcVirtualScreenOriginAndSize(final Rectangle rectangle, final Rectangle rectangle2) {
        RectangleImmutable rectangleImmutable = DEBUG ? (RectangleImmutable)this.getViewport().cloneMutable() : null;
        this.runWithLockedDisplayDevice(new DisplayImpl.DisplayRunnable<Object>(){

            public Object run(long l) {
                rectangle.set(0, 0, ScreenDriver.getWidth0(l, ScreenDriver.this.screen_idx), ScreenDriver.getHeight0(l, ScreenDriver.this.screen_idx));
                rectangle2.set((RectangleImmutable)rectangle);
                return null;
            }
        });
        if (DEBUG) {
            System.err.println("X11Screen.calcVirtualScreenOriginAndSize: Querying X11: " + rectangleImmutable + " -> " + rectangle);
        }
    }

    private final <T> T runWithLockedDisplayDevice(DisplayImpl.DisplayRunnable<T> displayRunnable) {
        return (T)this.display.runWithLockedDisplayDevice(displayRunnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T runWithTempDisplayHandle(DisplayImpl.DisplayRunnable<T> displayRunnable) {
        Object object;
        long l = X11Util.openDisplay((String)this.display.getName());
        if (0L == l) {
            throw new RuntimeException("null device");
        }
        try {
            object = displayRunnable.run(l);
        }
        finally {
            X11Util.closeDisplay((long)l);
        }
        return (T)object;
    }

    private static native long GetScreen0(long var0, int var2);

    private static native int getWidth0(long var0, int var2);

    private static native int getHeight0(long var0, int var2);

    private static native int[] getRandRVersion0(long var0);

    static {
        global_pixel_scale = new float[]{0.0f, 0.0f};
        monitor_pixel_scale_map = new HashMap<String, float[]>();
        Debug.initSingleton();
        DEBUG_TEST_RANDR13_DISABLED = PropertyAccess.isPropertyDefined((String)"newt.test.Screen.disableRandR13", (boolean)true);
        String[] stringArray = new String[]{"QT_SCREEN_SCALE_FACTORS", "QT_SCALE_FACTOR", "GDK_SCALE", "SOFT_SCALE"};
        int n = -1;
        try {
            n = SurfaceScaleUtils.getPixelScaleEnv((String[])stringArray, (float[])global_pixel_scale, monitor_pixel_scale_map);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        if (0 <= n && n < stringArray.length) {
            global_pixel_scale_set = global_pixel_scale[0] != 0.0f && global_pixel_scale[1] != 0.0f;
            boolean bl = monitor_pixel_scale_map_set = !monitor_pixel_scale_map.isEmpty();
            if (DEBUG) {
                System.err.println("X11Screen: Env PixelScale: Env-Variable " + stringArray[n]);
                System.err.println("X11Screen: Env PixelScale: Global: Set " + global_pixel_scale_set + ", " + global_pixel_scale[0] + "/" + global_pixel_scale[1]);
                System.err.println("X11Screen: Env PixelScale: Map: Set " + monitor_pixel_scale_map_set + ", " + SurfaceScaleUtils.toString(monitor_pixel_scale_map));
            }
        } else {
            if (DEBUG) {
                System.err.println("X11Screen: Env PixelScale: None");
            }
            global_pixel_scale_set = false;
            monitor_pixel_scale_map_set = false;
        }
        DisplayDriver.initSingleton();
    }
}

