/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.junit.util;

import com.jogamp.common.util.locks.SingletonInstance;
import com.jogamp.junit.util.JunitTracer;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public abstract class SingletonJunitCase
extends JunitTracer {
    public static final String SINGLE_INSTANCE_LOCK_FILE = "SingletonTestCase.lock";
    public static final int SINGLE_INSTANCE_LOCK_PORT = 59999;
    public static final long SINGLE_INSTANCE_LOCK_TO = 900000L;
    public static final long SINGLE_INSTANCE_LOCK_POLL = 500L;
    private static SingletonInstance singletonInstance = null;
    private static final Object singletonSync = new Object();
    private static boolean enabled = true;

    public static final void enableSingletonLock(boolean bl) {
        enabled = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BeforeClass
    public static final void oneTimeSetUpSingleton() {
        Object object = singletonSync;
        synchronized (object) {
            if (enabled) {
                if (null == singletonInstance) {
                    System.err.println("++++ Test Singleton.ctor()");
                    singletonInstance = SingletonInstance.createServerSocket((long)500L, (int)59999);
                }
                System.err.println("++++ Test Singleton.lock()");
                if (!singletonInstance.tryLock(900000L)) {
                    throw new RuntimeException("Fatal: Could not lock single instance: " + singletonInstance.getName());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AfterClass
    public static final void oneTimeTearDownSingleton() {
        Object object = singletonSync;
        synchronized (object) {
            System.gc();
            if (enabled) {
                System.err.println("++++ Test Singleton.unlock()");
                singletonInstance.unlock();
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

