/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.nativewindow.x11;

import com.jogamp.nativewindow.DefaultGraphicsDevice;
import com.jogamp.nativewindow.NativeWindowException;
import com.jogamp.nativewindow.NativeWindowFactory;
import com.jogamp.nativewindow.ToolkitLock;
import jogamp.nativewindow.x11.X11Lib;
import jogamp.nativewindow.x11.X11Util;

public class X11GraphicsDevice
extends DefaultGraphicsDevice
implements Cloneable {
    final boolean isXineramaEnabled;

    public X11GraphicsDevice(String string, int n) {
        super(".x11", string, n);
        this.setHandleOwnership(false);
        this.isXineramaEnabled = false;
    }

    public X11GraphicsDevice(long l, int n, boolean bl) {
        this(l, n, NativeWindowFactory.getDefaultToolkitLock((String)".x11"), bl);
    }

    public X11GraphicsDevice(long l, int n, ToolkitLock toolkitLock, boolean bl) {
        super(".x11", X11Lib.XDisplayString(l), n, l, toolkitLock);
        if (0L == l) {
            throw new NativeWindowException("null display");
        }
        this.setHandleOwnership(bl);
        this.isXineramaEnabled = X11Util.XineramaIsEnabled(this);
    }

    public X11GraphicsDevice(String string, int n, ToolkitLock toolkitLock) {
        super(".x11", string, n, 0L, toolkitLock);
        this.setHandleOwnership(true);
        this.open();
        this.isXineramaEnabled = X11Util.XineramaIsEnabled(this);
    }

    private static int getDefaultScreenImpl(long l) {
        return X11Lib.DefaultScreen(l);
    }

    public int getDefaultScreen() {
        long l = this.getHandle();
        if (0L == l) {
            throw new NativeWindowException("null display");
        }
        int n = X11GraphicsDevice.getDefaultScreenImpl(l);
        if (DEBUG) {
            System.err.println(Thread.currentThread().getName() + " - X11GraphicsDevice.getDefaultDisplay() of " + this + ": " + n + ", count " + X11Lib.ScreenCount(l));
        }
        return n;
    }

    public int getDefaultVisualID() {
        long l = this.getHandle();
        if (0L == l) {
            throw new NativeWindowException("null display");
        }
        return X11Lib.DefaultVisualID(l, X11GraphicsDevice.getDefaultScreenImpl(l));
    }

    public final boolean isXineramaEnabled() {
        return this.isXineramaEnabled;
    }

    public Object clone() {
        return super.clone();
    }

    public boolean open() {
        if (this.isHandleOwner() && 0L == this.handle) {
            if (DEBUG) {
                System.err.println(Thread.currentThread().getName() + " - X11GraphicsDevice.open(): " + this);
            }
            this.handle = X11Util.openDisplay(this.connection);
            if (0L == this.handle) {
                throw new NativeWindowException("X11GraphicsDevice.open() failed: " + this);
            }
            return true;
        }
        return false;
    }

    public boolean close() {
        if (this.isHandleOwner() && 0L != this.handle) {
            if (DEBUG) {
                System.err.println(Thread.currentThread().getName() + " - X11GraphicsDevice.close(): " + this);
            }
            X11Util.closeDisplay(this.handle);
        }
        return super.close();
    }

    private boolean setHandleOwnership(boolean bl) {
        Boolean bl2 = (Boolean)this.getHandleOwnership();
        super.setHandleOwnership((Object)(bl ? Boolean.valueOf(true) : null));
        return null != bl2 ? bl2 : false;
    }
}

