/*
 * Decompiled with CFR 0.152.
 */
package jogamp.nativewindow.x11;

import com.jogamp.nativewindow.Capabilities;
import com.jogamp.nativewindow.NativeWindowException;
import com.jogamp.nativewindow.VisualIDHolder;
import jogamp.nativewindow.x11.XVisualInfo;

public class X11Capabilities
extends Capabilities {
    private final XVisualInfo xVisualInfo;

    public X11Capabilities(XVisualInfo xVisualInfo) {
        this.xVisualInfo = xVisualInfo;
    }

    public Object cloneMutable() {
        return this.clone();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (RuntimeException runtimeException) {
            throw new NativeWindowException((Throwable)runtimeException);
        }
    }

    public final XVisualInfo getXVisualInfo() {
        return this.xVisualInfo;
    }

    public final int getXVisualID() {
        return null != this.xVisualInfo ? (int)this.xVisualInfo.getVisualid() : 0;
    }

    public final boolean hasXVisualInfo() {
        return null != this.xVisualInfo;
    }

    public final int getVisualID(VisualIDHolder.VIDType vIDType) throws NativeWindowException {
        switch (vIDType) {
            case INTRINSIC: 
            case NATIVE: 
            case X11_XVISUAL: {
                return this.getXVisualID();
            }
            case X11_FBCONFIG: {
                return 0;
            }
        }
        throw new NativeWindowException("Invalid type <" + vIDType + ">");
    }

    public final boolean isVisualIDSupported(VisualIDHolder.VIDType vIDType) {
        switch (vIDType) {
            case INTRINSIC: 
            case NATIVE: 
            case X11_XVISUAL: 
            case X11_FBCONFIG: {
                return true;
            }
        }
        return false;
    }

    public StringBuilder toString(StringBuilder stringBuilder) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        stringBuilder.append("x11 vid ");
        if (this.hasXVisualInfo()) {
            stringBuilder.append("0x").append(Long.toHexString(this.xVisualInfo.getVisualid()));
        } else {
            stringBuilder.append("----");
        }
        stringBuilder.append(": ");
        return super.toString(stringBuilder);
    }
}

