/*
 * Decompiled with CFR 0.152.
 */
package jogamp.nativewindow.windows;

import com.jogamp.common.ExceptionUtils;
import com.jogamp.common.os.Platform;
import com.jogamp.common.util.VersionNumber;
import com.jogamp.nativewindow.NativeWindowException;
import com.jogamp.nativewindow.util.Point;
import com.jogamp.nativewindow.util.Rectangle;
import java.io.PrintStream;
import jogamp.nativewindow.Debug;
import jogamp.nativewindow.NWJNILibLoader;
import jogamp.nativewindow.ToolkitProperties;
import jogamp.nativewindow.windows.AccentPolicy;
import jogamp.nativewindow.windows.DWM_BLURBEHIND;
import jogamp.nativewindow.windows.GDI;
import jogamp.nativewindow.windows.MARGINS;
import jogamp.nativewindow.windows.RegisteredClass;
import jogamp.nativewindow.windows.RegisteredClassFactory;

public class GDIUtil
implements ToolkitProperties {
    private static final boolean DEBUG = Debug.debug((String)"GDIUtil");
    private static final String dummyWindowClassNameBase = "_dummyWindow_clazz";
    private static RegisteredClassFactory dummyWindowClassFactory;
    private static volatile boolean isInit;
    private static RegisteredClass dummyWindowClass;
    private static Object dummyWindowSync;
    public static final VersionNumber Win8Version;
    public static final VersionNumber Win10Version;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized void initSingleton() {
        if (isInit) return;
        Class<GDIUtil> clazz = GDIUtil.class;
        synchronized (GDIUtil.class) {
            if (isInit) return;
            if (DEBUG) {
                System.out.println("GDI.initSingleton()");
            }
            if (!NWJNILibLoader.loadNativeWindow((String)"win32")) {
                throw new NativeWindowException("NativeWindow Windows native library load error.");
            }
            if (!GDIUtil.initIDs0()) {
                throw new NativeWindowException("GDI: Could not initialized native stub");
            }
            dummyWindowClassFactory = new RegisteredClassFactory(dummyWindowClassNameBase, GDIUtil.getDummyWndProc0(), true, 0L, 0L);
            if (DEBUG) {
                System.out.println("GDI.initSingleton() dummyWindowClassFactory " + dummyWindowClassFactory);
            }
            isInit = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static void shutdown() {
    }

    public static boolean requiresToolkitLock() {
        return false;
    }

    public static final boolean hasThreadingIssues() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long CreateDummyWindow(int n, int n2, int n3, int n4) {
        Object object = dummyWindowSync;
        synchronized (object) {
            dummyWindowClass = dummyWindowClassFactory.getSharedClass();
            if (DEBUG) {
                System.out.println("GDI.CreateDummyWindow() dummyWindowClassFactory " + dummyWindowClassFactory);
                System.out.println("GDI.CreateDummyWindow() dummyWindowClass " + dummyWindowClass);
            }
            return GDIUtil.CreateDummyWindow0(dummyWindowClass.getHInstance(), dummyWindowClass.getName(), dummyWindowClass.getHDispThreadContext(), dummyWindowClass.getName(), n, n2, n3, n4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean DestroyDummyWindow(long l) {
        boolean bl;
        Object object = dummyWindowSync;
        synchronized (object) {
            if (null == dummyWindowClass) {
                throw new InternalError("GDI Error (" + dummyWindowClassFactory.getSharedRefCount() + "): SharedClass is null");
            }
            bl = GDIUtil.DestroyWindow0(dummyWindowClass.getHDispThreadContext(), l);
            dummyWindowClassFactory.releaseSharedClass();
        }
        return bl;
    }

    public static Point GetRelativeLocation(long l, long l2, int n, int n2) {
        return (Point)GDIUtil.GetRelativeLocation0(l, l2, n, n2);
    }

    public static boolean DwmIsCompositionEnabled() {
        VersionNumber versionNumber = Platform.getOSVersionNumber();
        if (versionNumber.compareTo(Win8Version) >= 0) {
            return true;
        }
        return GDI.DwmIsCompositionEnabled();
    }

    public static boolean DwmSetupTranslucency(long l, boolean bl) {
        boolean bl2;
        Object object;
        boolean bl3;
        if (!GDI.DwmIsExtensionAvailable()) {
            if (DEBUG) {
                System.err.println("GDIUtil.DwmSetupTranslucency on wnd 0x" + Long.toHexString(l) + ": enable " + bl + " -> failed, extension not available");
            }
            return !bl;
        }
        VersionNumber versionNumber = Platform.getOSVersionNumber();
        boolean bl4 = bl3 = versionNumber.compareTo(Win8Version) >= 0;
        if (!bl3 && !GDI.DwmIsCompositionEnabled()) {
            if (DEBUG) {
                System.err.println("GDIUtil.DwmSetupTranslucency on wnd 0x" + Long.toHexString(l) + ": enable " + bl + " -> failed, composition disabled");
            }
            return !bl;
        }
        boolean bl5 = GDI.IsWindowCompositionExtensionAvailable();
        boolean bl6 = bl3 && bl5;
        boolean bl7 = GDIUtil.IsUndecorated(l);
        if (bl6 && !bl7) {
            object = AccentPolicy.create();
            if (bl) {
                ((AccentPolicy)object).setAccentState(3);
            } else {
                ((AccentPolicy)object).setAccentState(0);
            }
            bl2 = GDI.SetWindowCompositionAccentPolicy(l, (AccentPolicy)object);
        } else {
            object = DWM_BLURBEHIND.create();
            int n = bl ? 7 : 1;
            ((DWM_BLURBEHIND)object).setDwFlags(n);
            ((DWM_BLURBEHIND)object).setFEnable(bl ? 1 : 0);
            ((DWM_BLURBEHIND)object).setHRgnBlur(0L);
            ((DWM_BLURBEHIND)object).setFTransitionOnMaximized(1);
            bl2 = GDI.DwmEnableBlurBehindWindow(l, (DWM_BLURBEHIND)object);
            if (bl2) {
                MARGINS mARGINS = MARGINS.create();
                mARGINS.setCxLeftWidth(-1);
                mARGINS.setCxRightWidth(-1);
                mARGINS.setCyBottomHeight(-1);
                mARGINS.setCyTopHeight(-1);
                bl2 = GDI.DwmExtendFrameIntoClientArea(l, mARGINS);
            }
        }
        if (DEBUG) {
            boolean bl8 = GDIUtil.IsChild(l);
            System.err.println("GDIUtil.DwmSetupTranslucency on wnd 0x" + Long.toHexString(l) + ": enable " + bl + ", isUndecorated " + bl7 + ", isChild " + bl8 + ", version " + versionNumber + ", isWin8 " + bl3 + ", hasWinCompEXT " + bl5 + ", useWinCompEXT " + bl6 + " -> ok: " + bl2);
        }
        return bl2;
    }

    public static boolean IsUndecorated(long l) {
        return GDIUtil.IsUndecorated0(l);
    }

    public static boolean IsChild(long l) {
        return GDIUtil.IsChild0(l);
    }

    public static long GetMonitorFromWindow(long l) {
        return GDI.GetMonitorFromWindow(l);
    }

    public static long GetMonitorFromPoint(int n, int n2) {
        return GDI.GetMonitorFromPoint(n, n2);
    }

    public static long GetMonitorFromRect(int n, int n2, int n3, int n4) {
        return GDI.GetMonitorFromRect(n, n2, n + n3 - 1, n2 + n4 - 1);
    }

    public static long GetMonitorFromRect(Rectangle rectangle) {
        return GDIUtil.GetMonitorFromRect(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight());
    }

    public static boolean GetMonitorPixelScale(long l, float[] fArray) {
        return GDI.ShcGetMonitorPixelScale1(l, fArray, 0);
    }

    public static void SetProcessThreadsAffinityMask(long l, boolean bl) {
        GDIUtil.SetProcessThreadsAffinityMask0(l, bl);
    }

    private static final void dumpStack() {
        ExceptionUtils.dumpStack((PrintStream)System.err);
    }

    static native boolean CreateWindowClass0(long var0, String var2, long var3, long var5, long var7);

    static native boolean DestroyWindowClass0(long var0, String var2, long var3);

    static native long CreateDummyDispatchThread0();

    private static native boolean initIDs0();

    private static native long getDummyWndProc0();

    private static native Object GetRelativeLocation0(long var0, long var2, int var4, int var5);

    private static native boolean IsChild0(long var0);

    private static native boolean IsUndecorated0(long var0);

    private static native void SetProcessThreadsAffinityMask0(long var0, boolean var2);

    private static native long CreateDummyWindow0(long var0, String var2, long var3, String var5, int var6, int var7, int var8, int var9);

    private static native boolean DestroyWindow0(long var0, long var2);

    static {
        isInit = false;
        dummyWindowClass = null;
        dummyWindowSync = new Object();
        Win8Version = new VersionNumber(6, 2, 0);
        Win10Version = new VersionNumber(10, 0, 0);
    }
}

