/*
 * Decompiled with CFR 0.152.
 */
package jogamp.newt.driver.windows;

import com.jogamp.common.util.ArrayHashSet;
import com.jogamp.nativewindow.DefaultGraphicsScreen;
import com.jogamp.nativewindow.util.Rectangle;
import com.jogamp.nativewindow.util.RectangleImmutable;
import com.jogamp.newt.MonitorDevice;
import com.jogamp.newt.MonitorMode;
import com.jogamp.newt.Screen;
import jogamp.nativewindow.windows.GDIUtil;
import jogamp.newt.MonitorModeProps;
import jogamp.newt.ScreenImpl;
import jogamp.newt.driver.windows.DisplayDriver;

public class ScreenDriver
extends ScreenImpl {
    protected void createNativeImpl() {
        this.aScreen = new DefaultGraphicsScreen(this.getDisplay().getGraphicsDevice(), this.screen_idx);
    }

    protected void closeNativeImpl() {
    }

    private final String getAdapterName(int n) {
        return this.getAdapterName0(n);
    }

    private final String getMonitorName(String string, int n, boolean bl) {
        return this.getMonitorName0(string, n, bl);
    }

    private final String getMonitorName(long l) {
        return this.getMonitorName1(l);
    }

    private final MonitorMode getMonitorModeImpl(MonitorModeProps.Cache cache, String string, int n) {
        if (null == string) {
            return null;
        }
        int[] nArray = this.getMonitorMode0(string, n);
        if (null == nArray || 0 >= nArray.length) {
            return null;
        }
        return MonitorModeProps.streamInMonitorMode(null, (MonitorModeProps.Cache)cache, (int[])nArray, (int)0);
    }

    private static final int getMonitorId(int n, int n2) {
        if (n > 255) {
            throw new InternalError("Unsupported adapter idx > 0xff: " + n);
        }
        if (n2 > 255) {
            throw new InternalError("Unsupported monitor idx > 0xff: " + n2);
        }
        return (n & 0xFF) << 8 | n2 & 0xFF;
    }

    private static final int getAdapterIndex(int n) {
        return n >>> 8 & 0xFF;
    }

    private static final int getMonitorIndex(int n) {
        return n & 0xFF;
    }

    protected void collectNativeMonitorModesAndDevicesImpl(MonitorModeProps.Cache cache) {
        String string;
        ArrayHashSet arrayHashSet = new ArrayHashSet(false, 16, 0.75f);
        int n = 0;
        while (null != (string = this.getAdapterName(n))) {
            String string2 = null;
            int n2 = 0;
            while (null != (string2 = this.getMonitorName(string, n2, true))) {
                MonitorMode monitorMode;
                MonitorMode monitorMode2;
                int n3 = 0;
                do {
                    if (null == (monitorMode2 = this.getMonitorModeImpl(cache, string, n3))) continue;
                    arrayHashSet.getOrAdd((Object)monitorMode2);
                    ++n3;
                } while (null != monitorMode2);
                if (0 < n3 && null != (monitorMode = this.getMonitorModeImpl(cache, string, -1))) {
                    int n4 = ScreenDriver.getMonitorId(n, n2);
                    float[] fArray = new float[]{1.0f, 1.0f};
                    int[] nArray = this.getMonitorDevice0(n, n2, n4);
                    if (null != nArray && nArray.length >= 10) {
                        int n5 = nArray[6];
                        int n6 = nArray[7];
                        int n7 = nArray[8];
                        int n8 = nArray[9];
                        long l = GDIUtil.GetMonitorFromRect((int)n5, (int)n6, (int)n7, (int)n8);
                        if (0L != l) {
                            float[] fArray2 = new float[2];
                            if (GDIUtil.GetMonitorPixelScale((long)l, (float[])fArray2)) {
                                System.arraycopy(fArray2, 0, fArray, 0, 2);
                            }
                        } else {
                            l = n4;
                        }
                        MonitorModeProps.streamInMonitorDevice((MonitorModeProps.Cache)cache, (ScreenImpl)this, (long)l, (String)string2, (MonitorMode)monitorMode, (float[])fArray, (boolean)true, (ArrayHashSet)arrayHashSet, (int[])nArray, (int)0, null);
                        arrayHashSet = new ArrayHashSet(false, 16, 0.75f);
                    } else {
                        throw new RuntimeException("monitorProps length should be > 10, but is " + nArray.length);
                    }
                }
                ++n2;
            }
            ++n;
        }
    }

    protected boolean updateNativeMonitorDeviceViewportImpl(MonitorDevice monitorDevice, float[] fArray, Rectangle rectangle, Rectangle rectangle2) {
        int n = monitorDevice.getId();
        int n2 = ScreenDriver.getAdapterIndex(n);
        int n3 = ScreenDriver.getMonitorIndex(n);
        String string = this.getAdapterName(n2);
        if (null != string && null != this.getMonitorName(string, n3, true)) {
            int[] nArray = this.getMonitorDevice0(n2, n3, ScreenDriver.getMonitorId(n2, n3));
            int n4 = 6;
            rectangle.set(nArray[n4++], nArray[n4++], nArray[n4++], nArray[n4++]);
            rectangle2.set(nArray[n4++], nArray[n4++], nArray[n4++], nArray[n4++]);
            rectangle2.scaleInv(fArray[0], fArray[1]);
            return true;
        }
        return false;
    }

    protected MonitorMode queryCurrentMonitorModeImpl(MonitorDevice monitorDevice) {
        return this.getMonitorModeImpl(null, this.getAdapterName(ScreenDriver.getAdapterIndex(monitorDevice.getId())), -1);
    }

    protected boolean setCurrentMonitorModeImpl(MonitorDevice monitorDevice, MonitorMode monitorMode) {
        return this.setMonitorMode0(ScreenDriver.getAdapterIndex(monitorDevice.getId()), -1, -1, monitorMode.getSurfaceSize().getResolution().getWidth(), monitorMode.getSurfaceSize().getResolution().getHeight(), monitorMode.getSurfaceSize().getBitsPerPixel(), (int)monitorMode.getRefreshRate(), monitorMode.getFlags(), monitorMode.getRotation());
    }

    protected int validateScreenIndex(int n) {
        return 0;
    }

    protected void calcVirtualScreenOriginAndSize(Rectangle rectangle, Rectangle rectangle2) {
        rectangle.set(this.getVirtualOriginX0(), this.getVirtualOriginY0(), this.getVirtualWidthImpl0(), this.getVirtualHeightImpl0());
        rectangle2.set((RectangleImmutable)rectangle);
    }

    private native int getVirtualOriginX0();

    private native int getVirtualOriginY0();

    private native int getVirtualWidthImpl0();

    private native int getVirtualHeightImpl0();

    private static native void dumpMonitorInfo0();

    private native String getAdapterName0(int var1);

    private native String getMonitorName0(String var1, int var2, boolean var3);

    private native String getMonitorName1(long var1);

    private native int[] getMonitorMode0(String var1, int var2);

    private native int[] getMonitorDevice0(int var1, int var2, int var3);

    private native boolean setMonitorMode0(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9);

    static {
        DisplayDriver.initSingleton();
        if (Screen.DEBUG) {
            ScreenDriver.dumpMonitorInfo0();
        }
    }
}

