/*
 * Decompiled with CFR 0.152.
 */
package jogamp.newt.driver.windows;

import com.jogamp.common.os.Platform;
import com.jogamp.common.util.VersionNumber;
import com.jogamp.nativewindow.AbstractGraphicsConfiguration;
import com.jogamp.nativewindow.AbstractGraphicsDevice;
import com.jogamp.nativewindow.CapabilitiesImmutable;
import com.jogamp.nativewindow.GraphicsConfigurationFactory;
import com.jogamp.nativewindow.NativeWindowException;
import com.jogamp.nativewindow.util.InsetsImmutable;
import com.jogamp.nativewindow.util.Point;
import com.jogamp.newt.MonitorDevice;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.MonitorEvent;
import com.jogamp.newt.event.MouseEvent;
import java.nio.ByteBuffer;
import jogamp.nativewindow.SurfaceScaleUtils;
import jogamp.nativewindow.windows.GDI;
import jogamp.nativewindow.windows.GDIUtil;
import jogamp.newt.PointerIconImpl;
import jogamp.newt.WindowImpl;
import jogamp.newt.driver.windows.DisplayDriver;
import jogamp.newt.driver.windows.ScreenDriver;

public class WindowDriver
extends WindowImpl {
    private volatile long hmon;
    private long hdc;
    private long hdc_old;
    private long windowHandleClose;
    private short repeatedKey = 0;

    private boolean updatePixelScaleByMonitor(long l, int[] nArray, boolean bl) {
        float[] fArray;
        boolean bl2 = false;
        if (!this.hasSetPixelScale() && 0L != l && GDIUtil.GetMonitorPixelScale((long)l, (float[])(fArray = new float[]{0.0f, 0.0f}))) {
            bl2 = this.applySoftPixelScale(nArray, fArray, bl);
        }
        return bl2;
    }

    protected int lockSurfaceImpl() {
        long l;
        if (0L != this.hdc) {
            throw new InternalError("surface not released");
        }
        long l2 = this.getWindowHandle();
        this.hdc = GDI.GetDC((long)l2);
        if (0L == this.hdc) {
            return 1;
        }
        if (DEBUG_IMPLEMENTATION && this.hmon != (l = GDIUtil.GetMonitorFromWindow((long)l2))) {
            System.err.println("Info: Window Device Changed (L) " + WindowDriver.getThreadName() + ", HMON " + WindowDriver.toHexString((long)this.hmon) + " -> " + WindowDriver.toHexString((long)l));
        }
        return 3;
    }

    protected void unlockSurfaceImpl() {
        if (0L != this.hdc) {
            GDI.ReleaseDC((long)this.getWindowHandle(), (long)this.hdc);
            this.hdc_old = this.hdc;
            this.hdc = 0L;
        }
    }

    public final long getSurfaceHandle() {
        return this.hdc;
    }

    protected void monitorModeChanged(MonitorEvent monitorEvent, boolean bl) {
        if (this.hmon == monitorEvent.getMonitor().getHandle()) {
            this.updatePixelScaleByMonitor(monitorEvent.getMonitor().getHandle(), null, true);
        }
    }

    public final boolean setSurfaceScale(float[] fArray) {
        super.setSurfaceScale(fArray);
        boolean bl = false;
        if (this.isNativeValid()) {
            bl = this.applySoftPixelScale(null, this.reqPixelScale, true);
        }
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("WindowDriver.setPixelScale: min[" + this.minPixelScale[0] + ", " + this.minPixelScale[1] + "], max[" + this.maxPixelScale[0] + ", " + this.maxPixelScale[1] + "], req[" + this.reqPixelScale[0] + ", " + this.reqPixelScale[1] + "] -> result[" + this.hasPixelScale[0] + ", " + this.hasPixelScale[1] + "] - changed " + bl + ", realized " + this.isNativeValid());
        }
        return bl;
    }

    protected void createNativeImpl(boolean[] blArray) {
        long l;
        int[] nArray;
        int[] nArray2;
        ScreenDriver screenDriver = (ScreenDriver)this.getScreen();
        DisplayDriver displayDriver = (DisplayDriver)screenDriver.getDisplay();
        AbstractGraphicsConfiguration abstractGraphicsConfiguration = GraphicsConfigurationFactory.getFactory((AbstractGraphicsDevice)displayDriver.getGraphicsDevice(), (CapabilitiesImmutable)this.capsRequested).chooseGraphicsConfiguration(this.capsRequested, this.capsRequested, this.capabilitiesChooser, screenDriver.getGraphicsScreen(), 0);
        if (null == abstractGraphicsConfiguration) {
            throw new NativeWindowException("Error choosing GraphicsConfiguration creating window: " + (Object)((Object)this));
        }
        this.setGraphicsConfiguration(abstractGraphicsConfiguration);
        VersionNumber versionNumber = Platform.getOSVersionNumber();
        int n = this.getReconfigureMask(0, true) & 0x47FF;
        int n2 = 0;
        if (0 != (0x400 & n)) {
            n |= 0x400000;
            ++n2;
        }
        if (0 != (0x200 & n)) {
            n |= 0x800000;
            ++n2;
        }
        if (!this.hasSetPixelScale()) {
            nArray2 = this.getWindowPosI();
            nArray = this.getWindowSizeI();
            l = GDIUtil.GetMonitorFromRect((int)nArray2[0], (int)nArray2[1], (int)nArray[0], (int)nArray[1]);
            this.updatePixelScaleByMonitor(l, null, false);
        }
        nArray2 = this.getPixelPosI();
        nArray = this.getPixelSizeI();
        l = this.CreateWindow0(DisplayDriver.getHInstance(), displayDriver.getWindowClassName(), displayDriver.getWindowClassName(), versionNumber.getMajor(), versionNumber.getMinor(), this.getParentWindowHandle(), nArray2[0], nArray2[1], nArray[0], nArray[1], n);
        if (0L == l) {
            throw new NativeWindowException("Error creating window");
        }
        if (!abstractGraphicsConfiguration.getChosenCapabilities().isBackgroundOpaque()) {
            GDIUtil.DwmSetupTranslucency((long)l, (boolean)true);
        }
        this.setWindowHandle(l);
        this.windowHandleClose = l;
        this.InitWindow0(l, n);
        if (0 == (4 & n) && 1 <= n2) {
            this.reconfigureWindowImpl(nArray2[0], nArray2[1], nArray[0], nArray[1], n);
        }
        this.hmon = GDIUtil.GetMonitorFromWindow((long)l);
        boolean bl = blArray[0] = this.hasSetPixelScale() && this.applySoftPixelScale(null, this.reqPixelScale, true);
        if (DEBUG_IMPLEMENTATION) {
            Exception exception = new Exception("Info: Window new window handle " + Thread.currentThread().getName() + " (Parent HWND " + WindowDriver.toHexString((long)this.getParentWindowHandle()) + ") : HWND " + WindowDriver.toHexString((long)l) + ", " + Thread.currentThread());
            exception.printStackTrace();
        }
    }

    protected void closeNativeImpl() {
        block7: {
            if (0L != this.windowHandleClose) {
                Exception exception;
                block6: {
                    if (0L != this.hdc) {
                        try {
                            GDI.ReleaseDC((long)this.windowHandleClose, (long)this.hdc);
                        }
                        catch (Throwable throwable) {
                            if (!DEBUG_IMPLEMENTATION) break block6;
                            exception = new Exception("Warning: closeNativeImpl failed - " + Thread.currentThread().getName(), throwable);
                            exception.printStackTrace();
                        }
                    }
                }
                try {
                    GDI.DestroyWindow((long)this.windowHandleClose);
                }
                catch (Throwable throwable) {
                    if (!DEBUG_IMPLEMENTATION) break block7;
                    exception = new Exception("Warning: closeNativeImpl failed - " + Thread.currentThread().getName(), throwable);
                    exception.printStackTrace();
                }
            }
        }
        this.windowHandleClose = 0L;
        this.hdc = 0L;
        this.hdc_old = 0L;
        this.hmon = 0L;
    }

    protected final int getSupportedReconfigMaskImpl() {
        return 32637;
    }

    protected boolean reconfigureWindowImpl(int n, int n2, int n3, int n4, int n5) {
        boolean bl;
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("WindowsWindow reconfig.0: " + n + "/" + n2 + " " + n3 + "x" + n4 + ", " + WindowDriver.getReconfigStateMaskString((int)n5));
        }
        InsetsImmutable insetsImmutable = this.getInsets();
        if (0 == (4 & n5) && 0 != (0xC00000 & n5)) {
            int[] nArray = new int[]{n, n2, n3, n4};
            if (0 != (0x400 & n5) == (0 != (0x200 & n5))) {
                this.resetMaximizedManual(nArray);
            } else {
                this.reconfigMaximizedManual(n5, nArray, insetsImmutable);
            }
            n = nArray[0];
            n2 = nArray[1];
            n3 = nArray[2];
            n4 = nArray[3];
        }
        boolean bl2 = 0 != (0x10000000 & n5);
        boolean bl3 = bl = !this.getChosenCapabilities().isBackgroundOpaque();
        if (bl2 && bl) {
            GDIUtil.DwmSetupTranslucency((long)this.getWindowHandle(), (boolean)false);
        }
        int[] nArray = SurfaceScaleUtils.scale((int[])new int[2], (int)n, (int)n2, (float[])this.hasPixelScale);
        int[] nArray2 = SurfaceScaleUtils.scale((int[])new int[2], (int)n3, (int)n4, (float[])this.hasPixelScale);
        this.reconfigureWindow0(this.getParentWindowHandle(), this.getWindowHandle(), nArray[0], nArray[1], nArray2[0], nArray2[1], n5);
        if (bl2 && bl) {
            GDIUtil.DwmSetupTranslucency((long)this.getWindowHandle(), (boolean)true);
        }
        if (0 != (Integer.MIN_VALUE & n5)) {
            this.visibleChanged(0 != (1 & n5));
        }
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("WindowsWindow reconfig.X: " + this.getX() + "/" + this.getY() + " " + this.getWidth() + "x" + this.getHeight() + ", " + this.getStateMaskString());
        }
        return true;
    }

    protected boolean positionChanged(boolean bl, boolean bl2, int n, int n2) {
        long l;
        boolean bl3 = super.positionChanged(bl, bl2, n, n2);
        if (bl3 && 0L != (l = this.getWindowHandle())) {
            long l2 = GDIUtil.GetMonitorFromWindow((long)l);
            if (this.hmon != l2) {
                int[] nArray = new int[]{0, 0};
                MonitorDevice.Orientation orientation = MonitorDevice.Orientation.clone;
                MonitorDevice monitorDevice = this.getScreen().getMonitorByHandle(this.hmon);
                MonitorDevice monitorDevice2 = this.getScreen().getMonitorByHandle(l2);
                if (null != monitorDevice && null != monitorDevice2) {
                    orientation = monitorDevice2.getOrientationTo(monitorDevice, nArray);
                }
                if (DEBUG_IMPLEMENTATION) {
                    System.err.println("Info: Window Device Changed (P: " + n + "/" + n2 + ", crt_move[orient " + orientation + ", diff " + nArray[0] + "/" + nArray[1] + ") , HMON " + WindowDriver.toHexString((long)this.hmon) + " -> " + WindowDriver.toHexString((long)l2) + " - " + Thread.currentThread().getName());
                }
                this.hmon = l2;
                this.updatePixelScaleByMonitor(l2, nArray, true);
            } else {
                this.updatePixelScaleByMonitor(l2, null, true);
            }
        }
        return bl3;
    }

    protected void requestFocusImpl(boolean bl) {
        this.requestFocus0(this.getWindowHandle(), bl);
    }

    protected void setTitleImpl(String string) {
        WindowDriver.setTitle0(this.getWindowHandle(), string);
    }

    protected void setPointerIconImpl(PointerIconImpl pointerIconImpl) {
        WindowDriver.setPointerIcon0(this.getWindowHandle(), null != pointerIconImpl ? pointerIconImpl.validatedHandle() : 0L);
    }

    protected boolean setPointerVisibleImpl(final boolean bl) {
        final boolean[] blArray = new boolean[]{false};
        this.runOnEDTIfAvail(true, new Runnable(){

            @Override
            public void run() {
                blArray[0] = WindowDriver.setPointerVisible0(WindowDriver.this.getWindowHandle(), bl);
            }
        });
        return blArray[0];
    }

    protected boolean confinePointerImpl(final boolean bl) {
        final Boolean[] booleanArray = new Boolean[]{Boolean.FALSE};
        this.runOnEDTIfAvail(true, new Runnable(){

            @Override
            public void run() {
                Point point = WindowDriver.this.convertToPixelUnits(WindowDriver.this.getLocationOnScreenImpl(0, 0));
                booleanArray[0] = WindowDriver.confinePointer0(WindowDriver.this.getWindowHandle(), bl, point.getX(), point.getY(), point.getX() + WindowDriver.this.getSurfaceWidth(), point.getY() + WindowDriver.this.getSurfaceHeight());
            }
        });
        return booleanArray[0];
    }

    protected void warpPointerImpl(final int n, final int n2) {
        this.runOnEDTIfAvail(true, new Runnable(){

            @Override
            public void run() {
                Point point = GDIUtil.GetRelativeLocation((long)WindowDriver.this.getWindowHandle(), (long)0L, (int)n, (int)n2);
                WindowDriver.warpPointer0(WindowDriver.this.getWindowHandle(), point.getX(), point.getY());
            }
        });
    }

    protected Point getLocationOnScreenImpl(int n, int n2) {
        int[] nArray = SurfaceScaleUtils.scale((int[])new int[2], (int)n, (int)n2, (float[])this.hasPixelScale);
        return this.convertToWindowUnits(GDIUtil.GetRelativeLocation((long)this.getWindowHandle(), (long)0L, (int)nArray[0], (int)nArray[1]));
    }

    public final boolean sendTouchScreenEvent(short s, int n, int n2, short[] sArray, int[] nArray, int[] nArray2, float[] fArray, float f) {
        int n3 = sArray.length;
        MouseEvent.PointerType[] pointerTypeArray = new MouseEvent.PointerType[n3];
        for (int i = n3 - 1; i >= 0; --i) {
            pointerTypeArray[i] = MouseEvent.PointerType.TouchScreen;
        }
        this.doPointerEvent(false, false, pointerTypeArray, s, n, n2, false, sArray, nArray, nArray2, fArray, f, new float[]{0.0f, 0.0f, 0.0f}, 1.0f);
        return this.isNativeValid();
    }

    private final boolean handlePressTypedAutoRepeat(boolean bl, int n, short s, short s2, char c) {
        if (this.setKeyPressed(s, true)) {
            boolean bl2 = this.repeatedKey == s;
            this.repeatedKey = s;
            if (!bl) {
                n |= 0x20000000;
                if (bl2) {
                    super.sendKeyEvent((short)300, n, s, s2, c);
                }
                super.sendKeyEvent((short)301, n, s, s2, c);
            }
            return true;
        }
        return false;
    }

    public final boolean sendKeyEvent(short s, int n, short s2, short s3, char c) {
        boolean bl = KeyEvent.isModifierKey((short)s3);
        boolean bl2 = true;
        switch (s) {
            case 301: {
                if (this.isKeyCodeTracked(s2)) {
                    if (this.repeatedKey == s2 && !bl) {
                        bl2 = super.sendKeyEvent((short)300, n | 0x20000000, s2, s3, c);
                    }
                    this.setKeyPressed(s2, false);
                    this.repeatedKey = 0;
                }
                bl2 = bl2 && super.sendKeyEvent((short)301, n, s2, s3, c);
                break;
            }
            case 300: {
                if (this.handlePressTypedAutoRepeat(bl, n, s2, s3, c)) break;
                bl2 = super.sendKeyEvent((short)300, n, s2, s3, c);
            }
        }
        return bl2;
    }

    public final boolean enqueueKeyEvent(boolean bl, short s, int n, short s2, short s3, char c) {
        throw new InternalError("XXX: Adapt Java Code to Native Code Changes");
    }

    protected static native long getNewtWndProc0();

    protected static native boolean initIDs0(long var0);

    private native long CreateWindow0(long var1, String var3, String var4, int var5, int var6, long var7, int var9, int var10, int var11, int var12, int var13);

    private native void InitWindow0(long var1, int var3);

    private native void reconfigureWindow0(long var1, long var3, int var5, int var6, int var7, int var8, int var9);

    private static native void setTitle0(long var0, String var2);

    private native void requestFocus0(long var1, boolean var3);

    private static native boolean setPointerVisible0(long var0, boolean var2);

    private static native boolean confinePointer0(long var0, boolean var2, int var3, int var4, int var5, int var6);

    private static native void warpPointer0(long var0, int var2, int var3);

    private static native ByteBuffer newDirectByteBuffer(long var0, long var2);

    private static native void setPointerIcon0(long var0, long var2);

    static {
        DisplayDriver.initSingleton();
    }
}

