/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.egl;

import com.jogamp.common.ExceptionUtils;
import com.jogamp.common.nio.Buffers;
import com.jogamp.gluegen.runtime.FunctionAddressResolver;
import com.jogamp.gluegen.runtime.ProcAddressTable;
import com.jogamp.gluegen.runtime.opengl.GLProcAddressResolver;
import com.jogamp.nativewindow.AbstractGraphicsConfiguration;
import com.jogamp.nativewindow.AbstractGraphicsDevice;
import com.jogamp.nativewindow.egl.EGLGraphicsDevice;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLDrawableFactory;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.GLRendererQuirks;
import com.jogamp.opengl.egl.EGL;
import com.jogamp.opengl.egl.EGLExt;
import java.nio.IntBuffer;
import java.util.Map;
import jogamp.opengl.GLContextImpl;
import jogamp.opengl.GLDrawableImpl;
import jogamp.opengl.GLDynamicLookupHelper;
import jogamp.opengl.egl.EGLDrawableFactory;
import jogamp.opengl.egl.EGLExtImpl;
import jogamp.opengl.egl.EGLExtProcAddressTable;
import jogamp.opengl.egl.EGLGraphicsConfiguration;

public class EGLContext
extends GLContextImpl {
    private EGLExtProcAddressTable eglExtProcAddressTable;
    private EGLExtImpl eglExtImpl;
    static final int CTX_PROFILE_COMPAT = 2;
    static final int CTX_PROFILE_CORE = 4;
    static final int CTX_PROFILE_ES = 8;
    private static final int ctx_attribs_idx_major = 0;
    private static final int[] ctx_attribs_rom = new int[]{12440, 0, 12344, 12344, 12344, 12344, 12344, 12344, 12344, 12344, 12344};

    public static String getGLProfile(int n, int n2, int n3) throws GLException {
        return GLContext.getGLProfile((int)n, (int)n2, (int)n3);
    }

    EGLContext(GLDrawableImpl gLDrawableImpl, GLContext gLContext) {
        super(gLDrawableImpl, gLContext);
    }

    protected void resetStates(boolean bl) {
        this.eglExtProcAddressTable = null;
        this.eglExtImpl = null;
        super.resetStates(bl);
    }

    public Object getPlatformGLExtensions() {
        return this.getEGLExt();
    }

    public final EGLExt getEGLExt() {
        return this.eglExtImpl;
    }

    public final ProcAddressTable getPlatformExtProcAddressTable() {
        return this.eglExtProcAddressTable;
    }

    protected Map<String, String> getFunctionNameMap() {
        return null;
    }

    protected Map<String, String> getExtensionNameMap() {
        return null;
    }

    public final boolean isGLReadDrawableAvailable() {
        return true;
    }

    protected void makeCurrentImpl() throws GLException {
        long l = this.drawable.getNativeSurface().getDisplayHandle();
        if (!EGL.eglMakeCurrent(l, this.drawable.getHandle(), this.drawableRead.getHandle(), this.contextHandle)) {
            throw new GLException("Error making context " + EGLContext.toHexString(this.contextHandle) + " current on Thread " + EGLContext.getThreadName() + " with display " + EGLContext.toHexString(l) + ", drawableWrite " + EGLContext.toHexString(this.drawable.getHandle()) + ", drawableRead " + EGLContext.toHexString(this.drawableRead.getHandle()) + " - Error code " + EGLContext.toHexString(EGL.eglGetError()) + ", " + (Object)((Object)this));
        }
    }

    protected void releaseImpl() throws GLException {
        if (!EGL.eglMakeCurrent(this.drawable.getNativeSurface().getDisplayHandle(), 0L, 0L, 0L)) {
            throw new GLException("Error freeing OpenGL context " + EGLContext.toHexString(this.contextHandle) + ": error code " + EGLContext.toHexString(EGL.eglGetError()));
        }
    }

    protected void destroyImpl() throws GLException {
        this.destroyContextARBImpl(this.contextHandle);
    }

    protected void destroyContextARBImpl(long l) {
        int n;
        if (!EGL.eglDestroyContext(this.drawable.getNativeSurface().getDisplayHandle(), l) && 12288 != (n = EGL.eglGetError())) {
            throw new GLException("Error destroying OpenGL context " + EGLContext.toHexString(l) + ": error code " + EGLContext.toHexString(n));
        }
    }

    protected long createContextARBImpl(long l, boolean bl, int n, int n2, int n3) {
        long l2;
        long l3;
        block30: {
            boolean bl2;
            boolean bl3;
            boolean bl4;
            boolean bl5;
            boolean bl6;
            long l4;
            block29: {
                EGLGraphicsConfiguration eGLGraphicsConfiguration = (EGLGraphicsConfiguration)this.drawable.getNativeSurface().getGraphicsConfiguration();
                EGLGraphicsDevice eGLGraphicsDevice = (EGLGraphicsDevice)eGLGraphicsConfiguration.getScreen().getDevice();
                l3 = eGLGraphicsDevice.getHandle();
                l4 = eGLGraphicsConfiguration.getNativeConfig();
                EGLDrawableFactory eGLDrawableFactory = (EGLDrawableFactory)this.drawable.getFactoryImpl();
                boolean bl7 = eGLDrawableFactory.hasOpenGLDesktopSupport();
                bl6 = eGLDrawableFactory.hasDefaultDeviceKHRCreateContext();
                bl5 = 0 == (8 & n);
                bl4 = 0 != (2 & n);
                bl3 = 0 != (0x10 & n);
                boolean bl8 = bl2 = 0 != (0x20 & n);
                if (DEBUG) {
                    System.err.println(EGLContext.getThreadName() + ": EGLContext.createContextARBImpl: Start " + EGLContext.getGLVersion(n2, n3, n, "@creation") + ", useKHRCreateContext " + bl6 + ", OpenGL API Support " + bl7 + ", device " + eGLGraphicsDevice);
                }
                if (0L == l3) {
                    throw new GLException("Error: attempted to create an OpenGL context without a display connection");
                }
                if (0L == l4) {
                    throw new GLException("Error: attempted to create an OpenGL context without a graphics configuration");
                }
                if (bl5 && !bl7) {
                    if (DEBUG) {
                        System.err.println(EGLContext.getThreadName() + ": EGLContext.createContextARBImpl: DesktopGL not avail " + EGLContext.getGLVersion(n2, n3, n, "@creation"));
                    }
                    return 0L;
                }
                try {
                    if (bl7 && eGLGraphicsDevice.getEGLVersion().compareTo(Version1_2) >= 0) {
                        EGL.eglWaitClient();
                    }
                    if (!EGL.eglBindAPI(bl5 ? 12450 : 12448)) {
                        throw new GLException("Caught: eglBindAPI to " + (bl5 ? "ES" : "GL") + " failed , error " + EGLContext.toHexString(EGL.eglGetError()) + " - " + EGLContext.getGLVersion(n2, n3, n, "@creation"));
                    }
                }
                catch (GLException gLException) {
                    if (!DEBUG) break block29;
                    ExceptionUtils.dumpThrowable((String)"", (Throwable)gLException);
                }
            }
            int n4 = n2 >= 3 && GLRendererQuirks.existStickyDeviceQuirk((AbstractGraphicsDevice)GLDrawableFactory.getEGLFactory().getDefaultDevice(), (int)15) ? 2 : n2;
            IntBuffer intBuffer = Buffers.newDirectIntBuffer((int[])ctx_attribs_rom);
            if (bl6) {
                intBuffer.put(1, n4);
                int n5 = 2;
                if (n3 >= 0) {
                    intBuffer.put(n5 + 0, 12539);
                    intBuffer.put(n5 + 1, n3);
                    n5 += 2;
                }
                if (bl5 && (n4 > 3 || n4 == 3 && n3 >= 2)) {
                    intBuffer.put(n5 + 0, 12541);
                    if (bl4) {
                        intBuffer.put(n5 + 1, 2);
                    } else {
                        intBuffer.put(n5 + 1, 1);
                    }
                    n5 += 2;
                }
                int n6 = 0;
                if (bl5 && n4 >= 3 && !bl4 && bl3) {
                    n6 |= 2;
                }
                if (bl2) {
                    n6 |= 1;
                }
                if (0 != n6) {
                    intBuffer.put(n5 + 0, 12540);
                    intBuffer.put(n5 + 1, n6);
                    n5 += 2;
                }
                if (DEBUG) {
                    System.err.println(EGLContext.getThreadName() + ": EGLContext.createContextARBImpl: attrs.1: major " + n4 + ", flags " + EGLContext.toHexString(n6) + ", index " + n5);
                }
            } else {
                intBuffer.put(1, n4);
                if (DEBUG) {
                    System.err.println(EGLContext.getThreadName() + ": EGLContext.createContextARBImpl: attrs.2: major " + n4);
                }
            }
            l2 = 0L;
            try {
                l2 = EGL.eglCreateContext(l3, l4, l, intBuffer);
            }
            catch (RuntimeException runtimeException) {
                if (!DEBUG) break block30;
                System.err.println(EGLContext.getThreadName() + ": Info: EGLContext.createContextARBImpl glXCreateContextAttribsARB failed with " + EGLContext.getGLVersion(n2, n3, n, "@creation"));
                ExceptionUtils.dumpThrowable((String)"", (Throwable)runtimeException);
            }
        }
        if (0L != l2) {
            if (!EGL.eglMakeCurrent(l3, this.drawable.getHandle(), this.drawableRead.getHandle(), l2)) {
                if (DEBUG) {
                    System.err.println(EGLContext.getThreadName() + ": EGLContext.createContextARBImpl couldn't make current " + EGLContext.getGLVersion(n2, n3, n, "@creation") + " - error " + EGLContext.toHexString(EGL.eglGetError()));
                }
                EGL.eglMakeCurrent(l3, 0L, 0L, 0L);
                EGL.eglDestroyContext(l3, l2);
                l2 = 0L;
            } else if (DEBUG) {
                System.err.println(EGLContext.getThreadName() + ": EGLContext.createContextARBImpl: OK " + EGLContext.getGLVersion(n2, n3, n, "@creation") + ", share " + l + ", direct " + bl);
            }
        } else if (DEBUG) {
            System.err.println(EGLContext.getThreadName() + ": EGLContext.createContextARBImpl: NO " + EGLContext.getGLVersion(n2, n3, n, "@creation") + " - error " + EGLContext.toHexString(EGL.eglGetError()));
        }
        return l2;
    }

    protected boolean createImpl(long l) throws GLException {
        EGLGraphicsConfiguration eGLGraphicsConfiguration = (EGLGraphicsConfiguration)this.drawable.getNativeSurface().getGraphicsConfiguration();
        AbstractGraphicsDevice abstractGraphicsDevice = eGLGraphicsConfiguration.getScreen().getDevice();
        GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)eGLGraphicsConfiguration.getChosenCapabilities();
        GLProfile gLProfile = gLCapabilitiesImmutable.getGLProfile();
        boolean bl = this.isCreateContextARBAvail(abstractGraphicsDevice);
        if (DEBUG) {
            System.err.println(EGLContext.getThreadName() + ": EGLContext.createImpl: START " + gLCapabilitiesImmutable + ", share " + EGLContext.toHexString(l));
            System.err.println(EGLContext.getThreadName() + ": Use ARB[avail[" + this.getCreateContextARBAvailStr(abstractGraphicsDevice) + "] -> " + bl + "]]");
        }
        if (bl) {
            this.contextHandle = this.createContextARB(l, true);
            if (DEBUG) {
                if (0L != this.contextHandle) {
                    System.err.println(EGLContext.getThreadName() + ": createImpl: OK (ARB) on eglDevice " + abstractGraphicsDevice + ", eglConfig " + eGLGraphicsConfiguration + ", " + gLProfile + ", shareWith " + EGLContext.toHexString(l) + ", error " + EGLContext.toHexString(EGL.eglGetError()));
                } else {
                    System.err.println(EGLContext.getThreadName() + ": createImpl: NOT OK (ARB) - creation failed on eglDevice " + abstractGraphicsDevice + ", eglConfig " + eGLGraphicsConfiguration + ", " + gLProfile + ", shareWith " + EGLContext.toHexString(l) + ", error " + EGLContext.toHexString(EGL.eglGetError()));
                }
            }
        } else {
            this.contextHandle = 0L;
        }
        if (0L == this.contextHandle) {
            if (!gLProfile.isGLES()) {
                throw new GLException(EGLContext.getThreadName() + ": Unable to create desktop OpenGL context(ARB n/a) on eglDevice " + abstractGraphicsDevice + ", eglConfig " + eGLGraphicsConfiguration + ", " + gLProfile + ", shareWith " + EGLContext.toHexString(l) + ", error " + EGLContext.toHexString(EGL.eglGetError()));
            }
            int[] nArray = new int[]{0, 0};
            GLContext.getRequestMajorAndCompat((GLProfile)gLProfile, (int[])nArray);
            nArray[1] = nArray[1] | this.getContextCreationFlags();
            this.contextHandle = this.createContextARBImpl(l, true, nArray[1], nArray[0], 0);
            if (0L == this.contextHandle) {
                throw new GLException(EGLContext.getThreadName() + ": Unable to create ES OpenGL context on eglDevice " + abstractGraphicsDevice + ", eglConfig " + eGLGraphicsConfiguration + ", " + gLProfile + ", shareWith " + EGLContext.toHexString(l) + ", error " + EGLContext.toHexString(EGL.eglGetError()));
            }
            if (!this.setGLFunctionAvailability(true, nArray[0], 0, nArray[1], false, false)) {
                EGL.eglMakeCurrent(this.drawable.getNativeSurface().getDisplayHandle(), 0L, 0L, 0L);
                EGL.eglDestroyContext(this.drawable.getNativeSurface().getDisplayHandle(), this.contextHandle);
                this.contextHandle = 0L;
                throw new GLException("setGLFunctionAvailability !strictMatch failed");
            }
        }
        if (DEBUG) {
            System.err.println(EGLContext.getThreadName() + ": createImpl: Created OpenGL context 0x" + Long.toHexString(this.contextHandle) + ",\n\twrite surface 0x" + Long.toHexString(this.drawable.getHandle()) + ",\n\tread  surface 0x" + Long.toHexString(this.drawableRead.getHandle()) + ",\n\t" + (Object)((Object)this) + ",\n\tsharing with 0x" + Long.toHexString(l));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void updateGLXProcAddressTable(String string, GLDynamicLookupHelper gLDynamicLookupHelper) {
        if (null == gLDynamicLookupHelper) {
            throw new GLException("No GLDynamicLookupHelper for " + (Object)((Object)this));
        }
        AbstractGraphicsConfiguration abstractGraphicsConfiguration = this.drawable.getNativeSurface().getGraphicsConfiguration();
        AbstractGraphicsDevice abstractGraphicsDevice = abstractGraphicsConfiguration.getScreen().getDevice();
        String string2 = "EGL-" + abstractGraphicsDevice.getUniqueID();
        if (DEBUG) {
            System.err.println(EGLContext.getThreadName() + ": Initializing EGLextension address table: " + string2);
        }
        ProcAddressTable procAddressTable = null;
        Object object = mappedContextTypeObjectLock;
        synchronized (object) {
            procAddressTable = (ProcAddressTable)mappedGLXProcAddress.get(string2);
        }
        if (null != procAddressTable) {
            this.eglExtProcAddressTable = (EGLExtProcAddressTable)procAddressTable;
            if (DEBUG) {
                System.err.println(EGLContext.getThreadName() + ": GLContext EGL ProcAddressTable reusing key(" + string2 + ") -> " + EGLContext.toHexString(procAddressTable.hashCode()));
            }
            if (null == this.eglExtImpl || this.eglExtImpl.getProcAdressTable() != this.eglExtProcAddressTable) {
                this.eglExtImpl = new EGLExtImpl(this, this.eglExtProcAddressTable);
            }
        } else {
            this.eglExtProcAddressTable = new EGLExtProcAddressTable((FunctionAddressResolver)new GLProcAddressResolver());
            this.resetProcAddressTable(this.eglExtProcAddressTable, gLDynamicLookupHelper);
            object = mappedContextTypeObjectLock;
            synchronized (object) {
                mappedGLXProcAddress.put(string2, this.eglExtProcAddressTable);
                if (DEBUG) {
                    System.err.println(EGLContext.getThreadName() + ": GLContext EGL ProcAddressTable mapping key(" + string2 + ") -> " + EGLContext.toHexString(((Object)((Object)this.eglExtProcAddressTable)).hashCode()));
                }
            }
            this.eglExtImpl = new EGLExtImpl(this, this.eglExtProcAddressTable);
        }
    }

    protected final StringBuilder getPlatformExtensionsStringImpl() {
        EGLGraphicsDevice eGLGraphicsDevice = (EGLGraphicsDevice)this.drawable.getNativeSurface().getGraphicsConfiguration().getScreen().getDevice();
        return EGLContext.getPlatformExtensionsStringImpl(eGLGraphicsDevice);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final StringBuilder getPlatformExtensionsStringImpl(EGLGraphicsDevice eGLGraphicsDevice) {
        StringBuilder stringBuilder = new StringBuilder();
        eGLGraphicsDevice.lock();
        try {
            String string;
            long l = eGLGraphicsDevice.getHandle();
            if (DEBUG) {
                System.err.println("EGL PlatformExtensions: Device " + eGLGraphicsDevice);
                EGLDrawableFactory.dumpEGLInfo("EGL PlatformExtensions: ", l);
            }
            if (eGLGraphicsDevice.getEGLVersion().compareTo(Version1_5) >= 0) {
                string = EGL.eglQueryString(0L, 12373);
                if (DEBUG) {
                    System.err.println("EGL extensions (Client): " + string);
                }
                stringBuilder.append(string).append(" ");
            }
            if (0L != l) {
                string = EGL.eglQueryString(l, 12373);
                if (DEBUG) {
                    System.err.println("EGL extensions (Server): " + string);
                }
                stringBuilder.append(string).append(" ");
            }
        }
        finally {
            eGLGraphicsDevice.unlock();
        }
        return stringBuilder;
    }

    protected final Integer setSwapIntervalImpl2(int n) {
        if (!this.drawable.getChosenGLCapabilities().isOnscreen() || this.hasRendererQuirk(2)) {
            return null;
        }
        int n2 = 0 > n ? Math.abs(n) : n;
        if (EGL.eglSwapInterval(this.drawable.getNativeSurface().getDisplayHandle(), n2)) {
            return n2;
        }
        return null;
    }

    static long eglGetProcAddress(long l, String string) {
        if (0L == l) {
            throw new GLException("Passed null pointer for method \"eglGetProcAddress\"");
        }
        return EGLContext.dispatch_eglGetProcAddress0(string, l);
    }

    private static native long dispatch_eglGetProcAddress0(String var0, long var1);

    static final boolean isGLES1(int n, int n2) {
        return 0 != (n2 & 8) && n == 1;
    }

    static final boolean isGLES2ES3(int n, int n2) {
        if (0 != (n2 & 8)) {
            return 2 == n || 3 == n;
        }
        return false;
    }

    static final boolean isGLDesktop(int n) {
        return 0 != (n & 6);
    }

    protected static StringBuilder getGLProfile(StringBuilder stringBuilder, int n) {
        return GLContext.getGLProfile((StringBuilder)stringBuilder, (int)n);
    }

    int getContextOptions() {
        return this.ctxOptions;
    }

    protected static void remapAvailableGLVersions(AbstractGraphicsDevice abstractGraphicsDevice, AbstractGraphicsDevice abstractGraphicsDevice2, boolean bl, int n) {
        GLContextImpl.remapAvailableGLVersions((AbstractGraphicsDevice)abstractGraphicsDevice, (AbstractGraphicsDevice)abstractGraphicsDevice2, (boolean)bl, (int)n);
    }

    protected static synchronized void setMappedGLVersionListener(GLContextImpl.MappedGLVersionListener mappedGLVersionListener) {
        GLContextImpl.setMappedGLVersionListener((GLContextImpl.MappedGLVersionListener)mappedGLVersionListener);
    }

    protected static String getGLVersion(int n, int n2, int n3, String string) {
        return GLContext.getGLVersion((int)n, (int)n2, (int)n3, (String)string);
    }

    protected static String toHexString(int n) {
        return GLContext.toHexString((int)n);
    }

    protected static String toHexString(long l) {
        return GLContext.toHexString((long)l);
    }

    protected void copyImpl(GLContext gLContext, int n) throws GLException {
        throw new GLException("Not yet implemented");
    }
}

