/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.egl;

import com.jogamp.common.ExceptionUtils;
import com.jogamp.common.nio.Buffers;
import com.jogamp.common.util.LongObjectHashMap;
import com.jogamp.common.util.VersionNumber;
import com.jogamp.nativewindow.AbstractGraphicsDevice;
import com.jogamp.nativewindow.NativeSurface;
import com.jogamp.nativewindow.NativeWindowFactory;
import com.jogamp.nativewindow.egl.EGLGraphicsDevice;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.egl.EGL;
import java.io.PrintStream;
import java.nio.IntBuffer;
import jogamp.opengl.Debug;
import jogamp.opengl.GLVersionNumber;
import jogamp.opengl.egl.EGLContext;

public class EGLDisplayUtil {
    private static final boolean DEBUG = Debug.debug((String)"EGLDisplayUtil");
    private static boolean useSingletonEGLDisplay = false;
    private static EGLDisplayRef singletonEGLDisplay = null;
    private static final LongObjectHashMap openEGLDisplays = new LongObjectHashMap();
    private static boolean eglGetPlatformDisplayProbed;
    private static boolean eglGetPlatformDisplayAvail;
    private static VersionNumber eglGetPlatformDisplayMinVersion;
    private static final IntBuffer _eglMajorVersion;
    private static final IntBuffer _eglMinorVersion;
    private static final EGLGraphicsDevice.EGLDisplayLifecycleCallback eglLifecycleCallback;

    public static int shutdown(boolean bl) {
        if (DEBUG || bl || openEGLDisplays.size() > 0) {
            System.err.println("EGLDisplayUtil.EGLDisplays: Shutdown (open: " + openEGLDisplays.size() + ")");
            if (DEBUG) {
                ExceptionUtils.dumpStack((PrintStream)System.err);
            }
            if (openEGLDisplays.size() > 0) {
                EGLDisplayUtil.dumpOpenDisplayConnections();
            }
        }
        return openEGLDisplays.size();
    }

    public static void dumpOpenDisplayConnections() {
        System.err.println("EGLDisplayUtil: Open EGL Display Connections: " + openEGLDisplays.size());
        int n = 0;
        for (LongObjectHashMap.Entry entry : openEGLDisplays) {
            EGLDisplayRef eGLDisplayRef = (EGLDisplayRef)entry.value;
            System.err.println("EGLDisplayUtil: Open[" + n + "]: 0x" + Long.toHexString(entry.key) + ": " + eGLDisplayRef);
            if (null != eGLDisplayRef.createdStack) {
                eGLDisplayRef.createdStack.printStackTrace();
            }
            ++n;
        }
    }

    static synchronized void setSingletonEGLDisplayOnly(boolean bl) {
        useSingletonEGLDisplay = bl;
    }

    public static int getEGLPlatformType(boolean bl) {
        return EGLDisplayUtil.getEGLPlatformType(NativeWindowFactory.getNativeWindowType((boolean)bl));
    }

    public static int getEGLPlatformType(String string) {
        int n;
        switch (string) {
            case ".x11": {
                n = 12757;
                break;
            }
            case ".android": {
                n = 12609;
                break;
            }
            case ".egl.gbm": {
                n = 12759;
                break;
            }
            case ".wayland": {
                n = 12760;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    private static synchronized long eglGetDisplay(long l) {
        if (useSingletonEGLDisplay && null != singletonEGLDisplay) {
            if (DEBUG) {
                System.err.println("EGLDisplayUtil.eglGetDisplay.s: eglDisplay(" + EGLContext.toHexString(l) + "): " + EGLContext.toHexString(EGLDisplayUtil.singletonEGLDisplay.eglDisplay) + ", " + (0L != EGLDisplayUtil.singletonEGLDisplay.eglDisplay ? "OK" : "Failed") + ", singletonEGLDisplay " + singletonEGLDisplay + " (use " + useSingletonEGLDisplay + ")");
            }
            return EGLDisplayUtil.singletonEGLDisplay.eglDisplay;
        }
        if (!eglGetPlatformDisplayProbed) {
            int n;
            boolean bl = false;
            boolean bl2 = false;
            GLVersionNumber gLVersionNumber = GLVersionNumber.create((String)EGL.eglQueryString(0L, 12372));
            int n2 = EGL.eglGetError();
            boolean bl3 = eglGetPlatformDisplayAvail = 12288 == n2 && gLVersionNumber.isValid() && gLVersionNumber.compareTo(eglGetPlatformDisplayMinVersion) >= 0;
            if (!eglGetPlatformDisplayAvail) {
                String string = EGL.eglQueryString(0L, 12373);
                n = EGL.eglGetError();
                if (12288 == n && null != string && string.length() > 0 && string.indexOf("EGL_EXT_platform_base") >= 0) {
                    eglGetPlatformDisplayAvail = true;
                    bl2 = true;
                }
            } else {
                n = 12288;
            }
            eglGetPlatformDisplayProbed = true;
            if (DEBUG) {
                System.err.println("EGLDisplayUtil.eglGetDisplay.p: eglGetPlatformDisplay available: " + eglGetPlatformDisplayAvail + ", eglClientVersion '" + gLVersionNumber + "' via[Version " + bl3 + ", err 0x" + Integer.toHexString(n2) + " / Extension " + bl2 + ", err 0x" + Integer.toHexString(n) + "]");
            }
        }
        int n = EGLDisplayUtil.getEGLPlatformType(true);
        long l2 = eglGetPlatformDisplayAvail && 0 != n ? EGL.eglGetPlatformDisplay(n, l, null) : EGL.eglGetDisplay(l);
        if (DEBUG) {
            System.err.println("EGLDisplayUtil.eglGetDisplay.X: eglDisplay(" + EGLContext.toHexString(l) + ") @ " + n + "/" + NativeWindowFactory.getNativeWindowType((boolean)true) + ": " + EGLContext.toHexString(l2) + ", " + (0L != l2 ? "OK" : "Failed") + ", singletonEGLDisplay " + singletonEGLDisplay + " (use " + useSingletonEGLDisplay + ")");
        }
        return l2;
    }

    private static synchronized boolean eglInitialize(long l, int[] nArray, int[] nArray2) {
        if (0L == l) {
            return false;
        }
        EGLDisplayRef eGLDisplayRef = EGLDisplayRef.getOrCreateOpened(l, _eglMajorVersion, _eglMinorVersion);
        int n = _eglMajorVersion.get(0);
        int n2 = _eglMinorVersion.get(0);
        if (null != nArray && null != nArray2) {
            if (null != eGLDisplayRef) {
                nArray[0] = n;
                nArray2[0] = n2;
            } else {
                nArray[0] = 0;
                nArray2[0] = 0;
            }
        }
        if (DEBUG) {
            System.err.println("EGLDisplayUtil.eglInitialize(" + EGLContext.toHexString(l) + " ...): " + eGLDisplayRef + " = " + (null != eGLDisplayRef) + ", eglVersion " + n + "." + n2 + ", singletonEGLDisplay " + singletonEGLDisplay + " (use " + useSingletonEGLDisplay + ")");
        }
        return null != eGLDisplayRef;
    }

    private static synchronized int eglGetDisplayAndInitialize(long l, long[] lArray, int[] nArray, int[] nArray2, int[] nArray3) {
        lArray[0] = 0L;
        long l2 = EGLDisplayUtil.eglGetDisplay(l);
        if (0L == l2) {
            nArray[0] = EGL.eglGetError();
            return 12296;
        }
        if (!EGLDisplayUtil.eglInitialize(l2, nArray2, nArray3)) {
            nArray[0] = EGL.eglGetError();
            return 12289;
        }
        lArray[0] = l2;
        return 12288;
    }

    private static synchronized long eglGetDisplayAndInitialize(long[] lArray, int[] nArray, int[] nArray2) {
        long[] lArray2 = new long[1];
        int[] nArray3 = new int[1];
        int n = EGLDisplayUtil.eglGetDisplayAndInitialize(lArray[0], lArray2, nArray3, nArray, nArray2);
        if (12288 == n) {
            return lArray2[0];
        }
        if (0L != lArray[0]) {
            if (DEBUG) {
                System.err.println("EGLDisplayUtil.eglGetAndInitDisplay failed with native " + EGLContext.toHexString(lArray[0]) + ", error " + EGLContext.toHexString(n) + "/" + EGLContext.toHexString(nArray3[0]) + " - fallback!");
            }
            if (12288 == (n = EGLDisplayUtil.eglGetDisplayAndInitialize(0L, lArray2, nArray3, nArray, nArray2))) {
                lArray[0] = 0L;
                return lArray2[0];
            }
        }
        throw new GLException("Failed to created/initialize EGL display incl. fallback default: native " + EGLContext.toHexString(lArray[0]) + ", error " + EGLContext.toHexString(n) + "/" + EGLContext.toHexString(nArray3[0]));
    }

    private static synchronized boolean eglTerminate(long l) {
        if (0L == l) {
            return false;
        }
        boolean[] blArray = new boolean[1];
        EGLDisplayRef eGLDisplayRef = EGLDisplayRef.closeOpened(l, blArray);
        if (DEBUG) {
            System.err.println("EGLDisplayUtil.eglTerminate.X(" + EGLContext.toHexString(l) + " ...): " + eGLDisplayRef + " = " + blArray[0] + ", singletonEGLDisplay " + singletonEGLDisplay + " (use " + useSingletonEGLDisplay + ")");
        }
        return blArray[0];
    }

    public static EGLGraphicsDevice eglCreateEGLGraphicsDevice(long l, String string, int n) {
        return new EGLGraphicsDevice(l, string, n, eglLifecycleCallback);
    }

    public static EGLGraphicsDevice eglCreateEGLGraphicsDevice(AbstractGraphicsDevice abstractGraphicsDevice) {
        return new EGLGraphicsDevice(abstractGraphicsDevice, eglLifecycleCallback);
    }

    public static EGLGraphicsDevice eglCreateEGLGraphicsDevice(NativeSurface nativeSurface) {
        long l = ".windows" == NativeWindowFactory.getNativeWindowType((boolean)false) ? nativeSurface.getSurfaceHandle() : nativeSurface.getDisplayHandle();
        AbstractGraphicsDevice abstractGraphicsDevice = nativeSurface.getGraphicsConfiguration().getScreen().getDevice();
        return new EGLGraphicsDevice(l, abstractGraphicsDevice.getConnection(), abstractGraphicsDevice.getUnitID(), eglLifecycleCallback);
    }

    static {
        openEGLDisplays.setKeyNotFoundValue(null);
        eglGetPlatformDisplayProbed = false;
        eglGetPlatformDisplayAvail = false;
        eglGetPlatformDisplayMinVersion = new VersionNumber(1, 5, 0);
        _eglMajorVersion = Buffers.newDirectIntBuffer((int)1);
        _eglMinorVersion = Buffers.newDirectIntBuffer((int)1);
        eglLifecycleCallback = new EGLGraphicsDevice.EGLDisplayLifecycleCallback(){

            public long eglGetAndInitDisplay(long[] lArray, int[] nArray, int[] nArray2) {
                return EGLDisplayUtil.eglGetDisplayAndInitialize(lArray, nArray, nArray2);
            }

            public void eglTerminate(long l) {
                EGLDisplayUtil.eglTerminate(l);
            }
        };
    }

    private static class EGLDisplayRef {
        final long eglDisplay;
        final Throwable createdStack;
        int initRefCount;

        static EGLDisplayRef getOrCreateOpened(long l, IntBuffer intBuffer, IntBuffer intBuffer2) {
            EGLDisplayRef eGLDisplayRef = (EGLDisplayRef)openEGLDisplays.get(l);
            if (null == eGLDisplayRef) {
                boolean bl = EGL.eglInitialize(l, intBuffer, intBuffer2);
                if (DEBUG) {
                    System.err.println("EGLDisplayUtil.EGL.eglInitialize 0x" + Long.toHexString(l) + " -> " + bl);
                }
                if (bl) {
                    EGLDisplayRef eGLDisplayRef2 = new EGLDisplayRef(l);
                    openEGLDisplays.put(l, (Object)eGLDisplayRef2);
                    ++eGLDisplayRef2.initRefCount;
                    if (DEBUG) {
                        System.err.println("EGLDisplayUtil.EGL.eglInitialize " + eGLDisplayRef2);
                    }
                    if (null == singletonEGLDisplay) {
                        singletonEGLDisplay = eGLDisplayRef2;
                    }
                    return eGLDisplayRef2;
                }
                return null;
            }
            ++eGLDisplayRef.initRefCount;
            return eGLDisplayRef;
        }

        static EGLDisplayRef closeOpened(long l, boolean[] blArray) {
            EGLDisplayRef eGLDisplayRef = (EGLDisplayRef)openEGLDisplays.get(l);
            blArray[0] = true;
            if (null != eGLDisplayRef) {
                if (0 < eGLDisplayRef.initRefCount) {
                    --eGLDisplayRef.initRefCount;
                    if (0 == eGLDisplayRef.initRefCount) {
                        boolean bl = EGL.eglTerminate(l);
                        if (DEBUG) {
                            System.err.println("EGLDisplayUtil.EGL.eglTerminate 0x" + Long.toHexString(l) + " -> " + bl);
                            System.err.println("EGLDisplayUtil.EGL.eglTerminate " + eGLDisplayRef);
                        }
                        blArray[0] = bl;
                        if (eGLDisplayRef == singletonEGLDisplay) {
                            singletonEGLDisplay = null;
                        }
                    }
                }
                if (0 >= eGLDisplayRef.initRefCount) {
                    openEGLDisplays.remove(l);
                }
            }
            return eGLDisplayRef;
        }

        private EGLDisplayRef(long l) {
            this.eglDisplay = l;
            this.initRefCount = 0;
            this.createdStack = DEBUG ? new Throwable() : null;
        }

        public String toString() {
            return "EGLDisplayRef[0x" + Long.toHexString(this.eglDisplay) + ": refCnt " + this.initRefCount + "]";
        }
    }
}

