/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.egl;

import com.jogamp.common.ExceptionUtils;
import com.jogamp.nativewindow.NativeSurface;
import com.jogamp.nativewindow.ProxySurface;
import com.jogamp.nativewindow.egl.EGLGraphicsDevice;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLDrawableFactory;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.egl.EGL;
import java.io.PrintStream;
import jogamp.nativewindow.ProxySurfaceImpl;
import jogamp.opengl.GLDrawableImpl;
import jogamp.opengl.egl.EGLContext;
import jogamp.opengl.egl.EGLDrawableFactory;
import jogamp.opengl.egl.EGLSurface;

public class EGLDrawable
extends GLDrawableImpl {
    static boolean DEBUG = GLDrawableImpl.DEBUG;

    protected EGLDrawable(EGLDrawableFactory eGLDrawableFactory, EGLSurface eGLSurface) throws GLException {
        super((GLDrawableFactory)eGLDrawableFactory, (NativeSurface)eGLSurface, false);
    }

    public final GLContext createContext(GLContext gLContext) {
        return new EGLContext(this, gLContext);
    }

    protected final void createHandle() {
        EGLSurface eGLSurface = (EGLSurface)this.surface;
        if (DEBUG) {
            System.err.println(EGLDrawable.getThreadName() + ": createHandle of " + (Object)((Object)eGLSurface));
            ProxySurfaceImpl.dumpHierarchy((PrintStream)System.err, (ProxySurface)eGLSurface);
        }
        if (eGLSurface.containsUpstreamOptionBits(64)) {
            if (0L != eGLSurface.getSurfaceHandle()) {
                throw new InternalError("Set surface but claimed to be invalid: " + (Object)((Object)eGLSurface));
            }
            if (!eGLSurface.containsUpstreamOptionBits(512)) {
                eGLSurface.setEGLSurfaceHandle();
            }
        } else if (0L == eGLSurface.getSurfaceHandle()) {
            throw new InternalError("Nil surface but claimed to be valid: " + (Object)((Object)eGLSurface));
        }
    }

    protected void destroyHandle() {
        EGLSurface eGLSurface = (EGLSurface)this.surface;
        long l = eGLSurface.getSurfaceHandle();
        if (DEBUG) {
            System.err.println(EGLDrawable.getThreadName() + ": EGLDrawable: destroyHandle of " + EGLDrawable.toHexString((long)l));
            ProxySurfaceImpl.dumpHierarchy((PrintStream)System.err, (ProxySurface)eGLSurface);
            System.err.println(EGLDrawable.getThreadName() + ": EGLSurface         : " + (Object)((Object)eGLSurface));
            ExceptionUtils.dumpStack((PrintStream)System.err);
        }
        if (!eGLSurface.containsUpstreamOptionBits(512) && 0L == l) {
            throw new InternalError("Nil surface but claimed to be valid: " + (Object)((Object)eGLSurface));
        }
        EGLGraphicsDevice eGLGraphicsDevice = (EGLGraphicsDevice)eGLSurface.getGraphicsConfiguration().getScreen().getDevice();
        if (eGLSurface.containsUpstreamOptionBits(64) && 0L != l) {
            EGL.eglDestroySurface(eGLGraphicsDevice.getHandle(), l);
            eGLSurface.setSurfaceHandle(0L);
        }
    }

    protected final void setRealizedImpl() {
        if (DEBUG) {
            System.err.println(EGLDrawable.getThreadName() + ": EGLDrawable.setRealized(" + this.realized + "): NOP - " + this.surface);
        }
    }

    protected final void swapBuffersImpl(boolean bl) {
        EGLGraphicsDevice eGLGraphicsDevice;
        if (bl && !EGL.eglSwapBuffers((eGLGraphicsDevice = (EGLGraphicsDevice)this.surface.getGraphicsConfiguration().getScreen().getDevice()).getHandle(), this.surface.getSurfaceHandle())) {
            throw new GLException("Error swapping buffers, eglError " + EGLDrawable.toHexString((long)EGL.eglGetError()) + ", " + (Object)((Object)this));
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + "[realized " + this.isRealized() + ",\n\tfactory    " + this.getFactory() + ",\n\tsurface    " + this.getNativeSurface() + ",\n\teglSurface " + EGLDrawable.toHexString((long)this.surface.getSurfaceHandle()) + ",\n\teglConfig  " + this.surface.getGraphicsConfiguration() + ",\n\trequested  " + this.getRequestedGLCapabilities() + ",\n\tchosen     " + this.getChosenGLCapabilities() + "]";
    }
}

