/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.egl;

import com.jogamp.nativewindow.AbstractGraphicsDevice;
import com.jogamp.nativewindow.NativeWindowException;
import com.jogamp.nativewindow.VisualIDHolder;
import com.jogamp.nativewindow.egl.EGLGraphicsDevice;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLProfile;

public class EGLGLCapabilities
extends GLCapabilities {
    private long eglcfg;
    private final int eglcfgid;
    private final int renderableType;
    private final int nativeVisualID;

    public EGLGLCapabilities(long l, int n, int n2, GLProfile gLProfile, int n3) {
        super(gLProfile);
        this.eglcfg = l;
        this.eglcfgid = n;
        if (!EGLGLCapabilities.isCompatible(gLProfile, n3)) {
            throw new GLException("Requested GLProfile " + gLProfile + " not compatible with EGL-RenderableType[" + EGLGLCapabilities.renderableTypeToString(null, n3) + "]");
        }
        this.renderableType = n3;
        this.nativeVisualID = n2;
    }

    public Object cloneMutable() {
        return this.clone();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (RuntimeException runtimeException) {
            throw new GLException((Throwable)runtimeException);
        }
    }

    protected final void setEGLConfig(long l) {
        this.eglcfg = l;
    }

    public final long getEGLConfig() {
        return this.eglcfg;
    }

    public final int getEGLConfigID() {
        return this.eglcfgid;
    }

    public final int getRenderableType() {
        return this.renderableType;
    }

    public final int getNativeVisualID() {
        return this.nativeVisualID;
    }

    public final int getVisualID(VisualIDHolder.VIDType vIDType) throws NativeWindowException {
        switch (vIDType) {
            case INTRINSIC: 
            case EGL_CONFIG: {
                return this.getEGLConfigID();
            }
            case NATIVE: {
                return this.getNativeVisualID();
            }
        }
        throw new NativeWindowException("Invalid type <" + vIDType + ">");
    }

    public static boolean isCompatible(GLProfile gLProfile, int n) {
        if (null == gLProfile) {
            return true;
        }
        if (0 != (n & 0x40) && gLProfile.usesNativeGLES3()) {
            return true;
        }
        if (0 != (n & 4) && gLProfile.usesNativeGLES2()) {
            return true;
        }
        if (0 != (n & 1) && gLProfile.usesNativeGLES1()) {
            return true;
        }
        return 0 != (n & 8) && !gLProfile.usesNativeGLES();
    }

    public static GLProfile getCompatible(EGLGraphicsDevice eGLGraphicsDevice, int n) {
        if (0 != (n & 0x40) && GLProfile.isAvailable((AbstractGraphicsDevice)eGLGraphicsDevice, (String)"GLES3")) {
            return GLProfile.get((AbstractGraphicsDevice)eGLGraphicsDevice, (String)"GLES3");
        }
        if (0 != (n & 4) && GLProfile.isAvailable((AbstractGraphicsDevice)eGLGraphicsDevice, (String)"GLES2")) {
            return GLProfile.get((AbstractGraphicsDevice)eGLGraphicsDevice, (String)"GLES2");
        }
        if (0 != (n & 1) && GLProfile.isAvailable((AbstractGraphicsDevice)eGLGraphicsDevice, (String)"GLES1")) {
            return GLProfile.get((AbstractGraphicsDevice)eGLGraphicsDevice, (String)"GLES1");
        }
        if (0 != (n & 8)) {
            return GLProfile.getDefault((AbstractGraphicsDevice)eGLGraphicsDevice);
        }
        return null;
    }

    public static StringBuilder renderableTypeToString(StringBuilder stringBuilder, int n) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        boolean bl = true;
        stringBuilder.append("0x").append(Integer.toHexString(n)).append(": ");
        if (0 != (n & 8)) {
            stringBuilder.append("GL");
            bl = false;
        }
        if (0 != (n & 1)) {
            if (!bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("GLES1");
            bl = false;
        }
        if (0 != (n & 4)) {
            if (!bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("GLES2");
            bl = false;
        }
        if (0 != (n & 0x40)) {
            if (!bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("GLES3");
            bl = false;
        }
        if (0 != (n & 0x30A1)) {
            if (!bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("VG");
            bl = false;
        }
        return stringBuilder;
    }

    public StringBuilder toString(StringBuilder stringBuilder) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        stringBuilder.append("egl cfg 0x").append(Integer.toHexString(this.eglcfgid));
        stringBuilder.append(", vid 0x").append(Integer.toHexString(this.nativeVisualID)).append(": ");
        super.toString(stringBuilder);
        stringBuilder.append(", [");
        EGLGLCapabilities.renderableTypeToString(stringBuilder, this.renderableType);
        return stringBuilder.append("]");
    }
}

