/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.egl;

import com.jogamp.common.nio.Buffers;
import com.jogamp.nativewindow.AbstractGraphicsConfiguration;
import com.jogamp.nativewindow.GenericUpstreamSurfacelessHook;
import com.jogamp.nativewindow.NativeSurface;
import com.jogamp.nativewindow.NativeWindow;
import com.jogamp.nativewindow.NativeWindowFactory;
import com.jogamp.nativewindow.ProxySurface;
import com.jogamp.nativewindow.UpstreamSurfaceHook;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.egl.EGL;
import java.io.PrintStream;
import java.nio.IntBuffer;
import jogamp.nativewindow.ProxySurfaceImpl;
import jogamp.nativewindow.WrappedSurface;
import jogamp.opengl.GLDrawableImpl;
import jogamp.opengl.egl.EGLContext;
import jogamp.opengl.egl.EGLDisplayUtil;
import jogamp.opengl.egl.EGLDrawable;
import jogamp.opengl.egl.EGLDrawableFactory;
import jogamp.opengl.egl.EGLGraphicsConfiguration;
import jogamp.opengl.egl.EGLUpstreamSurfaceHook;

public class EGLSurface
extends WrappedSurface {
    static boolean DEBUG = EGLDrawable.DEBUG || ProxySurface.DEBUG;

    public static EGLSurface get(NativeSurface nativeSurface) {
        if (nativeSurface instanceof EGLSurface) {
            return (EGLSurface)nativeSurface;
        }
        return new EGLSurface(nativeSurface);
    }

    private EGLSurface(NativeSurface nativeSurface) {
        super(nativeSurface.getGraphicsConfiguration(), 0L, (UpstreamSurfaceHook)new EGLUpstreamSurfaceHook(nativeSurface), false);
        if (EGLDrawableFactory.DEBUG) {
            System.err.println("EGLSurface.ctor().1: " + (Object)((Object)this));
            ProxySurfaceImpl.dumpHierarchy((PrintStream)System.err, (ProxySurface)this);
        }
    }

    public static EGLSurface createWrapped(EGLGraphicsConfiguration eGLGraphicsConfiguration, long l, UpstreamSurfaceHook upstreamSurfaceHook, boolean bl) {
        return new EGLSurface(eGLGraphicsConfiguration, l, upstreamSurfaceHook, bl);
    }

    private EGLSurface(EGLGraphicsConfiguration eGLGraphicsConfiguration, long l, UpstreamSurfaceHook upstreamSurfaceHook, boolean bl) {
        super((AbstractGraphicsConfiguration)eGLGraphicsConfiguration, 0L, (UpstreamSurfaceHook)new EGLUpstreamSurfaceHook(eGLGraphicsConfiguration, l, upstreamSurfaceHook, bl), false);
        if (EGLDrawableFactory.DEBUG) {
            System.err.println("EGLSurface.ctor().2: " + (Object)((Object)this));
            ProxySurfaceImpl.dumpHierarchy((PrintStream)System.err, (ProxySurface)this);
        }
    }

    public static EGLSurface createSurfaceless(EGLGraphicsConfiguration eGLGraphicsConfiguration, GenericUpstreamSurfacelessHook genericUpstreamSurfacelessHook, boolean bl) {
        return new EGLSurface(eGLGraphicsConfiguration, genericUpstreamSurfacelessHook, bl);
    }

    private EGLSurface(EGLGraphicsConfiguration eGLGraphicsConfiguration, GenericUpstreamSurfacelessHook genericUpstreamSurfacelessHook, boolean bl) {
        super((AbstractGraphicsConfiguration)eGLGraphicsConfiguration, 0L, (UpstreamSurfaceHook)genericUpstreamSurfacelessHook, bl);
        if (EGLDrawableFactory.DEBUG) {
            System.err.println("EGLSurface.ctor().3: " + (Object)((Object)this));
            ProxySurfaceImpl.dumpHierarchy((PrintStream)System.err, (ProxySurface)this);
        }
    }

    public static long eglCreateWindowSurface(long l, long l2, long l3) {
        int n = EGLDisplayUtil.getEGLPlatformType(true);
        return EGL.eglCreateWindowSurface(l, l2, l3, null);
    }

    public void setEGLSurfaceHandle() throws GLException {
        this.setSurfaceHandle(this.createEGLSurface());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private long createEGLSurface() throws GLException {
        EGLGraphicsConfiguration eGLGraphicsConfiguration = (EGLGraphicsConfiguration)this.getGraphicsConfiguration();
        NativeSurface nativeSurface = this.getUpstreamSurface();
        boolean bl = ((GLCapabilitiesImmutable)eGLGraphicsConfiguration.getChosenCapabilities()).isPBuffer();
        long l = this.createEGLSurface(bl, true, eGLGraphicsConfiguration, nativeSurface);
        if (DEBUG) {
            System.err.println(EGLSurface.getThreadName() + ": EGLSurface: EGL.eglCreateSurface.0: 0x" + Long.toHexString(l));
            ProxySurfaceImpl.dumpHierarchy((PrintStream)System.err, (ProxySurface)this);
        }
        if (0L == l) {
            int n = EGL.eglGetError();
            if (12299 != n || bl) throw new GLException("Creation of window surface w/ surface handle failed (1): " + eGLGraphicsConfiguration + ", " + (Object)((Object)this) + ", error " + GLDrawableImpl.toHexString((long)n));
            if (!EGLSurface.hasUniqueNativeWindowHandle(nativeSurface)) throw new GLException("Creation of window surface w/ surface handle failed (2): " + eGLGraphicsConfiguration + ", " + (Object)((Object)this) + ", error " + GLDrawableImpl.toHexString((long)n));
            l = this.createEGLSurface(bl, false, eGLGraphicsConfiguration, nativeSurface);
            if (DEBUG) {
                System.err.println(EGLSurface.getThreadName() + ": Info: Creation of window surface w/ surface handle failed: " + eGLGraphicsConfiguration + ", error " + GLDrawableImpl.toHexString((long)n) + ", retry w/ windowHandle");
                System.err.println(EGLSurface.getThreadName() + ": EGLSurface: EGL.eglCreateSurface.1: 0x" + Long.toHexString(l));
            }
            if (0L == l) {
                throw new GLException("Creation of window surface w/ window handle failed: " + eGLGraphicsConfiguration + ", " + (Object)((Object)this) + ", error " + GLDrawableImpl.toHexString((long)EGL.eglGetError()));
            }
        }
        if (!DEBUG) return l;
        System.err.println(EGLSurface.getThreadName() + ": createEGLSurface handle " + GLDrawableImpl.toHexString((long)l));
        return l;
    }

    private long createEGLSurface(boolean bl, boolean bl2, EGLGraphicsConfiguration eGLGraphicsConfiguration, NativeSurface nativeSurface) {
        if (bl) {
            return EGLDrawableFactory.createPBufferSurfaceImpl(eGLGraphicsConfiguration, this.getSurfaceWidth(), this.getSurfaceHeight(), false);
        }
        long l = bl2 ? nativeSurface.getSurfaceHandle() : ((NativeWindow)nativeSurface).getWindowHandle();
        long l2 = EGLSurface.eglCreateWindowSurface(eGLGraphicsConfiguration.getScreen().getDevice().getHandle(), eGLGraphicsConfiguration.getNativeConfig(), l);
        if (DEBUG) {
            int n = EGLDisplayUtil.getEGLPlatformType(true);
            System.err.println("EGLSurface.createEGLSurface.X: useNativeSurface " + bl2 + ", nativeWin " + EGLContext.toHexString(l) + ") @ " + n + "/" + NativeWindowFactory.getNativeWindowType((boolean)true) + ": " + EGLContext.toHexString(l2) + ", " + (0L != l2 ? "OK" : "Failed") + " - with config " + eGLGraphicsConfiguration);
        }
        return l2;
    }

    private static boolean hasUniqueNativeWindowHandle(NativeSurface nativeSurface) {
        return nativeSurface instanceof NativeWindow && ((NativeWindow)nativeSurface).getWindowHandle() != nativeSurface.getSurfaceHandle();
    }

    static String getThreadName() {
        return Thread.currentThread().getName();
    }

    public static boolean isValidEGLSurfaceHandle(long l, long l2) {
        if (0L == l2) {
            return false;
        }
        IntBuffer intBuffer = Buffers.newDirectIntBuffer((int)1);
        boolean bl = EGL.eglQuerySurface(l, l2, 12328, intBuffer);
        if (!bl) {
            int n = EGL.eglGetError();
            if (DEBUG) {
                System.err.println(EGLSurface.getThreadName() + ": EGLSurface.isValidEGLSurfaceHandle eglQuerySuface failed: error " + GLDrawableImpl.toHexString((long)n) + ", " + GLDrawableImpl.toHexString((long)l2));
            }
        }
        return bl;
    }
}

