/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.egl;

import com.jogamp.nativewindow.AbstractGraphicsConfiguration;
import com.jogamp.nativewindow.AbstractGraphicsDevice;
import com.jogamp.nativewindow.AbstractGraphicsScreen;
import com.jogamp.nativewindow.DefaultGraphicsScreen;
import com.jogamp.nativewindow.NativeSurface;
import com.jogamp.nativewindow.ProxySurface;
import com.jogamp.nativewindow.UpstreamSurfaceHook;
import com.jogamp.nativewindow.VisualIDHolder;
import com.jogamp.nativewindow.egl.EGLGraphicsDevice;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.egl.EGL;
import jogamp.nativewindow.WrappedSurface;
import jogamp.opengl.egl.EGLContext;
import jogamp.opengl.egl.EGLDisplayUtil;
import jogamp.opengl.egl.EGLDrawableFactory;
import jogamp.opengl.egl.EGLGLCapabilities;
import jogamp.opengl.egl.EGLGraphicsConfiguration;
import jogamp.opengl.egl.EGLGraphicsConfigurationFactory;
import jogamp.opengl.egl.EGLSurface;

public class EGLUpstreamSurfaceHook
implements UpstreamSurfaceHook.MutableSize {
    private static final boolean DEBUG = EGLDrawableFactory.DEBUG;
    private final NativeSurface upstreamSurface;
    private final UpstreamSurfaceHook.MutableSize upstreamSurfaceHookMutableSize;

    public EGLUpstreamSurfaceHook(NativeSurface nativeSurface) {
        UpstreamSurfaceHook upstreamSurfaceHook;
        this.upstreamSurface = nativeSurface;
        this.upstreamSurfaceHookMutableSize = this.upstreamSurface instanceof ProxySurface ? ((upstreamSurfaceHook = ((ProxySurface)this.upstreamSurface).getUpstreamSurfaceHook()) instanceof UpstreamSurfaceHook.MutableSize ? (UpstreamSurfaceHook.MutableSize)upstreamSurfaceHook : null) : null;
    }

    public EGLUpstreamSurfaceHook(EGLGraphicsConfiguration eGLGraphicsConfiguration, long l, UpstreamSurfaceHook upstreamSurfaceHook, boolean bl) {
        this((NativeSurface)new WrappedSurface((AbstractGraphicsConfiguration)eGLGraphicsConfiguration, l, upstreamSurfaceHook, bl));
    }

    static String getThreadName() {
        return Thread.currentThread().getName();
    }

    public final NativeSurface getUpstreamSurface() {
        return this.upstreamSurface;
    }

    public final void setSurfaceSize(int n, int n2) {
        if (null != this.upstreamSurfaceHookMutableSize) {
            this.upstreamSurfaceHookMutableSize.setSurfaceSize(n, n2);
        }
    }

    public final void create(ProxySurface proxySurface) {
        String string;
        if (DEBUG) {
            string = EGLUpstreamSurfaceHook.getThreadName() + ": EGLUpstreamSurfaceHook.create( up " + this.upstreamSurface.getClass().getSimpleName() + " -> this " + proxySurface.getClass().getSimpleName() + " ): ";
            System.err.println(string + this);
        } else {
            string = null;
        }
        if (this.upstreamSurface instanceof ProxySurface) {
            ((ProxySurface)this.upstreamSurface).createNotify();
        }
        if (1 >= this.upstreamSurface.lockSurface()) {
            throw new GLException("Could not lock: " + this.upstreamSurface);
        }
        try {
            this.evalUpstreamSurface(string, proxySurface);
        }
        finally {
            this.upstreamSurface.unlockSurface();
        }
    }

    private final void evalUpstreamSurface(String string, ProxySurface proxySurface) {
        AbstractGraphicsConfiguration abstractGraphicsConfiguration;
        EGLGraphicsDevice eGLGraphicsDevice;
        Object object;
        boolean bl = true;
        AbstractGraphicsConfiguration abstractGraphicsConfiguration2 = proxySurface.getGraphicsConfiguration();
        AbstractGraphicsDevice abstractGraphicsDevice = object = null != abstractGraphicsConfiguration2 ? abstractGraphicsConfiguration2.getScreen().getDevice() : null;
        if (DEBUG) {
            System.err.println(string + "SurfaceDevice: " + object.getClass().getSimpleName() + ", hash 0x" + Integer.toHexString(object.hashCode()) + ", " + object);
            System.err.println(string + "SurfaceConfig: " + abstractGraphicsConfiguration2.getClass().getSimpleName() + ", hash 0x" + Integer.toHexString(abstractGraphicsConfiguration2.hashCode()) + ", " + abstractGraphicsConfiguration2);
        }
        Object object2 = this.upstreamSurface.getGraphicsConfiguration();
        AbstractGraphicsDevice abstractGraphicsDevice2 = object2.getScreen().getDevice();
        if (DEBUG) {
            System.err.println(string + "UpstreamDevice: " + abstractGraphicsDevice2.getClass().getSimpleName() + ", hash 0x" + Integer.toHexString(abstractGraphicsDevice2.hashCode()) + ", " + abstractGraphicsDevice2);
            System.err.println(string + "UpstreamConfig: " + object2.getClass().getSimpleName() + ", hash 0x" + Integer.toHexString(object2.hashCode()) + ", " + object2);
        }
        if (object instanceof EGLGraphicsDevice) {
            eGLGraphicsDevice = (EGLGraphicsDevice)object;
            abstractGraphicsConfiguration = abstractGraphicsConfiguration2;
            if (DEBUG) {
                System.err.println(string + "Reusing this eglDevice: " + eGLGraphicsDevice + ", using this config " + abstractGraphicsConfiguration.getClass().getSimpleName() + " " + abstractGraphicsConfiguration);
            }
            if (0L == eGLGraphicsDevice.getHandle()) {
                eGLGraphicsDevice.open();
                bl = false;
                proxySurface.addUpstreamOptionBits(128);
            }
        } else if (abstractGraphicsDevice2 instanceof EGLGraphicsDevice) {
            eGLGraphicsDevice = (EGLGraphicsDevice)abstractGraphicsDevice2;
            abstractGraphicsConfiguration = object2;
            if (DEBUG) {
                System.err.println(string + "Reusing upstream eglDevice: " + eGLGraphicsDevice + ", using upstream config " + abstractGraphicsConfiguration.getClass().getSimpleName() + " " + abstractGraphicsConfiguration);
            }
            if (0L == eGLGraphicsDevice.getHandle()) {
                eGLGraphicsDevice.open();
                bl = false;
                proxySurface.addUpstreamOptionBits(128);
            }
        } else {
            eGLGraphicsDevice = EGLDisplayUtil.eglCreateEGLGraphicsDevice(this.upstreamSurface);
            eGLGraphicsDevice.open();
            abstractGraphicsConfiguration = object2;
            bl = false;
            proxySurface.addUpstreamOptionBits(128);
        }
        abstractGraphicsConfiguration2 = (GLCapabilitiesImmutable)abstractGraphicsConfiguration.getRequestedCapabilities();
        if (abstractGraphicsConfiguration instanceof EGLGraphicsConfiguration) {
            object2 = (EGLGLCapabilities)abstractGraphicsConfiguration.getChosenCapabilities();
            if (!bl || !EGLGraphicsConfiguration.isEGLConfigValid(eGLGraphicsDevice.getHandle(), ((EGLGLCapabilities)((Object)object2)).getEGLConfig())) {
                ((EGLGLCapabilities)((Object)object2)).setEGLConfig(EGLGraphicsConfiguration.EGLConfigId2EGLConfig(eGLGraphicsDevice.getHandle(), ((EGLGLCapabilities)((Object)object2)).getEGLConfigID()));
                if (0L == ((EGLGLCapabilities)((Object)object2)).getEGLConfig()) {
                    throw new GLException("Refreshing native EGLConfig handle failed with error " + EGLContext.toHexString(EGL.eglGetError()) + ": " + eGLGraphicsDevice + ", " + object2 + " of " + abstractGraphicsConfiguration);
                }
                abstractGraphicsDevice2 = new DefaultGraphicsScreen((AbstractGraphicsDevice)eGLGraphicsDevice, abstractGraphicsConfiguration.getScreen().getIndex());
                object = new EGLGraphicsConfiguration((AbstractGraphicsScreen)abstractGraphicsDevice2, (EGLGLCapabilities)((Object)object2), (GLCapabilitiesImmutable)abstractGraphicsConfiguration2, null);
                if (DEBUG) {
                    System.err.println(string + "Refreshing eglConfig: " + object);
                }
                bl = false;
            } else {
                object = (EGLGraphicsConfiguration)abstractGraphicsConfiguration;
                if (DEBUG) {
                    System.err.println(string + "Reusing eglConfig: " + object);
                }
            }
        } else {
            object2 = new DefaultGraphicsScreen((AbstractGraphicsDevice)eGLGraphicsDevice, abstractGraphicsConfiguration.getScreen().getIndex());
            object = EGLGraphicsConfigurationFactory.chooseGraphicsConfigurationStatic((GLCapabilitiesImmutable)abstractGraphicsConfiguration2, (GLCapabilitiesImmutable)abstractGraphicsConfiguration2, null, (AbstractGraphicsScreen)object2, abstractGraphicsConfiguration.getVisualID(VisualIDHolder.VIDType.NATIVE), false);
            if (null == object) {
                throw new GLException("Couldn't create EGLGraphicsConfiguration from " + object2);
            }
            if (DEBUG) {
                System.err.println(string + "Chosen eglConfig: " + object);
            }
            bl = false;
        }
        proxySurface.setGraphicsConfiguration((AbstractGraphicsConfiguration)object);
        if (bl) {
            bl = EGLSurface.isValidEGLSurfaceHandle(eGLGraphicsDevice.getHandle(), this.upstreamSurface.getSurfaceHandle());
        }
        if (bl) {
            proxySurface.setSurfaceHandle(this.upstreamSurface.getSurfaceHandle());
            proxySurface.clearUpstreamOptionBits(64);
            if (DEBUG) {
                System.err.println(string + "Fin: Already valid EGL surface - use as-is: " + this.upstreamSurface);
            }
        } else {
            proxySurface.setSurfaceHandle(0L);
            proxySurface.addUpstreamOptionBits(64);
            if (DEBUG) {
                System.err.println(string + "Fin: EGL surface n/a - TBD: " + this.upstreamSurface);
            }
        }
    }

    public final void destroy(ProxySurface proxySurface) {
        if (DEBUG) {
            System.err.println(EGLUpstreamSurfaceHook.getThreadName() + ": EGLUpstreamSurfaceHook.destroy(" + proxySurface.getClass().getSimpleName() + "): " + this);
        }
        proxySurface.clearUpstreamOptionBits(64);
        if (this.upstreamSurface instanceof ProxySurface) {
            ((ProxySurface)this.upstreamSurface).destroyNotify();
        }
    }

    public final int getSurfaceWidth(ProxySurface proxySurface) {
        return this.upstreamSurface.getSurfaceWidth();
    }

    public final int getSurfaceHeight(ProxySurface proxySurface) {
        return this.upstreamSurface.getSurfaceHeight();
    }

    public String toString() {
        int n;
        int n2;
        String string;
        if (null != this.upstreamSurface) {
            string = this.upstreamSurface.getClass().getName() + ": 0x" + Long.toHexString(this.upstreamSurface.getSurfaceHandle());
            n2 = this.upstreamSurface.getSurfaceWidth();
            n = this.upstreamSurface.getSurfaceHeight();
        } else {
            string = "nil";
            n2 = -1;
            n = -1;
        }
        return "EGLUpstreamSurfaceHook[ " + n2 + "x" + n + ", " + string + "]";
    }
}

