/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.util.Bitstream;
import com.jogamp.opencl.CLBuffer;
import com.jogamp.opencl.CLCommandQueue;
import com.jogamp.opencl.CLContext;
import com.jogamp.opencl.CLDevice;
import com.jogamp.opencl.CLMemObjectListener;
import com.jogamp.opencl.CLMemory;
import com.jogamp.opencl.CLPlatform;
import com.jogamp.opencl.CLSubBuffer;
import com.jogamp.opencl.CLVersion;
import com.jogamp.opencl.test.util.MiscUtils;
import com.jogamp.opencl.test.util.UITestCase;
import com.jogamp.opencl.util.CLPlatformFilters;
import com.jogamp.opencl.util.Filter;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class CLBufferTest
extends UITestCase {
    @Test
    public void createBufferFromLimitedBuffer() {
        CLContext cLContext = CLContext.create();
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(40000152);
        byteBuffer.position(76);
        IntBuffer intBuffer = byteBuffer.slice().order(ByteOrder.nativeOrder()).asIntBuffer();
        intBuffer.limit(10000000);
        CLBuffer cLBuffer = cLContext.createBuffer((Buffer)intBuffer, new CLMemory.Mem[0]);
        Assert.assertEquals((long)10000000L, (long)cLBuffer.getCLCapacity());
        Assert.assertEquals((long)40000000L, (long)cLBuffer.getNIOSize());
        Assert.assertEquals((long)10000000L, (long)cLBuffer.getNIOCapacity());
    }

    @Test
    public void cloneWithLimitedBufferTest() {
        CLContext cLContext = CLContext.create();
        IntBuffer intBuffer = ByteBuffer.allocateDirect(40001248).asIntBuffer();
        intBuffer.limit(10000000);
        CLBuffer cLBuffer = cLContext.createBuffer(40000000, new CLMemory.Mem[0]).cloneWith((Buffer)intBuffer);
        Assert.assertEquals((long)10000000L, (long)cLBuffer.getCLCapacity());
        Assert.assertEquals((long)40000000L, (long)cLBuffer.getNIOSize());
        Assert.assertEquals((long)10000000L, (long)cLBuffer.getNIOCapacity());
        cLContext.release();
    }

    @Test
    public void copyLimitedSlicedBuffersTest() {
        CLContext cLContext = CLContext.create();
        CLCommandQueue cLCommandQueue = cLContext.getDevices()[0].createCommandQueue();
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(17107);
        byteBuffer.position(153);
        byteBuffer = byteBuffer.slice();
        byteBuffer.limit(16800);
        byteBuffer.order(ByteOrder.nativeOrder());
        MiscUtils.fillBuffer(byteBuffer, 12345);
        CLBuffer cLBuffer = cLContext.createBuffer(16800, new CLMemory.Mem[0]).cloneWith((Buffer)byteBuffer);
        CLBuffer cLBuffer2 = cLContext.createByteBuffer(16800, new CLMemory.Mem[0]);
        cLCommandQueue.putWriteBuffer(cLBuffer, false).putCopyBuffer(cLBuffer, cLBuffer2, (long)cLBuffer.getNIOSize()).putReadBuffer(cLBuffer2, true).finish();
        byteBuffer.rewind();
        ((ByteBuffer)cLBuffer2.buffer).rewind();
        MiscUtils.checkIfEqual(byteBuffer, (ByteBuffer)cLBuffer2.buffer, 4200);
        cLContext.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createBufferTest() {
        System.out.println(" - - - highLevelTest; create buffer test - - - ");
        CLContext cLContext = CLContext.create();
        try {
            CLBuffer cLBuffer = cLContext.createByteBuffer(6, new CLMemory.Mem[0]);
            CLBuffer cLBuffer2 = cLContext.createShortBuffer(6, new CLMemory.Mem[0]);
            CLBuffer cLBuffer3 = cLContext.createIntBuffer(6, new CLMemory.Mem[0]);
            CLBuffer cLBuffer4 = cLContext.createLongBuffer(6, new CLMemory.Mem[0]);
            CLBuffer cLBuffer5 = cLContext.createFloatBuffer(6, new CLMemory.Mem[0]);
            CLBuffer cLBuffer6 = cLContext.createDoubleBuffer(6, new CLMemory.Mem[0]);
            List list = cLContext.getMemoryObjects();
            Assert.assertEquals((long)6L, (long)list.size());
            Assert.assertEquals((long)1L, (long)cLBuffer.getElementSize());
            Assert.assertEquals((long)2L, (long)cLBuffer2.getElementSize());
            Assert.assertEquals((long)4L, (long)cLBuffer3.getElementSize());
            Assert.assertEquals((long)8L, (long)cLBuffer4.getElementSize());
            Assert.assertEquals((long)4L, (long)cLBuffer5.getElementSize());
            Assert.assertEquals((long)8L, (long)cLBuffer6.getElementSize());
            ByteBuffer byteBuffer = Buffers.newDirectByteBuffer((int)2);
            for (CLMemory cLMemory : list) {
                CLBuffer cLBuffer7 = (CLBuffer)cLMemory;
                Buffer buffer = cLBuffer7.getBuffer();
                Assert.assertEquals((long)buffer.capacity(), (long)cLBuffer7.getCLCapacity());
                Assert.assertEquals((long)cLBuffer7.getNIOSize(), (long)cLBuffer7.getCLSize());
                Assert.assertEquals((long)Buffers.sizeOfBufferElem((Object)buffer), (long)cLBuffer7.getElementSize());
                Assert.assertEquals((long)(buffer.capacity() * Buffers.sizeOfBufferElem((Object)buffer)), (long)cLBuffer7.getCLSize());
                CLBuffer cLBuffer8 = cLBuffer7.cloneWith((Buffer)byteBuffer);
                Assert.assertEquals((long)cLBuffer7.ID, (long)cLBuffer8.ID);
                Assert.assertTrue((boolean)cLBuffer8.equals((Object)cLBuffer7));
                Assert.assertTrue((boolean)cLBuffer7.equals((Object)cLBuffer8));
                Assert.assertEquals((long)cLBuffer7.getCLSize(), (long)cLBuffer8.getCLCapacity());
                Assert.assertEquals((long)cLBuffer7.getCLSize(), (long)cLBuffer8.getCLSize());
                Assert.assertEquals((long)byteBuffer.capacity(), (long)cLBuffer8.getNIOCapacity());
            }
        }
        finally {
            cLContext.release();
        }
    }

    @Test
    public void writeCopyReadBufferTest() {
        System.out.println(" - - - highLevelTest; copy buffer test - - - ");
        CLContext cLContext = CLContext.create();
        CLBuffer cLBuffer = cLContext.createByteBuffer(40000000, new CLMemory.Mem[]{CLMemory.Mem.READ_ONLY});
        CLBuffer cLBuffer2 = cLContext.createByteBuffer(40000000, new CLMemory.Mem[]{CLMemory.Mem.READ_ONLY});
        MiscUtils.fillBuffer((ByteBuffer)cLBuffer.buffer, 12345);
        CLCommandQueue cLCommandQueue = cLContext.getDevices()[0].createCommandQueue();
        cLCommandQueue.putWriteBuffer(cLBuffer, false).putCopyBuffer(cLBuffer, cLBuffer2, (long)((ByteBuffer)cLBuffer.buffer).capacity()).putReadBuffer(cLBuffer2, true).finish();
        cLContext.release();
        System.out.println("validating computed results...");
        MiscUtils.checkIfEqual((ByteBuffer)cLBuffer.buffer, (ByteBuffer)cLBuffer2.buffer, 10000000);
        System.out.println("results are valid");
    }

    @Test
    public void bufferWithHostPointerTest() {
        System.out.println(" - - - highLevelTest; host pointer test - - - ");
        CLContext cLContext = CLContext.create();
        ByteBuffer byteBuffer = Buffers.newDirectByteBuffer((int)40000000);
        MiscUtils.fillBuffer(byteBuffer, 12345);
        CLCommandQueue cLCommandQueue = cLContext.getDevices()[0].createCommandQueue();
        CLMemory.Mem[] memArray = new CLMemory.Mem[]{CLMemory.Mem.COPY_BUFFER, CLMemory.Mem.USE_BUFFER};
        for (int i = 0; i < memArray.length; ++i) {
            System.out.println("testing with " + memArray[i] + " config");
            CLBuffer cLBuffer = cLContext.createBuffer((Buffer)byteBuffer, new CLMemory.Mem[]{CLMemory.Mem.READ_ONLY, memArray[i]});
            CLBuffer cLBuffer2 = cLContext.createByteBuffer(40000000, new CLMemory.Mem[]{CLMemory.Mem.READ_ONLY});
            cLCommandQueue.putCopyBuffer(cLBuffer, cLBuffer2, (long)((ByteBuffer)cLBuffer.buffer).capacity()).putReadBuffer(cLBuffer2, true).finish();
            Assert.assertEquals((long)2L, (long)cLContext.getMemoryObjects().size());
            cLBuffer.release();
            Assert.assertEquals((long)1L, (long)cLContext.getMemoryObjects().size());
            cLBuffer2.release();
            Assert.assertEquals((long)0L, (long)cLContext.getMemoryObjects().size());
            System.out.println("validating computed results...");
            MiscUtils.checkIfEqual((ByteBuffer)cLBuffer.buffer, (ByteBuffer)cLBuffer2.buffer, 10000000);
            System.out.println("results are valid");
        }
        cLContext.release();
    }

    @Test
    public void mapBufferTest() {
        CLBuffer cLBuffer;
        CLBuffer cLBuffer2;
        CLContext cLContext;
        System.out.println(" - - - highLevelTest; map buffer test - - - ");
        if (CLPlatform.getDefault().listCLDevices(new CLDevice.Type[]{CLDevice.Type.CPU}).length > 0) {
            cLContext = CLContext.create((CLDevice.Type[])new CLDevice.Type[]{CLDevice.Type.CPU});
            cLBuffer2 = cLContext.createBuffer(40000000, new CLMemory.Mem[]{CLMemory.Mem.READ_WRITE});
            cLBuffer = cLContext.createBuffer(40000000, new CLMemory.Mem[]{CLMemory.Mem.READ_WRITE});
        } else {
            cLContext = CLContext.create();
            cLBuffer2 = cLContext.createByteBuffer(40000000, new CLMemory.Mem[]{CLMemory.Mem.READ_WRITE, CLMemory.Mem.USE_BUFFER});
            cLBuffer = cLContext.createByteBuffer(40000000, new CLMemory.Mem[]{CLMemory.Mem.READ_WRITE, CLMemory.Mem.USE_BUFFER});
        }
        CLCommandQueue cLCommandQueue = cLContext.getDevices()[0].createCommandQueue();
        ByteBuffer byteBuffer = cLCommandQueue.putMapBuffer(cLBuffer2, CLMemory.Map.WRITE, true);
        Assert.assertEquals((long)40000000L, (long)byteBuffer.capacity());
        MiscUtils.fillBuffer(byteBuffer, 12345);
        cLCommandQueue.putUnmapMemory((CLMemory)cLBuffer2, (Buffer)byteBuffer).putCopyBuffer(cLBuffer2, cLBuffer);
        ByteBuffer byteBuffer2 = cLCommandQueue.putMapBuffer(cLBuffer, CLMemory.Map.READ, true);
        Assert.assertEquals((long)40000000L, (long)byteBuffer2.capacity());
        System.out.println("validating computed results...");
        MiscUtils.checkIfEqual(byteBuffer, byteBuffer2, 10000000);
        System.out.println("results are valid");
        cLCommandQueue.putUnmapMemory((CLMemory)cLBuffer, (Buffer)byteBuffer2);
        cLContext.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void subBufferTest01ByteBuffer() {
        System.out.println(" - - - subBufferTest - - - ");
        CLPlatform cLPlatform = CLPlatform.getDefault((Filter[])new Filter[]{CLPlatformFilters.version((CLVersion)CLVersion.CL_1_1)});
        if (cLPlatform == null) {
            System.out.println("aborting subBufferTest");
            return;
        }
        CLContext cLContext = CLContext.create((CLPlatform)cLPlatform);
        try {
            long l = cLContext.getMaxMemBaseAddrAlign();
            int n = Bitstream.uint32LongToInt((long)l);
            System.err.println("XXX: maxAlignment " + l + ", 0x" + Long.toHexString(l) + ", (int)" + n + ", (int)0x" + Integer.toHexString(n));
            if (-1 == n) {
                throw new RuntimeException("Cannot handle MaxMemBaseAddrAlign > MAX_INT, has 0x" + Long.toHexString(l));
            }
            CLBuffer cLBuffer = cLContext.createBuffer(n + 5, new CLMemory.Mem[0]);
            Assert.assertFalse((boolean)cLBuffer.isSubBuffer());
            Assert.assertNotNull((Object)cLBuffer.getSubBuffers());
            Assert.assertTrue((boolean)cLBuffer.getSubBuffers().isEmpty());
            CLSubBuffer cLSubBuffer = cLBuffer.createSubBuffer(n, 5, new CLMemory.Mem[0]);
            Assert.assertTrue((boolean)cLSubBuffer.isSubBuffer());
            Assert.assertEquals((long)5L, (long)cLSubBuffer.getCLSize());
            Assert.assertEquals((long)n, (long)cLSubBuffer.getOffset());
            Assert.assertEquals((long)n, (long)cLSubBuffer.getCLOffset());
            Assert.assertEquals((Object)cLBuffer, (Object)cLSubBuffer.getParent());
            Assert.assertEquals((long)1L, (long)cLBuffer.getSubBuffers().size());
            cLSubBuffer.release();
            Assert.assertEquals((long)0L, (long)cLBuffer.getSubBuffers().size());
        }
        finally {
            cLContext.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void subBufferTest02FloatBuffer() {
        System.out.println(" - - - subBufferTest - - - ");
        CLPlatform cLPlatform = CLPlatform.getDefault((Filter[])new Filter[]{CLPlatformFilters.version((CLVersion)CLVersion.CL_1_1)});
        if (cLPlatform == null) {
            System.out.println("aborting subBufferTest");
            return;
        }
        CLContext cLContext = CLContext.create((CLPlatform)cLPlatform);
        try {
            long l = cLContext.getMaxMemBaseAddrAlign();
            int n = Bitstream.uint32LongToInt((long)l);
            System.err.println("XXX: maxAlignment " + l + ", 0x" + Long.toHexString(l) + ", (int)" + n + ", (int)0x" + Integer.toHexString(n));
            if (-1 == n) {
                throw new RuntimeException("Cannot handle MaxMemBaseAddrAlign > MAX_INT, has 0x" + Long.toHexString(l));
            }
            int n2 = n / 4;
            CLBuffer cLBuffer = cLContext.createFloatBuffer(n2 + 5, new CLMemory.Mem[0]);
            Assert.assertFalse((boolean)cLBuffer.isSubBuffer());
            Assert.assertNotNull((Object)cLBuffer.getSubBuffers());
            Assert.assertTrue((boolean)cLBuffer.getSubBuffers().isEmpty());
            CLSubBuffer cLSubBuffer = cLBuffer.createSubBuffer(n2, 5, new CLMemory.Mem[0]);
            Assert.assertTrue((boolean)cLSubBuffer.isSubBuffer());
            Assert.assertEquals((long)5L, (long)((FloatBuffer)cLSubBuffer.getBuffer()).capacity());
            Assert.assertEquals((long)n2, (long)cLSubBuffer.getOffset());
            Assert.assertEquals((long)n, (long)cLSubBuffer.getCLOffset());
            Assert.assertEquals((Object)cLBuffer, (Object)cLSubBuffer.getParent());
            Assert.assertEquals((long)1L, (long)cLBuffer.getSubBuffers().size());
            Assert.assertEquals((long)cLSubBuffer.getCLCapacity(), (long)((FloatBuffer)cLSubBuffer.getBuffer()).capacity());
            cLSubBuffer.release();
            Assert.assertEquals((long)0L, (long)cLBuffer.getSubBuffers().size());
        }
        finally {
            cLContext.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void destructorCallbackTest() throws InterruptedException {
        System.out.println(" - - - destructorCallbackTest - - - ");
        CLPlatform cLPlatform = CLPlatform.getDefault((Filter[])new Filter[]{CLPlatformFilters.version((CLVersion)CLVersion.CL_1_1)});
        if (cLPlatform == null) {
            System.out.println("aborting destructorCallbackTest");
            return;
        }
        CLContext cLContext = CLContext.create((CLPlatform)cLPlatform);
        try {
            final CLBuffer cLBuffer = cLContext.createBuffer(32, new CLMemory.Mem[0]);
            final CountDownLatch countDownLatch = new CountDownLatch(1);
            cLBuffer.registerDestructorCallback(new CLMemObjectListener(){

                public void memoryDeallocated(CLMemory<?> cLMemory) {
                    System.out.println("buffer released");
                    Assert.assertEquals(cLMemory, (Object)cLBuffer);
                    countDownLatch.countDown();
                }
            });
            cLBuffer.release();
            countDownLatch.await(2L, TimeUnit.SECONDS);
            Assert.assertEquals((long)countDownLatch.getCount(), (long)0L);
        }
        finally {
            cLContext.release();
        }
    }

    public static void main(String[] stringArray) throws IOException {
        String string = CLBufferTest.class.getName();
        JUnitCore.main((String[])new String[]{string});
    }
}

