/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl;

import com.jogamp.opencl.CLContext;
import com.jogamp.opencl.CLDevice;
import com.jogamp.opencl.CLException;
import com.jogamp.opencl.CLKernel;
import com.jogamp.opencl.CLProgram;
import com.jogamp.opencl.CLProgramBuilder;
import com.jogamp.opencl.test.util.UITestCase;
import com.jogamp.opencl.util.CLBuildConfiguration;
import com.jogamp.opencl.util.CLBuildListener;
import com.jogamp.opencl.util.CLProgramConfiguration;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class CLProgramTest
extends UITestCase {
    @Rule
    public TemporaryFolder tmpFolder = new TemporaryFolder();
    private static final String test20KernelSource = "__attribute__((reqd_work_group_size(1, 1, 1))) kernel void foo(float a, int b, short c) { }\n";

    @Test
    public void test01Enums() {
        for (CLProgram.Status status : CLProgram.Status.values()) {
            Assert.assertEquals((Object)status, (Object)CLProgram.Status.valueOf((int)status.STATUS));
        }
    }

    @Test
    public void test02RebuildProgram() throws IOException {
        CLContext cLContext = CLContext.create();
        CLProgram cLProgram = cLContext.createProgram(this.getClass().getResourceAsStream("testkernels.cl"));
        if (!cLContext.getPlatform().isVendorAMD()) {
            try {
                cLProgram.createCLKernels();
                Assert.fail((String)"expected exception but got none :(");
            }
            catch (CLException cLException) {
                System.out.println("got expected exception:  " + cLException.getCLErrorString());
                Assert.assertEquals((long)cLException.errorcode, (long)-45L);
            }
        }
        System.out.println(cLProgram.getBuildStatus());
        cLProgram.build();
        System.out.println(cLProgram.getBuildStatus());
        Assert.assertTrue((boolean)cLProgram.isExecutable());
        CLKernel cLKernel = cLProgram.createCLKernel("VectorAddGM");
        Assert.assertNotNull((Object)cLKernel);
        cLProgram.build();
        Assert.assertTrue((boolean)cLProgram.isExecutable());
        System.out.println(cLProgram.getBuildStatus());
        cLKernel = cLProgram.createCLKernel("VectorAddGM");
        Assert.assertNotNull((Object)cLKernel);
        cLContext.release();
    }

    @Test
    public void test03ProgramBinaries() throws IOException {
        CLContext cLContext = CLContext.create();
        CLProgram cLProgram = cLContext.createProgram(this.getClass().getResourceAsStream("testkernels.cl")).build(new String[]{"-cl-mad-enable", "-Werror"});
        Map map = cLProgram.getBinaries();
        Assert.assertFalse((boolean)map.isEmpty());
        CLDevice[] cLDeviceArray = cLProgram.getCLDevices();
        for (CLDevice cLDevice : cLDeviceArray) {
            Assert.assertTrue((boolean)map.containsKey(cLDevice));
        }
        cLProgram.release();
        Assert.assertFalse((boolean)cLProgram.isExecutable());
        Assert.assertNotNull((Object)cLProgram.getBinaries());
        Assert.assertEquals((long)cLProgram.getBinaries().size(), (long)0L);
        Assert.assertNotNull((Object)cLProgram.getBuildLog());
        Assert.assertEquals((long)cLProgram.getBuildLog().length(), (long)0L);
        Assert.assertNotNull((Object)cLProgram.getSource());
        Assert.assertEquals((long)cLProgram.getSource().length(), (long)0L);
        Assert.assertNotNull((Object)cLProgram.getCLDevices());
        Assert.assertEquals((long)cLProgram.getCLDevices().length, (long)0L);
        Object object = cLProgram.createCLKernels();
        Assert.assertNotNull((Object)object);
        Assert.assertEquals((long)object.size(), (long)0L);
        Assert.assertNull((Object)cLProgram.createCLKernel("foo"));
        cLProgram = cLContext.createProgram(map);
        if (!cLContext.getPlatform().isVendorIntel()) {
            Assert.assertFalse((boolean)cLProgram.isExecutable());
        } else {
            Assert.assertTrue((boolean)cLProgram.isExecutable());
        }
        Assert.assertNotNull((Object)cLProgram.getCLDevices());
        Assert.assertTrue((cLProgram.getCLDevices().length != 0 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)cLProgram.getBinaries());
        if (!cLContext.getPlatform().isVendorIntel()) {
            Assert.assertEquals((long)cLProgram.getBinaries().size(), (long)0L);
        } else {
            Assert.assertTrue((cLProgram.getBinaries().size() > 0 ? 1 : 0) != 0);
        }
        Assert.assertNotNull((Object)cLProgram.getBuildLog());
        Assert.assertTrue((cLProgram.getBuildLog().length() != 0 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)cLProgram.getSource());
        Assert.assertEquals((long)cLProgram.getSource().length(), (long)0L);
        if (!cLContext.getPlatform().isVendorAMD() && !cLContext.getPlatform().isVendorIntel()) {
            try {
                object = cLProgram.createCLKernels();
                Assert.fail((String)("expected an exception from createCLKernels but got: " + object));
            }
            catch (CLException cLException) {
                // empty catch block
            }
        }
        System.out.println(cLProgram.getBuildStatus());
        cLProgram.build();
        System.out.println(cLProgram.getBuildStatus());
        Assert.assertNotNull((Object)cLProgram.createCLKernel("Test"));
        Assert.assertTrue((boolean)cLProgram.isExecutable());
        cLContext.release();
    }

    private void builderImpl(boolean bl) throws IOException, ClassNotFoundException, InterruptedException {
        Object object;
        Object object2;
        Object object3;
        CLContext cLContext = CLContext.create();
        CLProgram cLProgram = cLContext.createProgram(this.getClass().getResourceAsStream("testkernels.cl"));
        cLProgram.prepare().build();
        Assert.assertTrue((boolean)cLProgram.isExecutable());
        cLProgram.prepare().withOption("-cl-mad-enable").forDevice(cLContext.getMaxFlopsDevice()).withDefine("RADIUS", (Object)5).withDefine("ENABLE_FOOBAR").build();
        Assert.assertTrue((boolean)cLProgram.isExecutable());
        CLBuildConfiguration cLBuildConfiguration = CLProgramBuilder.createConfiguration().withOption("-cl-mad-enable").forDevices(cLContext.getDevices()).withDefine("RADIUS", (Object)5).withDefine("ENABLE_FOOBAR");
        System.out.println(cLBuildConfiguration);
        if (bl) {
            object3 = cLProgram;
            cLBuildConfiguration.setProgram(cLProgram).build();
            Assert.assertEquals((Object)object3, (Object)cLProgram);
        } else {
            object3 = new CountDownLatch(1);
            object2 = cLProgram;
            object = new CLBuildListener(){
                final /* synthetic */ CLProgram val$outerProgram;
                final /* synthetic */ CountDownLatch val$countdown;
                {
                    this.val$outerProgram = cLProgram;
                    this.val$countdown = countDownLatch;
                }

                public void buildFinished(CLProgram cLProgram) {
                    Assert.assertEquals((Object)this.val$outerProgram, (Object)cLProgram);
                    this.val$countdown.countDown();
                }
            };
            cLBuildConfiguration.setProgram(cLProgram).build((CLBuildListener)object);
            ((CountDownLatch)object3).await();
        }
        Assert.assertTrue((boolean)cLProgram.isExecutable());
        object3 = this.tmpFolder.newFile("foobar.builder");
        object2 = new ObjectOutputStream(new FileOutputStream((File)object3));
        cLBuildConfiguration.save((ObjectOutputStream)object2);
        ((ObjectOutputStream)object2).close();
        object = new ObjectInputStream(new FileInputStream((File)object3));
        CLBuildConfiguration cLBuildConfiguration2 = CLProgramBuilder.loadConfiguration((ObjectInputStream)object);
        ((ObjectInputStream)object).close();
        Assert.assertEquals((Object)cLBuildConfiguration, (Object)cLBuildConfiguration2);
        cLBuildConfiguration2.build(cLProgram);
        Assert.assertTrue((boolean)cLProgram.isExecutable());
        object = new ObjectInputStream(new FileInputStream((File)object3));
        CLProgramConfiguration cLProgramConfiguration = CLProgramBuilder.loadConfiguration((ObjectInputStream)object, (CLContext)cLContext);
        Assert.assertNotNull((Object)cLProgramConfiguration.getProgram());
        ((ObjectInputStream)object).close();
        cLProgram = cLProgramConfiguration.build();
        Assert.assertTrue((boolean)cLProgram.isExecutable());
        Assert.assertEquals((Object)cLBuildConfiguration, (Object)cLBuildConfiguration.clone());
        cLContext.release();
    }

    @Test
    public void test10BuilderSync() throws IOException, ClassNotFoundException, InterruptedException {
        this.builderImpl(true);
    }

    @Test
    public void test11BuilderAsync() throws IOException, ClassNotFoundException, InterruptedException {
        this.builderImpl(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test20Kernel() {
        CLContext cLContext = CLContext.create();
        try {
            CLProgram cLProgram = cLContext.createProgram(test20KernelSource).build();
            Assert.assertTrue((boolean)cLProgram.isExecutable());
            CLKernel cLKernel = cLProgram.createCLKernel("foo");
            Assert.assertNotNull((Object)cLKernel);
            long[] lArray = cLKernel.getCompileWorkGroupSize(cLContext.getDevices()[0]);
            System.out.println("compile workgroup size: " + lArray[0] + " " + lArray[1] + " " + lArray[2]);
            Assert.assertEquals((long)1L, (long)lArray[0]);
            Assert.assertEquals((long)1L, (long)lArray[1]);
            Assert.assertEquals((long)1L, (long)lArray[2]);
            Assert.assertEquals((long)0L, (long)cLKernel.position());
            cLKernel.putArg(1.0f);
            Assert.assertEquals((long)1L, (long)cLKernel.position());
            cLKernel.putArg(2);
            Assert.assertEquals((long)2L, (long)cLKernel.position());
            cLKernel.putArg((short)3);
            Assert.assertEquals((long)3L, (long)cLKernel.position());
            try {
                cLKernel.putArg(3);
                Assert.fail((String)"exception not thrown");
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            Assert.assertEquals((long)3L, (long)cLKernel.position());
            Assert.assertEquals((long)0L, (long)cLKernel.rewind().position());
        }
        finally {
            cLContext.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test21AllKernels() {
        CLContext cLContext = CLContext.create();
        try {
            CLProgram cLProgram = cLContext.createProgram("kernel void foo(int a) { }\nkernel void bar(float b) { }\n").build();
            Assert.assertTrue((boolean)cLProgram.isExecutable());
            Map map = cLProgram.createCLKernels();
            for (CLKernel cLKernel : map.values()) {
                System.out.println("kernel: " + cLKernel.toString());
            }
            Assert.assertNotNull(map.get("foo"));
            Assert.assertNotNull(map.get("bar"));
            ((CLKernel)map.get("foo")).setArg(0, 42);
            ((CLKernel)map.get("bar")).setArg(0, 3.14f);
        }
        finally {
            cLContext.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test22KerneWorkGrouplInfo() {
        CLContext cLContext = CLContext.create();
        try {
            CLProgram cLProgram = cLContext.createProgram(test20KernelSource).build();
            Assert.assertTrue((boolean)cLProgram.isExecutable());
            CLKernel cLKernel = cLProgram.createCLKernel("foo");
            Assert.assertNotNull((Object)cLKernel);
            long l = cLKernel.getPreferredWorkGroupSizeMultiple(cLContext.getDevices()[0]);
            System.out.println("preferred workgroup size multiple: " + l);
            long l2 = cLKernel.getPrivateMemSize(cLContext.getDevices()[0]);
            System.out.println("private mem size: " + l2);
        }
        finally {
            cLContext.release();
        }
    }

    public void test60Load() throws IOException, ClassNotFoundException, InterruptedException {
        for (int i = 0; i < 100; ++i) {
            this.test02RebuildProgram();
            this.test11BuilderAsync();
            this.test03ProgramBinaries();
        }
    }

    public static void main(String[] stringArray) throws IOException {
        String string = CLProgramTest.class.getName();
        JUnitCore.main((String[])new String[]{string});
    }
}

