/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl.util.concurrent;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opencl.CLBuffer;
import com.jogamp.opencl.CLCommandQueue;
import com.jogamp.opencl.CLContext;
import com.jogamp.opencl.CLKernel;
import com.jogamp.opencl.CLMemory;
import com.jogamp.opencl.CLPlatform;
import com.jogamp.opencl.test.util.UITestCase;
import com.jogamp.opencl.util.CLMultiContext;
import com.jogamp.opencl.util.concurrent.CLCommandQueuePool;
import com.jogamp.opencl.util.concurrent.CLQueueContext;
import com.jogamp.opencl.util.concurrent.CLQueueContextFactory;
import com.jogamp.opencl.util.concurrent.CLTask;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class CLMultiContextTest
extends UITestCase {
    @Rule
    public Timeout methodTimeout = new Timeout(10000);
    private static final String programSource = "kernel void compute(global int* array, int numElements) { \n    int index = get_global_id(0);                         \n    if (index >= numElements)  {                          \n        return;                                           \n    }                                                     \n    array[index]++;                                       \n}                                                         \n";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createMultiContextTest() {
        CLMultiContext cLMultiContext = CLMultiContext.create((CLPlatform[])CLPlatform.listCLPlatforms());
        try {
            List list = cLMultiContext.getContexts();
            List list2 = cLMultiContext.getDevices();
            Assert.assertFalse((boolean)list.isEmpty());
            Assert.assertFalse((boolean)list2.isEmpty());
            for (CLContext cLContext : list) {
                System.out.println(cLContext);
            }
            for (CLContext cLContext : list2) {
                System.out.println(cLContext);
            }
        }
        finally {
            cLMultiContext.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void commandQueuePoolTest() throws InterruptedException, ExecutionException {
        CLMultiContext cLMultiContext = CLMultiContext.create((CLPlatform[])CLPlatform.listCLPlatforms());
        try {
            CLQueueContextFactory.CLSimpleContextFactory cLSimpleContextFactory = CLQueueContextFactory.createSimple((String)programSource);
            CLCommandQueuePool cLCommandQueuePool = CLCommandQueuePool.create((CLQueueContextFactory)cLSimpleContextFactory, (CLMultiContext)cLMultiContext, (CLCommandQueue.Mode[])new CLCommandQueue.Mode[0]);
            Assert.assertTrue((cLCommandQueuePool.getSize() > 0 ? 1 : 0) != 0);
            int n = cLCommandQueuePool.getSize() * 10;
            IntBuffer intBuffer = Buffers.newDirectIntBuffer((int)(64 * n));
            ArrayList<CLTestTask> arrayList = new ArrayList<CLTestTask>(n);
            for (int i = 0; i < n; ++i) {
                IntBuffer iterator2 = (IntBuffer)Buffers.slice((Buffer)intBuffer, (int)(i * 64), (int)64);
                Assert.assertEquals((long)64L, (long)iterator2.capacity());
                arrayList.add(new CLTestTask(iterator2));
            }
            System.out.println("invoking " + arrayList.size() + " tasks on " + cLCommandQueuePool.getSize() + " queues");
            cLCommandQueuePool.invokeAll(arrayList);
            this.checkBuffer(1, intBuffer);
            for (CLTestTask cLTestTask : arrayList) {
                cLCommandQueuePool.submit((CLTask)cLTestTask).get();
            }
            this.checkBuffer(2, intBuffer);
            List list = cLCommandQueuePool.submitAll(arrayList);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Future future = (Future)iterator.next();
                future.get();
            }
            this.checkBuffer(3, intBuffer);
            cLSimpleContextFactory = CLQueueContextFactory.createSimple((String)programSource.replaceAll("\\+\\+", "--"));
            cLCommandQueuePool.switchContext((CLQueueContextFactory)cLSimpleContextFactory);
            cLCommandQueuePool.invokeAll(arrayList);
            this.checkBuffer(2, intBuffer);
            cLCommandQueuePool.release();
        }
        finally {
            cLMultiContext.release();
        }
    }

    private void checkBuffer(int n, IntBuffer intBuffer) {
        while (intBuffer.hasRemaining()) {
            Assert.assertEquals((long)n, (long)intBuffer.get());
        }
        intBuffer.rewind();
    }

    public static void main(String[] stringArray) throws IOException {
        String string = CLMultiContextTest.class.getName();
        JUnitCore.main((String[])new String[]{string});
    }

    private final class CLTestTask
    implements CLTask<CLQueueContext.CLSimpleQueueContext, Buffer> {
        private final Buffer data;

        public CLTestTask(Buffer buffer) {
            this.data = buffer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Buffer execute(CLQueueContext.CLSimpleQueueContext cLSimpleQueueContext) {
            CLCommandQueue cLCommandQueue = cLSimpleQueueContext.getQueue();
            CLContext cLContext = cLSimpleQueueContext.getCLContext();
            CLKernel cLKernel = cLSimpleQueueContext.getKernel("compute");
            CLBuffer cLBuffer = null;
            try {
                cLBuffer = cLContext.createBuffer(this.data, new CLMemory.Mem[0]);
                int n = cLBuffer.getCLCapacity();
                cLKernel.putArg((CLMemory)cLBuffer).putArg(n).rewind();
                cLCommandQueue.putWriteBuffer(cLBuffer, true);
                cLCommandQueue.put1DRangeKernel(cLKernel, 0L, (long)n, 0L);
                cLCommandQueue.putReadBuffer(cLBuffer, true);
            }
            finally {
                if (cLBuffer != null) {
                    cLBuffer.release();
                }
            }
            return this.data;
        }
    }
}

