/*
 * Decompiled with CFR 0.152.
 */
package jogamp.newt.driver.awt;

import com.jogamp.common.os.Platform;
import com.jogamp.nativewindow.AbstractGraphicsConfiguration;
import com.jogamp.nativewindow.AbstractGraphicsDevice;
import com.jogamp.nativewindow.AbstractGraphicsScreen;
import com.jogamp.nativewindow.CapabilitiesChooser;
import com.jogamp.nativewindow.CapabilitiesImmutable;
import com.jogamp.nativewindow.GraphicsConfigurationFactory;
import com.jogamp.nativewindow.NativeWindow;
import com.jogamp.nativewindow.NativeWindowException;
import com.jogamp.nativewindow.NativeWindowFactory;
import com.jogamp.nativewindow.awt.AWTGraphicsConfiguration;
import com.jogamp.nativewindow.awt.AWTGraphicsDevice;
import com.jogamp.nativewindow.awt.AWTGraphicsScreen;
import com.jogamp.nativewindow.awt.JAWTWindow;
import com.jogamp.newt.Window;
import java.awt.Canvas;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import jogamp.nativewindow.jawt.JAWTUtil;
import jogamp.newt.driver.awt.WindowDriver;

public class AWTCanvas
extends Canvas {
    private static JAWTUtil.BackgroundEraseControl backgroundEraseControl = new JAWTUtil.BackgroundEraseControl();
    private final WindowDriver driver;
    private final CapabilitiesImmutable capabilities;
    private final CapabilitiesChooser chooser;
    private final UpstreamScalable upstreamScale;
    private GraphicsConfiguration chosen;
    private volatile GraphicsDevice device;
    private volatile AWTGraphicsConfiguration awtConfig;
    private volatile JAWTWindow jawtWindow = null;
    private boolean displayConfigChanged = false;

    public AWTCanvas(WindowDriver windowDriver, CapabilitiesImmutable capabilitiesImmutable, CapabilitiesChooser capabilitiesChooser, UpstreamScalable upstreamScalable) {
        if (null == capabilitiesImmutable) {
            throw new NativeWindowException("Capabilities null");
        }
        if (null == windowDriver) {
            throw new NativeWindowException("driver null");
        }
        this.driver = windowDriver;
        this.capabilities = capabilitiesImmutable;
        this.chooser = capabilitiesChooser;
        this.upstreamScale = upstreamScalable;
    }

    public AWTGraphicsConfiguration getAWTGraphicsConfiguration() {
        return this.awtConfig;
    }

    @Override
    public void update(Graphics graphics) {
    }

    @Override
    public void paint(Graphics graphics) {
    }

    public boolean hasDeviceChanged() {
        boolean bl = this.displayConfigChanged;
        this.displayConfigChanged = false;
        return bl;
    }

    @Override
    public void addNotify() {
        if (Platform.OSType.WINDOWS != Platform.getOSType()) {
            backgroundEraseControl.disable((Canvas)this);
        }
        this.awtConfig = AWTCanvas.chooseGraphicsConfiguration(this.capabilities, this.capabilities, this.chooser, this.device);
        if (Window.DEBUG_IMPLEMENTATION) {
            System.err.println(this.getThreadName() + ": AWTCanvas.addNotify.0: Created Config: " + this.awtConfig);
        }
        if (null == this.awtConfig) {
            throw new NativeWindowException("Error: NULL AWTGraphicsConfiguration");
        }
        this.chosen = this.awtConfig.getAWTGraphicsConfiguration();
        this.setAWTGraphicsConfiguration(this.awtConfig);
        super.addNotify();
        if (Platform.OSType.WINDOWS == Platform.getOSType()) {
            backgroundEraseControl.disable((Canvas)this);
        }
        this.jawtWindow = (JAWTWindow)NativeWindowFactory.getNativeWindow((Object)this, (AbstractGraphicsConfiguration)this.awtConfig);
        this.jawtWindow.lockSurface();
        try {
            this.jawtWindow.setSurfaceScale(this.upstreamScale.getReqPixelScale());
            this.upstreamScale.setHasPixelScale(this.jawtWindow.getCurrentSurfaceScale(new float[2]));
        }
        finally {
            this.jawtWindow.unlockSurface();
        }
        GraphicsConfiguration graphicsConfiguration = super.getGraphicsConfiguration();
        if (null != graphicsConfiguration) {
            this.device = graphicsConfiguration.getDevice();
        }
        this.driver.localCreate();
        if (Window.DEBUG_IMPLEMENTATION) {
            System.err.println(this.getThreadName() + ": AWTCanvas.addNotify.X");
        }
    }

    public NativeWindow getNativeWindow() {
        JAWTWindow jAWTWindow = this.jawtWindow;
        return null != jAWTWindow ? jAWTWindow : null;
    }

    public boolean isOffscreenLayerSurfaceEnabled() {
        return null != this.jawtWindow ? this.jawtWindow.isOffscreenLayerSurfaceEnabled() : false;
    }

    private void setAWTGraphicsConfiguration(AWTGraphicsConfiguration aWTGraphicsConfiguration) {
        this.awtConfig = aWTGraphicsConfiguration;
        if (null != this.jawtWindow) {
            this.jawtWindow.setAWTGraphicsConfiguration(aWTGraphicsConfiguration);
        }
    }

    @Override
    public void removeNotify() {
        if (Window.DEBUG_IMPLEMENTATION) {
            System.err.println(this.getThreadName() + ": AWTCanvas.removeNotify.0: Created Config: " + this.awtConfig);
        }
        try {
            this.driver.localDestroy();
        }
        finally {
            super.removeNotify();
        }
    }

    void dispose() {
        if (null != this.jawtWindow) {
            this.jawtWindow.destroy();
            if (Window.DEBUG_IMPLEMENTATION) {
                System.err.println(this.getThreadName() + ": AWTCanvas.disposeJAWTWindowAndAWTDeviceOnEDT(): post JAWTWindow: " + this.jawtWindow);
            }
            this.jawtWindow = null;
        }
        if (null != this.awtConfig) {
            AbstractGraphicsDevice abstractGraphicsDevice = this.awtConfig.getNativeGraphicsConfiguration().getScreen().getDevice();
            String string = null;
            if (Window.DEBUG_IMPLEMENTATION) {
                string = abstractGraphicsDevice.toString();
            }
            boolean bl = abstractGraphicsDevice.close();
            if (Window.DEBUG_IMPLEMENTATION) {
                System.err.println(this.getThreadName() + ": AWTCanvas.dispose(): closed GraphicsDevice: " + string + ", result: " + bl);
            }
        }
        this.awtConfig = null;
    }

    private String getThreadName() {
        return Thread.currentThread().getName();
    }

    @Override
    public GraphicsConfiguration getGraphicsConfiguration() {
        GraphicsConfiguration graphicsConfiguration = super.getGraphicsConfiguration();
        if (graphicsConfiguration != null && this.chosen != null && !this.chosen.equals(graphicsConfiguration)) {
            if (!this.chosen.getDevice().getIDstring().equals(graphicsConfiguration.getDevice().getIDstring())) {
                GraphicsConfiguration graphicsConfiguration2;
                AWTGraphicsConfiguration aWTGraphicsConfiguration = AWTCanvas.chooseGraphicsConfiguration(this.awtConfig.getChosenCapabilities(), this.awtConfig.getRequestedCapabilities(), this.chooser, graphicsConfiguration.getDevice());
                GraphicsConfiguration graphicsConfiguration3 = graphicsConfiguration2 = null != aWTGraphicsConfiguration ? aWTGraphicsConfiguration.getAWTGraphicsConfiguration() : null;
                if (Window.DEBUG_IMPLEMENTATION) {
                    Exception exception = new Exception("Info: Call Stack: " + Thread.currentThread().getName());
                    exception.printStackTrace();
                    System.err.println("Created Config (n): HAVE    GC " + this.chosen);
                    System.err.println("Created Config (n): THIS    GC " + graphicsConfiguration);
                    System.err.println("Created Config (n): Choosen GC " + graphicsConfiguration2);
                    System.err.println("Created Config (n): HAVE    CF " + this.awtConfig);
                    System.err.println("Created Config (n): Choosen CF " + aWTGraphicsConfiguration);
                    System.err.println("Created Config (n): EQUALS CAPS " + aWTGraphicsConfiguration.getChosenCapabilities().equals((Object)this.awtConfig.getChosenCapabilities()));
                }
                if (graphicsConfiguration2 != null) {
                    this.chosen = graphicsConfiguration2;
                    if (!aWTGraphicsConfiguration.getChosenCapabilities().equals((Object)this.awtConfig.getChosenCapabilities())) {
                        this.displayConfigChanged = true;
                    }
                    this.setAWTGraphicsConfiguration(aWTGraphicsConfiguration);
                }
            }
            return this.chosen;
        }
        if (graphicsConfiguration == null) {
            return this.chosen;
        }
        return graphicsConfiguration;
    }

    private static AWTGraphicsConfiguration chooseGraphicsConfiguration(CapabilitiesImmutable capabilitiesImmutable, CapabilitiesImmutable capabilitiesImmutable2, CapabilitiesChooser capabilitiesChooser, GraphicsDevice graphicsDevice) {
        AbstractGraphicsScreen abstractGraphicsScreen = null != graphicsDevice ? AWTGraphicsScreen.createScreenDevice((GraphicsDevice)graphicsDevice, (int)0) : AWTGraphicsScreen.createDefault();
        AWTGraphicsConfiguration aWTGraphicsConfiguration = (AWTGraphicsConfiguration)GraphicsConfigurationFactory.getFactory(AWTGraphicsDevice.class, (Class)capabilitiesImmutable.getClass()).chooseGraphicsConfiguration(capabilitiesImmutable, capabilitiesImmutable2, capabilitiesChooser, abstractGraphicsScreen, 0);
        if (aWTGraphicsConfiguration == null) {
            throw new NativeWindowException("Error: Couldn't fetch AWTGraphicsConfiguration");
        }
        return aWTGraphicsConfiguration;
    }

    public static interface UpstreamScalable {
        public float[] getReqPixelScale();

        public void setHasPixelScale(float[] var1);
    }
}

