/*
 * Decompiled with CFR 0.152.
 */
package jogamp.newt.driver.awt;

import com.jogamp.common.os.Platform;
import com.jogamp.common.util.awt.AWTEDTExecutor;
import com.jogamp.nativewindow.AbstractGraphicsConfiguration;
import com.jogamp.nativewindow.NativeSurface;
import com.jogamp.nativewindow.NativeWindow;
import com.jogamp.nativewindow.NativeWindowException;
import com.jogamp.nativewindow.awt.AWTGraphicsConfiguration;
import com.jogamp.nativewindow.awt.AWTGraphicsDevice;
import com.jogamp.nativewindow.awt.AWTGraphicsScreen;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.event.WindowUpdateEvent;
import com.jogamp.newt.event.awt.AWTKeyAdapter;
import com.jogamp.newt.event.awt.AWTMouseAdapter;
import com.jogamp.newt.event.awt.AWTWindowAdapter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import jogamp.nativewindow.awt.AWTMisc;
import jogamp.newt.WindowImpl;
import jogamp.newt.driver.awt.AWTCanvas;
import jogamp.newt.driver.awt.DisplayDriver;
import jogamp.newt.driver.awt.ScreenDriver;

public class WindowDriver
extends WindowImpl {
    private boolean owningFrame;
    private Container awtContainer = null;
    private Frame awtFrame = null;
    private AWTCanvas awtCanvas;
    private volatile boolean withinLocalDispose = false;
    private final AWTCanvas.UpstreamScalable upstreamScalable = new AWTCanvas.UpstreamScalable(){

        @Override
        public float[] getReqPixelScale() {
            return WindowDriver.this.reqPixelScale;
        }

        @Override
        public void setHasPixelScale(float[] fArray) {
            System.arraycopy(fArray, 0, WindowDriver.this.hasPixelScale, 0, 2);
        }
    };

    public WindowDriver() {
        this(null);
    }

    public static Class<?>[] getCustomConstructorArgumentTypes() {
        return new Class[]{Container.class};
    }

    public WindowDriver(Container container) {
        this.addWindowListener(0, new NEWTWindowListener());
        this.awtContainer = container;
        if (container instanceof Frame) {
            this.awtFrame = (Frame)container;
        }
    }

    protected void requestFocusImpl(boolean bl) {
        this.awtContainer.requestFocus();
    }

    protected void setTitleImpl(final String string) {
        if (this.awtFrame != null) {
            AWTEDTExecutor.singleton.invoke(false, new Runnable(){

                @Override
                public void run() {
                    WindowDriver.this.awtFrame.setTitle(string);
                }
            });
        }
    }

    protected void createNativeImpl(boolean[] blArray) {
        if (this.withinLocalDispose) {
            this.setupHandleAndGC();
            this.defineWindowPosition(this.getX(), this.getY());
            this.visibleChanged(true);
            this.withinLocalDispose = false;
        } else {
            if (0L != this.getParentWindowHandle()) {
                throw new RuntimeException("Window parenting not supported in AWT, use AWTWindow(Frame) cstr for wrapping instead");
            }
            if (null == this.awtContainer) {
                this.awtFrame = new Frame();
                this.awtContainer = this.awtFrame;
                this.owningFrame = true;
            } else {
                this.owningFrame = false;
                this.defineWindowSize(this.awtContainer.getWidth(), this.awtContainer.getHeight());
                this.defineWindowPosition(this.awtContainer.getX(), this.awtContainer.getY());
            }
            if (null != this.awtFrame) {
                this.awtFrame.setTitle(this.getTitle());
            }
            this.awtContainer.setLayout(new BorderLayout());
            if (null == this.awtCanvas) {
                this.awtCanvas = new AWTCanvas(this, this.capsRequested, this.capabilitiesChooser, this.upstreamScalable);
                this.awtContainer.add((Component)this.awtCanvas, "Center");
                new AWTMouseAdapter((com.jogamp.newt.Window)this).addTo(this.awtCanvas);
                new AWTKeyAdapter((com.jogamp.newt.Window)this).addTo(this.awtCanvas);
                new AWTWindowAdapter((WindowListener)new AWTWindowListener(), (com.jogamp.newt.Window)this).addTo(this.awtCanvas);
            } else {
                this.awtContainer.add((Component)this.awtCanvas, "Center");
            }
            this.reconfigureWindowImpl(this.getX(), this.getY(), this.getWidth(), this.getHeight(), this.getReconfigureMask(-1879048192, true));
        }
    }

    private void setupHandleAndGC() {
        NativeWindow nativeWindow;
        if (null != this.awtCanvas && null != (nativeWindow = this.awtCanvas.getNativeWindow())) {
            this.setGraphicsConfiguration((AbstractGraphicsConfiguration)this.awtCanvas.getAWTGraphicsConfiguration());
            this.setWindowHandle(nativeWindow.getWindowHandle());
        }
    }

    void localCreate() {
        if (this.withinLocalDispose) {
            this.setVisible(true);
        } else {
            this.setupHandleAndGC();
        }
    }

    void localDestroy() {
        this.withinLocalDispose = true;
        super.destroy();
    }

    protected void closeNativeImpl() {
        this.setWindowHandle(0L);
        if (this.withinLocalDispose) {
            if (null != this.awtCanvas) {
                this.awtCanvas.dispose();
            }
        } else {
            if (null != this.awtContainer) {
                this.awtContainer.setVisible(false);
                this.awtContainer.remove(this.awtCanvas);
                this.awtContainer.setEnabled(false);
                this.awtCanvas.setEnabled(false);
                this.awtCanvas.dispose();
            }
            if (this.owningFrame && null != this.awtFrame) {
                this.awtFrame.dispose();
                this.owningFrame = false;
            }
            this.awtCanvas = null;
            this.awtFrame = null;
            this.awtContainer = null;
        }
    }

    public boolean hasDeviceChanged() {
        boolean bl = this.awtCanvas.hasDeviceChanged();
        if (bl) {
            AWTGraphicsConfiguration aWTGraphicsConfiguration = this.awtCanvas.getAWTGraphicsConfiguration();
            if (null == aWTGraphicsConfiguration) {
                throw new NativeWindowException("Error Device change null GraphicsConfiguration: " + (Object)((Object)this));
            }
            this.setGraphicsConfiguration((AbstractGraphicsConfiguration)aWTGraphicsConfiguration);
            ((ScreenDriver)this.getScreen()).setAWTGraphicsScreen((AWTGraphicsScreen)aWTGraphicsConfiguration.getScreen());
            ((DisplayDriver)this.getScreen().getDisplay()).setAWTGraphicsDevice((AWTGraphicsDevice)aWTGraphicsConfiguration.getScreen().getDevice());
            ((ScreenDriver)this.getScreen()).updateVirtualScreenOriginAndSize();
        }
        return bl;
    }

    private void setCanvasSizeImpl(int n, int n2) {
        Dimension dimension = new Dimension(n, n2);
        Window window = AWTMisc.getWindow((Component)this.awtCanvas);
        Container container = null != window ? window : this.awtContainer;
        this.awtCanvas.setMinimumSize(dimension);
        this.awtCanvas.setPreferredSize(dimension);
        if (DEBUG_IMPLEMENTATION) {
            Insets insets = container.getInsets();
            Dimension dimension2 = new Dimension(n + insets.left + insets.right, n2 + insets.top + insets.bottom);
            System.err.println(WindowDriver.getThreadName() + ": AWTWindow setCanvasSize: szClient " + dimension + ", szCont " + dimension2 + ", insets " + insets);
        }
        this.awtCanvas.setSize(dimension);
        this.awtCanvas.invalidate();
        if (null != window) {
            window.pack();
        } else {
            this.awtContainer.validate();
        }
    }

    private void setFrameSizeImpl(int n, int n2) {
        Insets insets = this.awtContainer.getInsets();
        Dimension dimension = new Dimension(n + insets.left + insets.right, n2 + insets.top + insets.bottom);
        if (DEBUG_IMPLEMENTATION) {
            Dimension dimension2 = new Dimension(n, n2);
            System.err.println(WindowDriver.getThreadName() + ": AWTWindow setFrameSize: szClient " + dimension2 + ", szCont " + dimension + ", insets " + insets);
        }
        this.awtContainer.setSize(dimension);
        this.awtCanvas.invalidate();
        this.awtContainer.validate();
    }

    protected final int getSupportedReconfigMaskImpl() {
        return 18697;
    }

    protected boolean reconfigureWindowImpl(int n, int n2, int n3, int n4, int n5) {
        Insets insets;
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("AWTWindow reconfig: " + n + "/" + n2 + " " + n3 + "x" + n4 + ", " + WindowDriver.getReconfigStateMaskString((int)n5));
        }
        if (0 != (0x10000000 & n5) && null != this.awtFrame) {
            if (!this.awtContainer.isDisplayable()) {
                this.awtFrame.setUndecorated(this.isUndecorated());
            } else if (DEBUG_IMPLEMENTATION) {
                System.err.println(WindowDriver.getThreadName() + ": AWTWindow can't undecorate already created frame");
            }
        }
        if (0 != (Integer.MIN_VALUE & n5)) {
            if (0 != (1 & n5)) {
                this.setCanvasSizeImpl(n3, n4);
                this.awtContainer.setVisible(true);
                insets = this.awtContainer.getInsets();
                this.insetsChanged(false, insets.left, insets.right, insets.top, insets.bottom);
            } else {
                this.awtContainer.setVisible(false);
            }
        } else if (this.awtCanvas.getWidth() != n3 || this.awtCanvas.getHeight() != n4) {
            if (Platform.OSType.MACOS == Platform.getOSType() && this.awtCanvas.isOffscreenLayerSurfaceEnabled()) {
                this.setFrameSizeImpl(n3, n4);
            } else {
                this.setCanvasSizeImpl(n3, n4);
            }
        }
        this.defineWindowSize(n3, n4);
        if (this.awtContainer.getX() != n || this.awtContainer.getY() != n2) {
            this.awtContainer.setLocation(n, n2);
        }
        this.defineWindowPosition(n, n2);
        if (0 != (Integer.MIN_VALUE & n5)) {
            if (0 != (1 & n5) && !this.hasDeviceChanged()) {
                insets = this.awtCanvas.getAWTGraphicsConfiguration();
                if (null == insets) {
                    throw new NativeWindowException("Error: !hasDeviceChanged && null == GraphicsConfiguration: " + (Object)((Object)this));
                }
                this.setGraphicsConfiguration((AbstractGraphicsConfiguration)insets);
            }
            this.visibleChanged(0 != (1 & n5));
        }
        if (this.isVisible()) {
            this.windowRepaint(false, 0, 0, this.getSurfaceWidth(), this.getSurfaceHeight());
        }
        return true;
    }

    protected com.jogamp.nativewindow.util.Point getLocationOnScreenImpl(int n, int n2) {
        Point point = this.awtCanvas.getLocationOnScreen();
        point.translate(n, n2);
        return new com.jogamp.nativewindow.util.Point((int)(point.getX() + 0.5), (int)(point.getY() + 0.5));
    }

    public NativeSurface getWrappedSurface() {
        return null != this.awtCanvas ? this.awtCanvas.getNativeWindow() : null;
    }

    class NEWTWindowListener
    implements WindowListener {
        NEWTWindowListener() {
        }

        public void windowMoved(WindowEvent windowEvent) {
        }

        public void windowResized(WindowEvent windowEvent) {
        }

        public void windowDestroyNotify(WindowEvent windowEvent) {
            if (WindowDriver.this.withinLocalDispose) {
                windowEvent.setConsumed(true);
            }
        }

        public void windowDestroyed(WindowEvent windowEvent) {
            if (WindowDriver.this.withinLocalDispose) {
                windowEvent.setConsumed(true);
            }
        }

        public void windowGainedFocus(WindowEvent windowEvent) {
        }

        public void windowLostFocus(WindowEvent windowEvent) {
        }

        public void windowRepaint(WindowUpdateEvent windowUpdateEvent) {
        }
    }

    class AWTWindowListener
    implements WindowListener {
        AWTWindowListener() {
        }

        public void windowMoved(WindowEvent windowEvent) {
            if (null != WindowDriver.this.awtContainer) {
                WindowDriver.this.positionChanged(false, true, WindowDriver.this.awtContainer.getX(), WindowDriver.this.awtContainer.getY());
            }
        }

        public void windowResized(WindowEvent windowEvent) {
            if (null != WindowDriver.this.awtCanvas) {
                if (com.jogamp.newt.Window.DEBUG_IMPLEMENTATION) {
                    System.err.println("Window Resized: " + WindowDriver.this.awtCanvas);
                }
                WindowDriver.this.sizeChanged(false, false, WindowDriver.this.awtCanvas.getWidth(), WindowDriver.this.awtCanvas.getHeight(), true);
                WindowDriver.this.windowRepaint(false, 0, 0, WindowDriver.this.getSurfaceWidth(), WindowDriver.this.getSurfaceHeight());
            }
        }

        public void windowDestroyNotify(WindowEvent windowEvent) {
            WindowDriver.this.windowDestroyNotify(false);
        }

        public void windowDestroyed(WindowEvent windowEvent) {
        }

        public void windowGainedFocus(WindowEvent windowEvent) {
            WindowDriver.this.focusChanged(false, true);
        }

        public void windowLostFocus(WindowEvent windowEvent) {
            WindowDriver.this.focusChanged(false, false);
        }

        public void windowRepaint(WindowUpdateEvent windowUpdateEvent) {
            if (null != WindowDriver.this.awtCanvas) {
                if (com.jogamp.newt.Window.DEBUG_IMPLEMENTATION) {
                    System.err.println("Window Repaint: " + WindowDriver.this.awtCanvas);
                }
                WindowDriver.this.windowRepaint(false, 0, 0, WindowDriver.this.getSurfaceWidth(), WindowDriver.this.getSurfaceHeight());
            }
        }
    }
}

