/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.awt;

import com.jogamp.common.util.awt.AWTEDTExecutor;
import com.jogamp.opengl.GLException;
import java.awt.EventQueue;
import jogamp.opengl.GLWorkerThread;
import jogamp.opengl.ThreadingImpl;
import jogamp.opengl.ToolkitThreadingPlugin;
import jogamp.opengl.awt.Java2D;

public class AWTThreadingPlugin
implements ToolkitThreadingPlugin {
    public final boolean isToolkitThread() throws GLException {
        return EventQueue.isDispatchThread();
    }

    public final boolean isOpenGLThread() throws GLException {
        switch (ThreadingImpl.getMode()) {
            case ST_AWT: {
                if (Java2D.isOGLPipelineActive() && !ThreadingImpl.isX11()) {
                    return Java2D.isQueueFlusherThread();
                }
                return EventQueue.isDispatchThread();
            }
            case ST_WORKER: {
                if (Java2D.isOGLPipelineActive()) {
                    return Java2D.isQueueFlusherThread() || ThreadingImpl.isX11() && GLWorkerThread.isWorkerThread();
                }
                return GLWorkerThread.isWorkerThread();
            }
        }
        throw new InternalError("Illegal single-threading mode " + ThreadingImpl.getMode());
    }

    public final void invokeOnOpenGLThread(boolean bl, Runnable runnable) throws GLException {
        switch (ThreadingImpl.getMode()) {
            case ST_AWT: {
                if (bl && Java2D.isOGLPipelineActive() && !ThreadingImpl.isX11()) {
                    Java2D.invokeWithOGLContextCurrent(null, runnable);
                    break;
                }
                AWTEDTExecutor.singleton.invoke(bl, runnable);
                break;
            }
            case ST_WORKER: {
                ThreadingImpl.invokeOnWorkerThread((boolean)bl, (Runnable)runnable);
                break;
            }
            case MT: {
                runnable.run();
                break;
            }
            default: {
                throw new InternalError("Illegal single-threading mode " + ThreadingImpl.getMode());
            }
        }
    }
}

