/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl.llb.impl;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.ElementBuffer;
import com.jogamp.common.nio.StructAccessor;
import com.jogamp.common.os.MachineDataInfo;
import java.nio.ByteBuffer;
import jogamp.common.os.MachineDataInfoRuntime;

public class CLImageDescImpl {
    StructAccessor accessor;
    private static final int mdIdx = MachineDataInfoRuntime.getStatic().ordinal();
    private final MachineDataInfo md;
    private static final int[] CLImageDescImpl_size = new int[]{40, 40, 40, 40, 40, 40, 40, 72, 72, 72};
    private static final int[] imageType_offset = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final int[] imageWidth_offset = new int[]{4, 4, 4, 4, 4, 4, 4, 8, 8, 8};
    private static final int[] imageHeight_offset = new int[]{8, 8, 8, 8, 8, 8, 8, 16, 16, 16};
    private static final int[] imageDepth_offset = new int[]{12, 12, 12, 12, 12, 12, 12, 24, 24, 24};
    private static final int[] imageArraySize_offset = new int[]{16, 16, 16, 16, 16, 16, 16, 32, 32, 32};
    private static final int[] imageRowPitch_offset = new int[]{20, 20, 20, 20, 20, 20, 20, 40, 40, 40};
    private static final int[] imageSlicePitch_offset = new int[]{24, 24, 24, 24, 24, 24, 24, 48, 48, 48};
    private static final int[] numMipLevels_offset = new int[]{28, 28, 28, 28, 28, 28, 28, 56, 56, 56};
    private static final int[] numSamples_offset = new int[]{32, 32, 32, 32, 32, 32, 32, 60, 60, 60};

    public static boolean usesNativeCode() {
        return false;
    }

    public static int size() {
        return CLImageDescImpl_size[mdIdx];
    }

    public static CLImageDescImpl create() {
        return CLImageDescImpl.create(Buffers.newDirectByteBuffer((int)CLImageDescImpl.size()));
    }

    public static CLImageDescImpl create(ByteBuffer byteBuffer) {
        return new CLImageDescImpl(byteBuffer);
    }

    public static CLImageDescImpl derefPointer(long l) {
        return CLImageDescImpl.create(ElementBuffer.derefPointer((int)CLImageDescImpl.size(), (long)l, (int)1).getByteBuffer());
    }

    CLImageDescImpl(ByteBuffer byteBuffer) {
        this.md = MachineDataInfo.StaticConfig.values()[CLImageDescImpl.mdIdx].md;
        this.accessor = new StructAccessor(byteBuffer);
    }

    public final ByteBuffer getBuffer() {
        return this.accessor.getBuffer();
    }

    public final long getDirectBufferAddress() {
        return this.accessor.getDirectBufferAddress();
    }

    public final CLImageDescImpl setImageType(int n) {
        this.accessor.setIntAt(imageType_offset[mdIdx], n);
        return this;
    }

    public final int getImageType() {
        return this.accessor.getIntAt(imageType_offset[mdIdx]);
    }

    public final CLImageDescImpl setImageWidth(long l) {
        this.accessor.setLongAt(imageWidth_offset[mdIdx], l, this.md.longSizeInBytes());
        return this;
    }

    public final long getImageWidth() {
        return this.accessor.getLongAt(imageWidth_offset[mdIdx], this.md.longSizeInBytes());
    }

    public final CLImageDescImpl setImageHeight(long l) {
        this.accessor.setLongAt(imageHeight_offset[mdIdx], l, this.md.longSizeInBytes());
        return this;
    }

    public final long getImageHeight() {
        return this.accessor.getLongAt(imageHeight_offset[mdIdx], this.md.longSizeInBytes());
    }

    public final CLImageDescImpl setImageDepth(long l) {
        this.accessor.setLongAt(imageDepth_offset[mdIdx], l, this.md.longSizeInBytes());
        return this;
    }

    public final long getImageDepth() {
        return this.accessor.getLongAt(imageDepth_offset[mdIdx], this.md.longSizeInBytes());
    }

    public final CLImageDescImpl setImageArraySize(long l) {
        this.accessor.setLongAt(imageArraySize_offset[mdIdx], l, this.md.longSizeInBytes());
        return this;
    }

    public final long getImageArraySize() {
        return this.accessor.getLongAt(imageArraySize_offset[mdIdx], this.md.longSizeInBytes());
    }

    public final CLImageDescImpl setImageRowPitch(long l) {
        this.accessor.setLongAt(imageRowPitch_offset[mdIdx], l, this.md.longSizeInBytes());
        return this;
    }

    public final long getImageRowPitch() {
        return this.accessor.getLongAt(imageRowPitch_offset[mdIdx], this.md.longSizeInBytes());
    }

    public final CLImageDescImpl setImageSlicePitch(long l) {
        this.accessor.setLongAt(imageSlicePitch_offset[mdIdx], l, this.md.longSizeInBytes());
        return this;
    }

    public final long getImageSlicePitch() {
        return this.accessor.getLongAt(imageSlicePitch_offset[mdIdx], this.md.longSizeInBytes());
    }

    public final CLImageDescImpl setNumMipLevels(int n) {
        this.accessor.setIntAt(numMipLevels_offset[mdIdx], n);
        return this;
    }

    public final int getNumMipLevels() {
        return this.accessor.getIntAt(numMipLevels_offset[mdIdx]);
    }

    public final CLImageDescImpl setNumSamples(int n) {
        this.accessor.setIntAt(numSamples_offset[mdIdx], n);
        return this;
    }

    public final int getNumSamples() {
        return this.accessor.getIntAt(numSamples_offset[mdIdx]);
    }
}

