/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.nativewindow.awt;

import com.jogamp.nativewindow.AbstractGraphicsDevice;
import com.jogamp.nativewindow.AbstractGraphicsScreen;
import com.jogamp.nativewindow.DefaultGraphicsScreen;
import com.jogamp.nativewindow.awt.AWTGraphicsDevice;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;

public class AWTGraphicsScreen
extends DefaultGraphicsScreen
implements Cloneable {
    public AWTGraphicsScreen(AWTGraphicsDevice aWTGraphicsDevice) {
        super((AbstractGraphicsDevice)aWTGraphicsDevice, AWTGraphicsScreen.findScreenIndex(aWTGraphicsDevice.getGraphicsDevice()));
    }

    public static GraphicsDevice getScreenDevice(int n) {
        if (n < 0) {
            return null;
        }
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        if (n < graphicsDeviceArray.length) {
            return graphicsDeviceArray[n];
        }
        return null;
    }

    public static int findScreenIndex(GraphicsDevice graphicsDevice) {
        if (null == graphicsDevice) {
            return -1;
        }
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        for (int i = 0; i < graphicsDeviceArray.length; ++i) {
            if (graphicsDeviceArray[i] != graphicsDevice) continue;
            return i;
        }
        return -1;
    }

    public static AbstractGraphicsScreen createScreenDevice(GraphicsDevice graphicsDevice, int n) {
        return new AWTGraphicsScreen(new AWTGraphicsDevice(graphicsDevice, n));
    }

    public static AbstractGraphicsScreen createScreenDevice(int n, int n2) {
        return AWTGraphicsScreen.createScreenDevice(AWTGraphicsScreen.getScreenDevice(n), n2);
    }

    public static AbstractGraphicsScreen createDefault() {
        return new AWTGraphicsScreen(AWTGraphicsDevice.createDefault());
    }

    public Object clone() {
        return super.clone();
    }
}

