/*
 * Decompiled with CFR 0.152.
 */
package jogamp.nativewindow.awt;

import com.jogamp.nativewindow.NativeWindowException;
import com.jogamp.nativewindow.WindowClosingProtocol;
import com.jogamp.nativewindow.awt.DirectDataBufferInt;
import com.jogamp.nativewindow.util.PixelFormat;
import com.jogamp.nativewindow.util.PixelFormatUtil;
import com.jogamp.nativewindow.util.PixelRectangle;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.FocusTraversalPolicy;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.MenuSelectionManager;
import jogamp.nativewindow.jawt.JAWTUtil;

public class AWTMisc {
    static final HashMap<Integer, Cursor> cursorMap;
    static final Cursor nulCursor;

    public static JFrame getJFrame(Component component) {
        while (component != null && !(component instanceof JFrame)) {
            component = component.getParent();
        }
        return (JFrame)component;
    }

    public static Frame getFrame(Component component) {
        while (component != null && !(component instanceof Frame)) {
            component = component.getParent();
        }
        return (Frame)component;
    }

    public static Window getWindow(Component component) {
        while (component != null && !(component instanceof Window)) {
            component = component.getParent();
        }
        return (Window)component;
    }

    public static Container getContainer(Component component) {
        while (component != null && !(component instanceof Container)) {
            component = component.getParent();
        }
        return (Container)component;
    }

    public static Insets getInsets(Component component, boolean bl) {
        if (component instanceof Window) {
            return ((Window)component).getInsets();
        }
        if (component instanceof JRootPane) {
            Window window = AWTMisc.getWindow(component);
            if (null != window) {
                return window.getInsets();
            }
            return ((JRootPane)component).getInsets();
        }
        if (!bl && component instanceof JComponent) {
            return ((JComponent)component).getInsets();
        }
        return null;
    }

    public static com.jogamp.nativewindow.util.Point getLocationOnScreenSafe(com.jogamp.nativewindow.util.Point point, Component component, boolean bl) {
        if (!Thread.holdsLock(component.getTreeLock())) {
            if (null == point) {
                point = new com.jogamp.nativewindow.util.Point();
            }
            AWTMisc.getLocationOnScreenNonBlocking(point, component, bl);
            return point;
        }
        Point point2 = component.getLocationOnScreen();
        com.jogamp.nativewindow.util.Point point3 = null != point ? point.translate(point2.x, point2.y) : new com.jogamp.nativewindow.util.Point(point2.x, point2.y);
        return point3;
    }

    public static Component getLocationOnScreenNonBlocking(com.jogamp.nativewindow.util.Point point, Component component, boolean bl) {
        Insets insets = new Insets(0, 0, 0, 0);
        Component component2 = null;
        while (null != component) {
            int n = component.getX();
            int n2 = component.getY();
            if (bl) {
                Insets insets2 = AWTMisc.getInsets(component, false);
                if (null != insets2) {
                    insets.bottom += insets2.bottom;
                    insets.top += insets2.top;
                    insets.left += insets2.left;
                    insets.right += insets2.right;
                }
                System.err.print("LOS: " + point + " + " + component.getClass().getName() + "[" + n + "/" + n2 + ", vis " + component.isVisible() + ", ins " + insets2 + " -> " + insets + "] -> ");
            }
            point.translate(n, n2);
            if (bl) {
                System.err.println(point);
            }
            component2 = component;
            if (component instanceof Window) break;
            component = component.getParent();
        }
        return component2;
    }

    public static int performAction(Container container, Class<?> clazz, ComponentAction componentAction) {
        int n = 0;
        int n2 = container.getComponentCount();
        for (int i = 0; i < n2; ++i) {
            Component component = container.getComponent(i);
            if (component instanceof Container) {
                n += AWTMisc.performAction((Container)component, clazz, componentAction);
                continue;
            }
            if (!clazz.isInstance(component)) continue;
            componentAction.run(component);
            ++n;
        }
        if (clazz.isInstance(container)) {
            componentAction.run(container);
            ++n;
        }
        return n;
    }

    public static Component getNextFocus(Component component, boolean bl) {
        Container container = component.getFocusCycleRootAncestor();
        while (!(container == null || container.isShowing() && container.isFocusable() && container.isEnabled())) {
            component = container;
            container = component.getFocusCycleRootAncestor();
        }
        Component component2 = null;
        if (container != null) {
            FocusTraversalPolicy focusTraversalPolicy = container.getFocusTraversalPolicy();
            Component component3 = component2 = bl ? focusTraversalPolicy.getComponentAfter(container, component) : focusTraversalPolicy.getComponentBefore(container, component);
            if (component2 == null) {
                component2 = focusTraversalPolicy.getDefaultComponent(container);
            }
        }
        return component2;
    }

    public static void clearAWTMenus() {
        MenuSelectionManager.defaultManager().clearSelectedPath();
    }

    public static synchronized Cursor getNullCursor() {
        return nulCursor;
    }

    public static synchronized Cursor getCursor(PixelRectangle pixelRectangle, Point point) {
        int n = 31 + pixelRectangle.hashCode();
        Integer n2 = n = (n << 5) - n + point.hashCode();
        Cursor cursor = cursorMap.get(n2);
        if (null == cursor) {
            cursor = AWTMisc.createCursor(pixelRectangle, point);
            cursorMap.put(n2, cursor);
        }
        return cursor;
    }

    private static synchronized Cursor createCursor(PixelRectangle pixelRectangle, Point point) {
        int n = pixelRectangle.getSize().getWidth();
        int n2 = pixelRectangle.getSize().getHeight();
        DirectDataBufferInt.BufferedImageInt bufferedImageInt = DirectDataBufferInt.createBufferedImage(n, n2, 2, null, null);
        ByteBuffer byteBuffer = bufferedImageInt.getDataBuffer().getDataBytes();
        PixelFormatUtil.convert((PixelRectangle)pixelRectangle, (ByteBuffer)byteBuffer, (PixelFormat)PixelFormat.BGRA8888, (boolean)false, (int)(n * 4));
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        return toolkit.createCustomCursor(bufferedImageInt, point, pixelRectangle.toString());
    }

    public static WindowClosingProtocol.WindowClosingMode AWT2NWClosingOperation(int n) {
        switch (n) {
            case 2: 
            case 3: {
                return WindowClosingProtocol.WindowClosingMode.DISPOSE_ON_CLOSE;
            }
            case 0: 
            case 1: {
                return WindowClosingProtocol.WindowClosingMode.DO_NOTHING_ON_CLOSE;
            }
        }
        throw new NativeWindowException("Unhandled AWT Closing Operation: " + n);
    }

    public static WindowClosingProtocol.WindowClosingMode getNWClosingOperation(Component component) {
        JFrame jFrame = AWTMisc.getJFrame(component);
        int n = null != jFrame ? jFrame.getDefaultCloseOperation() : 0;
        return AWTMisc.AWT2NWClosingOperation(n);
    }

    static {
        Cursor cursor;
        block3: {
            cursorMap = new HashMap();
            cursor = null;
            if (!JAWTUtil.isHeadlessMode()) {
                try {
                    Toolkit toolkit = Toolkit.getDefaultToolkit();
                    BufferedImage bufferedImage = new BufferedImage(1, 1, 6);
                    cursor = toolkit.createCustomCursor(bufferedImage, new Point(0, 0), "nullCursor");
                }
                catch (Exception exception) {
                    if (!JAWTUtil.DEBUG) break block3;
                    System.err.println("Caught exception: " + exception.getMessage());
                    exception.printStackTrace();
                }
            }
        }
        nulCursor = cursor;
    }

    public static interface ComponentAction {
        public void run(Component var1);
    }
}

