/*
 * Decompiled with CFR 0.152.
 */
package jogamp.nativewindow.jawt.x11;

import com.jogamp.nativewindow.AbstractGraphicsConfiguration;
import com.jogamp.nativewindow.NativeWindowException;
import com.jogamp.nativewindow.awt.JAWTWindow;
import com.jogamp.nativewindow.util.Point;
import java.awt.GraphicsConfiguration;
import jogamp.nativewindow.jawt.JAWT;
import jogamp.nativewindow.jawt.JAWTUtil;
import jogamp.nativewindow.jawt.JAWT_DrawingSurface;
import jogamp.nativewindow.jawt.JAWT_DrawingSurfaceInfo;
import jogamp.nativewindow.jawt.x11.JAWT_X11DrawingSurfaceInfo;
import jogamp.nativewindow.x11.X11Lib;

public class X11JAWTWindow
extends JAWTWindow {
    private JAWT_DrawingSurface ds;
    private boolean dsLocked;
    private JAWT_DrawingSurfaceInfo dsi;
    private JAWT_X11DrawingSurfaceInfo x11dsi;

    public X11JAWTWindow(Object object, AbstractGraphicsConfiguration abstractGraphicsConfiguration) {
        super(object, abstractGraphicsConfiguration);
    }

    @Override
    protected void invalidateNative(long l) {
    }

    @Override
    protected JAWT fetchJAWTImpl() throws NativeWindowException {
        return JAWTUtil.getJAWT(false);
    }

    @Override
    protected int lockSurfaceImpl(GraphicsConfiguration graphicsConfiguration) throws NativeWindowException {
        int n = 3;
        this.ds = this.getJAWT().GetDrawingSurface(this.component);
        if (this.ds == null) {
            this.unlockSurfaceImpl();
            return 1;
        }
        int n2 = this.ds.Lock();
        boolean bl = this.dsLocked = 0 == (n2 & 1);
        if (!this.dsLocked) {
            this.unlockSurfaceImpl();
            throw new NativeWindowException("Unable to lock surface");
        }
        if ((n2 & 8) != 0) {
            n = 2;
        }
        this.dsi = this.ds.GetDrawingSurfaceInfo();
        if (this.dsi == null) {
            this.unlockSurfaceImpl();
            return 1;
        }
        this.updateLockedData(this.dsi.getBounds(), graphicsConfiguration);
        this.x11dsi = (JAWT_X11DrawingSurfaceInfo)this.dsi.platformInfo(this.getJAWT());
        if (this.x11dsi == null) {
            this.unlockSurfaceImpl();
            return 1;
        }
        this.drawable = this.x11dsi.getDrawable();
        if (this.drawable == 0L) {
            this.unlockSurfaceImpl();
            return 1;
        }
        return n;
    }

    @Override
    protected void unlockSurfaceImpl() throws NativeWindowException {
        if (null != this.ds) {
            if (null != this.dsi) {
                this.ds.FreeDrawingSurfaceInfo(this.dsi);
            }
            if (this.dsLocked) {
                this.ds.Unlock();
            }
            this.getJAWT().FreeDrawingSurface(this.ds);
        }
        this.ds = null;
        this.dsi = null;
        this.x11dsi = null;
    }

    @Override
    protected Point getLocationOnScreenNativeImpl(int n, int n2) {
        return X11Lib.GetRelativeLocation((long)this.getDisplayHandle(), (int)this.getScreenIndex(), (long)this.getWindowHandle(), (long)0L, (int)n, (int)n2);
    }
}

