/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.demos.es2;

import com.jogamp.common.os.Platform;
import com.jogamp.math.Recti;
import com.jogamp.math.Vec3f;
import com.jogamp.math.util.SyncBuffer;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLArrayData;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLUniformData;
import com.jogamp.opengl.util.GLArrayDataServer;
import com.jogamp.opengl.util.PMVMatrix;
import com.jogamp.opengl.util.glsl.ShaderCode;
import com.jogamp.opengl.util.glsl.ShaderProgram;
import com.jogamp.opengl.util.glsl.ShaderState;
import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.TextureCoords;
import com.jogamp.opengl.util.texture.TextureSequence;
import java.nio.FloatBuffer;

public class TextureSequenceES2
implements GLEventListener {
    public static final int EFFECT_NORMAL = 0;
    public static final int EFFECT_GRADIENT_BOTTOM2TOP = 2;
    public static final int EFFECT_TRANSPARENT = 8;
    private TextureSequence texSeq;
    private final boolean texSeqShared;
    private ShaderState st;
    private PMVMatrix pmvMatrix;
    private GLUniformData pmvMatrixUniform;
    private float zrot = 0.0f;
    private final boolean orthoProjection;
    private float nearPlaneNormalized;
    private float zoom;
    private int effects = 0;
    private float alpha = 1.0f;
    private boolean useOriginalScale = false;
    private float[] verts = null;
    private GLArrayDataServer interleavedVBO;
    private static final String shaderBasename = "texsequence_xxx";
    private static final String myTextureLookupName = "myTexture2D";
    private final float zNear = 1.0f;
    private final float zFar = 10.0f;

    public TextureSequenceES2(TextureSequence textureSequence, boolean bl, boolean bl2, float f) throws IllegalStateException {
        this.texSeq = textureSequence;
        this.texSeqShared = bl;
        this.orthoProjection = bl2;
        this.zoom = f;
    }

    public void setZoom(float f) {
        this.zoom = f;
    }

    public float getZoom() {
        return this.zoom;
    }

    public void setZRotation(float f) {
        this.zrot = f;
    }

    public boolean hasEffect(int n) {
        return 0 != (this.effects & n);
    }

    public void setEffects(int n) {
        this.effects = n;
    }

    public void setTransparency(float f) {
        this.effects |= 8;
        this.alpha = f;
    }

    public void setUseOriginalScale(boolean bl) {
        this.useOriginalScale = bl;
    }

    private void initShader(GL2ES2 gL2ES2) {
        ShaderCode shaderCode = ShaderCode.create((GL2ES2)gL2ES2, (int)35633, this.getClass(), (String)"shader", (String)"shader/bin", (String)shaderBasename, (boolean)true);
        ShaderCode shaderCode2 = ShaderCode.create((GL2ES2)gL2ES2, (int)35632, this.getClass(), (String)"shader", (String)"shader/bin", (String)shaderBasename, (boolean)true);
        boolean bl = true;
        if (36197 == this.texSeq.getTextureTarget()) {
            if (!gL2ES2.isExtensionAvailable("GL_OES_EGL_image_external")) {
                throw new GLException("GL_OES_EGL_image_external requested but not available");
            }
            if (Platform.OSType.ANDROID == Platform.getOSType() && gL2ES2.isGLES3()) {
                bl = false;
            }
        }
        shaderCode.defaultShaderCustomization(gL2ES2, bl, true);
        int n = bl ? shaderCode2.addGLSLVersion(gL2ES2) : 0;
        n = shaderCode2.insertShaderSource(0, n, (CharSequence)this.texSeq.getRequiredExtensionsShaderStub());
        shaderCode2.addDefaultShaderPrecision(gL2ES2, n);
        String string = this.texSeq.setTextureLookupFunctionName(myTextureLookupName);
        shaderCode2.replaceInShaderSource(myTextureLookupName, string);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("uniform ").append(this.texSeq.getTextureSampler2DType()).append(" mgl_ActiveTexture;\n");
        stringBuilder.append(this.texSeq.getTextureLookupFragmentShaderImpl());
        shaderCode2.insertShaderSource(0, "TEXTURE-SEQUENCE-CODE-BEGIN", 0, (CharSequence)stringBuilder);
        ShaderProgram shaderProgram = new ShaderProgram();
        shaderProgram.add(shaderCode);
        shaderProgram.add(shaderCode2);
        if (!shaderProgram.link(gL2ES2, System.err)) {
            throw new GLException("Couldn't link program: " + shaderProgram);
        }
        this.st = new ShaderState();
        this.st.attachShaderProgram(gL2ES2, shaderProgram, false);
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        float f;
        float f2;
        if (null == this.texSeq) {
            throw new InternalError("texSeq null");
        }
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        TextureSequence.TextureFrame textureFrame = this.texSeq.getLastTexture();
        if (null == textureFrame) {
            return;
        }
        Texture texture = textureFrame.getTexture();
        this.initShader(gL2ES2);
        this.st.useProgram(gL2ES2, true);
        Recti recti = new Recti(0, 0, gLAutoDrawable.getSurfaceWidth(), gLAutoDrawable.getSurfaceHeight());
        this.pmvMatrix = new PMVMatrix();
        this.reshapePMV(recti.width(), recti.height());
        this.pmvMatrixUniform = new GLUniformData("mgl_PMVMatrix", 4, 4, (SyncBuffer)this.pmvMatrix.getSyncPMv());
        if (!this.st.uniform(gL2ES2, this.pmvMatrixUniform)) {
            throw new GLException("Error setting PMVMatrix in shader: " + this.st);
        }
        if (!this.st.uniform(gL2ES2, new GLUniformData("mgl_ActiveTexture", this.texSeq.getTextureUnit()))) {
            throw new GLException("Error setting mgl_ActiveTexture in shader: " + this.st);
        }
        float f3 = gLAutoDrawable.getSurfaceWidth();
        float f4 = gLAutoDrawable.getSurfaceHeight();
        float f5 = texture.getImageWidth();
        float f6 = texture.getImageHeight();
        float f7 = f5 / f6;
        System.err.println("XXX0: mov aspect: " + f7);
        if (this.orthoProjection) {
            if (this.useOriginalScale && f5 < f3 && f6 < f4) {
                f2 = f5 / 2.0f;
                f = f2 / f7;
            } else {
                f2 = f3 / 2.0f;
                f = f2 / f7;
            }
        } else if (this.useOriginalScale && f5 < f3 && f6 < f4) {
            f2 = f7 * (f5 / f3);
            f = f2 / f7;
        } else {
            f2 = f7;
            f = 1.0f;
        }
        this.verts = new float[]{-1.0f * f2, -1.0f * f, 0.0f, 1.0f * f2, 1.0f * f, 0.0f};
        System.err.println("XXX0: pixel  LB: " + this.verts[0] + ", " + this.verts[1] + ", " + this.verts[2]);
        System.err.println("XXX0: pixel  RT: " + this.verts[3] + ", " + this.verts[4] + ", " + this.verts[5]);
        Vec3f vec3f = new Vec3f();
        Vec3f vec3f2 = new Vec3f();
        this.pmvMatrix.mapObjToWin(new Vec3f(this.verts[0], this.verts[1], this.verts[2]), recti, vec3f);
        this.pmvMatrix.mapObjToWin(new Vec3f(this.verts[3], this.verts[4], this.verts[5]), recti, vec3f2);
        System.err.println("XXX0: win   LB: " + vec3f);
        System.err.println("XXX0: win   RT: " + vec3f2);
        this.interleavedVBO = GLArrayDataServer.createGLSLInterleaved((int)9, (int)5126, (boolean)false, (int)12, (int)35044);
        this.interleavedVBO.addGLSLSubArray("mgl_Vertex", 3, 34962);
        this.interleavedVBO.addGLSLSubArray("mgl_Color", 4, 34962);
        this.interleavedVBO.addGLSLSubArray("mgl_MultiTexCoord", 2, 34962);
        this.updateInterleavedVBO((GL)gL2ES2, texture);
        this.st.ownAttribute((GLArrayData)this.interleavedVBO, true);
        gL2ES2.glClearColor(0.3f, 0.3f, 0.3f, 0.3f);
        gL2ES2.glEnable(2929);
        this.st.useProgram(gL2ES2, false);
        System.out.println("iVBO: " + this.interleavedVBO);
        System.out.println(this.st);
    }

    protected void updateInterleavedVBO(GL gL, Texture texture) {
        boolean bl = this.interleavedVBO.enabled();
        this.interleavedVBO.seal(gL, false);
        this.interleavedVBO.rewind();
        FloatBuffer floatBuffer = (FloatBuffer)this.interleavedVBO.getBuffer();
        TextureCoords textureCoords = texture.getImageTexCoords();
        System.err.println("XXX0: " + textureCoords);
        System.err.println("XXX0: tex aspect: " + texture.getAspectRatio());
        System.err.println("XXX0: tex y-flip: " + texture.getMustFlipVertically());
        floatBuffer.put(this.verts[0]);
        floatBuffer.put(this.verts[1]);
        floatBuffer.put(this.verts[2]);
        if (this.hasEffect(2)) {
            floatBuffer.put(0.0f);
            floatBuffer.put(0.0f);
            floatBuffer.put(0.0f);
            floatBuffer.put(this.alpha);
        } else {
            floatBuffer.put(1.0f);
            floatBuffer.put(1.0f);
            floatBuffer.put(1.0f);
            floatBuffer.put(this.alpha);
        }
        floatBuffer.put(textureCoords.left() * 1.0f);
        floatBuffer.put(textureCoords.bottom() * 1.0f);
        floatBuffer.put(this.verts[3]);
        floatBuffer.put(this.verts[1]);
        floatBuffer.put(this.verts[2]);
        if (this.hasEffect(2)) {
            floatBuffer.put(0.0f);
            floatBuffer.put(0.0f);
            floatBuffer.put(0.0f);
            floatBuffer.put(this.alpha);
        } else {
            floatBuffer.put(1.0f);
            floatBuffer.put(1.0f);
            floatBuffer.put(1.0f);
            floatBuffer.put(this.alpha);
        }
        floatBuffer.put(textureCoords.right() * 1.0f);
        floatBuffer.put(textureCoords.bottom() * 1.0f);
        floatBuffer.put(this.verts[0]);
        floatBuffer.put(this.verts[4]);
        floatBuffer.put(this.verts[2]);
        floatBuffer.put(1.0f);
        floatBuffer.put(1.0f);
        floatBuffer.put(1.0f);
        floatBuffer.put(this.alpha);
        floatBuffer.put(textureCoords.left() * 1.0f);
        floatBuffer.put(textureCoords.top() * 1.0f);
        floatBuffer.put(this.verts[3]);
        floatBuffer.put(this.verts[4]);
        floatBuffer.put(this.verts[2]);
        floatBuffer.put(1.0f);
        floatBuffer.put(1.0f);
        floatBuffer.put(1.0f);
        floatBuffer.put(this.alpha);
        floatBuffer.put(textureCoords.right() * 1.0f);
        floatBuffer.put(textureCoords.top() * 1.0f);
        this.interleavedVBO.seal(gL, true);
        if (!bl) {
            this.interleavedVBO.enableBuffer(gL, false);
        }
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        if (null != this.st) {
            this.reshapePMV(n3, n4);
            this.st.useProgram(gL2ES2, true);
            this.st.uniform(gL2ES2, this.pmvMatrixUniform);
            this.st.useProgram(gL2ES2, false);
        }
        System.out.println("pR " + this.texSeq);
    }

    private void reshapePMV(int n, int n2) {
        this.pmvMatrix.glMatrixMode(5889);
        this.pmvMatrix.glLoadIdentity();
        if (this.orthoProjection) {
            float f = (float)n / 2.0f;
            float f2 = (float)n2 / 2.0f;
            this.pmvMatrix.glOrthof(-f, f, -f2, f2, -1.0f, 1.0f);
            this.nearPlaneNormalized = 0.0f;
        } else {
            this.pmvMatrix.gluPerspective(0.7853982f, (float)n / (float)n2, 1.0f, 10.0f);
            this.nearPlaneNormalized = 0.11111111f;
        }
        System.err.println("XXX0: Perspective nearPlaneNormalized: " + this.nearPlaneNormalized);
        this.pmvMatrix.glMatrixMode(5888);
        this.pmvMatrix.glLoadIdentity();
        this.pmvMatrix.glTranslatef(0.0f, 0.0f, this.zoom);
    }

    public void dispose(GLAutoDrawable gLAutoDrawable) {
        if (null == this.texSeq) {
            return;
        }
        this.disposeImpl(gLAutoDrawable, true);
    }

    private void disposeImpl(GLAutoDrawable gLAutoDrawable, boolean bl) {
        if (bl) {
            this.texSeq = null;
        }
        this.pmvMatrixUniform = null;
        this.pmvMatrix = null;
        if (null != this.st) {
            GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
            this.st.destroy(gL2ES2);
            this.st = null;
        }
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        TextureSequence.TextureFrame textureFrame;
        if (null == this.texSeq) {
            return;
        }
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        gL2ES2.glClear(16640);
        if (null == this.st) {
            return;
        }
        this.st.useProgram(gL2ES2, true);
        this.pmvMatrix.glMatrixMode(5888);
        this.pmvMatrix.glLoadIdentity();
        this.pmvMatrix.glTranslatef(0.0f, 0.0f, this.zoom);
        if (this.zrot > 0.0f) {
            this.pmvMatrix.glRotatef(this.zrot, 0.0f, 0.0f, 1.0f);
        } else {
            this.zrot = 0.0f;
        }
        this.st.uniform(gL2ES2, this.pmvMatrixUniform);
        this.interleavedVBO.enableBuffer((GL)gL2ES2, true);
        Texture texture = null;
        if (null != this.texSeq && null != (textureFrame = this.texSeqShared ? this.texSeq.getLastTexture() : this.texSeq.getNextTexture((GL)gL2ES2))) {
            texture = textureFrame.getTexture();
            gL2ES2.glActiveTexture(33984 + this.texSeq.getTextureUnit());
            texture.enable((GL)gL2ES2);
            texture.bind((GL)gL2ES2);
        }
        gL2ES2.glDrawArrays(5, 0, 4);
        if (null != texture) {
            texture.disable((GL)gL2ES2);
        }
        this.interleavedVBO.enableBuffer((GL)gL2ES2, false);
        this.st.useProgram(gL2ES2, false);
    }
}

