/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.demos.graph.ui;

import com.jogamp.common.os.Clock;
import com.jogamp.graph.font.Font;
import com.jogamp.graph.font.FontFactory;
import com.jogamp.graph.ui.GraphShape;
import com.jogamp.graph.ui.Scene;
import com.jogamp.graph.ui.Shape;
import com.jogamp.graph.ui.shapes.Button;
import com.jogamp.math.Recti;
import com.jogamp.math.geom.AABBox;
import com.jogamp.math.util.PMVMatrix4f;
import com.jogamp.newt.event.WindowAdapter;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.demos.util.CommandlineOptions;
import com.jogamp.opengl.util.Animator;
import java.io.IOException;

public class UISceneDemo00 {
    static CommandlineOptions options = new CommandlineOptions(1280, 720, 2);

    public static void main(String[] stringArray) throws IOException {
        long l;
        options.parse(stringArray);
        System.err.println(options);
        GLProfile gLProfile = GLProfile.get((String)UISceneDemo00.options.glProfileName);
        System.err.println("GLProfile: " + gLProfile);
        Font font = FontFactory.get((int)0).get(1, 2);
        System.err.println("Font: " + font.getFullFamilyName());
        Button button = new Button(UISceneDemo00.options.renderModes, font, (CharSequence)"+", 0.1f, 0.04f);
        System.err.println("Shape bounds " + button.getBounds(gLProfile));
        Scene scene = new Scene(UISceneDemo00.options.graphAASamples);
        scene.setPMVMatrixSetup((Scene.PMVMatrixSetup)new MyPMVMatrixSetup());
        scene.setClearParams(new float[]{1.0f, 1.0f, 1.0f, 1.0f}, 16640);
        scene.addShape((Shape)button);
        scene.setAAQuality(UISceneDemo00.options.graphAAQuality);
        final Animator animator = new Animator(0);
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setAlphaBits(4);
        System.out.println("Requested: " + gLCapabilities);
        final GLWindow gLWindow = GLWindow.create((GLCapabilitiesImmutable)gLCapabilities);
        gLWindow.setSize(UISceneDemo00.options.surface_width, UISceneDemo00.options.surface_height);
        gLWindow.setTitle(UISceneDemo00.class.getSimpleName() + ": " + gLWindow.getSurfaceWidth() + " x " + gLWindow.getSurfaceHeight());
        gLWindow.setVisible(true);
        gLWindow.addGLEventListener((GLEventListener)scene);
        gLWindow.addWindowListener((WindowListener)new WindowAdapter(){

            public void windowResized(WindowEvent windowEvent) {
                gLWindow.setTitle(UISceneDemo00.class.getSimpleName() + ": " + gLWindow.getSurfaceWidth() + " x " + gLWindow.getSurfaceHeight());
            }

            public void windowDestroyNotify(WindowEvent windowEvent) {
                animator.stop();
            }
        });
        scene.attachInputListenerTo(gLWindow);
        animator.add((GLAutoDrawable)gLWindow);
        animator.start();
        scene.waitUntilDisplayed();
        AABBox aABBox = scene.getBounds();
        System.err.println("SceneBox " + aABBox);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        float f = aABBox.getMinX();
        float f2 = aABBox.getMaxX() - button.getScaledWidth();
        int[] nArray = button.getSurfaceSize(scene, new PMVMatrix4f(), new int[2]);
        float[] fArray = button.getPixelPerShapeUnit(nArray, new float[2]);
        float f3 = gLWindow.getPixelsPerMM(new float[2])[0];
        float f4 = scene.getWidth() - nArray[0];
        float f5 = f4 / f3 / 1000.0f;
        float f6 = 50.0f * f3;
        float f7 = f6 / fArray[0];
        float f8 = f5 / 0.05f;
        System.err.println();
        System.err.printf("Shape: %d x %d [pixel], %.4f px/shape_unit%n", nArray[0], nArray[1], Float.valueOf(fArray[0]));
        System.err.printf("Shape: %s%n", button);
        System.err.println();
        System.err.printf("Distance: %.0f pixel @ %.3f px/mm, %.3f mm%n", Float.valueOf(f4), Float.valueOf(f3), Float.valueOf(f5 * 1000.0f));
        System.err.printf("Velocity: %.3f mm/s, %.3f px/s, %.6f obj/s, expected travel-duration %.3f s%n", Float.valueOf(50.0f), Float.valueOf(f6), Float.valueOf(f7), Float.valueOf(f8));
        long l2 = l = Clock.currentNanos() / 1000L;
        button.moveTo(f, 0.0f, 0.0f);
        while (button.getPosition().x() < f2 && gLWindow.isNativeValid()) {
            long l3 = Clock.currentNanos() / 1000L;
            float f9 = (float)(l3 - l2) / 1000000.0f;
            l2 = l3;
            float f10 = f7 * f9;
            gLWindow.invoke(true, arg_0 -> UISceneDemo00.lambda$main$0((GraphShape)button, f10, arg_0));
        }
        float f11 = (float)(Clock.currentNanos() / 1000L - l) / 1000000.0f;
        System.err.printf("Actual travel-duration %.3f s, delay %.3f s%n", Float.valueOf(f11), Float.valueOf(f11 - f8));
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!UISceneDemo00.options.stayOpen) {
            gLWindow.destroy();
        }
    }

    private static /* synthetic */ boolean lambda$main$0(GraphShape graphShape, float f, GLAutoDrawable gLAutoDrawable) {
        graphShape.move(f, 0.0f, 0.0f);
        return true;
    }

    static class MyPMVMatrixSetup
    extends Scene.DefaultPMVMatrixSetup {
        MyPMVMatrixSetup() {
        }

        public void set(PMVMatrix4f pMVMatrix4f, Recti recti) {
            super.set(pMVMatrix4f, recti);
            AABBox aABBox = new AABBox();
            this.setPlaneBox(aABBox, pMVMatrix4f, recti);
            float f = aABBox.getWidth();
            float f2 = aABBox.getHeight();
            float f3 = f > f2 ? f : f2;
            pMVMatrix4f.scaleP(f3, f3, 1.0f);
        }
    }
}

