/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.demos.graph.ui;

import com.jogamp.common.util.InterruptSource;
import com.jogamp.graph.curve.opengl.RegionRenderer;
import com.jogamp.graph.ui.GraphShape;
import com.jogamp.graph.ui.Group;
import com.jogamp.graph.ui.Scene;
import com.jogamp.graph.ui.Shape;
import com.jogamp.graph.ui.shapes.Rectangle;
import com.jogamp.math.Vec2f;
import com.jogamp.math.Vec3f;
import com.jogamp.math.geom.AABBox;
import com.jogamp.math.geom.Cube;
import com.jogamp.math.geom.Frustum;
import com.jogamp.math.util.PMVMatrix4f;
import com.jogamp.newt.event.KeyAdapter;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.MouseEvent;
import com.jogamp.newt.event.WindowAdapter;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.demos.util.CommandlineOptions;
import com.jogamp.opengl.util.Animator;
import java.io.IOException;

public class UIShapeClippingDemo01 {
    static CommandlineOptions options = new CommandlineOptions(1280, 720, 2);

    public static void main(String[] stringArray) throws IOException {
        boolean bl = true;
        if (0 != stringArray.length) {
            int[] nArray = new int[]{0};
            nArray[0] = 0;
            while (nArray[0] < stringArray.length) {
                if (!options.parse(stringArray, nArray) && stringArray[nArray[0]].equals("-NoFixedSize")) {
                    bl = false;
                }
                nArray[0] = nArray[0] + 1;
            }
        }
        final boolean bl2 = bl;
        System.err.println(options);
        System.err.println("useFixedSize " + bl2);
        GLProfile gLProfile = GLProfile.get((String)UIShapeClippingDemo01.options.glProfileName);
        System.err.println("GLProfile: " + gLProfile);
        final Scene scene = new Scene(UIShapeClippingDemo01.options.graphAASamples);
        scene.setPMVMatrixSetup((Scene.PMVMatrixSetup)new Scene.DefaultPMVMatrixSetup(-1.0f));
        scene.setClearParams(new float[]{1.0f, 1.0f, 1.0f, 1.0f}, 16640);
        scene.setAAQuality(UIShapeClippingDemo01.options.graphAAQuality);
        final Animator animator = new Animator(0);
        GLCapabilities gLCapabilities = options.getGLCaps();
        System.out.println("Requested: " + gLCapabilities);
        final GLWindow gLWindow = GLWindow.create((GLCapabilitiesImmutable)gLCapabilities);
        gLWindow.setSize(UIShapeClippingDemo01.options.surface_width, UIShapeClippingDemo01.options.surface_height);
        gLWindow.setTitle(UIShapeClippingDemo01.class.getSimpleName() + ": " + gLWindow.getSurfaceWidth() + " x " + gLWindow.getSurfaceHeight());
        gLWindow.setVisible(true);
        System.out.println("Chosen: " + gLWindow.getChosenGLCapabilities());
        gLWindow.addGLEventListener((GLEventListener)scene);
        gLWindow.addGLEventListener(new GLEventListener(){
            GraphShape shape = null;
            Group contentBox = null;
            private final Cube tempC00 = new Cube();
            private final Cube tempC01 = new Cube();
            private final Cube tempC10 = new Cube();

            public void init(GLAutoDrawable gLAutoDrawable) {
                AABBox aABBox = scene.getBounds();
                System.err.println("Init Scene " + aABBox);
                this.shape = new Rectangle(UIShapeClippingDemo01.options.renderModes, aABBox.getWidth() / 8.0f, aABBox.getWidth() / 16.0f, 0.0f);
                this.contentBox = new Group();
                this.contentBox.setBorder(0.005f);
                this.contentBox.setInteractive(true);
                this.contentBox.setClipOnBounds(true);
                this.contentBox.addShape((Shape)this.shape);
                float f = aABBox.getWidth() * 0.6f;
                float f2 = aABBox.getHeight() * 0.6f;
                if (bl2) {
                    this.contentBox.setFixedSize(new Vec2f(f, f2));
                }
                this.contentBox.move(-f / 2.0f, -f2 / 2.0f, 0.0f);
                System.err.println("XXX contentBox " + this.contentBox.getBounds(gLAutoDrawable.getGLProfile()));
                System.err.println("XXX shape " + this.shape.getBounds());
                this.contentBox.addMouseListener((Shape.MouseGestureListener)new Shape.MouseGestureAdapter(){

                    public void mouseWheelMoved(MouseEvent mouseEvent) {
                        Shape.EventInfo eventInfo = (Shape.EventInfo)mouseEvent.getAttachment();
                        Vec3f vec3f = new Vec3f(mouseEvent.getRotation()).scale((float)Math.PI / 180);
                        float f = vec3f.x();
                        vec3f.setX(vec3f.y());
                        vec3f.setY(f);
                        eventInfo.shape.setRotation(eventInfo.shape.getRotation().rotateByEuler(vec3f.scale(2.0f)));
                    }
                });
                scene.addShape((Shape)this.contentBox);
            }

            public void dispose(GLAutoDrawable gLAutoDrawable) {
            }

            public void display(GLAutoDrawable gLAutoDrawable) {
                RegionRenderer regionRenderer = scene.getRenderer();
                PMVMatrix4f pMVMatrix4f = regionRenderer.getMatrix();
                pMVMatrix4f.pushMv();
                this.contentBox.applyMatToMv(pMVMatrix4f);
                AABBox aABBox = this.contentBox.getBounds();
                Cube cube = this.tempC00.set(aABBox);
                Frustum frustum = this.tempC01.set(cube).transform(pMVMatrix4f.getMv()).updateFrustumPlanes(new Frustum());
                pMVMatrix4f.pushMv();
                this.shape.applyMatToMv(pMVMatrix4f);
                AABBox aABBox2 = this.shape.getBounds();
                Cube cube2 = this.tempC10.set(aABBox2).transform(pMVMatrix4f.getMv());
                boolean bl = frustum.isOutside(cube2);
                Frustum frustum2 = new Frustum().setFromMat(pMVMatrix4f.getPMv());
                boolean bl22 = frustum2.isOutside(aABBox2);
                System.err.println("ClipBox  " + aABBox);
                System.err.println("ShapeBox " + aABBox2);
                System.err.println("FrusPMv  " + bl22 + ", " + frustum2);
                System.err.println("FsCbMv   1 " + bl + ", " + frustum);
                pMVMatrix4f.popMv();
                pMVMatrix4f.popMv();
            }

            public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
            }
        });
        gLWindow.addWindowListener((WindowListener)new WindowAdapter(){

            public void windowResized(WindowEvent windowEvent) {
                gLWindow.setTitle(UIShapeClippingDemo01.class.getSimpleName() + ": " + gLWindow.getSurfaceWidth() + " x " + gLWindow.getSurfaceHeight());
            }

            public void windowDestroyNotify(WindowEvent windowEvent) {
                animator.stop();
            }
        });
        scene.attachInputListenerTo(gLWindow);
        gLWindow.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                short s = keyEvent.getKeySymbol();
                if (s == 100 || s == 27 || s == 81) {
                    new InterruptSource.Thread(() -> gLWindow.destroy()).start();
                }
            }
        });
        gLWindow.addWindowListener((WindowListener)new WindowAdapter(){

            public void windowDestroyed(WindowEvent windowEvent) {
                animator.stop();
            }
        });
        animator.add((GLAutoDrawable)gLWindow);
        animator.start();
    }
}

